/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class PythonCodeEnvPackagesUtils {
    static final Pattern PYTHON_PACKAGE_NAME_PATTERN = Pattern.compile("^([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9._-]*[A-Za-z0-9])$");
    static final Pattern PYTHON_PACKAGE_LINE_PATTERN = Pattern.compile("^\\s*([A-Za-z0-9._-]+)(.*)$");
    static final String PYTHON_PACKAGE_VERSION_PATTERN = "\\s*([A-Za-z0-9][A-Za-z0-9_.*+!-]*)";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.code.envs.python.utils");

    public static PythonEnvPackages getEnvPackages(CodeEnvModel.DesignUIPythonEnv env) {
        ArrayList<PythonPackage> packageList = new ArrayList<PythonPackage>();
        packageList.addAll(PythonCodeEnvPackagesUtils.parsePipActualPackageList(env.actualPackageList));
        packageList.addAll(PythonCodeEnvPackagesUtils.parseCondaActualPackageList(env.actualCondaEnvironment));
        return new PythonEnvPackages(env.envName, env.deploymentMode, packageList, env.desc.pythonInterpreter);
    }

    public static PythonEnvPackages getEnvPackages(CodeEnvModel.AutomationUIPythonEnv env, CodeEnvModel.AutomationUIPythonEnvVersion envVersion) {
        ArrayList<PythonPackage> packageList = new ArrayList<PythonPackage>();
        packageList.addAll(PythonCodeEnvPackagesUtils.parsePipActualPackageList(envVersion.actualPackageList));
        packageList.addAll(PythonCodeEnvPackagesUtils.parseCondaActualPackageList(envVersion.actualCondaEnvironment));
        return new PythonEnvPackages(env.envName, env.deploymentMode, packageList, envVersion.desc.pythonInterpreter);
    }

    private static List<PythonPackage> parsePipActualPackageList(String pipActualPackages) {
        Pattern PIP_PACKAGE_VERSION_PATTERN = Pattern.compile("==\\s*([A-Za-z0-9][A-Za-z0-9_.*+!-]*)");
        return PythonCodeEnvPackagesUtils.parseActualPackageList(pipActualPackages, PIP_PACKAGE_VERSION_PATTERN);
    }

    private static List<PythonPackage> parseCondaActualPackageList(String condaActualPackages) {
        Pattern CONDA_PACKAGE_VERSION_PATTERN = Pattern.compile("=\\s*([A-Za-z0-9][A-Za-z0-9_.*+!-]*)=.*");
        return PythonCodeEnvPackagesUtils.parseActualPackageList(condaActualPackages, CONDA_PACKAGE_VERSION_PATTERN);
    }

    private static List<PythonPackage> parseActualPackageList(String actualPackages, Pattern packageVersionPattern) {
        ArrayList<PythonPackage> ret = new ArrayList<PythonPackage>();
        if (actualPackages == null || StringUtils.isBlank((String)actualPackages)) {
            return ret;
        }
        for (String line : actualPackages.split("\n")) {
            PythonPackage p;
            if (line.trim().startsWith("#") || (p = PythonCodeEnvPackagesUtils.parseLine(line, packageVersionPattern)) == null) continue;
            ret.add(p);
        }
        return ret;
    }

    public static PythonPackage parseLine(String line, Pattern packageVersionPattern) {
        if (StringUtils.isBlank((String)line)) {
            return null;
        }
        Matcher matcher = PYTHON_PACKAGE_LINE_PATTERN.matcher(line);
        if (!matcher.find()) {
            logger.info((Object)("Did not manage to parse package name: '" + line + "'"));
            return null;
        }
        String packageName = matcher.group(1);
        if (!PYTHON_PACKAGE_NAME_PATTERN.matcher(packageName).matches()) {
            logger.info((Object)("Package name: '" + packageName + "' does not follow PEP 0508, not parsing it"));
            return null;
        }
        Matcher packageVersionMatcher = packageVersionPattern.matcher(matcher.group(2));
        String packageVersion = null;
        if (packageVersionMatcher.find()) {
            packageVersion = packageVersionMatcher.group(1);
        }
        return new PythonPackage(packageName, packageVersion);
    }

    public static void updateEnvWithPipInstalledCUDA(Map<String, String> envVars, StandardPythonInterpreter pythonInterpreter, String specRequirements, String rootDir) {
        String cudaInstallDir;
        boolean hasLocalCUDAInstall = false;
        for (String pkg : List.of("tensorflow[and-cuda]", "skorch", "gluonts[torch]")) {
            if (!specRequirements.contains(pkg) || specRequirements.contains("whl/cpu")) continue;
            hasLocalCUDAInstall = true;
            break;
        }
        if (!hasLocalCUDAInstall) {
            return;
        }
        try {
            cudaInstallDir = rootDir + "/lib/" + pythonInterpreter.getPythonCommandString() + "/site-packages/nvidia/";
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Unable to set CUDA environment variables with a custom interpreter.");
            return;
        }
        logger.info((Object)("Updating environment variables to include pip-installed CUDA libraries at " + cudaInstallDir));
        StringBuilder bins = new StringBuilder();
        for (String string : List.of("cuda_nvcc")) {
            bins.append(cudaInstallDir).append(string).append("/bin").append(":");
        }
        StringBuilder libs = new StringBuilder();
        for (String component : List.of("cublas", "cuda_cupti", "cuda_nvcc", "cuda_nvrtc", "cuda_runtime", "cudnn", "cufft", "cufile", "curand", "cusolver", "cusparse", "nccl", "nvjitlink")) {
            libs.append(cudaInstallDir).append(component).append("/lib").append(":");
        }
        libs.append(rootDir).append("/lib/").append(pythonInterpreter.getPythonCommandString()).append("/site-packages/cusparselt/lib:");
        String string = "--xla_gpu_cuda_data_dir=" + cudaInstallDir + "cuda_nvcc";
        envVars.put("PATH", String.valueOf(bins) + envVars.getOrDefault("PATH", "$PATH"));
        envVars.put("LD_LIBRARY_PATH", String.valueOf(libs) + envVars.getOrDefault("LD_LIBRARY_PATH", "$LD_LIBRARY_PATH"));
        envVars.put("XLA_FLAGS", string + " " + envVars.getOrDefault("XLA_FLAGS", "$XLA_FLAGS"));
    }

    public static class PythonEnvPackages {
        public String envName;
        StandardPythonInterpreter pythonInterpreter;
        CodeEnvModel.CodeEnvDeploymentMode deploymentMode;
        Map<String, PythonPackageVersion> packages = new HashMap<String, PythonPackageVersion>();
        static final List<String> VISUAL_ML_PACKAGE_NAMES = Arrays.asList("scikit-learn", "scipy", "xgboost", "lightgbm", "statsmodels", "Jinja2", "flask", "cloudpickle");
        static final PythonPackageVersion MERGED_CPU_GPU_TENSORFLOW = PythonPackageVersion.fromString("2.1");
        static final PythonPackageVersion MAX_SUPPORTED_TENSORFLOW = PythonPackageVersion.fromString("2.6");
        static final PythonPackageVersion MIN_UNSUPPORTED_TENSORFLOW = PythonPackageVersion.fromString("3.0");
        static final List<String> KERAS_DL_PACKAGE_NAMES_EXCEPT_TENSORFLOW = Arrays.asList("keras", "Jinja2", "h5py", "pillow", "statsmodels", "flask", "scikit-learn");
        static final List<String> TIMESERIES_PACKAGE_NAMES_EXCEPT_MXNET = Arrays.asList("scikit-learn", "scipy", "statsmodels", "Jinja2", "flask", "cloudpickle", "gluonts", "pmdarima");
        static final List<String> TORCH_TIMESERIES_NAMES = Arrays.asList("torch", "pytorch-lightning");
        static final List<String> CAUSAL_ML_PACKAGE_NAMES = Arrays.asList("scikit-learn", "scipy", "xgboost", "lightgbm", "statsmodels", "Jinja2", "flask", "cloudpickle", "econml");
        static final List<String> DEEP_NEURAL_NETWORK_PACKAGE_NAMES = Arrays.asList("skorch", "torch");
        static final List<String> LLM_EVALUATION_RECIPE_PACKAGE_NAMES = Arrays.asList("langchain", "pydantic", "ragas", "bert-score", "torch", "sacrebleu", "rouge-score");

        PythonEnvPackages(String envName, CodeEnvModel.CodeEnvDeploymentMode deploymentMode, List<PythonPackage> packageList, StandardPythonInterpreter pythonInterpreter) {
            this.envName = envName;
            this.deploymentMode = deploymentMode;
            this.pythonInterpreter = pythonInterpreter;
            for (PythonPackage pythonPackage : packageList) {
                this.packages.put(this.normalize(pythonPackage.packageName), pythonPackage.version);
            }
        }

        String normalize(String packageName) {
            return packageName.toLowerCase().replace('_', '-');
        }

        public boolean hasPackage(String packageName) {
            return this.packages.containsKey(this.normalize(packageName));
        }

        public List<String> findMissingPackages(List<String> packageNameList) {
            ArrayList<String> missingPackages = new ArrayList<String>();
            for (String p : packageNameList) {
                if (this.hasPackage(p)) continue;
                missingPackages.add(p);
            }
            return missingPackages;
        }

        public PythonPackageVersion getPackageVersion(String packageName) {
            return this.packages.get(this.normalize(packageName));
        }

        List<String> findMissingPackagesForKerasDL() {
            List<String> missingPackages = this.findMissingPackages(KERAS_DL_PACKAGE_NAMES_EXCEPT_TENSORFLOW);
            PythonPackage tensorflowPackage = this.getTensorflowPackage();
            if (tensorflowPackage == null) {
                missingPackages.add("tensorflow");
            } else {
                PythonPackage tensorflowMetalPackage;
                boolean needsTensorflowMetal = DKUtils.isOsMacOS() && "tensorflow-macos".equals(tensorflowPackage.packageName);
                boolean bl = needsTensorflowMetal = needsTensorflowMetal || DKUtils.isOnMacSilicon() && "tensorflow".equals(tensorflowPackage.packageName) && tensorflowPackage.version.gte(PythonPackageVersion.fromString("2.17"));
                if (needsTensorflowMetal && (tensorflowMetalPackage = this.getPackage("tensorflow-metal")) == null) {
                    missingPackages.add("tensorflow-metal");
                }
            }
            return missingPackages;
        }

        List<String> findMissingPackagesForTimeseries() {
            return this.findMissingPackages(TIMESERIES_PACKAGE_NAMES_EXCEPT_MXNET);
        }

        List<String> findMissingPackagesForMxnetTimeseries() {
            ArrayList<String> missingPackages = new ArrayList<String>();
            if (this.getMxnetPackage() == null) {
                missingPackages.add("mxnet");
            }
            return missingPackages;
        }

        List<String> findMissingPackagesForTorchTimeseries() {
            return this.findMissingPackages(TORCH_TIMESERIES_NAMES);
        }

        private PythonPackage getPackage(String packageName) {
            PythonPackageVersion version = this.getPackageVersion(packageName);
            if (version != null) {
                return new PythonPackage(packageName, version);
            }
            return null;
        }

        private PythonPackage getTensorflowPackage() {
            PythonPackage tensorflowPackage = this.getPackage("tensorflow-gpu");
            if (tensorflowPackage == null) {
                tensorflowPackage = this.getPackage("tensorflow");
            }
            if (tensorflowPackage == null) {
                tensorflowPackage = this.getPackage("tensorflow-cpu");
            }
            if (tensorflowPackage == null) {
                tensorflowPackage = this.getPackage("tensorflow-macos");
            }
            return tensorflowPackage;
        }

        PythonPackageVersion getTensorflowVersion() {
            PythonPackage tfPackage = this.getTensorflowPackage();
            if (tfPackage != null) {
                return tfPackage.version;
            }
            return null;
        }

        TensorflowSupport getTensorflowSupport() {
            PythonPackage tensorflowPackage = this.getTensorflowPackage();
            if (tensorflowPackage == null) {
                return TensorflowSupport.NONE;
            }
            if ("tensorflow-macos".equals(tensorflowPackage.packageName)) {
                return TensorflowSupport.CPU;
            }
            PythonPackageVersion tensorflowVersion = tensorflowPackage.version;
            if (tensorflowVersion.unknown) {
                if ("tensorflow-gpu".equals(tensorflowPackage.packageName)) {
                    return TensorflowSupport.UNKNOWN_GPU;
                }
                return TensorflowSupport.UNKNOWN_CPU;
            }
            if (tensorflowVersion.gte(MIN_UNSUPPORTED_TENSORFLOW)) {
                return TensorflowSupport.UNSUPPORTED;
            }
            if (tensorflowVersion.gte(MAX_SUPPORTED_TENSORFLOW)) {
                return TensorflowSupport.LATEST_GPU;
            }
            if ("tensorflow-gpu".equals(tensorflowPackage.packageName) || tensorflowVersion.gte(MERGED_CPU_GPU_TENSORFLOW)) {
                return TensorflowSupport.GPU;
            }
            return TensorflowSupport.CPU;
        }

        private PythonPackage getMxnetPackage() {
            PythonPackage mxnetPackage = this.getPackage("mxnet-cu112");
            if (mxnetPackage == null) {
                mxnetPackage = this.getPackage("mxnet-cu110");
            }
            if (mxnetPackage == null) {
                mxnetPackage = this.getPackage("mxnet-cu102");
            }
            if (mxnetPackage == null) {
                mxnetPackage = this.getPackage("mxnet-cu101");
            }
            if (mxnetPackage == null) {
                mxnetPackage = this.getPackage("mxnet-cu100");
            }
            if (mxnetPackage == null) {
                mxnetPackage = this.getPackage("mxnet-cu92");
            }
            if (mxnetPackage == null) {
                mxnetPackage = this.getPackage("mxnet");
            }
            return mxnetPackage;
        }

        PythonPackageVersion getMxnetVersion() {
            PythonPackage mxnetPackage = this.getMxnetPackage();
            if (mxnetPackage != null) {
                return mxnetPackage.version;
            }
            return null;
        }

        MXNetSupport getMxnetSupport() {
            PythonPackage mxnetPackage = this.getMxnetPackage();
            if (mxnetPackage == null) {
                return MXNetSupport.NONE;
            }
            PythonPackageVersion mxnetVersion = mxnetPackage.version;
            if (mxnetVersion.unknown || mxnetVersion.lt(this.pythonInterpreter.minSupportedVersion("mxnet")) || mxnetVersion.gte(this.pythonInterpreter.minUnsupportedVersion("mxnet"))) {
                return MXNetSupport.UNSUPPORTED;
            }
            if ("mxnet-cu112".equals(mxnetPackage.packageName)) {
                return MXNetSupport.GPU_CUDA112;
            }
            if ("mxnet-cu110".equals(mxnetPackage.packageName)) {
                return MXNetSupport.GPU_CUDA110;
            }
            if ("mxnet-cu102".equals(mxnetPackage.packageName)) {
                return MXNetSupport.GPU_CUDA102;
            }
            if ("mxnet-cu101".equals(mxnetPackage.packageName)) {
                return MXNetSupport.GPU_CUDA101;
            }
            if ("mxnet-cu100".equals(mxnetPackage.packageName)) {
                return MXNetSupport.GPU_CUDA100;
            }
            if ("mxnet-cu92".equals(mxnetPackage.packageName)) {
                return MXNetSupport.GPU_CUDA92;
            }
            return MXNetSupport.CPU;
        }

        public static enum TensorflowSupport {
            NONE(false, false),
            UNSUPPORTED(false, false),
            UNKNOWN_CPU(true, false),
            CPU(true, false),
            UNKNOWN_GPU(true, true),
            GPU(true, true),
            LATEST_GPU(true, true);

            public final boolean supported;
            public final boolean supportsGpu;

            private TensorflowSupport(boolean supported, boolean supportsGpu) {
                this.supported = supported;
                this.supportsGpu = supportsGpu;
            }

            public boolean gt(TensorflowSupport otherTensorflowSupport) {
                return this.compareTo(otherTensorflowSupport) > 0;
            }
        }

        public static enum MXNetSupport {
            NONE(false, false),
            UNSUPPORTED(false, false),
            CPU(true, false),
            GPU_CUDA92(true, true),
            GPU_CUDA100(true, true),
            GPU_CUDA101(true, true),
            GPU_CUDA102(true, true),
            GPU_CUDA110(true, true),
            GPU_CUDA112(true, true);

            public final boolean supported;
            public final boolean supportsGpu;

            private MXNetSupport(boolean supported, boolean supportsGpu) {
                this.supported = supported;
                this.supportsGpu = supportsGpu;
            }

            public boolean gt(MXNetSupport otherMXNetSupport) {
                return this.compareTo(otherMXNetSupport) > 0;
            }
        }
    }

    static class PythonPackage {
        final PythonPackageVersion version;
        final String packageName;

        PythonPackage(String packageName, String versionString) {
            this.packageName = packageName;
            this.version = PythonPackageVersion.fromString(versionString);
        }

        PythonPackage(String packageName, PythonPackageVersion version) {
            this.packageName = packageName;
            this.version = version;
        }
    }

    public static class TestCompatibilityInfo {
        public CompatibilityStatus compatibilityStatus;
        public List<String> reasons = new ArrayList<String>();

        public TestCompatibilityInfo(PythonEnvPackages env) {
            switch (env.deploymentMode) {
                case DSS_INTERNAL: 
                case DESIGN_MANAGED: 
                case PLUGIN_MANAGED: 
                case AUTOMATION_VERSIONED: 
                case AUTOMATION_SINGLE: {
                    this.checkMissingPytestPackage(env);
                    this.checkPythonVersion(env);
                    break;
                }
                case DESIGN_NON_MANAGED: 
                case PLUGIN_NON_MANAGED: 
                case AUTOMATION_NON_MANAGED_PATH: 
                case EXTERNAL_CONDA_NAMED: {
                    this.reasons.add("Cannot assess Pytest compatibility status of a non-managed code environment");
                    this.compatibilityStatus = CompatibilityStatus.MAYBE_COMPATIBLE;
                }
            }
        }

        private void checkMissingPytestPackage(PythonEnvPackages env) {
            if (this.compatibilityStatus == CompatibilityStatus.INCOMPATIBLE) {
                return;
            }
            if (!env.hasPackage("pytest")) {
                this.reasons.add("it does not include pytest");
                this.compatibilityStatus = CompatibilityStatus.INCOMPATIBLE;
            } else {
                this.compatibilityStatus = CompatibilityStatus.COMPATIBLE;
            }
        }

        private void checkPythonVersion(PythonEnvPackages env) {
            if (this.compatibilityStatus == CompatibilityStatus.INCOMPATIBLE) {
                return;
            }
            if (env.pythonInterpreter.isDeprecated()) {
                this.reasons.add("the python interpreter: " + String.valueOf((Object)env.pythonInterpreter) + " is deprecated");
                this.compatibilityStatus = CompatibilityStatus.MAYBE_COMPATIBLE;
            }
        }

        public static enum CompatibilityStatus {
            INCOMPATIBLE,
            MAYBE_COMPATIBLE,
            COMPATIBLE;

        }
    }

    public static class CodeEnvTestCompat {
        public final String envName;
        public final TestCompatibilityInfo compatibilityInfo;

        public CodeEnvTestCompat(PythonEnvPackages env) {
            this.envName = env.envName;
            this.compatibilityInfo = new TestCompatibilityInfo(env);
        }
    }

    @UIModel
    public static class MLflowCompatibilityInfo {
        public static final String MLFLOW_PACKAGE_NAME = "mlflow";
        public static final String MLFLOW_UNSUPPORTED_BOUNDARY = "2.0.0";
        public CompatibilityStatus compatibilityStatus = CompatibilityStatus.TESTED_COMPATIBLE;
        public List<String> reasons = new ArrayList<String>();

        public MLflowCompatibilityInfo() {
            this.reasons.add("Could not assess MLflow compatibility status of code environment");
            this.compatibilityStatus = CompatibilityStatus.MAYBE_COMPATIBLE;
        }

        public MLflowCompatibilityInfo(PythonEnvPackages env) {
            switch (env.deploymentMode) {
                case DESIGN_NON_MANAGED: 
                case PLUGIN_NON_MANAGED: 
                case AUTOMATION_NON_MANAGED_PATH: 
                case EXTERNAL_CONDA_NAMED: {
                    this.reasons.add("Cannot assess MLflow compatibility status of a non-managed code environment");
                    this.compatibilityStatus = CompatibilityStatus.MAYBE_COMPATIBLE;
                    return;
                }
            }
            this.checkMLflowPackage(env);
            this.checkPythonVersion(env);
        }

        private void checkMLflowPackage(PythonEnvPackages env) {
            if (this.compatibilityStatus == CompatibilityStatus.INCOMPATIBLE) {
                return;
            }
            if (!env.hasPackage(MLFLOW_PACKAGE_NAME)) {
                this.reasons.add("Missing package: mlflow");
                this.compatibilityStatus = CompatibilityStatus.INCOMPATIBLE;
                return;
            }
            PythonPackageVersion mlflowVersion = env.getPackageVersion(MLFLOW_PACKAGE_NAME);
            if (null != mlflowVersion && mlflowVersion.lt(PythonPackageVersion.fromString(MLFLOW_UNSUPPORTED_BOUNDARY))) {
                this.reasons.add(String.format("Unsupported version of the %s package is used: %s. The minimum supported version is %s", MLFLOW_PACKAGE_NAME, mlflowVersion, MLFLOW_UNSUPPORTED_BOUNDARY));
                this.compatibilityStatus = CompatibilityStatus.DEPRECATED_COMPATIBLE;
            }
        }

        private void checkPythonVersion(PythonEnvPackages env) {
            if (this.compatibilityStatus == CompatibilityStatus.INCOMPATIBLE) {
                return;
            }
            if (env.pythonInterpreter.isDeprecated()) {
                this.reasons.add("Python interpreter: " + String.valueOf((Object)env.pythonInterpreter) + " is deprecated");
                this.compatibilityStatus = CompatibilityStatus.MAYBE_COMPATIBLE;
            }
        }

        public static enum CompatibilityStatus {
            INCOMPATIBLE,
            DEPRECATED_COMPATIBLE,
            MAYBE_COMPATIBLE,
            TESTED_COMPATIBLE;

        }
    }

    @UIModel
    public static class CodeEnvMLflowCompat {
        public final String envName;
        public final MLflowCompatibilityInfo compatibilityInfo;

        public CodeEnvMLflowCompat(PythonEnvPackages env) {
            this.envName = env.envName;
            this.compatibilityInfo = new MLflowCompatibilityInfo(env);
        }
    }

    public static class CodeEnvVisualMLCompat {
        public final String envName;
        public final CompatibilityInfo regularMl = new CompatibilityInfo("visual ML models");
        public final CompatibilityInfo monotonicConstraints = new CompatibilityInfo("monotonic constraints");
        public final CompatibilityInfo keepMissingNumericalAsNaN = new CompatibilityInfo("non-imputed empty numerical input");
        public final KerasCompatibilityInfo keras = new KerasCompatibilityInfo("deep learning models with Keras");
        public final CompatibilityInfoWithGPUSupport timeseries = new CompatibilityInfoWithGPUSupport("time series forecasting models");
        public final CompatibilityInfoWithGPUSupport torchTimeseries = new CompatibilityInfoWithGPUSupport("time series forecasting models using Torch: Simple Feed Forward, DeepAR");
        public final CompatibilityInfoWithGPUSupport mxnetTimeseries = new CompatibilityInfoWithGPUSupport("time series forecasting models using MXNet: Simple Feed Forward, DeepAR, Transformer and MQ-CNN");
        public final CompatibilityInfo prophet = new CompatibilityInfo("prophet algorithm");
        public final CompatibilityInfo gluonts = new CompatibilityInfo("gluonts algorithm");
        public final CompatibilityInfo statsmodel = new CompatibilityInfo("statsmodel algorithm");
        public final CompatibilityInfo pmdarima = new CompatibilityInfo("pdmarima algorithm");
        public final CompatibilityInfo causal = new CompatibilityInfo("causal prediction models");
        public final CompatibilityInfo sentenceEmbedding = new CompatibilityInfo("text embedding preprocessing");
        public final CompatibilityInfo bayesianSearch = new CompatibilityInfo("hyperparameters bayesian search");
        public final CompatibilityInfo deepNeuralNetwork = new CompatibilityInfo("deep neural network algorithm");
        public final CompatibilityInfo hdbscan = new CompatibilityInfo("hdbscan algorithm");
        public final CompatibilityInfo llmEvaluation = new CompatibilityInfo("LLM evaluation default metrics");

        public CodeEnvVisualMLCompat(PythonEnvPackages env) {
            this.envName = env.envName;
            this.buildForRegularMl(env);
            this.buildForKeras(env);
            this.buildForTimeseriesForecasting(env);
            this.buildForMxnetTimeseries(env);
            this.buildForTorchTimeseries(env);
            this.buildForProphet(env);
            this.buildForGluonts(env);
            this.buildForStatsmodel(env);
            this.buildForPmdarima(env);
            this.buildForCausalPrediction(env);
            this.buildForBayesianSearch(env);
            this.buildForSentenceEmbedding(env);
            this.buildForDeepNeuralNetwork(env);
            this.buildForHDBScan(env);
            this.buildForLLMEvaluation(env);
            this.buildForMonotonicConstraints(env);
            this.buildForMissingNumericalAsNaN(env);
        }

        public CodeEnvVisualMLCompat() {
            this.envName = null;
        }

        private void buildForKeras(PythonEnvPackages env) {
            PythonPackageVersion tfVersion;
            this.keras.setIncompatibleIfDeprecatedPythonInterpreter(env.pythonInterpreter);
            this.keras.setIncompatibleIfMissingPackages(env.findMissingPackagesForKerasDL());
            PythonEnvPackages.TensorflowSupport tfSupport = env.getTensorflowSupport();
            if (tfSupport.supportsGpu) {
                this.keras.supportsGpu = true;
            }
            boolean bl = this.keras.isAtLeastTensorflow2_2 = (tfVersion = env.getTensorflowVersion()) != null && tfVersion.gte(PythonPackageVersion.fromString("2.2"));
            if (PythonEnvPackages.TensorflowSupport.UNSUPPORTED.equals((Object)tfSupport)) {
                CodeEnvVisualMLCompat.checkPackageSupported("tensorflow", env, this.keras);
            }
            CodeEnvVisualMLCompat.checkPackageSupported("scikit-learn", env, this.keras);
        }

        public void buildForRegularMl(PythonEnvPackages env) {
            this.regularMl.setIncompatibleIfDeprecatedPythonInterpreter(env.pythonInterpreter);
            this.regularMl.setIncompatibleIfMissingPackages(env.findMissingPackages(PythonEnvPackages.VISUAL_ML_PACKAGE_NAMES));
            CodeEnvVisualMLCompat.checkPackageSupported("scikit-learn", env, this.regularMl);
        }

        private void buildForBayesianSearch(PythonEnvPackages env) {
            this.bayesianSearch.setIncompatibleIfMissingPackages(env.findMissingPackages(Arrays.asList("scikit-optimize")));
            CodeEnvVisualMLCompat.checkPackageSupported("scikit-optimize", env, this.bayesianSearch);
            this.checkScikitOptimizeAndScikitLearnCompatibility(env);
        }

        private void buildForSentenceEmbedding(PythonEnvPackages env) {
            this.sentenceEmbedding.setIncompatibleIfMissingPackages(env.findMissingPackages(Arrays.asList("sentence-transformers")));
            CodeEnvVisualMLCompat.checkPackageSupported("sentence-transformers", env, this.sentenceEmbedding);
        }

        public void buildForTimeseriesForecasting(PythonEnvPackages env) {
            this.timeseries.setIncompatibleIfDeprecatedPythonInterpreter(env.pythonInterpreter);
            this.timeseries.setIncompatibleIfMissingPackages(env.findMissingPackagesForTimeseries());
            CodeEnvVisualMLCompat.checkPackageSupported("scikit-learn", env, this.timeseries);
            this.checkPmdArimaAndScipyCompatibility(env);
        }

        private void buildForMxnetTimeseries(PythonEnvPackages env) {
            this.mxnetTimeseries.setIncompatibleIfMissingPackages(env.findMissingPackagesForMxnetTimeseries());
            PythonEnvPackages.MXNetSupport mxnetSupport = env.getMxnetSupport();
            if (mxnetSupport.supportsGpu) {
                this.mxnetTimeseries.supportsGpu = true;
            }
            if (PythonEnvPackages.MXNetSupport.UNSUPPORTED.equals((Object)mxnetSupport)) {
                CodeEnvVisualMLCompat.checkPackageSupported("mxnet", env, this.mxnetTimeseries);
            }
        }

        private void buildForTorchTimeseries(PythonEnvPackages env) {
            if (!env.pythonInterpreter.isVersionGreaterOrEqual(StandardPythonInterpreter.PYTHON37)) {
                this.torchTimeseries.addIncompatibilityReason("Python 3.6 and lower are not supported to run");
            }
            this.torchTimeseries.setIncompatibleIfMissingPackages(env.findMissingPackagesForTorchTimeseries());
            this.torchTimeseries.supportsGpu = true;
        }

        public void buildForProphet(PythonEnvPackages env) {
            this.prophet.setIncompatibleIfMissingPackages(env.findMissingPackages(Arrays.asList("prophet")));
            CodeEnvVisualMLCompat.checkPackageSupported("prophet", env, this.prophet);
        }

        public void buildForGluonts(PythonEnvPackages env) {
            this.gluonts.setIncompatibleIfMissingPackages(env.findMissingPackages(Arrays.asList("gluonts")));
            CodeEnvVisualMLCompat.checkPackageSupported("gluonts", env, this.gluonts);
        }

        public void buildForStatsmodel(PythonEnvPackages env) {
            this.statsmodel.setIncompatibleIfMissingPackages(env.findMissingPackages(Arrays.asList("statsmodels")));
            CodeEnvVisualMLCompat.checkPackageSupported("statsmodels", env, this.statsmodel);
        }

        public void buildForPmdarima(PythonEnvPackages env) {
            this.pmdarima.setIncompatibleIfMissingPackages(env.findMissingPackages(Arrays.asList("pmdarima")));
            CodeEnvVisualMLCompat.checkPackageSupported("pmdarima", env, this.pmdarima);
        }

        public void buildForCausalPrediction(PythonEnvPackages env) {
            this.causal.compatible = true;
            this.causal.setIncompatibleIfMissingPackages(env.findMissingPackages(PythonEnvPackages.CAUSAL_ML_PACKAGE_NAMES));
            CodeEnvVisualMLCompat.checkPackageSupported("econml", env, this.causal);
            CodeEnvVisualMLCompat.checkPackageSupported("scikit-learn", env, this.causal);
        }

        public void buildForDeepNeuralNetwork(PythonEnvPackages env) {
            if (env.pythonInterpreter.isVersionGreaterOrEqual(StandardPythonInterpreter.PYTHON36)) {
                this.deepNeuralNetwork.setIncompatibleIfMissingPackages(env.findMissingPackages(PythonEnvPackages.DEEP_NEURAL_NETWORK_PACKAGE_NAMES));
                CodeEnvVisualMLCompat.checkPackageSupported("torch", env, this.deepNeuralNetwork);
                CodeEnvVisualMLCompat.checkPackageSupported("skorch", env, this.deepNeuralNetwork);
            } else {
                this.deepNeuralNetwork.addIncompatibilityReason("Python version incompatible with");
            }
        }

        private void buildForHDBScan(PythonEnvPackages env) {
            PythonPackageVersion packageVersion = env.getPackageVersion("scikit-learn");
            if (packageVersion != null && packageVersion.gte(PythonPackageVersion.fromString("1.3"))) {
                this.hdbscan.compatible = true;
            } else {
                this.hdbscan.compatible = false;
                this.hdbscan.addIncompatibilityReason("Scikit-learn version must be greater or equal to 1.3 to run");
            }
        }

        public void buildForLLMEvaluation(PythonEnvPackages env) {
            PythonPackageVersion pydanticPackageVersion;
            this.llmEvaluation.setIncompatibleIfMissingPackages(env.findMissingPackages(PythonEnvPackages.LLM_EVALUATION_RECIPE_PACKAGE_NAMES));
            PythonPackageVersion ragasPackageVersion = env.getPackageVersion("ragas");
            if (ragasPackageVersion == null || ragasPackageVersion.lt(PythonPackageVersion.fromString("0.2"))) {
                this.llmEvaluation.compatible = false;
                this.llmEvaluation.addIncompatibilityReason("Ragas 0.1.X is deprecated. You should update it to 0.2.X to run.");
            }
            if (ragasPackageVersion == null || ragasPackageVersion.gte(PythonPackageVersion.fromString("0.3"))) {
                this.llmEvaluation.compatible = false;
                this.llmEvaluation.addIncompatibilityReason("Ragas 0.3.X is not supported. You should use version 0.2.X to run.");
            }
            if ((pydanticPackageVersion = env.getPackageVersion("pydantic")) == null || pydanticPackageVersion.lt(PythonPackageVersion.fromString("2"))) {
                this.llmEvaluation.compatible = false;
                this.llmEvaluation.addIncompatibilityReason("Pydantic version must be greater than 2 to run.");
            }
        }

        private void buildForMonotonicConstraints(PythonEnvPackages env) {
            PythonPackageVersion packageVersion = env.getPackageVersion("scikit-learn");
            if (packageVersion != null && packageVersion.gte(PythonPackageVersion.fromString("1.4"))) {
                this.monotonicConstraints.compatible = true;
            } else {
                this.monotonicConstraints.compatible = false;
                this.monotonicConstraints.addIncompatibilityReason("Scikit-learn version must be greater or equal to 1.4 to run");
            }
        }

        private void buildForMissingNumericalAsNaN(PythonEnvPackages env) {
            PythonPackageVersion packageVersion = env.getPackageVersion("scikit-learn");
            if (packageVersion != null && packageVersion.gte(PythonPackageVersion.fromString("1.3"))) {
                this.keepMissingNumericalAsNaN.compatible = true;
            } else {
                this.keepMissingNumericalAsNaN.compatible = false;
                this.keepMissingNumericalAsNaN.addIncompatibilityReason("Scikit-learn version must be greater or equal to 1.3 to support");
            }
        }

        public static CodeEnvVisualMLCompat builtinEnvCompatibility() {
            CodeEnvVisualMLCompat ret = new CodeEnvVisualMLCompat();
            ret.bayesianSearch.addBuiltinIncompatibilityReason();
            ret.sentenceEmbedding.addBuiltinIncompatibilityReason();
            ret.keras.addBuiltinIncompatibilityReason();
            ret.prophet.addBuiltinIncompatibilityReason();
            ret.gluonts.addBuiltinIncompatibilityReason();
            ret.pmdarima.addBuiltinIncompatibilityReason();
            ret.mxnetTimeseries.addBuiltinIncompatibilityReason();
            ret.causal.addBuiltinIncompatibilityReason();
            ret.deepNeuralNetwork.addBuiltinIncompatibilityReason();
            ret.hdbscan.addBuiltinIncompatibilityReason();
            ret.llmEvaluation.addBuiltinIncompatibilityReason();
            ret.monotonicConstraints.addBuiltinIncompatibilityReason();
            return ret;
        }

        private static void checkPackageSupported(String packageName, PythonEnvPackages env, CompatibilityInfo compatibilityInfo) {
            PythonPackageVersion minUnsupportedVersion;
            PythonPackageVersion packageVersion = env.getPackageVersion(packageName);
            if (packageVersion == null) {
                return;
            }
            PythonPackageVersion minSupportedVersion = env.pythonInterpreter.minSupportedVersion(packageName);
            PythonPackageVersionBounds packageVersionBounds = new PythonPackageVersionBounds(minSupportedVersion, minUnsupportedVersion = env.pythonInterpreter.minUnsupportedVersion(packageName));
            boolean isPackageVersionSupported = packageVersionBounds.contains(packageVersion);
            if (!isPackageVersionSupported) {
                String reasonPrefix = "Unsupported " + packageName + " version installed: " + String.valueOf(packageVersion) + ", must be ";
                compatibilityInfo.addIncompatibilityReason(reasonPrefix + packageVersionBounds.toString() + " to run");
            }
        }

        private PythonPackageVersionBounds getSkOptBounds(PythonPackageVersion scikitLearnVersion) {
            if (scikitLearnVersion.lt(PythonPackageVersion.fromString("0.23"))) {
                return new PythonPackageVersionBounds("0.7.0", "0.10");
            }
            if (scikitLearnVersion.lt(PythonPackageVersion.fromString("0.24"))) {
                return new PythonPackageVersionBounds("0.8.0", "0.10");
            }
            if (scikitLearnVersion.lt(PythonPackageVersion.fromString("1.4"))) {
                return new PythonPackageVersionBounds("0.9.0", "0.10");
            }
            return new PythonPackageVersionBounds("0.10.0", "0.10.3");
        }

        private void checkScikitOptimizeAndScikitLearnCompatibility(PythonEnvPackages env) {
            if (!env.hasPackage("scikit-learn") || !env.hasPackage("scikit-optimize")) {
                return;
            }
            PythonPackageVersion scikitLearnVersion = env.getPackageVersion("scikit-learn");
            PythonPackageVersionBounds skOptBounds = this.getSkOptBounds(scikitLearnVersion);
            if (!skOptBounds.contains(env.getPackageVersion("scikit-optimize"))) {
                this.bayesianSearch.addIncompatibilityReason(String.format("%s version %s needs: %s%s for", "scikit-learn", scikitLearnVersion.stringRepr, "scikit-optimize", skOptBounds.toString()));
            }
        }

        private PythonPackageVersionBounds getScipyBoundsForPmdArima(PythonPackageVersion pmdarimaVersion) {
            if (pmdarimaVersion.lt(PythonPackageVersion.fromString("1.3"))) {
                return new PythonPackageVersionBounds(null, "1.3");
            }
            if (pmdarimaVersion.lte(PythonPackageVersion.fromString("1.5.2"))) {
                return new PythonPackageVersionBounds("1.3", null);
            }
            return new PythonPackageVersionBounds("1.3.2", null);
        }

        private void checkPmdArimaAndScipyCompatibility(PythonEnvPackages env) {
            if (!env.hasPackage("pmdarima") || !env.hasPackage("scipy")) {
                return;
            }
            PythonPackageVersion pmdarimaVersion = env.getPackageVersion("pmdarima");
            PythonPackageVersionBounds scipyBounds = this.getScipyBoundsForPmdArima(pmdarimaVersion);
            if (!scipyBounds.contains(env.getPackageVersion("scipy"))) {
                this.timeseries.addIncompatibilityReason(String.format("%s version %s needs: %s%s for", "pmdarima", pmdarimaVersion.stringRepr, "scipy", scipyBounds.toString()));
            }
        }

        private static class PythonPackageVersionBounds {
            private PythonPackageVersion lower = null;
            private PythonPackageVersion upper = null;

            public PythonPackageVersionBounds(@Nullable PythonPackageVersion lower, @Nullable PythonPackageVersion upper) {
                this.lower = lower;
                this.upper = upper;
            }

            public PythonPackageVersionBounds(@Nullable String lower, @Nullable String upper) {
                if (lower != null) {
                    this.lower = PythonPackageVersion.fromString(lower);
                }
                if (upper != null) {
                    this.upper = PythonPackageVersion.fromString(upper);
                }
            }

            public boolean contains(PythonPackageVersion packageVersion) {
                if (packageVersion == null) {
                    throw new IllegalArgumentException("Cannot check null package version against requirements");
                }
                return !(this.lower != null && !this.lower.lte(packageVersion) || this.upper != null && !this.upper.gt(packageVersion));
            }

            public String toString() {
                ArrayList<CallSite> versionComparisonStrings = new ArrayList<CallSite>();
                if (this.lower != null) {
                    versionComparisonStrings.add((CallSite)((Object)(">=" + String.valueOf(this.lower))));
                }
                if (this.upper != null) {
                    versionComparisonStrings.add((CallSite)((Object)("<" + String.valueOf(this.upper))));
                }
                return StringUtils.join(versionComparisonStrings, (String)", ");
            }
        }
    }

    public static class KerasCompatibilityInfo
    extends CompatibilityInfoWithGPUSupport {
        boolean isAtLeastTensorflow2_2;

        KerasCompatibilityInfo(String displayName) {
            super(displayName);
        }
    }

    public static class CompatibilityInfoWithGPUSupport
    extends CompatibilityInfo {
        boolean supportsGpu;

        CompatibilityInfoWithGPUSupport(String displayName) {
            super(displayName);
            this.displayName = displayName + (this.supportsGpu ? " (GPU or CPU)" : " (CPU)");
        }
    }

    public static class CompatibilityInfo {
        public String displayName;
        public boolean compatible = true;
        public List<String> reasons = new ArrayList<String>();

        public CompatibilityInfo(String displayName) {
            this.displayName = displayName;
        }

        public void addBuiltinIncompatibilityReason() {
            this.addIncompatibilityReason("Builtin env does not support");
        }

        public void addIncompatibilityReason(String baseReason) {
            this.compatible = false;
            this.reasons.add(baseReason + " " + this.displayName);
        }

        public void setIncompatibleIfMissingPackages(List<String> missingPackages) {
            if (!missingPackages.isEmpty()) {
                this.addIncompatibilityReason("Missing packages " + StringUtils.join(missingPackages, (String)", ") + " to run");
            }
        }

        public void setIncompatibleIfDeprecatedPythonInterpreter(StandardPythonInterpreter pythonInterpreter) {
            if (pythonInterpreter.isDeprecated()) {
                this.compatible = false;
                this.reasons.add("Python interpreter: '" + String.valueOf((Object)pythonInterpreter) + "' is deprecated and will soon be removed");
            }
        }
    }

    public static class PythonPackageVersion {
        private static final Pattern PY_PACKAGE_VERSION_COMPONENT = Pattern.compile("(\\d+|[a-z]+|\\.)");
        String stringRepr;
        boolean unknown = false;
        List<String> components = new ArrayList<String>();

        public static PythonPackageVersion fromString(String versionString) {
            PythonPackageVersion version = new PythonPackageVersion();
            version.stringRepr = versionString;
            if (versionString != null) {
                Matcher matcher = PY_PACKAGE_VERSION_COMPONENT.matcher(versionString);
                while (matcher.find()) {
                    String group = matcher.group(1);
                    if (".".equals(group)) continue;
                    version.components.add(group);
                }
            } else {
                version.unknown = true;
            }
            return version;
        }

        public int compareTo(PythonPackageVersion otherVersion) {
            ComparisonChain chain = ComparisonChain.start();
            for (int j = 0; j < Math.max(this.components.size(), otherVersion.components.size()); ++j) {
                String component = j < this.components.size() ? this.components.get(j) : null;
                String otherComponent = j < otherVersion.components.size() ? otherVersion.components.get(j) : null;
                chain = NumberUtils.isDigits((String)component) && NumberUtils.isDigits((String)otherComponent) ? chain.compare(Integer.parseInt(component), Integer.parseInt(otherComponent)) : chain.compare((Object)component, (Object)otherComponent, (Comparator)Ordering.natural().nullsFirst());
            }
            return chain.compare((Object)this.stringRepr, (Object)otherVersion.stringRepr, (Comparator)Ordering.natural().nullsFirst()).result();
        }

        public boolean gt(PythonPackageVersion otherVersion) {
            return this.compareTo(otherVersion) > 0;
        }

        public boolean gte(PythonPackageVersion otherVersion) {
            return this.compareTo(otherVersion) >= 0;
        }

        public boolean lt(PythonPackageVersion otherVersion) {
            return this.compareTo(otherVersion) < 0;
        }

        public boolean lte(PythonPackageVersion otherVersion) {
            return this.compareTo(otherVersion) <= 0;
        }

        public String toString() {
            if (this.stringRepr != null) {
                return this.stringRepr;
            }
            return "__no_version__";
        }
    }
}

