/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.object;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.codestudio.CodeStudioCodes;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectParams;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.shaker.text.StringNormalizer;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppMeta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeStudioObjectsService {
    @Autowired
    private CodeStudioObjectsDAO dao;
    @Autowired
    private CodeStudioTemplatesDAO templatesDao;
    @Autowired
    private CodeStudioRuntimeManager runtimeManager;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TrackingService trackingService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.codestudio.objects.service");

    public CodeStudioObject getMandatory(String projectKey, String id) throws IOException {
        return (CodeStudioObject)this.dao.getMandatory(projectKey, id);
    }

    public CodeStudioObject getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (CodeStudioObject)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    public CodeStudioObject getOrNull(String projectKey, String id) throws IOException {
        return (CodeStudioObject)this.dao.getOrNull(projectKey, id);
    }

    public CodeStudioObject getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (CodeStudioObject)this.dao.getOrNullUnsafe(projectKey, id);
    }

    public List<CodeStudioObject> listUnsafe(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.dao.approximateCount(projectKey);
    }

    private List<CodeStudioObject.ListItem> listHeads(String projectKey) throws IOException {
        ArrayList<CodeStudioObject.ListItem> ret = new ArrayList<CodeStudioObject.ListItem>();
        HashMap templates = Maps.newHashMap();
        for (CodeStudioObject codeStudioObject : this.listUnsafe(projectKey)) {
            CodeStudioTemplate template;
            CodeStudioObject.ListItem listItem = new CodeStudioObject.ListItem(codeStudioObject);
            this.taggableObjectsService.setEditionInfoFromTags(codeStudioObject, listItem);
            if (!templates.containsKey(codeStudioObject.templateId)) {
                templates.put(codeStudioObject.templateId, this.templatesDao.getOrNullUnsafe(codeStudioObject.templateId));
            }
            if ((template = (CodeStudioTemplate)templates.get(codeStudioObject.templateId)) != null && CodeStudioRegistry.hasMeta(template)) {
                listItem.desc = CodeStudioRegistry.getMeta(template).getCodeStudioType(template);
                CodeStudioTemplatesService.CodeStudioTemplateImageBuilt imageBuilt = CodeStudioTemplatesService.getLatest(template);
                listItem.templateNeedRebuild = imageBuilt == null || !DKUApp.getDSSVersionTag().equals(imageBuilt.dssVersion);
            } else {
                listItem.templateId = codeStudioObject.templateId;
                listItem.templateWasDeleted = true;
            }
            ret.add(listItem);
        }
        return ret;
    }

    public List<CodeStudioObject.ListItem> listHeads(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        if (authCtx.isAdmin() || this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN)) {
            return this.listHeads(projectKey);
        }
        ArrayList<CodeStudioObject.ListItem> ret = new ArrayList<CodeStudioObject.ListItem>();
        for (CodeStudioObject.ListItem head : this.listHeads(projectKey)) {
            if (!StringUtils.equals((String)authCtx.getAssociatedDSSUser(), (String)head.owner)) continue;
            ret.add(head);
        }
        return ret;
    }

    public CodeStudioObject createNoSave(AuthCtx authCtx, String projectKey, String codeStudioId, String name, String codeStudioTemplateId) throws Exception {
        if (codeStudioId == null) {
            codeStudioId = this.dao.generateUniqueId(projectKey);
        } else if (this.getOrNullUnsafe(projectKey, codeStudioId) != null) {
            throw new IllegalArgumentException(String.format("Code Studio with id %s already exists", codeStudioId));
        }
        this.templatesDao.getMandatoryUnsafe(codeStudioTemplateId);
        CodeStudioObject codeStudioObject = new CodeStudioObject();
        codeStudioObject.id = codeStudioId;
        codeStudioObject.projectKey = projectKey;
        codeStudioObject.name = name;
        codeStudioObject.libName = this.makeUniqueLibName(codeStudioObject);
        codeStudioObject.templateId = codeStudioTemplateId;
        codeStudioObject.params = new CodeStudioObjectParams();
        codeStudioObject.owner = authCtx.getIdentifier();
        return codeStudioObject;
    }

    public boolean hasPartialAccess(AuthCtx authCtx, String projectKey, String codeStudioId) throws DKUSecurityException, IOException {
        if (authCtx.isAdmin()) {
            return true;
        }
        if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN)) {
            return true;
        }
        CodeStudioObject codeStudio = (CodeStudioObject)this.dao.getMandatoryUnsafe(projectKey, codeStudioId);
        return StringUtils.equals((String)codeStudio.getOwner(), (String)authCtx.getAssociatedDSSUser());
    }

    public boolean hasFullAccess(AuthCtx authCtx, String projectKey, String codeStudioId) throws DKUSecurityException, IOException {
        if (authCtx.isAdmin()) {
            return true;
        }
        CodeStudioObject codeStudio = (CodeStudioObject)this.dao.getMandatoryUnsafe(projectKey, codeStudioId);
        return StringUtils.equals((String)codeStudio.getOwner(), (String)authCtx.getAssociatedDSSUser());
    }

    public void postCreate_NT(AuthCtx authCtx, CodeStudioObject codeStudioObject, InfoMessage.InfoMessages messages) throws Exception {
        block52: {
            CodeStudioTemplate codeStudioTemplate;
            try (Transaction t = this.transactionService.beginRead();){
                codeStudioTemplate = this.templatesDao.getMandatoryUnsafe(codeStudioObject.templateId);
            }
            CodeStudioMeta meta = CodeStudioRegistry.getMeta(codeStudioTemplate);
            try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"code-studio-object-creation", (String)codeStudioObject.id);){
                RWTransaction t;
                NativeFS tmpFS;
                CodeStudioMeta.CreationEnv creationEnv = new CodeStudioMeta.CreationEnv();
                creationEnv.tmpDir = tmpDir.getAbsolutePath();
                creationEnv.codeStudio = codeStudioObject;
                CodeStudioMeta.CreationSpec creationSpec = meta.getCreationSpec(authCtx, codeStudioTemplate, creationEnv);
                if (!creationSpec.codeStudioVersionedFiles.isEmpty() || !creationSpec.userVersionedFiles.isEmpty()) {
                    tmpFS = NativeFS.from((File)tmpDir).build();
                    try (RWTransaction t2 = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                        this.copyIfNotAlreadyThere(creationSpec.codeStudioVersionedFiles, tmpFS, t2, CodeStudioSyncZones.CODE_STUDIO_VERSIONED.rootRelFile(authCtx, codeStudioObject));
                        t2.commit("Ran post-creation actions on Code Studio " + codeStudioObject.getFullId());
                    }
                    t2 = this.transactionService.beginWriteAsLoggedInUser(authCtx);
                    try {
                        this.copyIfNotAlreadyThere(creationSpec.userVersionedFiles, tmpFS, t2, CodeStudioSyncZones.USER_VERSIONED.rootRelFile(authCtx, codeStudioObject));
                        t2.commit("Ran post-creation actions on Code Studio " + codeStudioObject.getFullId());
                    }
                    finally {
                        if (t2 != null) {
                            t2.close();
                        }
                    }
                }
                if (creationSpec.codeStudioResourcesFiles.isEmpty() && creationSpec.userResourcesFiles.isEmpty()) break block52;
                tmpFS = NativeFS.from((File)tmpDir).build();
                try (TransactionProvider transactionProvider = new TransactionProvider(ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio"}), (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, false, true));){
                    t = transactionProvider.beginWrite(authCtx);
                    try {
                        this.copyIfNotAlreadyThere(creationSpec.codeStudioResourcesFiles, tmpFS, t, CodeStudioSyncZones.CODE_STUDIO_RESOURCES.rootRelFile(authCtx, codeStudioObject));
                        t.commit("Ran post-creation actions on Code Studio " + codeStudioObject.getFullId());
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                }
                transactionProvider = new TransactionProvider(ApplicationConfigurator.getFile((String[])new String[]{"lib", "user-data"}), (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, false, true));
                try {
                    t = transactionProvider.beginWrite(authCtx);
                    try {
                        this.copyIfNotAlreadyThere(creationSpec.userResourcesFiles, tmpFS, t, CodeStudioSyncZones.USER_RESOURCES.rootRelFile(authCtx, codeStudioObject));
                        t.commit("Ran post-creation actions on Code Studio " + codeStudioObject.getFullId());
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                }
                finally {
                    transactionProvider.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to handle starter files", (Throwable)e);
                messages.withWarning((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CREATE, "Failed to setup starter files : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    private void copyIfNotAlreadyThere(List<SimpleKeyValue> files, NativeFS tmpFS, RWTransaction t, RelFile root) throws IOException {
        for (SimpleKeyValue kv : files) {
            RelFile target = root.appendChildPath(kv.value);
            RelFile source = RelFile.fromPath((String)kv.key);
            if (!tmpFS.exists(source)) {
                throw new IOException("Source file " + kv.key + " not found");
            }
            if (t.exists(target)) {
                logger.info((Object)("Target file " + kv.value + " already exists, skipping"));
                continue;
            }
            if (kv.value.endsWith("/") && tmpFS.isFile(source)) {
                target = target.append(new String[]{source.getLeafName()});
            }
            if (!t.exists(target.getParent())) {
                t.makeDirectory(target.getParent());
            }
            FSUtils.newRecursiveCopy().from((ReadOnlyFS)tmpFS, source).to((ReadWriteFS)t, target).run();
        }
    }

    public Set<TaggableObjectsDeletionService.ImpactedWebApp> getCodeStudioWebApps(String projectKey, String id) throws IOException {
        HashSet<TaggableObjectsDeletionService.ImpactedWebApp> webapps = new HashSet<TaggableObjectsDeletionService.ImpactedWebApp>();
        for (WebApp webapp : this.webAppsService.listUnsafe_noCode(projectKey)) {
            if (!webapp.type.equals("CODE_STUDIO_AS_WEBAPP") || !webapp.getParamsAs(CodeStudioWebAppMeta.CodeStudioWebAppParams.class).codeStudioId.equals(id)) continue;
            webapps.add(new TaggableObjectsDeletionService.ImpactedWebApp(webapp.getProjectKey(), webapp.getDisplayName(), webapp.getId(), webapp.type));
        }
        return webapps;
    }

    public CodeStudioObjectUsage getCurrentUsage(String projectKey, String id) throws Exception {
        CodeStudioObjectUsage usage = new CodeStudioObjectUsage();
        usage.users = this.trackingService.getUsersOnObject(ITaggingService.TaggableType.CODE_STUDIO, projectKey, id);
        usage.webapps = this.getCodeStudioWebApps(projectKey, id);
        return usage;
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        CodeStudioObjectUsage usage = this.getCurrentUsage(projectKey, id);
        di.deletedWebApps = usage.webapps.stream().filter(webapp -> ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(webapp.projectKey, ITaggingService.TaggableType.WEB_APP, webapp.id))).collect(Collectors.toSet());
        TaggableObjectsDeletionService.AvailableDeletionOptions availableOptions = new TaggableObjectsDeletionService.AvailableDeletionOptions();
        di.availableOptions.put(projectKey + "." + id, availableOptions);
        return di;
    }

    public CodeStudioObject save(CodeStudioObject codeStudioObject, boolean creation) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)codeStudioObject.params, (Object)"CodeStudioObject params are required");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        CodeStudioObject existing = this.getOrNullUnsafe(codeStudioObject.projectKey, codeStudioObject.id);
        if (creation && existing != null) {
            throw new IllegalArgumentException("CodeStudioObject already exists");
        }
        if (!creation && existing == null) {
            throw new IllegalArgumentException("CodeStudioObject does not exist");
        }
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(codeStudioObject, existing);
        if (StringUtils.isNotBlank((String)codeStudioObject.params.runAs) && (existing == null || existing.params.runAs == null || !existing.params.runAs.equals(codeStudioObject.params.runAs))) {
            this.permissionsService.checkAdmin(t.getUser(), "change run-as of a codeStudioObject backend");
        }
        if (creation) {
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(codeStudioObject);
            RelFile versionedLib = new RelFile(new String[]{"projects", codeStudioObject.projectKey, "code_studios", codeStudioObject.id});
            t.makeDirectory(versionedLib);
            File resourcesLib = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", codeStudioObject.projectKey, codeStudioObject.libName});
            DKUFileUtils.mkdirs((File)resourcesLib);
        } else {
            if (!StringUtils.equals((String)existing.templateId, (String)codeStudioObject.templateId)) {
                throw new UnsupportedOperationException("Cannot change template of an existing Code Studio");
            }
            if (Pattern.matches("[^a-zA-Z0-9\\-_\\.]", codeStudioObject.libName)) {
                throw new IllegalArgumentException("The Code Studio library name can only contain a-z A-Z 0-9 . - and _");
            }
            if (StringUtils.equals((String)codeStudioObject.libName, (String)existing.libName)) {
                final File oldResourcesLib = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", codeStudioObject.projectKey, existing.libName});
                final File newResourcesLib = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", codeStudioObject.projectKey, codeStudioObject.libName});
                if (oldResourcesLib.exists() && oldResourcesLib.isDirectory()) {
                    t.onPostCommit(new Runnable(){

                        @Override
                        public void run() {
                            logger.info((Object)("Moving resources Code Studio lib " + oldResourcesLib.getAbsolutePath() + " to " + newResourcesLib.getAbsolutePath()));
                            if (!oldResourcesLib.renameTo(newResourcesLib)) {
                                logger.error((Object)"Could not rename");
                            }
                        }
                    });
                }
            }
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), this.getOrNull(codeStudioObject.projectKey, codeStudioObject.id), codeStudioObject);
        this.dao.save(codeStudioObject);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", codeStudioObject.name);
        if (creation) {
            action = TaggableObjectChangedEvent.ActionType.CODE_STUDIO_CREATE;
        } else if (codeStudioObject.name != null && !codeStudioObject.name.equals(existing.name)) {
            action = TaggableObjectChangedEvent.ActionType.CODE_STUDIO_RENAME;
            details.addProperty("newName", codeStudioObject.name);
            details.addProperty("oldName", existing.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.CODE_STUDIO_EDIT;
        }
        this.taggingService.onObjectSaved(codeStudioObject.projectKey, codeStudioObject.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.CODE_STUDIO, codeStudioObject.projectKey, codeStudioObject.id, t.getUser(), action).withDetails(details));
        return codeStudioObject;
    }

    public CodeStudioObject changeOwner(AuthCtx authCtx, String projectKey, String codeStudioObjectId, String newOwner) throws Exception {
        UsersService.UIUser destUser = this.usersService.getUser_NoLeak(newOwner);
        AuthCtx destUserAuth = this.authCtxCreationService.create(destUser.login);
        this.permissionsService.checkProjectPrivileges(destUserAuth, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        CodeStudioObject codeStudioObject = this.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        CodeStudioRuntime.CodeStudioUIState codeStudioUIState = this.runtimeManager.getState(authCtx, codeStudioObject);
        Preconditions.checkArgument((boolean)codeStudioUIState.state.equals((Object)CodeStudioRuntime.CodeStudioRuntimeState.STOPPED), (Object)"Code studio needs to be stopped in order to change it's owner");
        codeStudioObject.owner = destUserAuth.getIdentifier();
        return this.save(codeStudioObject, false);
    }

    public void delete(AuthCtx authCtx, String projectKey, String id) throws Exception {
        JsonObject details = new JsonObject();
        CodeStudioObject codeStudio = this.getOrNull(projectKey, id);
        if (codeStudio != null) {
            File resourcesFiles;
            details.addProperty("objectDisplayName", codeStudio.name);
            this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, codeStudio);
            this.runtimeManager.stop(authCtx, codeStudio);
            Set<TaggableObjectsDeletionService.ImpactedWebApp> webapps = this.getCodeStudioWebApps(projectKey, id);
            for (TaggableObjectsDeletionService.ImpactedWebApp webapp : webapps) {
                logger.info((Object)("Delete WebApp " + webapp.projectKey + "." + webapp.name + " " + webapp.id + " based on Code Studio " + projectKey + "." + id));
                this.webAppsService.delete(authCtx, webapp.projectKey, webapp.id);
            }
            this.dao.delete(projectKey, id);
            RelFile versionedFiles = new RelFile(new String[]{"projects", codeStudio.projectKey, "code_studios", codeStudio.id});
            RWTransactionRef t = TransactionContext.retrieveWrite();
            if (t.exists(versionedFiles)) {
                t.deleteDirectory(versionedFiles);
            }
            if ((resourcesFiles = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", codeStudio.projectKey, codeStudio.libName})).exists()) {
                t.onPostCommit(new Runnable(){

                    @Override
                    public void run() {
                        logger.info((Object)("Deleting resources Code Studio lib " + resourcesFiles.getAbsolutePath()));
                        try {
                            DKUFileUtils.forceDelete((File)resourcesFiles);
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Failed to cleanup Code Studio files", (Throwable)e);
                        }
                    }
                });
            }
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.CODE_STUDIO, projectKey, id, authCtx, TaggableObjectChangedEvent.ActionType.CODE_STUDIO_DELETE).withDetails(details));
    }

    public CodeStudioObject copy(AuthCtx authCtx, String projectKey, String codeStudioObjectId, String newName) throws Exception {
        CodeStudioObject srcCodeStudioObject = this.getMandatory(projectKey, codeStudioObjectId);
        CodeStudioObject codeStudioObject = (CodeStudioObject)JSON.deepCopy((Object)srcCodeStudioObject);
        newName = StringUtils.isBlank((String)newName) ? srcCodeStudioObject.name : newName;
        Preconditions.checkArgument((srcCodeStudioObject.projectKey != null ? 1 : 0) != 0, (Object)"Original codeStudioObject has no project key");
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", newName);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.CODE_STUDIO_CREATE;
        details.addProperty("copy", Boolean.valueOf(true));
        details.addProperty("originalObjectName", srcCodeStudioObject.name);
        details.addProperty("originalObjectId", srcCodeStudioObject.id);
        AuthCtx user = TransactionContext.retrieveWrite().getUser();
        codeStudioObject.id = SecretKeyGenerator.generateSmall();
        codeStudioObject.name = newName;
        codeStudioObject.libName = this.makeUniqueLibName(codeStudioObject);
        codeStudioObject.owner = authCtx.getIdentifier();
        codeStudioObject.creationTag = codeStudioObject.versionTag = VersionTag.increment(null, user.getIdentifier());
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, codeStudioObject);
        this.dao.save(codeStudioObject);
        RelFile srcVersionedFiles = new RelFile(new String[]{"projects", projectKey, "code_studios", srcCodeStudioObject.id});
        RelFile versionedFiles = new RelFile(new String[]{"projects", projectKey, "code_studios", codeStudioObject.id});
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(srcVersionedFiles)) {
            FSUtils.newRecursiveCopy().from((ReadOnlyFS)t, srcVersionedFiles).to((ReadWriteFS)t, versionedFiles).copyMethod(FSUtils.COPY_COMPRESSED_BYTES_REF).run();
        }
        final File srcResourcesFiles = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", projectKey, srcCodeStudioObject.libName});
        final File resourcesFiles = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", projectKey, codeStudioObject.libName});
        this.taggingService.onObjectSaved(codeStudioObject.projectKey, codeStudioObject.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.CODE_STUDIO, codeStudioObject.projectKey, codeStudioObject.id, user, action).withDetails(details));
        if (srcResourcesFiles.exists()) {
            t.onPostCommit(new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)("Copying resources Code Studio lib " + srcResourcesFiles.getAbsolutePath()));
                    try {
                        DKUFileUtils.copyDirectory((File)srcResourcesFiles, (File)resourcesFiles);
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Failed to copy Code Studio files", (Throwable)e);
                    }
                }
            });
        }
        return codeStudioObject;
    }

    public List<CodeStudioObject.CodeStudioObjectType> listTypes(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ArrayList ret = Lists.newArrayList();
        for (CodeStudioTemplate template : this.templatesDao.listUnsafe()) {
            if (!CodeStudioRegistry.hasMeta(template) || !this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, template, Privileges.CodeStudioTemplatePrivilegeType.USE)) continue;
            CodeStudioMeta meta = CodeStudioRegistry.getMeta(template);
            ret.add(meta.getCodeStudioType(template));
        }
        return ret;
    }

    private String makeUniqueLibName(CodeStudioObject codeStudio) throws IOException {
        String libName = StringNormalizer.normalize((String)codeStudio.name).replaceAll("[^a-zA-Z0-9\\-_\\.]", "_");
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        for (CodeStudioObject o : this.dao.listUnsafe(codeStudio.projectKey)) {
            if (StringUtils.equals((String)o.id, (String)codeStudio.id)) continue;
            transmogrifier.addAlreadyTransmogrified(o.libName);
        }
        return transmogrifier.transmogrify(libName);
    }

    public void checkCommandPerm(AuthCtx authCtx, CodeStudioObject codeStudio, String commandType) throws DKUSecurityException {
        if ("run_command_line".equals(commandType) && !this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudio.templateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
            throw new DKUSecurityException("Insufficient permissions to run command");
        }
    }

    public static class CodeStudioObjectUsage {
        Set<PublicUser> users;
        Set<TaggableObjectsDeletionService.ImpactedWebApp> webapps;
    }
}

