/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.anthropic.AnthropicPricing;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class AnthropicConnection
extends AbstractLLMConnection<AnthropicModel, HardcodedAnthropicModel, CustomAnthropicModel> {
    private static final EnrichedLLMStructuredRef.FieldRange TEMPERATURE_RANGE = new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01);
    private static final EnrichedLLMStructuredRef.FieldRange TOP_K_RANGE = new EnrichedLLMStructuredRef.FieldRange(0.0, 500.0, 1.0);
    public AnthropicConnectionParams params = new AnthropicConnectionParams();
    public static final String connectionType = "Anthropic";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.anthropic");

    @Override
    public AbstractLLMConnection.AbstractLLMConnectionParams getLLMConnectionParams() {
        return this.params;
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected List<HardcodedAnthropicModel> listRawHardcodedModels() {
        return Arrays.asList(HardcodedAnthropicModel.values());
    }

    @Override
    protected List<CustomAnthropicModel> listRawCustomModels() {
        return this.params.customModels;
    }

    @Override
    protected AnthropicModel loadRawHardcodedModel(HardcodedAnthropicModel hardcodedModel) {
        AnthropicModel model = hardcodedModel.toModel();
        this.loadDefaultHardcodedModelSettings(hardcodedModel, model);
        return model;
    }

    @Override
    protected AnthropicModel loadRawCustomModel(CustomAnthropicModel customModel) {
        AnthropicModel model = customModel.toModel();
        this.loadDefaultCustomModelSettings(customModel, model);
        return model;
    }

    @Override
    protected boolean isHardcodedModelEnabled(HardcodedAnthropicModel anthropicModel) {
        return anthropicModel.allowedModel.apply(this.params);
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        ICredentialsService.BasicCredential creds = new ICredentialsService.BasicCredential("", this.params.apiKey);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.apiKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.apiKey);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.apiKey = cryptoService.decryptIfEncrypted(this.params.apiKey);
    }

    public static class AnthropicConnectionParams
    extends AbstractLLMConnection.AbstractLLMConnectionParams {
        public AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings = new AbstractLLMConnection.HTTPBasedLLMNetworkSettings();
        public String apiKey;
        public int maxParallelism = 2;
        public boolean allowClaudeV2 = false;
        public boolean allowClaudeV3Opus = false;
        public boolean allowClaudeV4Opus = false;
        public boolean allowClaudeV3Sonnet = false;
        public boolean allowClaudeV35Sonnet = false;
        public boolean allowClaudeV35SonnetV2 = false;
        public boolean allowClaudeV4Sonnet = false;
        public boolean allowClaudeV37Sonnet = false;
        public boolean allowClaudeV3Haiku = false;
        public boolean allowClaudeV35Haiku = false;
        public List<CustomAnthropicModel> customModels = new ArrayList<CustomAnthropicModel>();
    }

    public static enum HardcodedAnthropicModel implements AbstractLLMConnection.IHardcodedConnectionModel
    {
        CLAUDE_V2("claude-2", "Claude 2 (deprecated)", false, p -> p.allowClaudeV2),
        CLAUDE_V3_OPUS("claude-3-opus-20240229", "Claude 3 Opus", true, p -> p.allowClaudeV3Opus),
        CLAUDE_V4_OPUS("claude-opus-4-20250514", "Claude 4 Opus", true, p -> p.allowClaudeV4Opus),
        CLAUDE_V3_SONNET("claude-3-sonnet-20240229", "Claude 3 Sonnet (deprecated)", true, p -> p.allowClaudeV3Sonnet),
        CLAUDE_V35_SONNET("claude-3-5-sonnet-20240620", "Claude 3.5 Sonnet V1 (Jun. 24)", true, p -> p.allowClaudeV35Sonnet),
        CLAUDE_V35_SONNET_V2("claude-3-5-sonnet-20241022", "Claude 3.5 Sonnet V2 (Oct. 24)", true, p -> p.allowClaudeV35SonnetV2),
        CLAUDE_V37_SONNET("claude-3-7-sonnet-20250219", "Claude 3.7 Sonnet", true, p -> p.allowClaudeV37Sonnet),
        CLAUDE_V4_SONNET("claude-sonnet-4-20250514", "Claude 4 Sonnet", true, p -> p.allowClaudeV4Sonnet),
        CLAUDE_V3_HAIKU("claude-3-haiku-20240307", "Claude 3 Haiku", true, p -> p.allowClaudeV3Haiku),
        CLAUDE_V35_HAIKU("claude-3-5-haiku-20241022", "Claude 3.5 Haiku", true, p -> p.allowClaudeV35Haiku);

        public final String id;
        public final String displayName;
        public final boolean useChatAPI;
        public final Function<AnthropicConnectionParams, Boolean> allowedModel;

        private HardcodedAnthropicModel(String id, String displayName, boolean useChatAPI, Function<AnthropicConnectionParams, Boolean> allowedModel) {
            this.id = id;
            this.displayName = displayName;
            this.useChatAPI = useChatAPI;
            this.allowedModel = allowedModel;
        }

        public AnthropicModel toModel() {
            AnthropicModel model = new AnthropicModel();
            model.id = this.id;
            model.displayName = this.displayName;
            model.useChatApi = this.useChatAPI;
            model.completionCost = AnthropicPricing.getAnthropicCompletionCostPer1KTokens(this.id);
            model.promptCost = AnthropicPricing.getAnthropicPromptCostPer1KTokens(this.id);
            return model;
        }
    }

    public static class AnthropicModel
    extends AbstractLLMConnection.BaseModel {
        public boolean useChatApi;

        @Override
        public AbstractLLMConnection.ModelCapabilities getModelCapabilities() {
            AbstractLLMConnection.ModelCapabilities capabilities = new AbstractLLMConnection.ModelCapabilities();
            capabilities.canGenerateCrossLanguageOutput = true;
            capabilities.handlesSystemMessage = true;
            capabilities.temperatureRange = TEMPERATURE_RANGE;
            capabilities.topKRange = TOP_K_RANGE;
            return capabilities;
        }

        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            return LLMStructuredRef.forAnthropicConnection(connection, this.getId());
        }
    }

    public static class CustomAnthropicModel
    extends AbstractLLMConnection.CustomModel<AnthropicModel> {
        public String id;
        public String displayName;

        @Override
        public AnthropicModel toModel() {
            AnthropicModel model = new AnthropicModel();
            model.loadFromCustomModel(this);
            model.id = this.id;
            model.displayName = this.displayName;
            model.useChatApi = true;
            return model;
        }
    }
}

