/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.VectorStoreConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class AzureAISearchConnection
extends DSSConnection
implements VectorStoreConnection,
ConnectionWithAzureAuthCredentials {
    private static final String DEFAULT_OAUTH_SCOPE = "https://search.azure.com/.default";
    private static final String DEFAULT_OAUTH_USER_IMPERSONATION_SCOPE = "https://search.azure.com/user_impersonation offline_access";
    public AzureAISearchConnectionParams params = new AzureAISearchConnectionParams();
    public static final String connectionType = "AzureAISearch";

    @Override
    public RetrievableKnowledge.VectorStoreType getVectorStoreType() {
        return RetrievableKnowledge.VectorStoreType.AZURE_AI_SEARCH;
    }

    @Override
    public String getConnectionName() {
        return this.name;
    }

    @Override
    @Nonnull
    public ConnectionWithAzureAuthCredentials.IAzureAuthParams getAzureAuth2NonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public Params getDkuPropertiesAsParams() {
        return new Params();
    }

    @Override
    public String getDefaultAuthScope() {
        return DEFAULT_OAUTH_SCOPE;
    }

    @Override
    public String getDefaultAuthUserImpersonationScope() {
        return DEFAULT_OAUTH_USER_IMPERSONATION_SCOPE;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            this.params.apiKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.apiKey);
            this.params.appSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecret);
        }
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.apiKey = cryptoService.decryptIfEncrypted(this.params.apiKey);
        this.params.appSecret = cryptoService.decryptIfEncrypted(this.params.appSecret);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class));
        ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = this.getFullyResolvedAzureAuthCredentials(ctx);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }

    @Override
    public boolean isADataStoringConnection() {
        return false;
    }

    public static class AzureAISearchConnectionParams
    extends DSSConnection.DkuConnectionParams
    implements ConnectionWithAzureAuthCredentials.IAzureAuthParams {
        public String resourceName;
        public AuthType authType = AuthType.API_KEY;
        public String apiKey;
        public String tenantId;
        public String appId;
        public String appSecret;
        public String tokenEndpoint;
        public String authorizationEndpoint;
        public boolean refreshTokenRotation;

        @Override
        public ConnectionWithAzureAuthCredentials.AuthType getAuthType() {
            switch (this.authType) {
                case API_KEY: {
                    return ConnectionWithAzureAuthCredentials.AuthType.KEY;
                }
                case OAUTH2_APP: {
                    return ConnectionWithAzureAuthCredentials.AuthType.OAUTH2_APP;
                }
            }
            throw new IllegalArgumentException("Unhandled auth mode " + String.valueOf((Object)this.authType));
        }

        @Override
        public String getKey() {
            return this.apiKey;
        }

        @Override
        public String getOauth2TenantId() {
            return this.tenantId;
        }

        @Override
        public String getOauth2AppId() {
            return this.appId;
        }

        @Override
        public String getOauth2AppSecret() {
            return this.appSecret;
        }

        @Override
        public String getOauth2AuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public String getOauth2TokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Override
        public boolean getRefreshTokenRotation() {
            return this.refreshTokenRotation;
        }
    }

    public static enum AuthType {
        OAUTH2_APP,
        API_KEY;

    }
}

