/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobModel;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AzureConnection
extends AbstractCloudStorageConnection
implements ConnectionWithEncryptedFields,
ConnectionWithAzureAuthCredentials {
    private static final String DEFAULT_ENDPOINT_SUFFIX = "core.windows.net";
    private static final String DEFAULT_OAUTH_SCOPE = "https://storage.azure.com/.default";
    private static final String DEFAULT_OAUTH_USER_IMPERSONATION_SCOPE = "https://storage.azure.com/user_impersonation offline_access";
    public static final String connectionType = "Azure";
    public AzureParam params = new AzureParam();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.azure");

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.storageAccount = vc.expand(this.params.storageAccount);
        this.params.accessKey = vc.expand(this.params.accessKey);
        this.params.sasToken = vc.expand(this.params.sasToken);
        this.params.tenantId = vc.expand(this.params.tenantId);
        this.params.appId = vc.expand(this.params.appId);
        this.params.appSecret = vc.expand(this.params.appSecret);
        this.params.chcontainer = vc.expand(this.params.chcontainer);
        this.params.chroot = vc.expand(this.params.chroot);
    }

    public String getEndpointSuffix() {
        return this.getDkuPropertiesAsParams().getParam("dku.endpoint.suffix", DEFAULT_ENDPOINT_SUFFIX);
    }

    @Override
    public ConnectionWithAzureAuthCredentials.IAzureAuthParams getAzureAuth2NonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public String getDefaultAuthScope() {
        return DEFAULT_OAUTH_SCOPE;
    }

    @Override
    public String getDefaultAuthUserImpersonationScope() {
        return DEFAULT_OAUTH_USER_IMPERSONATION_SCOPE;
    }

    private String getEndpointSuffixPattern() {
        String globalSuffix = this.getEndpointSuffix();
        String endpointSuffixPattern = ApplicationConfigurator.getParams().getParam("dku.azureblob.endpointSuffix.pattern", "%s." + globalSuffix, false);
        for (AbstractSQLConnection.CustomDatabaseProperty property : this.params.dkuProperties) {
            if (!"dku.endpoint.suffix.pattern".equals(property.name) || !StringUtils.isNotBlank((String)property.value)) continue;
            endpointSuffixPattern = property.value;
        }
        return endpointSuffixPattern;
    }

    private String getEndpointSuffixForHadoopFSType(String forType) {
        String endpointSuffixPattern = this.getEndpointSuffixPattern();
        if (StringUtils.isBlank((String)endpointSuffixPattern)) {
            return "";
        }
        return String.format(endpointSuffixPattern, forType);
    }

    public AzureBlobModel.BlobServiceAccountHolder getAzureBlobClient(AuthCtx authCtx, ProxySettings proxySettings, boolean useCachedAccessToken) throws DKUSecurityException, IOException {
        try {
            ConnectionWithBasicCredential.CredentialResolutionContext ctx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null);
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = this.getFullyResolvedCredentials_fsLike(ctx.withUseTokenCache(useCachedAccessToken), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
            AzureBlobModel.ConnectionSettings settings = creds.getConnectionSettings(this.params.storageAccount, this.getEndpointSuffix(), this, ctx, proxySettings);
            return new AzureBlobModel.BlobServiceAccountHolder(settings);
        }
        catch (InvalidKeyException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "Failed to generate a connection string", (Throwable)e);
        }
    }

    public AzureBlobModel.BlobServiceAccountHolder getAzureBlobClient(AuthCtx authCtx, ProxySettings proxySettings) throws DKUSecurityException, IOException {
        return this.getAzureBlobClient(authCtx, proxySettings, true);
    }

    public AzureBlobModel.BlobServiceAccountHolder getAzureBlobClient(AuthCtx authCtx, boolean useCachedAccessToken) throws DKUSecurityException, IOException {
        return this.getAzureBlobClient(authCtx, this.getProxySettings(), useCachedAccessToken);
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2_APP;
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{connectionType});
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.getDkuProperties());
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableAzureStorageAccountCredentials.class));
        ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = this.getFullyResolvedAzureAuthCredentials(ctx);
        SerializableAzureStorageAccountCredentials azCreds = (SerializableAzureStorageAccountCredentials)JSON.parse((String)JSON.json((Object)creds), SerializableAzureStorageAccountCredentials.class);
        azCreds.sasToken = this.params.sasToken;
        return clazz.cast(azCreds);
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopConfigForAzureAccess(AuthCtx authCtx) throws DKUSecurityException, IOException {
        ArrayList ret = Lists.newArrayList();
        ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
        switch (this.params.hdfsInterface) {
            case WASB: {
                String storageAccountFQDNSuffix;
                String endpointSuffix = this.getEndpointSuffixForHadoopFSType("blob");
                String string = storageAccountFQDNSuffix = StringUtils.isBlank((String)endpointSuffix) ? "" : "." + this.params.storageAccount + "." + endpointSuffix;
                if (this.params.authType == AuthType.SHARED_KEY) {
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.key" + storageAccountFQDNSuffix, creds.key, true));
                    break;
                }
                throw new NotImplementedException("WASB cannot use OAuth authentication");
            }
            case ABFS: {
                String endpointSuffix = this.getEndpointSuffixForHadoopFSType("dfs");
                String storageAccountFQDNSuffix = StringUtils.isBlank((String)endpointSuffix) ? "" : "." + this.params.storageAccount + "." + endpointSuffix;
                switch (creds.authType) {
                    case KEY: {
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.auth.type" + storageAccountFQDNSuffix, "SharedKey", false));
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.key" + storageAccountFQDNSuffix, creds.key, true));
                        break;
                    }
                    case OAUTH2_APP: {
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.client.id" + storageAccountFQDNSuffix, creds.oauth2AppId, false));
                        if (StringUtils.isNotBlank((String)creds.oauth2AppSecret)) {
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.client.secret" + storageAccountFQDNSuffix, creds.oauth2AppSecret, true));
                        }
                        if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                            if (this.useRemoteCredentialsProvider()) {
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.auth.type" + storageAccountFQDNSuffix, "Custom", false));
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth.provider.type" + storageAccountFQDNSuffix, "com.dataiku.dip.hadoop.azure.RemoteDSSOAuth2Provider", false));
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.dss.connection.name" + storageAccountFQDNSuffix, this.name, false));
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.access.token" + storageAccountFQDNSuffix, creds.oauth2AccessToken, true));
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.access.token.expires.on" + storageAccountFQDNSuffix, Long.toString(creds.oauth2AccessTokenExpiresOn), false));
                                break;
                            }
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.auth.type" + storageAccountFQDNSuffix, "OAuth", false));
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth.provider.type" + storageAccountFQDNSuffix, "org.apache.hadoop.fs.azurebfs.oauth2.RefreshTokenBasedTokenProvider", false));
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.refresh.token" + storageAccountFQDNSuffix, creds.oauth2RefreshToken, true));
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.refresh.token.endpoint" + storageAccountFQDNSuffix, creds.oauth2TokenEndpoint, false));
                            break;
                        }
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.auth.type" + storageAccountFQDNSuffix, "OAuth", false));
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth.provider.type" + storageAccountFQDNSuffix, "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider", false));
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.account.oauth2.client.endpoint" + storageAccountFQDNSuffix, creds.oauth2TokenEndpoint, false));
                    }
                }
                break;
            }
            case NONE: {
                throw new IllegalArgumentException("You must define a HDFS interface for accessing Hadoop.");
            }
        }
        this.addDisableCacheIfNeeded(ret, this.params.dkuProperties);
        if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.UNKNOWN) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.azure.ssl.channel.mode", "Default_JSSE", false));
        }
        this.addExtraHadoopConf(ret, this.params.dkuProperties);
        return ret;
    }

    public boolean useRemoteCredentialsProvider() {
        return this.mustResolveOnBackend() || this.mustResolveOnDSSHost() || this.isOauthAppPrivate(this.params.getOauth2AppSecret());
    }

    private boolean isOauthAppPrivate(String oauth2AppSecret) {
        if (StringUtils.isNotBlank((String)oauth2AppSecret)) {
            return this.getDkuPropertiesAsParams().getBoolParam("app.private", true);
        }
        return false;
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkConfigForAzureAccess(AuthCtx authCtx) throws IOException, DKUSecurityException {
        List<AbstractSQLConnection.CustomDatabaseProperty> ret = this.getHadoopConfigForAzureAccess(authCtx);
        for (AbstractSQLConnection.CustomDatabaseProperty cdp : ret) {
            cdp.name = "spark.hadoop." + cdp.name;
        }
        return ret;
    }

    @Override
    public String getHDFSScheme() {
        switch (this.params.hdfsInterface) {
            case WASB: {
                return this.params.useSSL ? "wasbs" : "wasb";
            }
            case ABFS: {
                return this.params.useSSL ? "abfss" : "abfs";
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public String getHDFSLocation() {
        switch (this.params.hdfsInterface) {
            case WASB: {
                return "blob." + this.getEndpointSuffix();
            }
            case ABFS: {
                return "dfs." + this.getEndpointSuffix();
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.accessKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.accessKey);
        this.params.sasToken = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.sasToken);
        this.params.appSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecret);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.accessKey = cryptoService.decryptIfEncrypted(this.params.accessKey);
        this.params.sasToken = cryptoService.decryptIfEncrypted(this.params.sasToken);
        this.params.appSecret = cryptoService.decryptIfEncrypted(this.params.appSecret);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allowManagedDatasets() {
        return this.allowManagedDatasets;
    }

    @Override
    public String getResolvedHDFSRoot(AuthCtx authCtx, String projectKey) {
        String scheme;
        String location;
        String container = StringUtils.isNotBlank((String)this.params.chcontainer) ? this.params.chcontainer : this.params.defaultManagedContainer;
        switch (this.params.hdfsInterface) {
            case NONE: {
                return null;
            }
            case WASB: 
            case ABFS: {
                location = this.getHDFSLocation();
                scheme = this.getHDFSScheme();
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        return String.format("%s://%s@%s.%s%s", scheme, container, this.params.storageAccount, location, PathUtils.makeLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)this.params.chroot, (String)"")));
    }

    public static class AzureParam
    extends DSSConnection.DkuConnectionParams
    implements ConnectionWithAzureAuthCredentials.IAzureAuthParams {
        public String storageAccount;
        public AuthType authType = AuthType.SHARED_KEY;
        public String accessKey;
        public String sasToken;
        public String tenantId;
        public String appId;
        public String appSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public boolean refreshTokenRotation;
        public String defaultManagedContainer;
        public String defaultManagedPath;
        public String chcontainer;
        public String chroot;
        public String snowflakeStorageIntegration;
        public String snowflakeExternalStageName;
        public String snowflakeExternalStagePath;
        public HDFSConnection.HiveSynchronizationMode metastoreSynchronizationMode = HDFSConnection.HiveSynchronizationMode.NO_SYNC;
        public String defaultMetastoreDatabase;
        public AzureBlobDatasetHandler.HDFSInterface hdfsInterface = AzureBlobDatasetHandler.HDFSInterface.NONE;
        public boolean useSSL = true;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule();

        public String getDefaultManagedContainer() {
            return StringUtils.isNotBlank((String)this.chcontainer) ? this.chcontainer : this.defaultManagedContainer;
        }

        @Override
        public ConnectionWithAzureAuthCredentials.AuthType getAuthType() {
            switch (this.authType) {
                case SHARED_KEY: {
                    return ConnectionWithAzureAuthCredentials.AuthType.KEY;
                }
                case OAUTH2_APP: {
                    return ConnectionWithAzureAuthCredentials.AuthType.OAUTH2_APP;
                }
                case ENVIRONMENT: {
                    return ConnectionWithAzureAuthCredentials.AuthType.ENVIRONMENT;
                }
            }
            throw new IllegalArgumentException("Unhandled auth mode " + String.valueOf((Object)this.authType));
        }

        @Override
        public String getKey() {
            return this.accessKey;
        }

        @Override
        public String getOauth2TenantId() {
            return this.tenantId;
        }

        @Override
        public String getOauth2AppId() {
            return this.appId;
        }

        @Override
        public String getOauth2AppSecret() {
            return this.appSecret;
        }

        @Override
        public String getOauth2AuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public String getOauth2TokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Override
        public boolean getRefreshTokenRotation() {
            return this.refreshTokenRotation;
        }
    }

    public static enum AuthType {
        SHARED_KEY,
        OAUTH2_APP,
        ENVIRONMENT;

    }

    public static class SerializableAzureStorageAccountCredentials
    extends ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials {
        public String sasToken;
    }
}

