/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SimpleDSSConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.datastax.driver.core.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class CassandraConnection
extends SimpleDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public CassandraConnectionParams params = new CassandraConnectionParams();
    public static final String connectionType = "Cassandra";

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.hosts = vc.expand(this.params.hosts);
        this.params.keyspace = vc.expand(this.params.keyspace);
        this.params.user = vc.expand(this.params.user);
        this.params.password = vc.expand(this.params.password);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public String toString() {
        return "CassandraConnection{params=" + String.valueOf(this.params) + ", name='" + this.name + "', type='" + this.type + "'}";
    }

    public static class CassandraConnectionParams
    extends DSSConnection.DkuConnectionParams {
        public String hosts;
        public String keyspace;
        public String user;
        public String password = "";
        public boolean ssl;
        public int port = -1;
        public ProtocolVersion protocolVersion;
        public int readTimeout = -1;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public void check() {
            if (StringUtils.isBlank((String)this.hosts)) {
                throw ErrorContext.iae((String)"missing contact hosts for Cassandra connection");
            }
            if (this.port > 65535) {
                throw ErrorContext.iaef((String)"invalid port value for Cassandra connection %s", (Object)this.port, (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((String)this.keyspace)) {
                throw ErrorContext.iae((String)"missing keyspace for Cassandra connection");
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CassandraConnectionParams)) {
                return false;
            }
            CassandraConnectionParams ccp = (CassandraConnectionParams)o;
            return ccp.hosts.equals(this.hosts) && StringUtils.equals((String)this.keyspace, (String)ccp.keyspace) && StringUtils.equals((String)this.user, (String)ccp.user) && StringUtils.equals((String)this.password, (String)ccp.password) && ccp.ssl == this.ssl && ccp.port == this.port && ccp.protocolVersion == this.protocolVersion && ccp.readTimeout == this.readTimeout;
        }

        public int hashCode() {
            return Objects.hash(this.hosts, this.keyspace, this.user, this.password, this.ssl, this.port, this.protocolVersion, this.readTimeout);
        }

        public String toString() {
            return "CassandraConnectionParams{hosts='" + this.hosts + "', keyspace='" + this.keyspace + "', user='" + this.user + "', ssl=" + this.ssl + ", port=" + this.port + ", protocolVersion=" + String.valueOf(this.protocolVersion) + ", readTimeout=" + this.readTimeout + "}";
        }
    }
}

