/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.fs.AzureBlobModel;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.okhttp3.Credentials;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.identity.DefaultAzureCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.DefaultAzureCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageSharedKeyCredential;
import com.dataiku.dss.shadelibazure.okhttp3.Authenticator;
import com.dataiku.dss.shadelibazure.okhttp3.OkHttpClient;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public interface ConnectionWithAzureAuthCredentials
extends ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials {
    public static final long TOKEN_MIN_VALIDITY = 600000L;
    public static final String BASE_OAUTH2_ENDPOINT = "https://login.microsoftonline.com/${tenantId}/oauth2/v2.0/";
    public static final String DKU_AZURE_CLIENT_ID_ENV_KEY = "DKU_AZURE_CLIENT_ID";
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.azure");

    @Nonnull
    public IAzureAuthParams getAzureAuth2NonResolvedParams();

    public ProxySettings getProxySettingsFromConnection();

    public Params getDkuPropertiesAsParams();

    public String getDefaultAuthScope();

    public String getDefaultAuthUserImpersonationScope();

    default public SerializableAzureAuthCredentials getFullyResolvedAzureAuthCredentials(ConnectionWithBasicCredential.CredentialResolutionContext ctx) throws DKUSecurityException, IOException, SQLException {
        IAzureAuthParams params = this.getAzureAuth2NonResolvedParams();
        SerializableAzureAuthCredentials creds = new SerializableAzureAuthCredentials();
        creds.authType = params.getAuthType();
        switch (creds.authType) {
            case KEY: {
                creds.key = params.getKey();
                break;
            }
            case OAUTH2_APP: {
                creds.oauth2AppId = params.getOauth2AppId();
                creds.oauth2AppSecret = params.getOauth2AppSecret();
                StrSubstitutor subst = new StrSubstitutor((Map)ImmutableMap.of((Object)"tenantId", (Object)params.getOauth2TenantId()));
                creds.oauth2TokenEndpoint = StringUtils.defaultIfBlank((String)params.getOauth2TokenEndpoint(), (String)(subst.replace(BASE_OAUTH2_ENDPOINT) + "token"));
                creds.oauth2AuthEndpoint = StringUtils.defaultIfBlank((String)params.getOauth2AuthorizationEndpoint(), (String)(subst.replace(BASE_OAUTH2_ENDPOINT) + "authorize"));
                OAuth2Client.AccessTokenResult accessTokenResult = this.getAzureAccessToken(ctx.authCtx, this.getProxySettingsFromConnection(), ctx.useTokenCache);
                if (((DSSConnection)((Object)this)).credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                    creds.oauth2RefreshToken = accessTokenResult.getRefreshToken();
                }
                creds.oauth2AccessToken = accessTokenResult.getAccessToken();
                creds.oauth2AccessTokenExpiresOn = accessTokenResult.getExpiresOn().getTime();
                for (AbstractSQLConnection.CustomDatabaseProperty prop : ((DSSConnection)((Object)this)).getDkuProperties()) {
                    if (!"force.token.duration.ms".equals(prop.name)) continue;
                    try {
                        long d = Long.parseLong(prop.value);
                        logger.info((Object)("Override token duration to " + d));
                        creds.oauth2AccessTokenExpiresOn = System.currentTimeMillis() + d;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to apply property " + prop.name), (Throwable)e);
                    }
                }
                break;
            }
        }
        return creds;
    }

    @Override
    default public boolean actuallyHasPerUserOAuth2Credential() {
        return ((DSSConnection)((Object)this)).credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.getAzureAuth2NonResolvedParams().getAuthType() == AuthType.OAUTH2_APP;
    }

    @Override
    default public boolean hasRefreshTokenRotation() {
        IAzureAuthParams params = this.getAzureAuth2NonResolvedParams();
        return params.getRefreshTokenRotation();
    }

    default public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, boolean useCachedAccessToken) throws DKUSecurityException {
        Params dkuProperties = this.getDkuPropertiesAsParams();
        String scope = dkuProperties.getParam("dku.endpoint.oauth_user_impersonation_scope", this.getDefaultAuthUserImpersonationScope());
        return this.buildOAuth2Client(proxySettings, useCachedAccessToken, scope);
    }

    default public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, boolean useCachedAccessToken, String scope) throws DKUSecurityException {
        IAzureAuthParams params = this.getAzureAuth2NonResolvedParams();
        StrSubstitutor subst = new StrSubstitutor((Map)ImmutableMap.of((Object)"tenantId", (Object)params.getOauth2TenantId()));
        String baseOAuth2Endpoint = subst.replace(BASE_OAUTH2_ENDPOINT);
        Object authorizationEndpoint = StringUtils.isEmpty((String)params.getOauth2AuthorizationEndpoint()) ? baseOAuth2Endpoint + "authorize" : params.getOauth2AuthorizationEndpoint();
        Object tokenEndpoint = StringUtils.isEmpty((String)params.getOauth2TokenEndpoint()) ? baseOAuth2Endpoint + "token" : params.getOauth2TokenEndpoint();
        logger.info((Object)("Using OAuth2 authorize endpoint: " + (String)authorizationEndpoint));
        logger.info((Object)("Using OAuth2 token endpoint: " + (String)tokenEndpoint));
        Params dkuProperties = this.getDkuPropertiesAsParams();
        boolean useCache = dkuProperties.getBoolParam("dku.connection.oauth.enableCache", true);
        OAuth2Client.Builder builder = new OAuth2Client.Builder().authorizationEndpoint((String)authorizationEndpoint).tokenEndpoint((String)tokenEndpoint).clientId(params.getOauth2AppId()).scope(scope).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache && useCachedAccessToken);
        if (StringUtils.isNotEmpty((String)params.getOauth2AppSecret())) {
            builder.clientSecret(params.getOauth2AppSecret());
        }
        return builder.build();
    }

    @Override
    default public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        return this.buildOAuth2Client(proxySettings, true);
    }

    @Override
    default public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAzureAccessToken(authCtx, this.getProxySettingsFromConnection(), true).getAccessToken());
    }

    default public OAuth2Client.AccessTokenResult getAzureAccessToken(AuthCtx authCtx, ProxySettings proxySettings, boolean useCachedAccessToken) {
        IAzureAuthParams params = this.getAzureAuth2NonResolvedParams();
        if (((DSSConnection)((Object)this)).credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
            logger.info((Object)"Exchanging user's refresh token for an access token");
            try {
                OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, useCachedAccessToken);
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            catch (DKUSecurityException e) {
                throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
            }
            catch (ParseException | IOException | URISyntaxException e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
            }
        }
        String scope = this.getDkuPropertiesAsParams().getParam("dku.endpoint.oauth_scope", this.getDefaultAuthScope());
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        try {
            StrSubstitutor subst = new StrSubstitutor((Map)ImmutableMap.of((Object)"tenantId", (Object)params.getOauth2TenantId()));
            URI tokenEndpoint = new URI(StringUtils.defaultIfBlank((String)params.getOauth2TokenEndpoint(), (String)(subst.replace(BASE_OAUTH2_ENDPOINT) + "token")));
            logger.info((Object)("Get access token from: " + String.valueOf(tokenEndpoint)));
            return this.buildOAuth2Client(proxySettings, useCachedAccessToken, scope).acquireAccessTokenResultWithClientCredentialsGrant(useCache && useCachedAccessToken);
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "Failed to get access token", (Throwable)e);
        }
    }

    public static DefaultAzureCredential getDefaultAzureCredential(ProxySettings proxySettings) throws ServerAuthenticationFailure {
        DefaultAzureCredentialBuilder credentialBuilder;
        block6: {
            String azureClientId = System.getenv(DKU_AZURE_CLIENT_ID_ENV_KEY);
            boolean trustAllCerts = true;
            HttpClient azureCredentialsHttpClient = ConnectionWithAzureAuthCredentials.getAzureCredentialsHttpClient(proxySettings, trustAllCerts);
            credentialBuilder = (DefaultAzureCredentialBuilder)new DefaultAzureCredentialBuilder().httpClient(azureCredentialsHttpClient);
            if (StringUtils.isNotBlank((String)azureClientId)) {
                if (azureClientId.contains("providers/Microsoft.ManagedIdentity")) {
                    logger.info((Object)"Managed identity passed as a resource id, calling IMDS ourselves to check if we can get the token and client id");
                    try {
                        String url = "http://169.254.169.254/metadata/identity/oauth2/token?api-version=2018-02-01&resource=https%3A%2F%2Fmanagement.azure.com%2F&msi_res_id=" + URLEncoder.encode(azureClientId, StandardCharsets.UTF_8.toString());
                        HttpRequest request = new HttpRequest(HttpMethod.GET, url);
                        request.getHeaders().add("Metadata", "true");
                        HttpResponse response = azureCredentialsHttpClient.sendSync(request, Context.NONE);
                        String token = (String)response.getBodyAsString().block();
                        JsonObject tokenObj = (JsonObject)JSON.parse((String)token, JsonObject.class);
                        if (tokenObj.has("client_id")) {
                            azureClientId = tokenObj.get("client_id").getAsString();
                            logger.info((Object)("Retrieved clientId " + azureClientId));
                            break block6;
                        }
                        logger.warn((Object)"Unable to get the clientId");
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Unable to check the managed identity, continue without");
                    }
                } else {
                    logger.info((Object)("Use SDK with clientId " + azureClientId));
                    credentialBuilder.managedIdentityClientId(azureClientId);
                }
            }
        }
        return credentialBuilder.build();
    }

    public static HttpClient getAzureCredentialsHttpClient(@Nonnull ProxySettings proxySettings, boolean trustAllCerts) throws ServerAuthenticationFailure {
        try {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            if (proxySettings.hasProxy()) {
                logger.info((Object)"Use proxy for azure env credentials");
                ConnectionWithAzureAuthCredentials.applyProxySettingsToOkHttpClient(proxySettings, trustAllCerts, clientBuilder);
            }
            return new OkHttpAsyncHttpClientBuilder(clientBuilder.build()).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ServerAuthenticationFailure("Couldn't setup proxy for Azure HTTP Client", (Throwable)e);
        }
    }

    private static void applyProxySettingsToOkHttpClient(ProxySettings proxySettings, boolean trustAllCerts, OkHttpClient.Builder clientBuilder) throws NoSuchAlgorithmException, KeyManagementException {
        InetSocketAddress proxyInetAddress = new InetSocketAddress(proxySettings.host, proxySettings.port);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
        clientBuilder.proxy(proxy);
        if (proxySettings.hasAuthentication()) {
            Authenticator proxyAuthenticator = (route, response) -> {
                String credential = Credentials.basic((String)proxySettings.username, (String)proxySettings.password);
                if (response.isSuccessful()) {
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
                return null;
            };
            clientBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        if (trustAllCerts) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{ProxyUtils.TRUST_ALL_CERTS}, new SecureRandom());
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)ProxyUtils.TRUST_ALL_CERTS);
        }
    }

    public static interface IAzureAuthParams {
        public AuthType getAuthType();

        public String getKey();

        public String getOauth2TenantId();

        public String getOauth2AppId();

        public String getOauth2AppSecret();

        public String getOauth2AuthorizationEndpoint();

        public String getOauth2TokenEndpoint();

        public boolean getRefreshTokenRotation();
    }

    public static class SerializableAzureAuthCredentials {
        public AuthType authType;
        public String key;
        public String tenantId;
        public String oauth2AppId;
        public String oauth2AppSecret;
        public String oauth2AuthEndpoint;
        public String oauth2TokenEndpoint;
        public String oauth2RefreshToken;
        public String oauth2AccessToken;
        public long oauth2AccessTokenExpiresOn;

        public static SerializableAzureAuthCredentials fromEnvironmentToken(AccessToken accessToken) {
            SerializableAzureAuthCredentials creds = new SerializableAzureAuthCredentials();
            creds.authType = AuthType.ENVIRONMENT;
            creds.oauth2AccessToken = accessToken.getToken();
            creds.oauth2AccessTokenExpiresOn = accessToken.getExpiresAt().toInstant().toEpochMilli();
            return creds;
        }

        public AzureBlobModel.ConnectionSettings getConnectionSettings(String storageAccount, String endPointSuffix, DSSConnection conn, ConnectionWithBasicCredential.CredentialResolutionContext ctx, ProxySettings proxy) throws InvalidKeyException {
            String url = String.format("https://%s.blob.%s/", storageAccount, endPointSuffix);
            switch (this.authType) {
                case KEY: {
                    return new AzureBlobModel.ConnectionSettings(url, proxy, new StorageSharedKeyCredential(storageAccount, this.key));
                }
                case OAUTH2_APP: {
                    return new AzureBlobModel.ConnectionSettings(url, proxy, new ForwardingAzureOAuth2TokenCredential(this.oauth2AccessToken, this.oauth2AccessTokenExpiresOn, ctx, conn));
                }
            }
            throw new NotImplementedException("Cannot handle auth type " + String.valueOf((Object)this.authType));
        }

        public ICredentialsService.OAuth2Credential toOAuth2Credential() {
            return new ICredentialsService.OAuth2Credential(this.oauth2AccessToken);
        }

        public TokenCredential toTokenCredential(ConnectionWithBasicCredential.CredentialResolutionContext ctx, DSSConnection conn) throws IOException {
            switch (this.authType) {
                case ENVIRONMENT: {
                    MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(conn);
                    if (rmiTo == null) {
                        try {
                            return ConnectionWithAzureAuthCredentials.getDefaultAzureCredential(conn.getProxySettings());
                        }
                        catch (ServerAuthenticationFailure e) {
                            throw new IOException("Unable to get access token", e);
                        }
                    }
                    return new ForwardingAzureEnvironmentTokenCredential(ctx, conn);
                }
                case OAUTH2_APP: {
                    return new ForwardingAzureOAuth2TokenCredential(this.oauth2AccessToken, this.oauth2AccessTokenExpiresOn, ctx, conn);
                }
                case KEY: {
                    throw new NotImplementedException("Can't use SHARED_KEY mode to get a generic Azure SDK TokenCredential");
                }
            }
            throw new NotImplementedException("Unknown auth type " + String.valueOf((Object)this.authType));
        }
    }

    public static enum AuthType {
        KEY,
        OAUTH2_APP,
        ENVIRONMENT;

    }

    public static class ForwardingAzureEnvironmentTokenCredential
    implements TokenCredential {
        private AccessToken accessToken;
        private final ConnectionWithBasicCredential.CredentialResolutionContext ctx;
        private final DSSConnection conn;

        public ForwardingAzureEnvironmentTokenCredential(ConnectionWithBasicCredential.CredentialResolutionContext ctx, DSSConnection conn) {
            this.ctx = ctx;
            this.conn = conn;
        }

        private AccessToken getTokenRefreshIfNeeded(TokenRequestContext tokenRequestContext) {
            if (this.accessToken == null || ChronoUnit.MILLIS.between(this.accessToken.getExpiresAt(), OffsetDateTime.now()) < 600000L) {
                try {
                    MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(this.conn);
                    if (rmiTo == null) {
                        throw new IllegalStateException("Should be fetching credentials from a remote location");
                    }
                    CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
                    String[] requestCtxParam = new String[]{"claims", tokenRequestContext.getClaims(), "scopes", JSON.json((Object)tokenRequestContext.getScopes()), "tenantId", tokenRequestContext.getTenantId()};
                    SerializableAzureAuthCredentials refreshed = CredentialsRemoteFetchConfigurationProvider.getFromRemote(fetchInfo, "/connections/refresh-azure-default-credential-access-token", SerializableAzureAuthCredentials.class, requestCtxParam, "name", this.conn.name);
                    this.accessToken = new AccessToken(refreshed.oauth2AccessToken, new Date(refreshed.oauth2AccessTokenExpiresOn).toInstant().atOffset(ZoneOffset.UTC));
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to refresh access token, keeping current one", (Throwable)e);
                }
            }
            return this.accessToken;
        }

        public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
            return Mono.fromSupplier(() -> this.getTokenRefreshIfNeeded(tokenRequestContext));
        }
    }

    public static class ForwardingAzureOAuth2TokenCredential
    implements TokenCredential {
        private String accessToken;
        private long expiresOn;
        private final ConnectionWithBasicCredential.CredentialResolutionContext ctx;
        private final DSSConnection conn;

        public ForwardingAzureOAuth2TokenCredential(String accessToken, long expiresOn, ConnectionWithBasicCredential.CredentialResolutionContext ctx, DSSConnection conn) {
            this.accessToken = accessToken;
            this.expiresOn = expiresOn;
            this.ctx = ctx;
            this.conn = conn;
        }

        private AccessToken getTokenRefreshIfNeeded() {
            if (this.expiresOn - new Date().getTime() < 600000L) {
                try {
                    SerializableAzureAuthCredentials refreshed = this.conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.ctx).withUseTokenCache(false), SerializableAzureAuthCredentials.class);
                    this.accessToken = refreshed.oauth2AccessToken;
                    this.expiresOn = refreshed.oauth2AccessTokenExpiresOn;
                }
                catch (DKUSecurityException | IOException e) {
                    logger.warn((Object)"Unable to refresh access token, keeping current one", e);
                }
            }
            return new AccessToken(this.accessToken, new Date(this.expiresOn).toInstant().atOffset(ZoneOffset.UTC));
        }

        public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
            return Mono.fromSupplier(() -> this.getTokenRefreshIfNeeded());
        }
    }
}

