/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.SimpleDSSConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class FTPConnection
extends SimpleDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
FSProviderizableConnection {
    public Params params = new Params();
    public static final String connectionType = "FTP";

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.host = vc.expand(this.params.host);
        this.params.user = vc.expand(this.params.user);
        this.params.password = vc.expand(this.params.password);
        this.params.path = vc.expand(this.params.path);
        this.params.file = vc.expand(this.params.file);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{connectionType});
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public String host;
        public int port = 21;
        public String user;
        public String password;
        public String path;
        public String file;
        public int connectionLimit;
        public boolean passive;
        public FSProviderizableConnection.FilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.FilesBasedDatasetNamingRule();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }
}

