/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.StreamingConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class KafkaConnection
extends DSSConnection
implements ConnectionWithEncryptedFields,
StreamingConnection {
    public KafkaConnectionParams params = new KafkaConnectionParams();
    public static final String connectionType = "Kafka";

    public KsqlConnectionParams getKSqlParameters() throws DKUSecurityException, IOException {
        SerializableKafkaCredentials creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(null, null), SerializableKafkaCredentials.class);
        KsqlConnectionParams ksqlConnectionParams = (KsqlConnectionParams)JSON.deepCopy((Object)this.params.ksqlConnectionParams);
        ksqlConnectionParams.basicAuthPassword = creds.ksqlBasicAuthPassword;
        ksqlConnectionParams.sslKeystorePassword = creds.ksqlSslKeystorePassword;
        ksqlConnectionParams.sslKeyPassword = creds.ksqlSslKeyPassword;
        return ksqlConnectionParams;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.bootstrapServers = vc.expand(this.params.bootstrapServers);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableKafkaCredentials.class));
        SerializableKafkaCredentials creds = new SerializableKafkaCredentials();
        creds.sslKeyPassword = this.params.sslKeyPassword;
        creds.sslKeystorePassword = this.params.sslKeystorePassword;
        creds.sslTruststorePassword = this.params.sslTruststorePassword;
        creds.properties.addAll(this.params.properties);
        creds.ksqlBasicAuthPassword = this.params.ksqlConnectionParams.basicAuthPassword;
        creds.ksqlSslKeyPassword = this.params.ksqlConnectionParams.sslKeyPassword;
        creds.ksqlSslKeystorePassword = this.params.ksqlConnectionParams.sslKeystorePassword;
        return clazz.cast(creds);
    }

    private void putPropWithDefault(Properties props, String key, String value, String defaultValue, String message) {
        if (StringUtils.isEmpty((String)value)) {
            if (StringUtils.isNotBlank((String)message)) {
                throw new IllegalArgumentException(message);
            }
            props.put(key, defaultValue);
        } else {
            props.put(key, value);
        }
    }

    public Properties buildBasicProperties(AuthCtx authCtx, String projectKey) throws DKUSecurityException, IOException {
        SerializableKafkaCredentials creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableKafkaCredentials.class);
        Properties props = new Properties();
        this.putPropWithDefault(props, "bootstrap.servers", this.params.bootstrapServers, null, "Bootstrap servers cannot be empty");
        if (this.params.securityMode == KafkaSecurityMode.NONE) {
            props.put("security.protocol", this.params.sslEnabled ? "SSL" : "PLAINTEXT");
        } else if (this.params.securityMode == KafkaSecurityMode.KERBEROS) {
            props.put("security.protocol", this.params.sslEnabled ? "SASL_SSL" : "SASL_PLAINTEXT");
        } else if (this.params.securityMode == KafkaSecurityMode.SASL) {
            props.put("security.protocol", this.params.sslEnabled ? "SASL_SSL" : "SASL_PLAINTEXT");
        }
        if (this.params.securityMode == KafkaSecurityMode.KERBEROS) {
            if (this.params.kerberosUseDSSKeytab) {
                jaasConfigPattern = "com.sun.security.auth.module.Krb5LoginModule required useTicketCache=true ticketCache=\"%s\";";
                String ticketCache = HadoopLoader.getTicketCacheEnvVar();
                if (StringUtils.isBlank((String)ticketCache)) {
                    throw new IllegalArgumentException("Unable to find the ticket cache maintained by DSS");
                }
                String jaasConfig = String.format(jaasConfigPattern, ticketCache);
                props.put("sasl.jaas.config", jaasConfig);
            } else {
                jaasConfigPattern = "com.sun.security.auth.module.Krb5LoginModule required useKeyTab=true storeKey=true keyTab=\"%s\" principal=\"%s\";";
                String jaasConfig = String.format(jaasConfigPattern, this.params.kerberosKeytab, this.params.kerberosPrincipal);
                props.put("sasl.jaas.config", jaasConfig);
            }
            props.put("sasl.mechanism", "GSSAPI");
            if (StringUtils.isNotBlank((String)this.params.kerberosServiceName)) {
                props.put("sasl.kerberos.service.name", this.params.kerberosServiceName);
            }
        } else if (this.params.securityMode == KafkaSecurityMode.SASL) {
            this.putPropWithDefault(props, "sasl.jaas.config", this.params.saslJAASConfig, null, "JAAS  config body is mandatory");
            this.putPropWithDefault(props, "sasl.mechanism", this.params.saslMechanism, null, "SASL mechanism is mandatory");
        }
        if (this.params.sslEnabled) {
            this.putPropWithDefault(props, "ssl.truststore.location", this.params.sslTruststoreLocation, null, "The truststore location is mandatory");
            this.putPropWithDefault(props, "ssl.truststore.password", creds.sslTruststorePassword, "", null);
            if (this.params.sslClientAuth) {
                this.putPropWithDefault(props, "ssl.keystore.location", this.params.sslKeystoreLocation, null, "The keystore location is mandatory");
                this.putPropWithDefault(props, "ssl.keystore.password", creds.sslKeystorePassword, "", null);
                this.putPropWithDefault(props, "ssl.key.password", creds.sslKeyPassword, "", null);
            }
        }
        for (AbstractSQLConnection.CustomDatabaseProperty cdp : creds.properties) {
            props.put(cdp.name, cdp.value);
        }
        return props;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            for (AbstractSQLConnection.CustomDatabaseProperty property : this.params.properties) {
                if (!property.secret) continue;
                property.value = cryptoService.encryptIfNotEncryptedOrEmpty(property.value);
            }
        }
        this.params.sslTruststorePassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.sslTruststorePassword);
        this.params.sslKeystorePassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.sslKeystorePassword);
        this.params.sslKeyPassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.sslKeyPassword);
        this.params.ksqlConnectionParams.sslKeyPassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.ksqlConnectionParams.sslKeyPassword);
        this.params.ksqlConnectionParams.basicAuthPassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.ksqlConnectionParams.basicAuthPassword);
        this.params.ksqlConnectionParams.sslKeystorePassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.ksqlConnectionParams.sslKeystorePassword);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        for (AbstractSQLConnection.CustomDatabaseProperty property : this.params.properties) {
            if (!property.secret) continue;
            property.value = cryptoService.decryptIfEncrypted(property.value);
        }
        this.params.sslTruststorePassword = cryptoService.decryptIfEncrypted(this.params.sslTruststorePassword);
        this.params.sslKeystorePassword = cryptoService.decryptIfEncrypted(this.params.sslKeystorePassword);
        this.params.sslKeyPassword = cryptoService.decryptIfEncrypted(this.params.sslKeyPassword);
        this.params.ksqlConnectionParams.sslKeyPassword = cryptoService.decryptIfEncrypted(this.params.ksqlConnectionParams.sslKeyPassword);
        this.params.ksqlConnectionParams.basicAuthPassword = cryptoService.decryptIfEncrypted(this.params.ksqlConnectionParams.basicAuthPassword);
        this.params.ksqlConnectionParams.sslKeystorePassword = cryptoService.decryptIfEncrypted(this.params.ksqlConnectionParams.sslKeystorePassword);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    public static class KafkaConnectionParams
    extends DSSConnection.DkuConnectionParams {
        public String bootstrapServers;
        public KafkaSecurityMode securityMode = KafkaSecurityMode.NONE;
        public boolean sslEnabled;
        public String sslTruststoreLocation;
        public String sslTruststorePassword;
        public boolean sslClientAuth;
        public String sslKeystoreLocation;
        public String sslKeystorePassword;
        public String sslKeyPassword;
        public boolean kerberosUseDSSKeytab;
        public String kerberosPrincipal;
        public String kerberosKeytab;
        public String kerberosServiceName;
        public String saslJAASConfig;
        public String saslMechanism;
        public KsqlConnectionParams ksqlConnectionParams = new KsqlConnectionParams();
        public List<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public void check() {
            if (StringUtils.isBlank((String)this.bootstrapServers)) {
                throw ErrorContext.iae((String)"missing bootstrap servers for Kafka connection");
            }
        }
    }

    public static class SerializableKafkaCredentials {
        public String sslTruststorePassword;
        public String sslKeystorePassword;
        public String sslKeyPassword;
        public String ksqlSslKeyPassword;
        public String ksqlBasicAuthPassword;
        public String ksqlSslKeystorePassword;
        public List<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }

    public static class KsqlConnectionParams {
        public boolean sslClientAuthEnabled;
        public String sslKeystoreLocation;
        public String sslKeystorePassword;
        public String sslKeyPassword;
        public boolean basicAuthentication;
        public String basicAuthUser;
        public String basicAuthPassword;
        public String serverUrl;
        public String serverVersion;
    }

    public static enum KafkaSecurityMode {
        NONE,
        KERBEROS,
        SASL,
        CUSTOM;

    }
}

