/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SimpleDSSConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.variables.VariablesContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MongoDBConnection
extends SimpleDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public Params params = new Params();
    public static final String connectionType = "MongoDB";

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.uri = vc.expand(this.params.uri);
        this.params.displayURI = vc.expand(this.params.displayURI);
        this.params.host = vc.expand(this.params.host);
        this.params.user = vc.expand(this.params.user);
        this.params.password = vc.expand(this.params.password);
        this.params.db = vc.expand(this.params.db);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public String toString() {
        return "MongoDBConnection{name='" + this.name + "', type='" + this.type + "', params=" + String.valueOf(this.params) + "}";
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public boolean useURI;
        public String uri;
        public String displayURI;
        public String host;
        public String user;
        public String password;
        public String db;
        public int port = 27017;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public String toString() {
            return "Params{useURI=" + this.useURI + ", uri='" + this.getDisplayableUri() + "', host='" + this.host + "', user='" + this.user + "', db='" + this.db + "', port=" + this.port + "}";
        }

        public String getDisplayableUri() {
            return this.useURI && StringUtils.isNotBlank((String)this.displayURI) ? this.displayURI : this.uri;
        }
    }
}

