/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@Deprecated
public class MosaicMLConnection
extends AbstractLLMConnection<MosaicMLModel, HardcodedMosaicMLModel, AbstractLLMConnection.CustomModel<MosaicMLModel>> {
    private static final EnrichedLLMStructuredRef.FieldRange TEMPERATURE_RANGE = new EnrichedLLMStructuredRef.FieldRange(0.0, 2.0, 0.1);
    private static final EnrichedLLMStructuredRef.FieldRange TOP_K_RANGE = new EnrichedLLMStructuredRef.FieldRange(1.0, null, 1.0);
    public MosaicMLConnectionParams params = new MosaicMLConnectionParams();
    public static final String connectionType = "MosaicML";
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.connections.mosaicml");

    @Override
    public AbstractLLMConnection.AbstractLLMConnectionParams getLLMConnectionParams() {
        return this.params;
    }

    @Override
    protected boolean isHardcodedModelEnabled(HardcodedMosaicMLModel mosaicModel) {
        return mosaicModel.allowedModel.apply(this.params);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected List<HardcodedMosaicMLModel> listRawHardcodedModels() {
        return Arrays.asList(HardcodedMosaicMLModel.values());
    }

    @Override
    protected MosaicMLModel loadRawHardcodedModel(HardcodedMosaicMLModel hardcodedModel) {
        MosaicMLModel model = hardcodedModel.toModel();
        this.loadDefaultHardcodedModelSettings(hardcodedModel, model);
        return model;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        ICredentialsService.BasicCredential creds = new ICredentialsService.BasicCredential("", this.params.apiKey);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.apiKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.apiKey);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.apiKey = cryptoService.decryptIfEncrypted(this.params.apiKey);
    }

    public static class MosaicMLConnectionParams
    extends AbstractLLMConnection.AbstractLLMConnectionParams {
        public String apiKey;
        public int maxParallelism = 1;
        public AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings = new AbstractLLMConnection.HTTPBasedLLMNetworkSettings();
        public boolean allowMPT7BInstruct = true;
        public boolean allowMPT30BInstruct = true;
        public boolean allowLLAMA270BChat = true;
    }

    public static enum HardcodedMosaicMLModel implements AbstractLLMConnection.IHardcodedConnectionModel<MosaicMLModel>
    {
        MPT_7B_INSTRUCT("mpt-7b-instruct", "MPT 7B Instruct", p -> p.allowMPT7BInstruct),
        MPT_30B_INSTRUCT("mpt-30b-instruct", "MPT 30B Instruct", p -> p.allowMPT30BInstruct),
        LLAMA2_70B_CHAT("llama2-70b-chat", "Llama2 70B Chat", p -> p.allowLLAMA270BChat);

        public final String id;
        public final String displayName;
        public final Function<MosaicMLConnectionParams, Boolean> allowedModel;

        private HardcodedMosaicMLModel(String id, String displayName, Function<MosaicMLConnectionParams, Boolean> allowedModel) {
            this.id = id;
            this.displayName = displayName;
            this.allowedModel = allowedModel;
        }

        @Override
        public MosaicMLModel toModel() {
            MosaicMLModel model = new MosaicMLModel();
            model.id = this.id;
            model.displayName = this.displayName;
            return model;
        }
    }

    public static class MosaicMLModel
    extends AbstractLLMConnection.BaseModel {
        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            return LLMStructuredRef.forMosaicMLConnection(connection, this.getId());
        }

        @Override
        public AbstractLLMConnection.ModelCapabilities getModelCapabilities() {
            AbstractLLMConnection.ModelCapabilities capabilities = new AbstractLLMConnection.ModelCapabilities();
            capabilities.handlesSystemMessage = true;
            capabilities.temperatureRange = TEMPERATURE_RANGE;
            capabilities.topKRange = TOP_K_RANGE;
            return capabilities;
        }

        @Override
        public Optional<String> getInvalidityReason() {
            return Optional.of("MosaicML connection is no longer available. Please use a Databricks Mosaic AI connection instead.");
        }
    }
}

