/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.model.ICredentialsService;
import java.io.IOException;
import java.sql.SQLException;

public abstract class SimpleDSSConnectionWithBasicCredential
extends DSSConnection
implements ConnectionWithBasicCredential {
    @Override
    public boolean actuallyHasBasicCredential() {
        return true;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        if (this.actuallyHasBasicCredential()) {
            ICredentialsService.BasicCredential creds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
            return clazz.cast(creds);
        }
        return null;
    }
}

