/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.builtin.AvroSchemaConverter;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryDataType;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryResultSet;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryStatement;
import com.dataiku.dip.connections.bigquery.builtin.QueryStatisticsProvider;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.LegacySQLTypeName;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.MutableDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.Base64;
import java.util.Calendar;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class BigQueryAvroResultSet
extends BigQueryResultSet {
    private static final AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter();
    private static final Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter TIME_WITHOUT_MILLIS_FORMATTER = DateTimeFormat.forPattern((String)"HH:mm:ss").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter TIME_WITH_MILLIS_FORMATTER = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS").withZone(DateTimeZone.UTC);
    private static final java.time.format.DateTimeFormatter DATETIME_WITHOUT_MICROS_FORMATTER = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final java.time.format.DateTimeFormatter DATETIME_WITH_MICROS_FORMATTER = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
    private final Schema flatAvroSchema;
    private final Iterator<GenericRecord> rows;
    private GenericRecord currentRow;
    private boolean wasNull;

    public BigQueryAvroResultSet(BigQueryStatement statement, Schema avroSchema, Iterator<GenericRecord> rows, @Nullable QueryStatisticsProvider queryStatisticsProvider) {
        super(statement, avroSchemaConverter.convertSchemaToBigQuerySchema(avroSchema), queryStatisticsProvider);
        this.flatAvroSchema = avroSchemaConverter.flattenSchema(avroSchema);
        this.rows = rows;
    }

    @Override
    public boolean next() {
        this.currentRow = this.rows.hasNext() ? this.rows.next() : null;
        return this.currentRow != null;
    }

    public Object get(int columnIndex) throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("Invalid row");
        }
        return this.currentRow.get(columnIndex - 1);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        Field field = this.getField(columnIndex);
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        if (field.getMode() == Field.Mode.REPEATED || columnType == BigQueryDataType.RECORD) {
            return JSON.gson().toJson(this.toJson(field, this.getFieldAvroSchema(columnIndex), value));
        }
        return this.formatValue(columnType, this.getFieldAvroSchema(columnIndex), value);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return false;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return Boolean.parseBoolean(value.toString());
            }
            case INTEGER: {
                return (Long)value != 0L;
            }
            case FLOAT: {
                return (Double)value != 0.0;
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return !BigDecimal.ZERO.equals(this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value));
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return 0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return Byte.parseByte(value.toString());
            }
            case INTEGER: {
                return (byte)((Long)value).longValue();
            }
            case FLOAT: {
                return BigDecimal.valueOf((Double)value).byteValue();
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value).byteValue();
            }
            case BOOLEAN: {
                return (byte)((Boolean)value != false ? 1 : 0);
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return 0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return Short.parseShort(value.toString());
            }
            case INTEGER: {
                return (short)((Long)value).longValue();
            }
            case FLOAT: {
                return BigDecimal.valueOf((Double)value).shortValue();
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value).shortValue();
            }
            case BOOLEAN: {
                return (short)((Boolean)value != false ? 1 : 0);
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return 0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return Integer.parseInt(value.toString());
            }
            case INTEGER: {
                return (int)((Long)value).longValue();
            }
            case FLOAT: {
                return BigDecimal.valueOf((Double)value).intValue();
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value).intValue();
            }
            case BOOLEAN: {
                return (Boolean)value != false ? 1 : 0;
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return 0L;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return Long.parseLong(value.toString());
            }
            case INTEGER: {
                return (Long)value;
            }
            case FLOAT: {
                return BigDecimal.valueOf((Double)value).longValue();
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value).longValue();
            }
            case BOOLEAN: {
                return (Boolean)value != false ? 1L : 0L;
            }
            case TIMESTAMP: 
            case TIME: {
                return (Long)value / 1000L;
            }
            case DATE: {
                return BigQueryAvroResultSet.buildMutableDateTimeFromDays((Integer)value).getMillis();
            }
            case DATETIME: {
                return DATETIME_PARSER.parseMillis(value.toString());
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return 0.0f;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return Float.parseFloat(value.toString());
            }
            case INTEGER: {
                return ((Long)value).longValue();
            }
            case FLOAT: {
                return (float)((Double)value).doubleValue();
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value).floatValue();
            }
            case BOOLEAN: {
                return (Boolean)value != false ? 1.0f : 0.0f;
            }
            case TIMESTAMP: 
            case TIME: {
                return (float)((Long)value).longValue() / 1000.0f;
            }
            case DATE: {
                return BigQueryAvroResultSet.buildMutableDateTimeFromDays((Integer)value).getMillis();
            }
            case DATETIME: {
                return DATETIME_PARSER.parseMillis(value.toString());
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return 0.0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return Double.parseDouble(value.toString());
            }
            case INTEGER: {
                return ((Long)value).longValue();
            }
            case FLOAT: {
                return (Double)value;
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value).doubleValue();
            }
            case BOOLEAN: {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            case TIMESTAMP: 
            case TIME: {
                return (double)((Long)value).longValue() / 1000.0;
            }
            case DATE: {
                return BigQueryAvroResultSet.buildMutableDateTimeFromDays((Integer)value).getMillis();
            }
            case DATETIME: {
                return DATETIME_PARSER.parseMillis(value.toString());
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return new BigDecimal(value.toString());
            }
            case INTEGER: {
                return new BigDecimal((Long)value);
            }
            case FLOAT: {
                return BigDecimal.valueOf((Double)value);
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(this.getFieldAvroSchema(columnIndex), (ByteBuffer)value);
            }
            case BOOLEAN: {
                return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case TIMESTAMP: 
            case TIME: {
                return new BigDecimal((Long)value).divide(new BigDecimal(1000), RoundingMode.FLOOR);
            }
            case DATE: {
                return new BigDecimal(BigQueryAvroResultSet.buildMutableDateTimeFromDays((Integer)value).getMillis());
            }
            case DATETIME: {
                return new BigDecimal(DATETIME_PARSER.parseMillis(value.toString()));
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case STRING: {
                return ((Utf8)value).getBytes();
            }
            case BYTES: {
                return ((ByteBuffer)value).array();
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return BigQueryAvroResultSet.buildDate((Long)value);
            }
            case TIMESTAMP: 
            case TIME: {
                return BigQueryAvroResultSet.buildDate((Long)value / 1000L);
            }
            case DATE: {
                return BigQueryAvroResultSet.buildDate(BigQueryAvroResultSet.buildMutableDateTimeFromDays((Integer)value));
            }
            case DATETIME: {
                return BigQueryAvroResultSet.buildDate(DATETIME_PARSER.parseMillis(value.toString()));
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return BigQueryAvroResultSet.buildTime((Long)value);
            }
            case TIMESTAMP: 
            case TIME: {
                return BigQueryAvroResultSet.buildTime((Long)value / 1000L);
            }
            case DATE: {
                return BigQueryAvroResultSet.buildTime(0L);
            }
            case DATETIME: {
                return BigQueryAvroResultSet.buildTime(DATETIME_PARSER.parseMillis(value.toString()));
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return new Timestamp((Long)value);
            }
            case TIMESTAMP: 
            case TIME: {
                return new Timestamp((Long)value / 1000L);
            }
            case DATE: {
                return new Timestamp(BigQueryAvroResultSet.buildMutableDateTimeFromDays((Integer)value).getMillis());
            }
            case DATETIME: {
                return new Timestamp(DATETIME_PARSER.parseMillis(value.toString()));
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return BigQueryAvroResultSet.buildDate((Long)value, cal);
            }
            case TIMESTAMP: 
            case TIME: {
                return BigQueryAvroResultSet.buildDate((Long)value / 1000L, cal);
            }
            case DATE: {
                return BigQueryAvroResultSet.buildDate(BigQueryAvroResultSet.buildLocalDateTimeFromDays((Integer)value), cal);
            }
            case DATETIME: {
                return BigQueryAvroResultSet.buildDate(DATETIME_PARSER.parseLocalDateTime(value.toString()), cal);
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return BigQueryAvroResultSet.buildTime((Long)value, cal);
            }
            case TIMESTAMP: 
            case TIME: {
                return BigQueryAvroResultSet.buildTime((Long)value / 1000L, cal);
            }
            case DATE: {
                return BigQueryAvroResultSet.buildTime(0L, cal);
            }
            case DATETIME: {
                return BigQueryAvroResultSet.buildTime(DATETIME_PARSER.parseLocalDateTime(value.toString()), cal);
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfRepeated(columnIndex);
        Object value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return BigQueryAvroResultSet.buildTimestamp((Long)value, cal);
            }
            case TIMESTAMP: 
            case TIME: {
                return BigQueryAvroResultSet.buildTimestamp((Long)value / 1000L, cal);
            }
            case DATE: {
                return BigQueryAvroResultSet.buildTimestamp(BigQueryAvroResultSet.buildLocalDateTimeFromDays((Integer)value), cal);
            }
            case DATETIME: {
                return BigQueryAvroResultSet.buildTimestamp(DATETIME_PARSER.parseLocalDateTime(value.toString()), cal);
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    private void throwIfRepeated(int columnIndex) throws SQLFeatureNotSupportedException {
        if (this.getField(columnIndex).getMode() == Field.Mode.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported field mode: REPEATED");
        }
    }

    private boolean checkIsNull(Object value) {
        this.wasNull = value == null;
        return this.wasNull;
    }

    private JsonElement toJson(Field field, Schema fieldAvroSchema, Object value) throws SQLFeatureNotSupportedException {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (field.getMode() == Field.Mode.REPEATED) {
            JsonArray array = new JsonArray();
            for (Object elementValue : (GenericData.Array)value) {
                array.add(this.singleElementToJson(field, fieldAvroSchema, elementValue));
            }
            return array;
        }
        return this.singleElementToJson(field, fieldAvroSchema, value);
    }

    private JsonElement singleElementToJson(Field field, Schema fieldAvroSchema, Object value) throws SQLFeatureNotSupportedException {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (field.getType() == LegacySQLTypeName.RECORD) {
            return this.recordElementToJson(field, fieldAvroSchema, value);
        }
        Object o = this.extractValue(this.getBigQueryType(field), fieldAvroSchema, value);
        if (o instanceof Long) {
            return new JsonPrimitive((Number)((Long)o));
        }
        if (o instanceof Double) {
            return new JsonPrimitive((Number)((Double)o));
        }
        if (o instanceof Boolean) {
            return new JsonPrimitive((Boolean)o);
        }
        return new JsonPrimitive(String.valueOf(o));
    }

    private JsonElement recordElementToJson(Field field, Schema fieldAvroSchema, Object value) throws SQLFeatureNotSupportedException {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject result = new JsonObject();
        for (int i = 0; i < field.getSubFields().size(); ++i) {
            Field subField = field.getSubFields().get(i);
            Object subFieldValue = ((GenericData.Record)value).get(i);
            result.add(subField.getName(), this.toJson(subField, ((Schema.Field)fieldAvroSchema.getFields().get(i)).schema(), subFieldValue));
        }
        return result;
    }

    private String formatValue(BigQueryDataType columnType, Schema fieldAvroSchema, Object value) throws SQLFeatureNotSupportedException {
        return String.valueOf(this.extractValue(columnType, fieldAvroSchema, value));
    }

    private Object extractValue(BigQueryDataType columnType, Schema fieldAvroSchema, Object value) throws SQLFeatureNotSupportedException {
        switch (columnType) {
            case STRING: 
            case GEOGRAPHY: {
                return value.toString();
            }
            case INTEGER: {
                return Long.parseLong(value.toString());
            }
            case FLOAT: {
                return Double.parseDouble(value.toString());
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value.toString());
            }
            case BYTES: {
                return new String(Base64.getEncoder().encode(((ByteBuffer)value).array()));
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return this.getBigDecimalInternal(fieldAvroSchema, (ByteBuffer)value).toString();
            }
            case TIMESTAMP: {
                return DKUDateUtils.isoFormatUTC((long)((Long)value / 1000L));
            }
            case DATE: {
                return DATE_FORMATTER.print((ReadableInstant)BigQueryAvroResultSet.buildMutableDateTimeFromDays((Integer)value));
            }
            case TIME: {
                return this.formatTime((Long)value);
            }
            case DATETIME: {
                return this.formatDatetime(value.toString());
            }
        }
        throw BigQueryAvroResultSet.unsupportedColumnTypeException(columnType);
    }

    private BigDecimal getBigDecimalInternal(Schema fieldAvroSchema, ByteBuffer value) {
        value.rewind();
        return decimalConversion.fromBytes(value, fieldAvroSchema, fieldAvroSchema.getLogicalType());
    }

    private String formatTime(long value) {
        long millis = value / 1000L;
        long microsOfMillis = value % 1000L;
        if (millis % 1000L == 0L && microsOfMillis == 0L) {
            return TIME_WITHOUT_MILLIS_FORMATTER.print(millis);
        }
        return TIME_WITH_MILLIS_FORMATTER.print(millis) + String.format("%03d", microsOfMillis);
    }

    private String formatDatetime(String value) {
        LocalDateTime localDateTime = LocalDateTime.parse(value);
        java.time.format.DateTimeFormatter formatter = localDateTime.get(ChronoField.MICRO_OF_SECOND) > 0 ? DATETIME_WITH_MICROS_FORMATTER : DATETIME_WITHOUT_MICROS_FORMATTER;
        return localDateTime.format(formatter);
    }

    private Schema getFieldAvroSchema(int columnIndex) {
        return ((Schema.Field)this.flatAvroSchema.getFields().get(columnIndex - 1)).schema();
    }

    private static SQLFeatureNotSupportedException unsupportedColumnTypeException(BigQueryDataType columnType) {
        return new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    private static MutableDateTime buildMutableDateTimeFromDays(int days) {
        MutableDateTime dt = new MutableDateTime(0L, DateTimeZone.UTC);
        dt.addDays(days);
        return dt;
    }

    private static com.dataiku.dss.shadelib.org.joda.time.LocalDateTime buildLocalDateTimeFromDays(int days) {
        com.dataiku.dss.shadelib.org.joda.time.LocalDateTime dt = new com.dataiku.dss.shadelib.org.joda.time.LocalDateTime(0L, DateTimeZone.UTC);
        return dt.plusDays(days);
    }
}

