/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.builtin.BigQueryDataType;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryResultSet;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryStatement;
import com.dataiku.dip.connections.bigquery.builtin.QueryStatisticsProvider;
import com.dataiku.dip.sql.bigquery.BigQueryAbortedOperationException;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldValue;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldValueList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.LegacySQLTypeName;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Schema;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableResult;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;

public class BigQueryFieldValueResultSet
extends BigQueryResultSet {
    protected static final DateTimeFormatter DATE_PARSER = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.UTC);
    protected static final DateTimeFormatter TIME_PARSER = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)"HH:mm:ss")).appendOptional(MILLISECONDS_PARSER).toFormatter().withZone(DateTimeZone.UTC);
    private final Iterator<FieldValueList> rows;
    private final long maxRecords;
    private FieldValueList currentRow;
    private long currentRowIndex;
    private boolean wasNull;

    public BigQueryFieldValueResultSet(BigQueryStatement statement, long maxRecords, Schema schema, TableResult tableResult, QueryStatisticsProvider queryStatisticsProvider) {
        super(statement, schema, queryStatisticsProvider);
        this.rows = tableResult != null ? tableResult.iterateAll().iterator() : null;
        this.maxRecords = maxRecords;
    }

    public BigQueryFieldValueResultSet(BigQueryStatement statement, TableResult tableResult, QueryStatisticsProvider queryStatisticsProvider) {
        this(statement, -1L, tableResult.getSchema(), tableResult, queryStatisticsProvider);
    }

    public BigQueryFieldValueResultSet(BigQueryStatement statement, long maxRecords, Schema schema, QueryStatisticsProvider queryStatisticsProvider) {
        this(statement, maxRecords, schema, null, queryStatisticsProvider);
    }

    public BigQueryFieldValueResultSet(BigQueryStatement statement, long maxRecords, Schema schema, TableResult tableResult) {
        this(statement, maxRecords, schema, tableResult, null);
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rows == null) {
            throw new SQLException("data are not available on dry queries");
        }
        if (this.statement.isCancelled()) {
            throw new BigQueryAbortedOperationException("Statement has been cancelled");
        }
        if (this.rows.hasNext() && (this.maxRecords <= 0L || this.currentRowIndex < this.maxRecords)) {
            this.currentRow = this.rows.next();
            ++this.currentRowIndex;
            return true;
        }
        this.currentRow = null;
        return false;
    }

    public FieldValue get(int columnIndex) throws SQLException {
        if (this.rows == null) {
            throw new SQLException("data are not available on dry queries");
        }
        if (this.currentRow == null) {
            throw new SQLException("Invalid row.");
        }
        try {
            return this.currentRow.get(columnIndex - 1);
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED || columnType == BigQueryDataType.RECORD) {
            return JSON.gson().toJson(this.toJson(this.getField(columnIndex), value));
        }
        return this.formatValue(columnType, value);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return false;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case BOOLEAN: {
                return value.getBooleanValue();
            }
            case INTEGER: {
                return value.getLongValue() != 0L;
            }
            case FLOAT: {
                return value.getDoubleValue() != 0.0;
            }
            case STRING: 
            case JSON: {
                return Boolean.parseBoolean(value.getStringValue());
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return !BigDecimal.ZERO.equals(value.getNumericValue());
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return 0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return (byte)value.getLongValue();
            }
            case STRING: 
            case JSON: {
                return Byte.parseByte(value.getStringValue());
            }
            case BOOLEAN: {
                return value.getBooleanValue() ? (byte)1 : 0;
            }
            case FLOAT: 
            case NUMERIC: 
            case BIGNUMERIC: {
                return value.getNumericValue().byteValue();
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return 0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return (short)value.getLongValue();
            }
            case STRING: 
            case JSON: {
                return Short.parseShort(value.getStringValue());
            }
            case BOOLEAN: {
                return value.getBooleanValue() ? (short)1 : 0;
            }
            case FLOAT: 
            case NUMERIC: 
            case BIGNUMERIC: {
                return value.getNumericValue().shortValue();
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return 0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return (int)value.getLongValue();
            }
            case STRING: 
            case JSON: {
                return Integer.parseInt(value.getStringValue());
            }
            case FLOAT: 
            case NUMERIC: 
            case BIGNUMERIC: {
                return value.getNumericValue().intValue();
            }
            case BOOLEAN: {
                return value.getBooleanValue() ? 1 : 0;
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return 0L;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: {
                return value.getLongValue();
            }
            case STRING: 
            case JSON: {
                return Long.parseLong(value.getStringValue());
            }
            case TIMESTAMP: {
                return value.getTimestampValue() / 1000L;
            }
            case FLOAT: 
            case NUMERIC: 
            case BIGNUMERIC: {
                return value.getNumericValue().longValue();
            }
            case BOOLEAN: {
                return value.getBooleanValue() ? 1L : 0L;
            }
            case DATE: {
                return DATE_PARSER.parseMillis(value.getStringValue());
            }
            case TIME: {
                return TIME_PARSER.parseMillis(value.getStringValue());
            }
            case DATETIME: {
                return DATETIME_PARSER.parseMillis(value.getStringValue());
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return 0.0f;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: 
            case FLOAT: 
            case STRING: 
            case JSON: {
                return Float.parseFloat(value.getStringValue());
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return value.getNumericValue().floatValue();
            }
            case BOOLEAN: {
                return value.getBooleanValue() ? 1.0f : 0.0f;
            }
            case TIMESTAMP: {
                return (float)value.getTimestampValue() / 1000.0f;
            }
            case DATE: {
                return DATE_PARSER.parseMillis(value.getStringValue());
            }
            case TIME: {
                return TIME_PARSER.parseMillis(value.getStringValue());
            }
            case DATETIME: {
                return DATETIME_PARSER.parseMillis(value.getStringValue());
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return 0.0;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: 
            case FLOAT: 
            case STRING: 
            case JSON: {
                return Double.parseDouble(value.getStringValue());
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                return value.getNumericValue().doubleValue();
            }
            case BOOLEAN: {
                return value.getBooleanValue() ? 1.0 : 0.0;
            }
            case TIMESTAMP: {
                return (double)value.getTimestampValue() / 1000.0;
            }
            case DATE: {
                return DATE_PARSER.parseMillis(value.getStringValue());
            }
            case TIME: {
                return TIME_PARSER.parseMillis(value.getStringValue());
            }
            case DATETIME: {
                return DATETIME_PARSER.parseMillis(value.getStringValue());
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case INTEGER: 
            case FLOAT: 
            case STRING: 
            case JSON: 
            case NUMERIC: 
            case BIGNUMERIC: {
                return value.getNumericValue();
            }
            case BOOLEAN: {
                return value.getBooleanValue() ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case TIMESTAMP: {
                return new BigDecimal(value.getTimestampValue()).divide(new BigDecimal(1000), RoundingMode.FLOOR);
            }
            case DATE: {
                return new BigDecimal(DATE_PARSER.parseMillis(value.getStringValue()));
            }
            case TIME: {
                return new BigDecimal(TIME_PARSER.parseMillis(value.getStringValue()));
            }
            case DATETIME: {
                return new BigDecimal(DATETIME_PARSER.parseMillis(value.getStringValue()));
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (this.checkIsNull(value)) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case BYTES: {
                return value.getBytesValue();
            }
            case STRING: 
            case JSON: {
                return value.getStringValue().getBytes(StandardCharsets.UTF_8);
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (value.isNull()) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case TIMESTAMP: {
                return BigQueryFieldValueResultSet.buildDate(value.getTimestampValue() / 1000L);
            }
            case DATE: {
                return BigQueryFieldValueResultSet.buildDate(DATE_PARSER.parseMillis(value.getStringValue()));
            }
            case TIME: {
                return BigQueryFieldValueResultSet.buildDate(TIME_PARSER.parseMillis(value.getStringValue()));
            }
            case DATETIME: {
                return BigQueryFieldValueResultSet.buildDate(DATETIME_PARSER.parseMillis(value.getStringValue()));
            }
            case INTEGER: {
                return BigQueryFieldValueResultSet.buildDate(value.getLongValue());
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (value.isNull()) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case TIMESTAMP: {
                return BigQueryFieldValueResultSet.buildTime(value.getTimestampValue() / 1000L);
            }
            case DATE: {
                return BigQueryFieldValueResultSet.buildTime(DATE_PARSER.parseMillis(value.getStringValue()));
            }
            case TIME: {
                return BigQueryFieldValueResultSet.buildTime(TIME_PARSER.parseMillis(value.getStringValue()));
            }
            case DATETIME: {
                return BigQueryFieldValueResultSet.buildTime(DATETIME_PARSER.parseMillis(value.getStringValue()));
            }
            case INTEGER: {
                return BigQueryFieldValueResultSet.buildTime(value.getLongValue());
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (value.isNull()) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case TIMESTAMP: {
                return new Timestamp(value.getTimestampValue() / 1000L);
            }
            case DATE: {
                return new Timestamp(DATE_PARSER.parseMillis(value.getStringValue()));
            }
            case TIME: {
                return new Timestamp(TIME_PARSER.parseMillis(value.getStringValue()));
            }
            case DATETIME: {
                return new Timestamp(DATETIME_PARSER.parseMillis(value.getStringValue()));
            }
            case INTEGER: {
                return new Timestamp(value.getLongValue());
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (value.isNull()) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case TIMESTAMP: {
                return BigQueryFieldValueResultSet.buildDate(value.getTimestampValue() / 1000L, cal);
            }
            case DATE: {
                return BigQueryFieldValueResultSet.buildDate(DATE_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case TIME: {
                return BigQueryFieldValueResultSet.buildDate(TIME_PARSER.parseMillis(value.getStringValue()), cal);
            }
            case DATETIME: {
                return BigQueryFieldValueResultSet.buildDate(DATETIME_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case INTEGER: {
                return BigQueryFieldValueResultSet.buildDate(value.getLongValue(), cal);
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (value.isNull()) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case TIMESTAMP: {
                return BigQueryFieldValueResultSet.buildTime(value.getTimestampValue() / 1000L, cal);
            }
            case DATE: {
                return BigQueryFieldValueResultSet.buildTime(DATE_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case TIME: {
                return BigQueryFieldValueResultSet.buildTime(TIME_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case DATETIME: {
                return BigQueryFieldValueResultSet.buildTime(DATETIME_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case INTEGER: {
                return BigQueryFieldValueResultSet.buildTime(value.getLongValue(), cal);
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        FieldValue value = this.get(columnIndex);
        if (value.getAttribute() == FieldValue.Attribute.REPEATED) {
            throw new SQLFeatureNotSupportedException("Unsupported column type: ARRAY");
        }
        if (value.isNull()) {
            return null;
        }
        BigQueryDataType columnType = this.getBigQueryType(columnIndex);
        switch (columnType) {
            case TIMESTAMP: {
                return BigQueryFieldValueResultSet.buildTimestamp(value.getTimestampValue() / 1000L, cal);
            }
            case DATE: {
                return BigQueryFieldValueResultSet.buildTimestamp(DATE_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case TIME: {
                return BigQueryFieldValueResultSet.buildTimestamp(TIME_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case DATETIME: {
                return BigQueryFieldValueResultSet.buildTimestamp(DATETIME_PARSER.parseLocalDateTime(value.getStringValue()), cal);
            }
            case INTEGER: {
                return BigQueryFieldValueResultSet.buildTimestamp(value.getLongValue(), cal);
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
    }

    private boolean checkIsNull(FieldValue value) {
        if (value == null || value.isNull()) {
            this.wasNull = true;
            return true;
        }
        this.wasNull = false;
        return false;
    }

    private JsonElement toJson(Field field, FieldValue fieldValue) throws SQLFeatureNotSupportedException {
        if (fieldValue.isNull()) {
            return JsonNull.INSTANCE;
        }
        if (field.getMode() == Field.Mode.REPEATED) {
            JsonArray array = new JsonArray();
            for (FieldValue value : fieldValue.getRepeatedValue()) {
                array.add(this.singleElementToJson(field, value));
            }
            return array;
        }
        return this.singleElementToJson(field, fieldValue);
    }

    private JsonElement singleElementToJson(Field field, FieldValue fieldValue) throws SQLFeatureNotSupportedException {
        if (fieldValue.isNull()) {
            return JsonNull.INSTANCE;
        }
        if (field.getType() == LegacySQLTypeName.RECORD) {
            return this.recordElementToJson(field, fieldValue);
        }
        Object o = this.extractValue(this.getBigQueryType(field), fieldValue);
        if (o instanceof Long) {
            return new JsonPrimitive((Number)((Long)o));
        }
        if (o instanceof Double) {
            return new JsonPrimitive((Number)((Double)o));
        }
        if (o instanceof Boolean) {
            return new JsonPrimitive((Boolean)o);
        }
        return new JsonPrimitive(String.valueOf(o));
    }

    private JsonElement recordElementToJson(Field field, FieldValue fieldValue) throws SQLFeatureNotSupportedException {
        if (fieldValue.isNull()) {
            return JsonNull.INSTANCE;
        }
        JsonObject result = new JsonObject();
        FieldValueList fieldRecordValue = fieldValue.getRecordValue();
        FieldList subFields = field.getSubFields();
        int subFieldsSize = subFields.size();
        for (int i = 0; i < subFieldsSize; ++i) {
            Field subField = subFields.get(i);
            FieldValue subFieldValue = fieldRecordValue.get(i);
            if (subFieldValue == null) continue;
            result.add(subField.getName(), this.toJson(subField, subFieldValue));
        }
        return result;
    }

    private String formatValue(BigQueryDataType columnType, FieldValue value) throws SQLFeatureNotSupportedException {
        return String.valueOf(this.extractValue(columnType, value));
    }

    private Object extractValue(BigQueryDataType columnType, FieldValue value) throws SQLFeatureNotSupportedException {
        return switch (columnType) {
            case BigQueryDataType.INTEGER -> value.getLongValue();
            case BigQueryDataType.FLOAT -> value.getDoubleValue();
            case BigQueryDataType.BOOLEAN -> {
                if (value.getBooleanValue()) {
                    yield Boolean.TRUE;
                }
                yield Boolean.FALSE;
            }
            case BigQueryDataType.TIMESTAMP -> DKUDateUtils.isoFormatUTC((long)(value.getTimestampValue() / 1000L));
            case BigQueryDataType.STRING, BigQueryDataType.JSON, BigQueryDataType.NUMERIC, BigQueryDataType.BIGNUMERIC, BigQueryDataType.BYTES, BigQueryDataType.DATE, BigQueryDataType.TIME, BigQueryDataType.DATETIME, BigQueryDataType.GEOGRAPHY, BigQueryDataType.INTERVAL -> value.getStringValue();
            default -> throw new SQLFeatureNotSupportedException("Unsupported column type: " + String.valueOf((Object)columnType));
        };
    }
}

