/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.builtin.AbstractResultSet;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryDataType;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryResultSetMetadata;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryStatement;
import com.dataiku.dip.connections.bigquery.builtin.QueryStatisticsProvider;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobStatistics;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Schema;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.MutableDateTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BigQueryResultSet
extends AbstractResultSet {
    protected static final DateTimeParser MILLISECONDS_PARSER = new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(0, 6).toParser();
    protected static final DateTimeFormatter DATETIME_PARSER = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss")).appendOptional(MILLISECONDS_PARSER).toFormatter().withZone(DateTimeZone.UTC);
    protected final Schema schema;
    private final Map<String, Integer> columnsIndexesByName;
    private final QueryStatisticsProvider queryStatisticsProvider;

    protected BigQueryResultSet(BigQueryStatement statement, Schema schema, @Nullable QueryStatisticsProvider queryStatisticsProvider) {
        super(statement);
        this.schema = schema;
        this.columnsIndexesByName = schema != null ? this.buildColumnIndexes(schema) : Collections.emptyMap();
        this.queryStatisticsProvider = queryStatisticsProvider;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new BigQueryResultSetMetadata(this.schema);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer index = this.columnsIndexesByName.get(columnLabel);
        if (index == null) {
            throw new SQLException("Unknown column name: " + columnLabel);
        }
        return index;
    }

    public JobStatistics.QueryStatistics getQueryStatistics() {
        return this.queryStatisticsProvider == null ? null : this.queryStatisticsProvider.getQueryStatistics();
    }

    protected Field getField(int columnIndex) {
        return this.schema.getFields().get(columnIndex - 1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex).setScale(scale, RoundingMode.FLOOR);
    }

    protected BigQueryDataType getBigQueryType(int columnIndex) throws SQLFeatureNotSupportedException {
        return this.getBigQueryType(this.getField(columnIndex));
    }

    protected BigQueryDataType getBigQueryType(Field field) throws SQLFeatureNotSupportedException {
        return BigQueryDataType.fromType(field.getType());
    }

    private Map<String, Integer> buildColumnIndexes(Schema schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        FieldList fields = schema.getFields();
        int fieldsSize = fields.size();
        for (int i = 0; i < fieldsSize; ++i) {
            result.put(fields.get(i).getName(), i + 1);
        }
        return result;
    }

    protected static Date buildDate(long millis) {
        return BigQueryResultSet.buildDate(new MutableDateTime(millis, DateTimeZone.UTC));
    }

    protected static Time buildTime(long millis) {
        MutableDateTime dt = new MutableDateTime(millis, DateTimeZone.UTC);
        dt.setDate(1970, 1, 1);
        return new Time(dt.getMillis());
    }

    protected static Date buildDate(long millis, Calendar cal) {
        cal.setTimeInMillis(millis);
        return new Date(cal.getTimeInMillis());
    }

    protected static Date buildDate(LocalDateTime dt, Calendar cal) {
        cal.set(dt.getYear(), dt.getMonthOfYear() - 1, dt.getDayOfMonth(), dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute());
        cal.set(14, dt.getMillisOfSecond());
        return new Date(cal.getTimeInMillis());
    }

    protected static Time buildTime(long millis, Calendar cal) {
        cal.setTimeInMillis(millis);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        return new Time(cal.getTimeInMillis());
    }

    protected static Time buildTime(LocalDateTime dt, Calendar cal) {
        cal.set(1970, 0, 1, dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute());
        cal.set(14, dt.getMillisOfSecond());
        return new Time(cal.getTimeInMillis());
    }

    protected static Date buildDate(MutableDateTime dt) {
        return new Date(dt.getMillis());
    }

    protected static Date buildDate(MutableDateTime dt, Calendar cal) {
        return BigQueryResultSet.buildDate(dt.getMillis(), cal);
    }

    protected static Timestamp buildTimestamp(long millis, Calendar cal) {
        cal.setTimeInMillis(millis);
        return new Timestamp(cal.getTimeInMillis());
    }

    protected static Timestamp buildTimestamp(LocalDateTime dt, Calendar cal) {
        cal.set(dt.getYear(), dt.getMonthOfYear() - 1, dt.getDayOfMonth(), dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute());
        cal.set(14, dt.getMillisOfSecond());
        return new Timestamp(cal.getTimeInMillis());
    }

    protected static Timestamp buildTimestamp(MutableDateTime dt, Calendar cal) {
        return BigQueryResultSet.buildTimestamp(dt.getMillis(), cal);
    }
}

