/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.builtin.AbstractResultSet;
import com.dataiku.dip.connections.bigquery.builtin.SimpleResult;
import com.dataiku.dip.connections.bigquery.builtin.SimpleResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

public class SimpleResultSet
extends AbstractResultSet {
    private final SimpleResult.Schema schema;
    private final Iterator<SimpleResult.Row> rows;
    private SimpleResult.Row currentRow;

    public SimpleResultSet(SimpleResult data) {
        super(null);
        this.schema = data.schema;
        this.rows = data.rows.iterator();
    }

    @Override
    public boolean next() {
        if (this.rows.hasNext()) {
            this.currentRow = this.rows.next();
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new SimpleResultSetMetaData(this.schema);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int column = this.schema.findColumn(columnLabel);
        if (column <= 0) {
            throw new SQLException("Invalid column label: " + columnLabel);
        }
        return column;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.get(columnIndex);
        return value == null ? null : String.valueOf(value);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object value = this.get(columnIndex);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return value == null ? 0 : Integer.parseInt(String.valueOf(value));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object value = this.get(columnIndex);
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return value == null ? 0L : (long)Integer.parseInt(String.valueOf(value));
    }

    public Object get(int columnIndex) throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("Invalid row");
        }
        SimpleResult.Column column = this.schema.columns.get(columnIndex - 1);
        return this.currentRow.values.get(column.name);
    }
}

