/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.j2py.annotations.PyModel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@PyModel
public class ContainerExecRuntimeConfig
extends ContainerExecUtils.KubernetesAwareContainerConfig {
    public String name;
    public Container type;
    public List<SimpleKeyValue> properties = new ArrayList<SimpleKeyValue>();
    public UsableBy usableBy = UsableBy.ALL;
    public List<String> allowedGroups = new ArrayList<String>();
    public WorkloadType workloadType = WorkloadType.ANY;
    public String dockerRuntime;
    public String dockerGpus;
    public String dockerNetwork = "host";
    public ClusterPropertyList dockerResources = new ClusterPropertyList();
    public String kubernetesNamespace;
    public K8SAPIDeploymentInfra.K8SContainerLimits kubernetesResources = new K8SAPIDeploymentInfra.K8SContainerLimits();
    public ClusterPropertyList hostPathVolumes = new ClusterPropertyList();
    public String nodeSelector;
    public String tolerations;
    public String affinity;
    public String deploymentTopologySpreadConstraints;
    public boolean enableCustomSHM = false;
    public int customSHMValueMB = -1;
    public String serviceAccountName;
    public boolean isFinal = false;

    public ContainerExecRuntimeConfig() {
        super(ContainerExecUtils.BaseImageType.EXEC);
    }

    public ContainerExecRuntimeConfig(ContainerExecRuntimeConfig containerExecRuntimeConfig) {
        this(containerExecRuntimeConfig.baseImageType, containerExecRuntimeConfig);
    }

    public ContainerExecRuntimeConfig(ContainerExecUtils.BaseImageType baseImageType, ContainerExecRuntimeConfig containerExecRuntimeConfig) {
        super(baseImageType, containerExecRuntimeConfig);
        this.name = containerExecRuntimeConfig.name;
        this.type = containerExecRuntimeConfig.type;
        containerExecRuntimeConfig.properties.forEach(kv -> this.properties.add(new SimpleKeyValue(kv)));
        this.usableBy = containerExecRuntimeConfig.usableBy;
        this.allowedGroups.addAll(containerExecRuntimeConfig.allowedGroups);
        this.dockerRuntime = containerExecRuntimeConfig.dockerRuntime;
        this.dockerGpus = containerExecRuntimeConfig.dockerGpus;
        this.dockerNetwork = containerExecRuntimeConfig.dockerNetwork;
        this.dockerResources = containerExecRuntimeConfig.dockerResources.deepCopy();
        this.kubernetesNamespace = containerExecRuntimeConfig.kubernetesNamespace;
        this.kubernetesResources = containerExecRuntimeConfig.kubernetesResources.deepCopy();
        this.hostPathVolumes = containerExecRuntimeConfig.hostPathVolumes.deepCopy();
        this.nodeSelector = containerExecRuntimeConfig.nodeSelector;
        this.tolerations = containerExecRuntimeConfig.tolerations;
        this.affinity = containerExecRuntimeConfig.affinity;
        this.deploymentTopologySpreadConstraints = containerExecRuntimeConfig.deploymentTopologySpreadConstraints;
        this.isFinal = containerExecRuntimeConfig.isFinal;
        this.workloadType = containerExecRuntimeConfig.workloadType;
        this.enableCustomSHM = containerExecRuntimeConfig.enableCustomSHM;
        this.customSHMValueMB = containerExecRuntimeConfig.customSHMValueMB;
        this.noImplicitK8sClusterAndNoDefaultClusterId = containerExecRuntimeConfig.noImplicitK8sClusterAndNoDefaultClusterId;
        this.serviceAccountName = containerExecRuntimeConfig.serviceAccountName;
    }

    public ContainerExecRuntimeConfig deepCopy() {
        return new ContainerExecRuntimeConfig(this);
    }

    public ContainerExecRuntimeConfig copyAsBaseImageType(ContainerExecUtils.BaseImageType baseImageType) {
        return new ContainerExecRuntimeConfig(baseImageType, this);
    }

    @Override
    public String getRequestedKubernetesNamespace() {
        return this.kubernetesNamespace;
    }

    public String getProperty(String key) {
        for (SimpleKeyValue p : this.properties) {
            if (!StringUtils.equals((String)key, (String)p.key)) continue;
            return p.value;
        }
        return null;
    }

    public boolean isFreelyUsableBy(AuthCtx authCtx) {
        if (authCtx == null) {
            return true;
        }
        if (this.usableBy == UsableBy.ALL) {
            return true;
        }
        if (this.usableBy == UsableBy.ALLOWED) {
            if (authCtx.isAdmin()) {
                return true;
            }
            for (String allowedGroup : this.allowedGroups) {
                if (!authCtx.getGroupsIfRelevant().contains(allowedGroup)) continue;
                return true;
            }
            return false;
        }
        throw new Error("Invalid usableBy value: " + String.valueOf((Object)this.usableBy));
    }

    public String getProperty(String key, String defaultValue) {
        return StringUtils.defaultIfBlank((String)this.getProperty(key), (String)defaultValue);
    }

    public boolean supportsWorkloadType(WorkloadType wt) {
        return this.workloadType == wt || this.workloadType == WorkloadType.ANY;
    }

    public Pattern getExcludedEnvVarsPattern() {
        String excludedEnvVarsPatternStr = this.getProperty("env_vars.excluded_from_propagation", "");
        if (StringUtils.isBlank((String)excludedEnvVarsPatternStr)) {
            excludedEnvVarsPatternStr = ApplicationConfigurator.getParams().getParam("dku.k8s.env_vars.excluded_from_propagation", "^(PYTHONPATH|PATH|USER|UID|HOME|PWD|TMPDIR|XDG_.*)$");
        }
        return Pattern.compile(excludedEnvVarsPatternStr);
    }

    public static enum UsableBy {
        ALL,
        ALLOWED;

    }

    public static enum Container {
        DOCKER,
        KUBERNETES;

    }
}

