/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.datamodel.config.InfraStage;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.eventserver.dssmodel.EventServerSettings;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.llm.online.LLMCostLimitingCountersRepository;
import com.dataiku.dip.plugins.model.PluginComponentRef;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.audit.model.AuditTrailSettings;
import com.dataiku.dip.security.auth.AuthSyncSettings;
import com.dataiku.dip.security.auth.CustomAuthSettings;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.impersonation.ImpersonationConfig;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.pam.PAMSettings;
import com.dataiku.dip.security.scenario.ScenarioSecuritySettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.HomepageContentService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsageDataReporting;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesUpdateConfig;
import com.dataiku.dip.webapps.VirtualWebAppBackendSettings;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.j2py.annotations.PyModel;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralSettingsDAO {
    @Autowired
    private TransactionService transactionService;
    private static RelFile f = RelFile.global((String)"general-settings.json");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.generalSettings.dao");

    public GeneralSettings read() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return (GeneralSettings)t.readObjectDefault(f, GeneralSettings.class);
    }

    public GeneralSettings getUnsafe() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isFile(f)) {
            return (GeneralSettings)t.readObjectUnsafe(f, GeneralSettings.class);
        }
        return new GeneralSettings();
    }

    public GeneralSettings getUnsafeAutoTXN() throws IOException {
        if (this.transactionService == null) {
            logger.warn((Object)"dep injection mess : transactionService isn't ready");
            this.transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        }
        try (Transaction t = this.transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            GeneralSettings generalSettings = this.getUnsafe();
            return generalSettings;
        }
    }

    public long getLastModified() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.getLastModified(f);
    }

    public void save(GeneralSettings gs) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(f, (Object)gs);
    }

    @PyModel
    public static class GeneralSettings {
        public UsageDataReporting.UsageDataReportingMode udrMode = UsageDataReporting.UsageDataReportingMode.DEFAULT;
        public boolean npsSurveyEnabled = true;
        public boolean errorsReportingEnabled = true;
        public boolean opalsEnabled = true;
        public boolean dropDataWithDatasetDeleteEnabled;
        public ProxySettings proxySettings = new ProxySettings();
        public MailSettings mailSettings = new MailSettings();
        public String jobMailsAlwaysCC;
        public VariablesUpdateConfig variablesUpdateConfig;
        public String h2o_url;
        public int maxRunningActivitiesPerJob = 5;
        public int maxRunningActivities = 5;
        public List<SimpleKeyValue> maxRunningActivitiesPerKey = new ArrayList<SimpleKeyValue>();
        public LdapSettings ldapSettings = new LdapSettings();
        public AuthSyncSettings authSyncSettings = new AuthSyncSettings();
        public PAMSettings pamSettings = new PAMSettings();
        public SSOSettings ssoSettings = new SSOSettings();
        public AzureADSettings azureADSettings = new AzureADSettings();
        public CustomAuthSettings customAuthSettings = new CustomAuthSettings();
        public ScenarioSecuritySettings scenarioSecuritySettings = new ScenarioSecuritySettings();
        public ComputablesAvailabilityMode computablesAvailabilityMode = ComputablesAvailabilityMode.EXPOSED_ONLY;
        public GlobalCrossProjectBuildBehaviour globalCrossProjectBuildBehaviour = GlobalCrossProjectBuildBehaviour.STOP_AT_BOUNDARIES;
        public boolean noLoginMode;
        public String noLoginImpersonate;
        public SparkSettings sparkSettings = new SparkSettings();
        public ContainerSettings containerSettings = new ContainerSettings();
        public KubernetesPoliciesSettings k8sPoliciesSettings = new KubernetesPoliciesSettings();
        public boolean isAWSMarketplace;
        public boolean generateInitialPassword;
        public boolean pluginDevExplicitCommit = false;
        public List<PluginComponentRef> customFieldsPluginComponentOrder = new ArrayList<PluginComponentRef>();
        public List<PluginComponentRef> customPolicyHooksPluginComponentOrder = new ArrayList<PluginComponentRef>();
        public String lambdaDevBundledConnection;
        public String defaultClusterId;
        public String defaultK8sClusterId;
        public boolean useImplicitK8sCluster = false;
        public MetastoreCatalogsSettings metastoreCatalogsSettings = new MetastoreCatalogsSettings();
        public HadoopSettings hadoopSettings = new HadoopSettings();
        public HiveSettings hiveSettings = new HiveSettings();
        public ImpalaSettings impalaSettings = new ImpalaSettings();
        public SecuritySettings security = new SecuritySettings();
        public String studioExternalUrl;
        public String studioInternalUrl;
        public String studioMailAddress;
        public String studioForgotPasswordUrl;
        public String studioAdminContactLabel;
        public String studioAdminContact;
        public WebAppSecuritySettings webAppSecuritySettings = new WebAppSecuritySettings();
        public int debounceDelayForWikiArticleSave = 300000;
        public DeployerClientSettings deployerClientSettings = new DeployerClientSettings();
        public APIDeployerServerSettings apiDeployerServerSettings = new APIDeployerServerSettings();
        public ProjectDeployerServerSettings projectDeployerServerSettings = new ProjectDeployerServerSettings();
        public List<RemoteDesignNodeCreds> remoteDesignNodeCreds = new ArrayList<RemoteDesignNodeCreds>();
        public boolean deployerServerEnabledDespiteRemote;
        public GovernIntegrationSettings governIntegrationSettings = new GovernIntegrationSettings();
        public String graphiteServerUrl;
        public String graphiteMetricPrefix;
        public int graphiteReportingDelay;
        public boolean disableAutomaticTriggers = false;
        public int triggerCountdownDuration = 60;
        public boolean achievementsDisabled = false;
        public String themeId;
        public String nodeName;
        public DefaultFolderSettings defaultFolderSettings = new DefaultFolderSettings();
        public List<ProjectStatus> projectStatusList = new ArrayList<ProjectStatus>();
        public List<BrandColor> brandColors = new ArrayList<BrandColor>();
        public List<HomeMessage> homeMessages = new ArrayList<HomeMessage>();
        public GitSettings git = new GitSettings();
        public List<GlobalTagCategory> globalTagsCategories = new ArrayList<GlobalTagCategory>();
        public boolean quickSharingElementsEnabled = true;
        public boolean pluginInstallRequestsEnabled = true;
        public GlobalVisibilitySettings projectVisibility = new GlobalVisibilitySettings();
        public GlobalVisibilitySettings appVisibility = new GlobalVisibilitySettings();
        public InheritableEnabledSetting objectSharingRequestsMode = InheritableEnabledSetting.ENABLED_BY_DEFAULT;
        public boolean permissionsByEmailEnabled = true;
        public NotificationsSettings notifications = new NotificationsSettings();
        public ImpersonationConfig impersonation = new ImpersonationConfig();
        public SerializedProject.LimitsSettings limits = new SerializedProject.LimitsSettings();
        public LocalProcessesCgroupsSettings cgroupSettings = new LocalProcessesCgroupsSettings();
        public GlobalDefaultDatasetCreationSettings defaultDatasetCreationSettings = new GlobalDefaultDatasetCreationSettings();
        public GlobalDefaultRecipeCreationSettings defaultRecipeCreationSettings = new GlobalDefaultRecipeCreationSettings();
        public RecipeEnginesPreferenceConfig recipeEnginesPreferences = new RecipeEnginesPreferenceConfig();
        public CorsSettings corsSettings = new CorsSettings();
        public WebappsSettings webappsSettings = new WebappsSettings();
        public AlationCatalogSettings alationSettings = new AlationCatalogSettings();
        public boolean graphicsExportsEnabled = false;
        public GlobalCodeEnvsExtraSettings codeEnvs = new GlobalCodeEnvsExtraSettings();
        public PersonalHomePagesSettings personalHomePages = new PersonalHomePagesSettings();
        public List<HelpCenterLabeledLink> helpCenterSupportLinks = new ArrayList<HelpCenterLabeledLink>();
        public InternalDBConnectionSettings internalDatabase = new InternalDBConnectionSettings();
        public LicensingSettings licensingSettings = new LicensingSettings();
        public VirtualWebAppBackendSettings virtualWebAppBackendSettings = new VirtualWebAppBackendSettings(true);
        public WhiteLabelingSettings whiteLabeling;
        public UICustomizationSettings uiCustomizationSettings = new UICustomizationSettings();
        public EventServerSettings eventServerSettings = new EventServerSettings();
        public boolean helpIntegrationEnabled = true;
        public boolean openTicketsFromOpalsEnabled = true;
        public boolean onboardingExperience = true;
        public AuditTrailSettings auditTrailSettings = new AuditTrailSettings();
        public ComputeResourceUsageReportingSettings computeResourceUsageReportingSettings = new ComputeResourceUsageReportingSettings();
        public boolean streamingEnabled = false;
        public boolean showProjectsGraphView = false;
        public PortRangeParams dssPortRange = new PortRangeParams();
        public boolean autoAcceptSchemaChangeAtEndOfFlow = true;
        public Set<String> sanityCheckExclusionList = new HashSet<String>();
        public GenerativeAISettings generativeAISettings = new GenerativeAISettings();
        public AIDrivenAnalyticsSettings aiDrivenAnalyticsSettings = new AIDrivenAnalyticsSettings();
        public boolean storiesVocalEnabled = false;
        public CodeAssistantSettings codeAssistantSettings = new CodeAssistantSettings();
        public DataikuStoriesSettings dataikuStoriesSettings = new DataikuStoriesSettings();
        public AskDataikuSettings askDataikuSettings = new AskDataikuSettings();
        public boolean codeEnvInstallRequestsEnabled = true;
        public PopularDatasetsSettings popularDatasetsSettings = new PopularDatasetsSettings();
        public String recoBannerHomeMessage;
        public List<HelpCenterLabeledLink> recoBannerMustReads = new ArrayList<HelpCenterLabeledLink>();
        public JEKSettings jekSettings = new JEKSettings();
        public WelcomeEmailSettings welcomeEmailSettings = new WelcomeEmailSettings();
        public LocalAIServerSettings localAIServerSettings = new LocalAIServerSettings();
        public DataikuCloudUISettings dataikuCloudUISettings;
        public NamingRulesSettings namingRulesSettings;
        public String selectedDSSVisualizationThemeId;
    }

    public static class PopularDatasetsSettings {
        public boolean enablePopularDatasets = true;
        public int maxDaysSinceLastRebuild = -1;
        public int maxDaysSinceUseByANewRecipe = 60;
        public int minShares = 3;
        public boolean onlyFromDataCollections = false;
        public boolean onlyTrendingDatasets = false;
    }

    public static class RemoteDesignNodeCreds {
        @Nonnull
        public String url;
        @Nonnull
        public String apiKey;
        @Nonnull
        public boolean trustAllSSLCertificates;

        public RemoteDesignNodeCreds(String url, String apiKey) {
            this.url = url;
            this.apiKey = apiKey;
            this.trustAllSSLCertificates = true;
        }

        public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.apiKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.apiKey);
        }

        public void decryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.apiKey = passwordEncryptionService.decryptIfEncrypted(this.apiKey);
        }
    }

    public static class AskDataikuSettings {
        public boolean enabled = true;
        public boolean telemetryEnabled = true;
    }

    public static class DataikuStoriesSettings {
        public boolean enabled = false;
        public int clickhouseClientMaxInsertBlockSize = 1000;
        public double clickhouseMaxServerMemoryUsageToRamRatio = 0.9;
        public double minimumFreeDiskSpaceRatio = 0.05;
        public boolean sqlDataCacheEnabled = true;
    }

    public static class CodeAssistantSettings {
        public boolean codeAssistantEnabled = false;
        public String codeAssistantDefaultLlmId;
    }

    public static class LocalAIServerSettings {
        public String webappReference;
        public boolean prepareAICompletionUseLocal;
        public boolean aiGenerateSQLUseLocal;
        public boolean aiExplanationsUseLocal;
        public boolean storiesAIUseLocal;

        public boolean isLocalAiAssistantEnabled(@Nullable AiAssistant aiAgent) {
            if (aiAgent == null) {
                return false;
            }
            switch (aiAgent) {
                case prepareAICompletion: {
                    return this.prepareAICompletionUseLocal;
                }
                case aiGenerateSQL: {
                    return this.aiGenerateSQLUseLocal;
                }
                case aiExplanations: {
                    return this.aiExplanationsUseLocal;
                }
                case storiesAI: {
                    return this.storiesAIUseLocal;
                }
            }
            return false;
        }

        public static enum AiAssistant {
            prepareAICompletion,
            aiGenerateSQL,
            aiExplanations,
            storiesAI;

        }
    }

    public static enum LLMCostLimitingPeriodicity {
        YEAR(LLMCostLimitingCountersRepository.AggregationType.YEAR, true, "year"),
        QUARTER(LLMCostLimitingCountersRepository.AggregationType.QUARTER, true, "quarter"),
        MONTH(LLMCostLimitingCountersRepository.AggregationType.MONTH, true, "month"),
        DAY(LLMCostLimitingCountersRepository.AggregationType.DAY, true, "day"),
        MINUTE(LLMCostLimitingCountersRepository.AggregationType.MINUTE, false, "minute"),
        NONE(LLMCostLimitingCountersRepository.AggregationType.NONE, true, "None");

        public final LLMCostLimitingCountersRepository.AggregationType aggregationType;
        public final boolean defaultVisibility;
        private final String displayName;

        private LLMCostLimitingPeriodicity(LLMCostLimitingCountersRepository.AggregationType aggregationType, boolean defaultVisibility, String displayName) {
            this.aggregationType = aggregationType;
            this.defaultVisibility = defaultVisibility;
            this.displayName = displayName;
        }

        public static List<LLMCostLimitingPeriodicity> listDisplayedPeriodicities() {
            return Arrays.stream(LLMCostLimitingPeriodicity.values()).filter(p -> DKUApp.getParams().getBoolParam("dku.llm.costLimiting.displayedPeriodicity." + p.name(), p.defaultVisibility)).collect(Collectors.toList());
        }

        public String toDisplayLabel(int rollingPeriods) {
            StringBuilder name = new StringBuilder();
            if (rollingPeriods == 1) {
                name.append("Calendar ");
            } else if (rollingPeriods > 1) {
                name.append(rollingPeriods);
                name.append(" rolling ");
            }
            name.append(this.displayName);
            if (rollingPeriods > 1) {
                name.append("s");
            }
            return name.toString();
        }
    }

    public static class ReportingTarget {
        public String email;
    }

    public static class ReportingAction {
        public double threshold;

        public ReportingAction() {
        }

        public ReportingAction(double threshold) {
            this.threshold = threshold;
        }
    }

    public static class RateLimitingConfig {
        public long requestsPerMinute;
        public boolean managed = true;

        public RateLimitingConfig(long requestsPerMinute) {
            this(requestsPerMinute, true);
        }

        public RateLimitingConfig(long requestsPerMinute, boolean managed) {
            this.requestsPerMinute = requestsPerMinute;
            this.managed = managed;
        }

        public RateLimitingConfig(RateLimitingConfig that) {
            this.requestsPerMinute = that.requestsPerMinute;
            this.managed = that.managed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RateLimitingConfig that = (RateLimitingConfig)o;
            return Objects.equals(this.requestsPerMinute, that.requestsPerMinute) && Objects.equals(this.managed, that.managed);
        }

        public int hashCode() {
            return Objects.hash(this.requestsPerMinute, this.managed);
        }
    }

    public static class RateLimitingProviderSettings {
        public RateLimitingConfig completionDefault;
        public RateLimitingConfig embeddingDefault;
        public RateLimitingConfig imageGenerationDefault;
        public Map<String, RateLimitingConfig> perModelConfigs = new HashMap<String, RateLimitingConfig>();

        public RateLimitingProviderSettings(RateLimitingConfig completionDefault, RateLimitingConfig embeddingDefault, RateLimitingConfig imageGenDefault, Map<String, RateLimitingConfig> perModelsConfigs) {
            this.completionDefault = completionDefault;
            this.embeddingDefault = embeddingDefault;
            this.imageGenerationDefault = imageGenDefault;
            this.perModelConfigs.putAll(perModelsConfigs);
        }

        public RateLimitingProviderSettings(RateLimitingProviderSettings that) {
            this.completionDefault = RateLimitingProviderSettings.copyConfig(that.completionDefault);
            this.embeddingDefault = RateLimitingProviderSettings.copyConfig(that.embeddingDefault);
            this.imageGenerationDefault = RateLimitingProviderSettings.copyConfig(that.imageGenerationDefault);
            for (Map.Entry<String, RateLimitingConfig> entry : that.perModelConfigs.entrySet()) {
                this.perModelConfigs.put(entry.getKey(), new RateLimitingConfig(entry.getValue()));
            }
        }

        private static RateLimitingConfig copyConfig(RateLimitingConfig config) {
            if (config != null) {
                return new RateLimitingConfig(config);
            }
            return null;
        }

        public static ProviderSettingsBuilder builder() {
            return new ProviderSettingsBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RateLimitingProviderSettings that = (RateLimitingProviderSettings)o;
            return Objects.equals(this.completionDefault, that.completionDefault) && Objects.equals(this.embeddingDefault, that.embeddingDefault) && Objects.equals(this.imageGenerationDefault, that.imageGenerationDefault) && Objects.equals(this.perModelConfigs, that.perModelConfigs);
        }

        public int hashCode() {
            return Objects.hash(this.completionDefault, this.embeddingDefault, this.imageGenerationDefault, this.perModelConfigs);
        }

        public static class ProviderSettingsBuilder {
            private RateLimitingConfig completionDefault;
            private RateLimitingConfig embeddingDefault;
            private RateLimitingConfig imageGenerationDefault;
            private Map<String, RateLimitingConfig> perModelConfigs = new HashMap<String, RateLimitingConfig>();

            public ProviderSettingsBuilder withCompletionDefaultConfig(long requestsPerMinute) {
                this.completionDefault = new RateLimitingConfig(requestsPerMinute);
                return this;
            }

            public ProviderSettingsBuilder withEmbeddingDefaultConfig(long requestsPerMinute) {
                this.embeddingDefault = new RateLimitingConfig(requestsPerMinute);
                return this;
            }

            public ProviderSettingsBuilder withImageGenerationDefaultConfig(long requestsPerMinute) {
                this.imageGenerationDefault = new RateLimitingConfig(requestsPerMinute);
                return this;
            }

            public ProviderSettingsBuilder withPerModelConfig(String modelId, long requestsPerMinute) {
                this.perModelConfigs.put(modelId, new RateLimitingConfig(requestsPerMinute));
                return this;
            }

            public RateLimitingProviderSettings build() {
                return new RateLimitingProviderSettings(this.completionDefault, this.embeddingDefault, this.imageGenerationDefault, this.perModelConfigs);
            }
        }
    }

    public static class RateLimitingSettings {
        public Map<String, RateLimitingProviderSettings> perProviderSettings = new HashMap<String, RateLimitingProviderSettings>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RateLimitingSettings that = (RateLimitingSettings)o;
            return Objects.equals(this.perProviderSettings, that.perProviderSettings);
        }

        public int hashCode() {
            return Objects.hash(this.perProviderSettings);
        }
    }

    public static class FallbackLLMCostLimitingQuota
    extends LLMCostLimitingQuota {
        public static final String DKU_FALLBACK_QUOTA_ID = "DKU-FALLBACK-QUOTA";
        public final String id = "DKU-FALLBACK-QUOTA";

        @Override
        public String getId() {
            return DKU_FALLBACK_QUOTA_ID;
        }

        @Override
        public String getName() {
            return "Fallback quota";
        }

        @Override
        public boolean isFallback() {
            return true;
        }
    }

    public static class CustomLLMCostLimitingQuota
    extends LLMCostLimitingQuota {
        public String id;
        public String name;
        public FilterDesc filter = new FilterDesc();

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFallback() {
            return false;
        }
    }

    public static abstract class LLMCostLimitingQuota {
        public double costLimit;
        public LLMCostLimitingPeriodicity periodicity = LLMCostLimitingPeriodicity.MONTH;
        public Integer rollingPeriods = 1;
        public boolean blockingLimit;
        public List<ReportingAction> reportingActions = new ArrayList<ReportingAction>();
        public List<ReportingTarget> reportingTargets = new ArrayList<ReportingTarget>();
        public String emailChannelId;

        public abstract String getId();

        public abstract String getName();

        public abstract boolean isFallback();

        public final String getLogIdentifier() {
            return this.getName() + " (" + this.getId() + ")";
        }
    }

    public static class EmbedDocumentsRecipeSettings {
        public String defaultVLMId;
        public String defaultOutputFolderConnectionId;
        private String textExtractionCodeEnv;
        public ContainerExecSelection documentExtractionContainerExecSelection = new ContainerExecSelection();

        public String getTextExtractionCodeEnv() {
            if (StringUtils.isBlank((String)this.textExtractionCodeEnv)) {
                return DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.DOCUMENT_EXTRACTION_CODE_ENV);
            }
            return this.textExtractionCodeEnv;
        }
    }

    public static class LLMCostLimitingSettings {
        public List<CustomLLMCostLimitingQuota> quotas = new ArrayList<CustomLLMCostLimitingQuota>();
        public FallbackLLMCostLimitingQuota fallbackQuota = new FallbackLLMCostLimitingQuota();
    }

    public static class GenerativeAISettings {
        private String defaultRetrievableKnowledgeCodeEnv;
        public ContainerExecSelection defaultRetrievableKnowledgeContainerExecSelection = new ContainerExecSelection();
        private String presidioBasedPIIDetectionCodeEnv;
        public ContainerExecSelection presidioBasedPIIDetectionContainerExecSelection = new ContainerExecSelection();
        public HuggingFaceLocalSettings huggingFaceLocalSettings = new HuggingFaceLocalSettings();
        public String defaultEvalTextEmbeddingModelId;
        public String defaultEvalLLMCompletionModelId;
        public String defaultLLMEvalCodeEnv;
        public LLMCostLimitingSettings costLimitingSettings = new LLMCostLimitingSettings();
        public RateLimitingSettings rateLimitingSettings = new RateLimitingSettings();
        public EmbedDocumentsRecipeSettings embedDocumentsRecipeSettings = new EmbedDocumentsRecipeSettings();
        public GlobalLLMAuditSettings globalLLMAuditSettings = new GlobalLLMAuditSettings();
        public AgentsToolsSettings agentsToolsSettings = new AgentsToolsSettings();
        public LLMTraceSettings llmTraceSettings = new LLMTraceSettings();

        public String getDefaultRetrievableKnowledgeCodeEnv() {
            if (StringUtils.isBlank((String)this.defaultRetrievableKnowledgeCodeEnv)) {
                return DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV);
            }
            return this.defaultRetrievableKnowledgeCodeEnv;
        }

        public String getPresidioBasedPIIDetectionCodeEnv() {
            if (StringUtils.isBlank((String)this.presidioBasedPIIDetectionCodeEnv)) {
                return DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.PII_DETECTION_CODE_ENV);
            }
            return this.presidioBasedPIIDetectionCodeEnv;
        }
    }

    public static class GlobalLLMAuditSettings {
        public AbstractLLMConnection.LLMQueriesAuditingMode auditingModeForLLMsWithoutConnection = AbstractLLMConnection.LLMQueriesAuditingMode.METADATA_ONLY;
        public boolean auditCompletionTracesForLLMsWithoutConnection;
        public boolean auditImageGenerationTracesForLLMsWithoutConnection;
    }

    public static class LLMTraceSettings {
        public TraceExplorerDefaultWebApp traceExplorerDefaultWebApp = new TraceExplorerDefaultWebApp();
    }

    public static class TraceExplorerDefaultWebApp {
        public String projectKey;
        public String webAppId;
    }

    public static class AgentsToolsSettings {
        public boolean auditToolsInputs;
        public boolean auditToolsOutputs;
        public boolean auditToolsTraces;
    }

    public static class HuggingFaceLocalSettings {
        public int maxConcurrentKernels = 20;
        public int kernelIdleTTLSeconds = 1200;
    }

    public static class AIDrivenAnalyticsSettings {
        public boolean dataikuAIServicesTermsOfUseAccepted = false;
        public String dataikuAIServicesTermsOfUseAcceptedOn;
        public String dataikuAIServicesTermsOfUseAcceptedBy;
        public boolean prepareAICompletionEnabled;
        public boolean prepareAICompletionSendSampleValues = true;
        public boolean prepareAICompletionTelemetryEnabled = true;
        public boolean aiGenerateSQLEnabled;
        public boolean aiGenerateSQLTelemetryEnabled = true;
        public boolean aiExplanationsEnabled;
        public boolean aiExplanationsTelemetryEnabled = true;
        public boolean storiesAIEnabled;
        public boolean storiesAISamplesEnabled = true;
        public boolean storiesAITelemetryEnabled = true;
    }

    public static class WebAppSecuritySettings {
        public RequiredAuthenticationMode requiredAuthenticationMode = RequiredAuthenticationMode.ALL_BUT_ADMIN_WHITELIST;
        public List<String> requiredAuthenticationWhitelist = new ArrayList<String>();
        public List<SimpleKeyValue> vanityURLs = new ArrayList<SimpleKeyValue>();
        public boolean disableAccessToken;
        public List<String> accessTokenWhitelist = new ArrayList<String>();
        public String webAppAuthCustomRedirectUrl;
        public RedirectMode redirectMode = RedirectMode.DEFAULT;
        public TrustedCodePolicy trustedCodePolicy = TrustedCodePolicy.NOBODY;

        public static enum RequiredAuthenticationMode {
            ALL_BUT_ADMIN_WHITELIST,
            LET_USER_DECIDE;

        }

        public static enum RedirectMode {
            DEFAULT,
            RELATIVE_URL,
            USE_STUDIO_URL;

        }

        public static enum TrustedCodePolicy {
            NOBODY,
            ADMIN,
            EVERYONE;

        }
    }

    public static class WhiteLabelingSettings {
        public String productShortName = "DSS";
        public String productLongName = "Dataiku";
        public String productAppName = "Dataiku App";
        public String navbarIconUrl;
        public List<List<Integer>> defaultProjectColors = new ArrayList<List<Integer>>();
        public String referenceDocRootUrl;
        public String apiDocRootUrl;
        public String academyRootUrl;
        public String learnRootUrl;
        public boolean contextualHelpSearchEnabled = true;
        public boolean homepageGettingStartedEnabled = true;
        public boolean userEmailsEnabled = true;
        public boolean giveFeedbackModalEnabled = true;
        public boolean npsEnabled = true;
        public List<HelpMenuItem> additionalHelpMenuItems = new ArrayList<HelpMenuItem>();
        public String aboutModalTitle;
        public String aboutModalLogoUrl;
        public String aboutModalText;
        public String getHelpModalTitle;
        public String getHelpModalText;

        static class HelpMenuItem {
            public String label;
            public String url;

            HelpMenuItem() {
            }
        }
    }

    public static class UICustomizationSettings {
        public boolean showTraditionalHadoop = true;
        public boolean showR = true;
        public boolean showScala = true;
        public String[] hideDatasetTypes = new String[0];
        public boolean showDatasetTypesForWhichThereIsNoConnection = false;
        public List<String> highlightedDatasets = Lists.newArrayList((Object[])new String[]{"UploadedFiles", "search_and_import"});
        public Map<String, String> custom504Error;
    }

    public static enum DEFAULT_PROJECT_STATUS {
        SANDBOX("Sandbox", "#4285F4"),
        DRAFT("Draft", "#77bec2"),
        INUSE("In use", "#94BF51"),
        INNPROD("In production", "#ee874a"),
        ARCHIVED("Archived", "#CCCCCC");

        public final ProjectStatus projectStatus;

        private DEFAULT_PROJECT_STATUS(String name, String color) {
            this.projectStatus = new ProjectStatus(name, color);
        }
    }

    public static class HomeMessage {
        public String name;
        public String content;

        public HomeMessage() {
        }

        public HomeMessage(String name, String content) {
            this.name = name;
            this.content = content;
        }
    }

    public static class BrandColor {
        public String color;
    }

    public static class DefaultFolderSettings {
        public List<DefaultFolderRule> rules = Lists.newArrayList((Object[])new DefaultFolderRule[]{new DefaultFolderRule("$$ALL_USERS$$", "SANDBOX", false)});
    }

    public static class DefaultFolderRule {
        public String group;
        public String folderId;
        public boolean subFolderPerUser = false;

        public DefaultFolderRule() {
        }

        public DefaultFolderRule(String group, String folderId, boolean subFolderPerUser) {
            this.group = group;
            this.folderId = folderId;
            this.subFolderPerUser = subFolderPerUser;
        }
    }

    public static class ProjectStatus {
        public String name;
        public String color;

        public ProjectStatus() {
        }

        public ProjectStatus(String name, String color) {
            this.name = name;
            this.color = color;
        }
    }

    public static enum GlobalCrossProjectBuildBehaviour {
        STOP_AT_BOUNDARIES,
        TRAVERSE_BOUNDARIES;

    }

    public static enum ComputablesAvailabilityMode {
        ALL_ACCESSIBLE_AVAILABLE,
        EXPOSED_ONLY;

    }

    public static class MailSettings {
        public String method;
        public String smtpHost;
        public String awsAccessKey;
        public String awsSecretKey;
    }

    public static class WelcomeEmailSettings {
        public boolean enabled = true;
        public boolean useDefaultTemplate = true;
        public String subject = "Welcome to Dataiku!";
        public boolean sendAsHTML = false;
        public String message = "";
    }

    public static class NotificationsSettings {
        public GlobalDispatchPolicy notifyOnUserConnection = GlobalDispatchPolicy.ALL;
        public ProjectDispatchPolicy notifyOnTaskStartAndStop = ProjectDispatchPolicy.ALL_WITH_ACCESS_TO_PROJECT;
        public String emailChannelId;

        public static enum GlobalDispatchPolicy {
            NOBODY,
            ALL;

        }

        public static enum ProjectDispatchPolicy {
            NOBODY,
            ALL_WITH_ACCESS_TO_PROJECT,
            ALL_BROWSING_PROJECT,
            INITIATOR;

        }
    }

    public static class GlobalVisibilitySettings {
        public InheritableEnabledSetting visibilityMode = InheritableEnabledSetting.ENABLED_BY_DEFAULT;
        public InheritableEnabledSetting accessRequestsMode = InheritableEnabledSetting.ENABLED_BY_DEFAULT;
    }

    public static class LicensingSettings {
        public TrialBehavior trialBehavior = TrialBehavior.ENABLED;
        public NoneUsersCallToActionBehavior noneUsersCallToActionBehavior = NoneUsersCallToActionBehavior.DISPLAY_MESSAGE;
        public String userProfileForTrialsStartedByNoneUsers = "DESIGNER";
        public String noneUsersCallToActionMessage;
        public TrialExpirationBehavior trialExpirationBehavior = TrialExpirationBehavior.SWITCH_TO_NONE;
        public String trialExpirationTargetProfile = "AI_CONSUMER";
        public boolean allowRequestAccessWithStartedTrial = true;
        public String signUpMessage;
        public boolean allowProfileUpgradeRequests = true;
        public String upgradeProfileCallToActionMessage;
    }

    public static enum TrialExpirationBehavior {
        SWITCH_TO_NORMAL_LICENSE,
        SWITCH_TO_OTHER_PROFILE,
        SWITCH_TO_NONE;

    }

    public static enum NoneUsersCallToActionBehavior {
        DISPLAY_MESSAGE,
        ALLOW_START_TRIAL,
        ALLOW_REQUEST_ACCESS;

    }

    public static enum TrialBehavior {
        DISABLED,
        ENABLED,
        ENABLED_IF_PRESENT_IN_LICENSE;

    }

    public static enum InheritableEnabledSetting {
        ENABLED_BY_DEFAULT,
        DISABLED_BY_DEFAULT,
        ALL_ENABLED,
        ALL_DISABLED;


        public boolean resolveLocalSetting(LocalValue localValue) {
            if (this == ALL_DISABLED) {
                return false;
            }
            if (this == ALL_ENABLED) {
                return true;
            }
            if (localValue == LocalValue.INHERIT) {
                return this == ENABLED_BY_DEFAULT;
            }
            return localValue == LocalValue.ENABLED;
        }

        public static enum LocalValue {
            ENABLED,
            DISABLED,
            INHERIT;


            public boolean isEnabled() {
                return this == ENABLED;
            }

            public boolean isDisabled() {
                return this == DISABLED;
            }

            public boolean isInherited() {
                return this == INHERIT;
            }
        }
    }

    public static enum WebappsIsolationMode {
        NONE,
        SANDBOX,
        ALTERNATIVE_ORIGIN;

    }

    public static enum PostLogoutBehavior {
        LOGGED_OUT_PAGE,
        CUSTOM_URL;

    }

    public static class SecuritySettings {
        public boolean hideVersionStringsWhenNotLogged;
        public boolean hideLogs;
        public boolean hideErrorStacks;
        public boolean hideLogTails;
        public boolean secureCookies;
        public boolean sameSiteNoneCookies;
        public boolean secureSecretKeys = true;
        public boolean disableDataTableLinks;
        public int sessionsMaxTotalTimeMinutes;
        public int sessionsMaxIdleTimeMinutes;
        public boolean forceSingleSessionPerUser;
        public boolean restrictUsersAndGroupsVisibility;
        public boolean caseSensitiveLogins = true;
        public boolean ipBoundSessions;
        public WebappsIsolationMode webappsIsolationMode = WebappsIsolationMode.NONE;
        public String webappsIsolationOrigin;
        public boolean restrictEasterEggsEvenForAdmin = false;
        public PostLogoutBehavior postLogoutBehavior = PostLogoutBehavior.LOGGED_OUT_PAGE;
        public String postLogoutCustomURL;
        public boolean enableCodeEnvResources = true;
        public boolean requireProjectAdminPermissionToExportAndBundleProjects = false;
        public boolean enableEmailAndDisplayNameModification = false;
        public boolean hashApiKeys = true;
        public int apiKeysLifetimeDays = 0;
    }

    public static class AlationCatalogSettings {
        public boolean enabled;
        public String alationURL;
    }

    public static class WebappsSettings {
        public Integer readinessProbeTimeoutSeconds;
    }

    public static class CorsSettings {
        public Set<String> accessControlAllowOriginRegExps = new HashSet<String>();
        public Set<String> accessControlExposeHeaders = new HashSet<String>();
        public Integer accessControlMaxAge;
        public Set<String> accessControlAllowMethods = new HashSet<String>();
        public Set<String> accessControlAllowHeaders = new HashSet<String>();
        public boolean accessControlAllowCredentials;
    }

    public static abstract class AbstractCodeEnvExtraSettings {
        public List<String> condaInstallExtraOptions = new ArrayList<String>();
        public List<String> condaCreateExtraOptions = new ArrayList<String>();
        public List<String> pipInstallExtraOptions = new ArrayList<String>();
        public List<String> virtualenvCreateExtraOptions = new ArrayList<String>();
        public String cranMirrorURL = "https://cloud.r-project.org";
        public Boolean useConda = false;
    }

    public static class GovernIntegrationSettings {
        private boolean enabled;
        private String nodeUrl;
        private String nodeExternalUrl;
        private String apiKey;
        private boolean trustAllSSLCertificates;

        public NodeRef getRef() {
            boolean isNodesDirectoryEnabledAndHasGovernNode;
            PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            NodeRef nodeRef = new NodeRef(false, null, null, false);
            boolean bl = isNodesDirectoryEnabledAndHasGovernNode = nd.enabled && nd.hasGovernNode();
            if (nd.enabled && StringUtils.isNotBlank((String)nd.governNodeId) && !isNodesDirectoryEnabledAndHasGovernNode) {
                logger.warn((Object)("Nodes directory misconfigured: govern node not found in fleet, ignoring it: " + nd.governNodeId));
            }
            if (isNodesDirectoryEnabledAndHasGovernNode) {
                Optional governNodeOpt = nd.getById(nd.governNodeId);
                if (governNodeOpt.isPresent()) {
                    NodesDirectory.NodeRef governNode = (NodesDirectory.NodeRef)governNodeOpt.get();
                    nodeRef = new NodeRef(true, governNode.url, governNode.externalUrl, passwordEncryptionService.decryptIfEncrypted(governNode.adminAPIKey), true);
                } else {
                    logger.error((Object)"Should not happen: govern node of Schr\u00f6dinger");
                }
            } else if (this.enabled) {
                nodeRef = new NodeRef(true, this.nodeUrl, StringUtils.defaultIfBlank((String)this.nodeExternalUrl, (String)this.nodeUrl), passwordEncryptionService.decryptIfEncrypted(this.apiKey), this.trustAllSSLCertificates);
            }
            return nodeRef;
        }

        public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.apiKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.apiKey);
        }
    }

    public static class NodeRef {
        public final boolean enabled;
        public final String nodeUrl;
        public final String nodeExternalUrl;
        public final String apiKey;
        public final boolean trustAllSSLCertificates;

        public NodeRef(boolean enabled, String nodeUrl, String apiKey, boolean trustAllSSLCertificates) {
            this(enabled, nodeUrl, nodeUrl, apiKey, trustAllSSLCertificates);
        }

        public NodeRef(boolean enabled, String nodeUrl, String nodeExternalUrl, String apiKey, boolean trustAllSSLCertificates) {
            this.enabled = enabled;
            this.nodeUrl = nodeUrl;
            this.nodeExternalUrl = StringUtils.isNotBlank((String)nodeExternalUrl) ? nodeExternalUrl : nodeUrl;
            this.apiKey = apiKey;
            this.trustAllSSLCertificates = trustAllSSLCertificates;
        }
    }

    public static class ProjectDeployerServerSettings
    extends DeployerServerSettings {
        public boolean allowMultiNodeInfrastructures;
    }

    public static class APIDeployerServerSettings
    extends DeployerServerSettings {
    }

    public static class DeployerServerSettings {
        public List<InfraStage> stages = Lists.newArrayList((Object[])new InfraStage[]{new InfraStage("Development", "For applications development"), new InfraStage("Test", "Acceptance testing"), new InfraStage("Production", "Running live for users")});

        public boolean stageExists(String stage) {
            return this.stages.stream().anyMatch(is -> is.id.equals(stage));
        }
    }

    public static class DeployerClientSettings {
        private DeployerMode mode = DeployerMode.LOCAL;
        private String nodeUrl;
        private String apiKey;
        private boolean trustAllSSLCertificates;
        private boolean warningOnUsedPluginsOnly;

        public DeployerRef getRef() {
            PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            if (nd.enabled && StringUtils.isNotBlank((String)nd.remoteDeployerNodeId)) {
                if (Objects.equals(DKUApp.getNodeId(), nd.remoteDeployerNodeId)) {
                    return new DeployerRef(DeployerMode.LOCAL, null, null, false, false);
                }
                NodesDirectory.NodeRef nr = (NodesDirectory.NodeRef)nd.getById(nd.remoteDeployerNodeId).orElseThrow(() -> new IllegalArgumentException("Invalid deployer node " + nd.remoteDeployerNodeId));
                return new DeployerRef(DeployerMode.REMOTE, nr.url, nr.externalUrl, passwordEncryptionService.decryptIfEncrypted(nr.adminAPIKey), true, false);
            }
            return new DeployerRef(this.mode, this.nodeUrl, passwordEncryptionService.decryptIfEncrypted(this.apiKey), this.trustAllSSLCertificates, this.warningOnUsedPluginsOnly);
        }

        public void check() {
            if (this.mode == DeployerMode.DISABLED) {
                throw ErrorContext.iae((String)"Deployer is disabled");
            }
            if (this.mode == DeployerMode.REMOTE && (StringUtils.isBlank((String)this.nodeUrl) || StringUtils.isBlank((String)this.apiKey))) {
                throw ErrorContext.iae((String)"Deployer is not properly configured in the settings (URL + API key)");
            }
        }

        public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.apiKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.apiKey);
        }
    }

    public static class DeployerRef {
        public final DeployerMode mode;
        public final String nodeUrl;
        public final String nodeExternalUrl;
        public final String apiKey;
        public final boolean trustAllSSLCertificates;
        public final boolean warningOnUsedPluginsOnly;

        public DeployerRef(DeployerMode mode, String nodeUrl, String apiKey, boolean trustAllSSLCertificates, boolean warningOnUsedPluginsOnly) {
            this(mode, nodeUrl, null, apiKey, trustAllSSLCertificates, warningOnUsedPluginsOnly);
        }

        public DeployerRef(DeployerMode mode, String nodeUrl, String externalUrl, String apiKey, boolean trustAllSSLCertificates, boolean warningOnUsedPluginsOnly) {
            this.mode = mode;
            this.nodeUrl = nodeUrl;
            this.nodeExternalUrl = StringUtils.isNotBlank((String)externalUrl) ? externalUrl : nodeUrl;
            this.apiKey = apiKey;
            this.trustAllSSLCertificates = trustAllSSLCertificates;
            this.warningOnUsedPluginsOnly = warningOnUsedPluginsOnly;
        }
    }

    public static enum DeployerMode {
        DISABLED,
        LOCAL,
        REMOTE;

    }

    public static class GlobalCodeEnvsExtraSettings
    extends AbstractCodeEnvExtraSettings {
        public String defaultJuliaEnv;
        public String defaultPythonEnv;
        public String defaultREnv;
    }

    @UIModel
    public static class HomepagePromotedContent {
        public HomepageContentService.HomePromotableType type;
        @Nullable
        public String projectKey;
        @Nullable
        public String id;
        @Nullable
        public String customTitle;
        @Nullable
        public String customDescription;
        public boolean openInNewTab = false;
        public ThumbnailMode thumbnailMode = ThumbnailMode.DEFAULT;
        @Nullable
        public String customThumbnailImageId;
        @Nullable
        public String url;
    }

    public static enum ThumbnailMode {
        DEFAULT,
        UPLOAD,
        NONE;

    }

    @UIModel
    public static class HelpCenterLabeledLink {
        public String label;
        public String url;
    }

    public static class PersonalHomePagesSettings {
        public AlertBanner alertBanner;
        public Set<AnyLoc> articles = new HashSet<AnyLoc>();
        public List<HomepagePromotedContent> promotedContent = new ArrayList<HomepagePromotedContent>();
    }

    public static class AlertBanner {
        public String id;
        public String message;
        public String authorId;
    }

    public static class MetastoreCatalogsSettings {
        public MetastoreCatalogDesc synchronizeTo = MetastoreCatalogDesc.hs2();

        public static class MetastoreCatalogDesc {
            public MetastoreCatalogFlavor flavor = MetastoreCatalogFlavor.HIVESERVER2;
            public GlueCredentialsMode glueCredentialsMode = GlueCredentialsMode.DEFAULT;
            public String glueCredentialsBearingConnection;

            static MetastoreCatalogDesc hs2() {
                MetastoreCatalogDesc ret = new MetastoreCatalogDesc();
                ret.flavor = MetastoreCatalogFlavor.HIVESERVER2;
                return ret;
            }
        }

        public static enum GlueCredentialsMode {
            DEFAULT,
            FROM_CONNECTION;

        }

        public static enum MetastoreCatalogFlavor {
            HIVESERVER2,
            DSS_INTERNAL,
            AWS_GLUE;

        }
    }

    public static class InternalDBConnectionSettings {
        public DSSConnection connection;
        public String tableNamePrefix;
        public String schema;
        public long externalConnectionsMaxIdleTimeMS = 600000L;
        public long externalConnectionsValidationIntervalMS = 180000L;
        public int maxPooledExternalConnections = 50;
        public long builtinConnectionsMaxIdleTimeMS = 1800000L;
        public long builtinConnectionsValidationIntervalMS = 600000L;
        public int maxPooledBuiltinConnectionsPerDatabase = 50;
    }

    public static class GitEnforcedConfigurationRule {
        public String groupName;
        public boolean allowGit = true;
        public Set<String> remoteWhitelist = new HashSet<String>();
        public String alternateHomeDir;
        public List<SimpleKeyValue> gitConfigurationOptions = new ArrayList<SimpleKeyValue>();
        public boolean dssControlsSSHCommand = true;

        public GitEnforcedConfigurationRule withRemoteWhitelist(Set<String> whitelist) {
            this.remoteWhitelist = whitelist;
            return this;
        }

        public GitEnforcedConfigurationRule withGroup(String group) {
            this.groupName = group;
            return this;
        }
    }

    public static class GitSettings {
        public List<GitEnforcedConfigurationRule> enforcedConfigurationRules = new ArrayList<GitEnforcedConfigurationRule>();
        public String defaultBaseBranch = null;
    }

    public static class ComputeResourceUsageReportingSettings {
        public boolean periodicKubernetesUsageReporting = false;
        public boolean includeBuiltinCluster = false;
        public String namespacePattern = "^(?!kube-).*";
    }

    public static class DataikuCloudUISettings {
        public String spaceRoleARN;
        public List<String> usedSourceIPs = new ArrayList<String>();
    }

    public static class NamingRulesSettings {
        public String defaultPrefixForTables;
        public String defaultPrefixForPath;
    }

    public static class JEKSettings {
        public int numberOfReadyJEKs = 1;
        public int maxRunningJobs = 0;
    }

    public static class KubernetesPoliciesSettings {
        public List<KubernetesPolicy> policies = new ArrayList<KubernetesPolicy>();
    }

    public static class KubernetesPolicy {
        public String namespacePattern = "^(?!kube-).*";
        public boolean applyToDefaultCluster;
        public String dynamicClustersPattern = ".*";
        public List<KubernetesPolicyItem> items = new ArrayList<KubernetesPolicyItem>();
    }

    public static class KubernetesPolicyItem {
        public String yaml;
    }

    public static class GlobalTagCategory {
        public String name;
        public List<GlobalTag> globalTags = new ArrayList<GlobalTag>();
        public List<ITaggingService.TaggableType> appliesTo;
    }

    public static class GlobalTag {
        public String name;
        public String color;
    }

    public static class LocalProcessesCgroupsSettings {
        public boolean enabled;
        public CGroupsVersion cgroupsVersion = CGroupsVersion.CGROUPS_V1;
        public String cgroupsV2Controllers = "cpu,memory";
        public String hierarchiesMountPoint = "/sys/fs/cgroup";
        public ProcessTypeCGroupSettings mlKernels = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings pythonRRecipes = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings pythonRSparkRecipes = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings pythonScenarios = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings jupyterKernels = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings mlRecipes = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings pythonMacros = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings rmarkdownBuilders = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings webappDevBackends = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings eda = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings edaRecipes = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings metricsChecks = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings deploymentHooks = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings devLambdaServer = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings customPythonDataAccessComponents = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings jobExecutionKernels = new ProcessTypeCGroupSettings();
        public ProcessTypeCGroupSettings projectStandards = new ProcessTypeCGroupSettings();
        public List<CGroupSettings> cgroups = new ArrayList<CGroupSettings>();

        public static enum CGroupsVersion {
            CGROUPS_V1,
            CGROUPS_V2;

        }
    }

    public static class ProcessTypeCGroupSettings {
        public List<ProcessTypeCGroupTarget> targets = new ArrayList<ProcessTypeCGroupTarget>();
    }

    public static class ProcessTypeCGroupTarget {
        public String cgroupPathTemplate;
    }

    public static class CGroupSettings {
        public String cgroupPathTemplate;
        public List<SimpleKeyValue> limits = new ArrayList<SimpleKeyValue>();
    }

    public static enum CGrouppableProcessType {
        ML_KERNEL,
        ML_RECIPE,
        PYTHON_R_RECIPE,
        PYTHON_R_SPARK_RECIPE,
        PYTHON_SCENARIO,
        JUPYTER_KERNEL,
        WEBAPP_DEV_BACKEND,
        RMARKDOWN_BUILDER,
        PYTHON_MACRO,
        METRIC_CHECK,
        EDA,
        EDA_RECIPE,
        DEPLOYMENT_HOOK,
        LAMBDA_DEV_SERVER,
        CUSTOM_PYTHON_DATA_ACCESS_COMPONENT,
        JOB_EXECUTION_KERNEL,
        PROJECT_STANDARDS;

    }

    public static class ProjectDefaultDatasetCreationSettings
    extends AbstractDefaultDatasetCreationSettings {
        public boolean useGlobal = true;
    }

    public static class GlobalDefaultDatasetCreationSettings
    extends AbstractDefaultDatasetCreationSettings {
    }

    public static class GlobalDefaultRecipeCreationSettings {
        public PrepareRecipeColumnTypeMode prepareRecipeColumnTypeMode = PrepareRecipeColumnTypeMode.KEEP_STRONGLY_TYPED_INPUTS;

        public static enum PrepareRecipeColumnTypeMode {
            ALWAYS_INFER,
            ALWAYS_USE_INPUT_TYPES,
            KEEP_STRONGLY_TYPED_INPUTS;

        }
    }

    public static class AbstractDefaultDatasetCreationSettings {
        public String preferedConnection;
        public String forcedPreferedConnection;
        public String preferedStorageFormats = "CSV_ESCAPING_NOGZIP_FORHIVE,CSV_EXCEL_GZIP,PARQUET_HIVE";
        public boolean virtualizable;
        public String preferedUploadConnection;
        public boolean allowUploadsWithoutConnection = true;
    }

    public static class SoftHardLimit {
        public long soft = -1L;
        public long hard = -1L;
    }
}

