/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.CreateTableQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.JSON;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ExternalCatalogInternalDB
extends AbstractDSSDBService {
    private static final String DB_NAME = "external_tables";
    private static final int SCHEMA_VERSION = 1;
    private final String delete = "DELETE FROM " + this.getQuotedFullResolvedTableName("DSS_METADATA") + " WHERE " + this.quote("TABLE_KEY") + " = ?";
    private final String insert = InsertQueryBuilder.insertInto(this.resolveTable("DSS_METADATA")).addColumns(COLUMNS_DSS_METADATA).toSQL(this.getDialect());
    private static Logger logger = Logger.getLogger((String)"dku.catalog.externaltables.dao");
    public static final String TABLE_DSS_METADATA = "DSS_METADATA";
    private static final String TABLE_KEY_COLUMN = "TABLE_KEY";
    private static final String DESCRIPTION_COLUMN = "DESCRIPTION";
    private static final String TAGS_COLUMN = "TAGS";
    private static final SchemaColumn[] COLUMNS_DSS_METADATA = new SchemaColumn[]{new SchemaColumn("TABLE_KEY", Type.STRING), new SchemaColumn("DESCRIPTION", Type.STRING), new SchemaColumn("TAGS", Type.STRING)};

    public ExternalCatalogInternalDB() {
        super(ApplicationConfigurator.getFile((String[])new String[]{"data-catalog", DB_NAME}), DB_NAME, DB_NAME, 1, false);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws CodedSQLException {
        if (currentSchemaVersion == 0) {
            try (Statement st2 = conn.createStatement();){
                CreateTableQueryBuilder.createTable(this.resolveTable(TABLE_DSS_METADATA)).addColumns(COLUMNS_DSS_METADATA).execute(st2, this.getDialect());
                CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(TABLE_DSS_METADATA)).addColumns(TABLE_KEY_COLUMN).execute(st2, this.getDialect());
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access internal database", (Throwable)e);
            }
        }
    }

    public void updateDSSMetadata(DatabaseObjectKey key, ExternalTableDSSMetadata metadata) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.delete);
            ps2.setString(1, key.toKey());
            ps2.execute();
            ps2 = this.getPreparedStatement(conn, this.insert);
            ps2.setString(1, key.toKey());
            ps2.setString(2, metadata.description);
            ps2.setString(3, JSON.json(metadata.tags));
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update table data", (Throwable)e);
            throw e;
        }
    }

    public ExternalTableDSSMetadata getDSSMetadata(DatabaseObjectKey tableKey) throws SQLException {
        ExternalTableDSSMetadata ret = null;
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable(TABLE_DSS_METADATA), TABLE_DSS_METADATA);
        sqb.select("*");
        sqb.where(new ExpressionBuilder.ExpressionBuilderFactory().parameterizedColumnOperation(TABLE_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ));
        try (DSSDBConnection conn = this.acquireConnection();
             PreparedStatement statement = conn.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
            statement.setString(1, tableKey.toKey());
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    ret = new ExternalTableDSSMetadata();
                    ret.description = resultSet.getString("description");
                    ret.tags = (List)JSON.parse((String)resultSet.getString("tags"), JSON.StringList.class);
                }
            }
        }
        return ret;
    }

    public static class ExternalTableDSSMetadata {
        public String description;
        public List<String> tags = new ArrayList<String>();
    }
}

