/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.ExtensionFilter;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedDatasetsDAO
extends AbstractStandardDAO<SerializedDataset>
implements DatasetsDAO {
    @Autowired
    TransactionService transactionService;

    @Override
    protected List<SerializedDataset> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<SerializedDataset> ret = new ArrayList<SerializedDataset>();
        RelFile datasetsFolder = this.getDatasetsFolder(projectKey);
        if (!t.isDirectory(datasetsFolder)) {
            return ret;
        }
        for (RelFile f : t.listFiles(datasetsFolder, (RelFileFilter)ExtensionFilter.json())) {
            try {
                String name = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                SerializedDataset sd = this.getOrNull_noTag(projectKey, name, unsafe);
                if (sd == null) continue;
                ret.add(sd);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error in dataset file:" + String.valueOf(f)), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile datasetsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(datasetsFolder = this.getDatasetsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(datasetsFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    protected SerializedDataset getOrNull_noTag(String projectKey, String datasetName, boolean unsafe) throws IOException {
        RelFile dsFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(dsFile = this.getDAOFile(projectKey, datasetName))) {
            return null;
        }
        try {
            SerializedDataset sds = unsafe ? (SerializedDataset)t.readObjectUnsafe(dsFile, SerializedDataset.class) : (SerializedDataset)t.readObject(dsFile, SerializedDataset.class);
            sds.projectKey = projectKey;
            sds.name = datasetName;
            return sds;
        }
        catch (Exception e) {
            throw new IOException("Failed to parse dataset " + projectKey + "." + datasetName + " from file " + String.valueOf(dsFile), e);
        }
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.DATASET.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String datasetName) throws IOException {
        RelFile dsFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(dsFile = this.getDAOFile(projectKey, datasetName))) {
            throw new NotFoundException("Dataset does not exist: " + projectKey + "." + datasetName);
        }
        t.deleteFile(dsFile);
    }

    @Override
    public List<String> listUsedNames(String projectKey) throws IOException {
        RelFile datasetsFolder;
        ArrayList<String> names = new ArrayList<String>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(datasetsFolder = this.getDatasetsFolder(projectKey))) {
            return names;
        }
        for (RelFile rf : t.listFiles(datasetsFolder, (RelFileFilter)FileFilter.json())) {
            String fileName = rf.getLeafName();
            if (!StringUtils.endsWith((String)fileName, (String)".json")) {
                this.logger.error((Object)("Expected a file with .json extension, got '" + fileName + "'. Skipping."));
            }
            names.add(fileName.substring(0, fileName.length() - 5));
        }
        return names;
    }

    @Override
    public boolean datasetExistsCaseInsensitive(String projectKey, String name) throws IOException {
        List datasets = this.listUnsafe(projectKey);
        for (SerializedDataset dataset : datasets) {
            if (!dataset.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void rename(String projectKey, String oldName, String newName) throws IOException {
        SerializedDataset prev = (SerializedDataset)this.getMandatory(projectKey, oldName);
        DatasetUtils.checkName(newName);
        if (!oldName.equalsIgnoreCase(newName) && this.exists(projectKey, newName)) {
            throw ErrorContext.iae((String)("Can't rename, target dataset already exists: " + projectKey + "." + newName));
        }
        this.delete(projectKey, oldName);
        prev.name = newName;
        this.save(prev);
    }

    private RelFile getDatasetsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "datasets"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Dataset name is not specified");
        return new RelFile(this.getDatasetsFolder(projectKey), new String[]{name + ".json"});
    }
}

