/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights;

import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dashboards.insights.InsightHandler;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.insights.InsightsRegistry;
import com.dataiku.dip.dashboards.insights.staticfile.StaticFileInsightMeta;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.ui.EnrichedDashboardPage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InsightsService {
    @Autowired
    private InsightsDAO dao;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IWorkspacePermissionsService workspacePermissionsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.services.insights");

    public Insight getMandatory(String projectKey, String id) throws IOException {
        return (Insight)this.dao.getMandatory(projectKey, id);
    }

    public Insight getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (Insight)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    public Insight getOrNull(String projectKey, String id) throws IOException {
        return (Insight)this.dao.getOrNull(projectKey, id);
    }

    public Insight getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (Insight)this.dao.getOrNullUnsafe(projectKey, id);
    }

    public List<Insight> list(String projectKey) throws IOException {
        return this.dao.list(projectKey);
    }

    public List<Insight> listUnsafe(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    public List<Insight> listUnsafeVisible(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        ArrayList<Insight> result = new ArrayList<Insight>();
        for (Insight insight : this.listUnsafe(projectKey)) {
            if (!this.isVisibleToUser(insight, authCtx)) continue;
            result.add(insight);
        }
        return result;
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.dao.approximateCount(projectKey);
    }

    public String getPayload(Insight insight) throws IOException {
        return InsightsRegistry.buildHandler(insight).getPayload();
    }

    public void savePayload(Insight insight, String payload) throws IOException {
        InsightsRegistry.buildHandler(insight).savePayload(payload, this.dao);
    }

    public void save(Insight insight, boolean creation, String payload) throws IOException, UnauthorizedException, CodedException {
        TaggableObjectChangedEvent.ActionType action;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Insight existing = this.getOrNullUnsafe(insight.projectKey, insight.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(insight, existing);
        if (StringUtils.isBlank((String)insight.name)) {
            throw new IllegalArgumentException("Insight name is required");
        }
        if (creation) {
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(insight);
        }
        InsightHandler handler = InsightsRegistry.buildHandler(insight);
        handler.checkSavePermissions(t.getUser(), existing);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), this.getOrNull(insight.projectKey, insight.id), insight);
        this.dao.save(insight);
        handler.savePayload(payload, this.dao);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", insight.name);
        if (creation) {
            action = TaggableObjectChangedEvent.ActionType.INSIGHT_CREATE;
        } else if (insight.name != null && existing != null && !insight.name.equals(existing.name)) {
            action = TaggableObjectChangedEvent.ActionType.INSIGHT_RENAME;
            details.addProperty("newName", insight.name);
            details.addProperty("oldName", existing.name);
        } else {
            action = existing != null && insight.listed != existing.listed ? (insight.listed ? TaggableObjectChangedEvent.ActionType.INSIGHT_LISTED : TaggableObjectChangedEvent.ActionType.INSIGHT_UNLISTED) : TaggableObjectChangedEvent.ActionType.INSIGHT_EDIT;
        }
        this.taggingService.onObjectSaved(insight.projectKey, insight.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.INSIGHT, insight.projectKey, insight.id, t.getUser(), action).withDetails(details));
    }

    public Insight copy(String projectKey, String insightId, @Nullable String newName, @Nullable String dashboardId, @Nullable String newOwner) throws IOException, CodedException {
        Insight insight = this.getMandatory(projectKey, insightId);
        String payload = this.getPayload(insight);
        newName = StringUtils.isBlank((String)newName) ? insight.name : newName;
        Preconditions.checkArgument((insight.projectKey != null ? 1 : 0) != 0, (Object)"Original insight has no project key");
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", newName);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.INSIGHT_CREATE;
        details.addProperty("copy", Boolean.valueOf(true));
        details.addProperty("originalObjectName", insight.name);
        details.addProperty("originalObjectId", insight.id);
        AuthCtx user = TransactionContext.retrieveWrite().getUser();
        insight.id = SecretKeyGenerator.generateSmall();
        insight.creationTag = null;
        insight.listed = false;
        insight.name = newName;
        insight.creationTag = insight.versionTag = VersionTag.increment(null, user.getIdentifier());
        if (StringUtils.isNotBlank((String)newOwner)) {
            insight.owner = newOwner;
        }
        insight.dashboardCreationId = dashboardId;
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, insight);
        this.dao.save(insight);
        InsightHandler handler = InsightsRegistry.buildHandler(insight);
        handler.savePayload(payload, this.dao);
        this.taggingService.onObjectSaved(insight.projectKey, insight.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.INSIGHT, insight.projectKey, insight.id, user, action).withDetails(details));
        return insight;
    }

    public void delete(String projectKey, String id) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        try {
            Insight insight = (Insight)this.dao.getOrNull(projectKey, id);
            if (insight != null) {
                this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), insight);
                details.addProperty("objectDisplayName", insight.name);
                InsightHandler handler = InsightsRegistry.buildHandler(insight);
                handler.beforeDelete();
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to delete insight. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        this.dao.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.INSIGHT, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.INSIGHT_DELETE).withDetails(details));
    }

    public void makeListed(String projectKey, String id, boolean listed) throws IOException, UnauthorizedException, CodedException {
        Preconditions.checkArgument((projectKey != null ? 1 : 0) != 0, (Object)"No project key");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"No insight ID");
        Insight insight = this.getMandatory(projectKey, id);
        insight.listed = listed;
        this.save(insight, false, null);
    }

    public boolean isVisibleToUser(Insight insight, AuthCtx user) throws IOException, DKUSecurityException {
        return this.canInsightBeListed(insight) && this.isUserAwareOfInsight(insight, user);
    }

    public boolean isUserAwareOfInsight(Insight insight, AuthCtx user) throws IOException, DKUSecurityException {
        if (insight.listed) {
            return true;
        }
        SerializedProject project = this.projectsService.getOrNullUnsafe(insight.projectKey);
        if (this.permissionsService.hasProjectPrivilege(user, project.projectKey, project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY ? Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS : Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS)) {
            return true;
        }
        return Objects.equals(insight.owner, user.getIdentifier());
    }

    private boolean canInsightBeListed(Insight insight) {
        return !Objects.equals(insight.type, "filters") && !Objects.equals(insight.type, "scenario_run_button");
    }

    public boolean hasInsightReadPermission(AuthCtx authCtx, Insight insight) throws IOException, DKUSecurityException {
        SerializedProject project = this.projectsService.getOrNullUnsafe(insight.projectKey);
        if (!this.permissionsService.hasProjectPrivilege(authCtx, project.projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) && !this.workspacePermissionsService.isObjectReadableViaSomeWorkspace(authCtx, insight.projectKey, ITaggingService.TaggableType.INSIGHT, insight.id)) {
            return false;
        }
        InsightHandler handler = InsightsRegistry.buildHandler(insight);
        for (InsightHandler.RequiredPermission requiredPermission : handler.getRequiredPermissions()) {
            if (requiredPermission.objectRef.objectType == ITaggingService.TaggableType.PROJECT) {
                logger.info((Object)("insight.type = " + insight.type));
                assert ("project_activity".equals(insight.type) || "metrics".equals(insight.type) || "data-quality".equals(insight.type) || "runnable-button".equals(insight.type) || "static_file".equals(insight.type) || "eda".equals(insight.type));
                return this.permissionsService.hasProjectPrivilege(authCtx, requiredPermission.objectRef.objectId, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            if (this.projectsService.hasDashboardPermission(authCtx, requiredPermission.objectRef, insight.projectKey, requiredPermission.mode)) continue;
            return false;
        }
        return true;
    }

    public EnrichedDashboardPage.InsightAccessState getInsightAccessState(@Nullable Insight insight) throws IOException {
        if (insight == null) {
            return EnrichedDashboardPage.InsightAccessState.DELETED;
        }
        EnrichedDashboardPage.InsightAccessState ret = EnrichedDashboardPage.InsightAccessState.READER;
        InsightHandler handler = InsightsRegistry.buildHandler(insight);
        SerializedProject project = this.projectsService.getOrNullUnsafe(insight.projectKey);
        for (InsightHandler.RequiredPermission requiredPermission : handler.getRequiredPermissions()) {
            if (!this.projectsService.isObjectAvailableInProject(requiredPermission.objectRef, insight.projectKey)) {
                return EnrichedDashboardPage.InsightAccessState.NOT_EXPOSED;
            }
            if (project.dashboardAuthorizations.hasObjectAuthorization(requiredPermission.objectRef, requiredPermission.mode)) continue;
            ret = EnrichedDashboardPage.InsightAccessState.ANALYST;
        }
        return ret;
    }

    public List<SerializedProject.ReaderAuthorization> getMissingReaderAuthorizations(Insight insight) throws IOException {
        ArrayList<SerializedProject.ReaderAuthorization> ret = new ArrayList<SerializedProject.ReaderAuthorization>();
        SerializedProject project = this.projectsService.getMandatoryUnsafe(insight.projectKey);
        for (InsightHandler.RequiredPermission requiredPermission : InsightsRegistry.buildHandler(insight).getRequiredPermissions()) {
            if (project.dashboardAuthorizations.hasObjectAuthorization(requiredPermission.objectRef, requiredPermission.mode)) continue;
            HashSet<SerializedProject.ReaderAuthorization.Mode> modes = new HashSet<SerializedProject.ReaderAuthorization.Mode>();
            modes.add(requiredPermission.mode);
            SerializedProject.ReaderAuthorization readerAuthorization = new SerializedProject.ReaderAuthorization(requiredPermission.objectRef, modes);
            ret.add(readerAuthorization);
        }
        return ret;
    }

    public List<Insight> listForSourceUnsafe(String sourceProjectKey, ITaggingService.TaggableType sourceType, String sourceId) throws IOException {
        logger.debug((Object)("Listing all insights with source " + sourceProjectKey + " " + String.valueOf((Object)sourceType) + " " + sourceId));
        Set<String> authorizedTargetProjectKeys = this.listTargetProjectKeys(sourceProjectKey, sourceId);
        return this.listForSource(sourceProjectKey, sourceType, sourceId, authorizedTargetProjectKeys, true);
    }

    public List<Insight> listForSource(String sourceProjectKey, ITaggingService.TaggableType sourceType, String sourceId, Set<String> authorizedTargetProjectKeys, boolean unsafe) throws IOException {
        ArrayList<Insight> ret = new ArrayList<Insight>();
        for (String projectKey : authorizedTargetProjectKeys) {
            block1: for (Insight insight : unsafe ? this.listUnsafe(projectKey) : this.list(projectKey)) {
                InsightHandler handler = InsightsRegistry.buildHandler(insight);
                for (InsightHandler.RequiredPermission requiredPermission : handler.getRequiredPermissions()) {
                    if (!requiredPermission.objectRef.getProjectKey(projectKey).equals(sourceProjectKey) || !requiredPermission.objectRef.objectType.equals((Object)sourceType) || !requiredPermission.objectRef.objectId.equals(sourceId)) continue;
                    ret.add(insight);
                    continue block1;
                }
            }
        }
        return ret;
    }

    public Set<String> listTargetProjectKeys(String sourceProjectKey, String sourceId) throws IOException {
        HashSet<String> authorizedTargetProjectKeys = new HashSet<String>();
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(sourceProjectKey);
        for (ExposedObject eo : sp.exposedObjects.objects) {
            if (!sourceId.equals(eo.localName)) continue;
            for (ExposedObject.Rule rule : eo.rules) {
                if (!this.projectsService.projectExists(rule.targetProject)) continue;
                authorizedTargetProjectKeys.add(rule.targetProject);
            }
        }
        return authorizedTargetProjectKeys;
    }

    public void deleteForSource(String projectKey, ITaggingService.TaggableType type, String id) throws IOException, CodedException {
        for (Insight insight : this.listForSourceUnsafe(projectKey, type, id)) {
            this.delete(insight.projectKey, insight.id);
        }
    }

    public void setIdAndOwnerOnNewInsight(Insight insight, AuthCtx user) throws IOException {
        assert (StringUtils.isBlank((String)insight.id));
        insight.id = this.dao.generateUniqueId(insight.projectKey);
        insight.owner = user.getIdentifier();
    }

    public void setOwnerOnNewInsight(Insight insight, AuthCtx user) {
        insight.owner = user.getIdentifier();
    }

    public InputStream streamStaticContent(Insight insight) throws IOException {
        StaticFileInsightMeta.StaticFileInsightHandler sih = new StaticFileInsightMeta.StaticFileInsightHandler(insight);
        return new FileInputStream(sih.getContentFile());
    }
}

