/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.model;

import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.theming.model.DSSVisualizationTheme;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.List;

@UIModel
public class Dashboard
extends TaggableObjectsService.TaggableObject {
    public static final int DEFAULT_COLUMN_NUMBER = 36;
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public List<DashboardPage> pages = Lists.newArrayList((Object[])new DashboardPage[]{new DashboardPage()});
    public String owner;
    public boolean listed;
    public String name;
    public DSSVisualizationTheme theme;
    public boolean showGrid = false;
    public int columnNumber = 36;
    public boolean showNavigationArrows = false;
    public boolean reloadWhenEventReceived;
    public int tileSpacing = 8;
    public boolean circularNavigation = false;

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.DASHBOARD;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public static class DashboardSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        public String ownerDisplayName;
    }

    public static class DashboardListItem
    extends TaggableObjectsService.TaggableListItem {
        public String owner;
        public String ownerDisplayName;
        public boolean listed;
        public int numPages;
        public int numTiles;
        public boolean hasMissingReaderAuthorizations;

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.DASHBOARD;
        }

        public DashboardListItem(Dashboard dashboard) {
            super(dashboard);
            this.owner = dashboard.owner;
            this.listed = dashboard.listed;
            this.numPages = dashboard.pages.size();
            for (DashboardPage page : dashboard.pages) {
                this.numTiles += page.grid.tiles.size();
            }
        }
    }
}

