/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.data.geo;

import com.dataiku.dip.shaker.processors.geo.GeoDistanceProcessor;
import com.dataiku.dip.shaker.types.GeoPoint;
import org.apache.commons.math3.util.Precision;

public class GeoPointUtils {
    public static double computeDistance(GeoPoint.Coords coords1, GeoPoint.Coords coords2, GeoDistanceProcessor.DistanceUnit unit) {
        return GeoPointUtils.computeDistance(coords1.latitude, coords1.longitude, coords2.latitude, coords2.longitude, unit);
    }

    public static double computeDistance(double lat1, double long1, double lat2, double long2, GeoDistanceProcessor.DistanceUnit unit) {
        double distance = 0.0;
        distance = Math.acos(Math.sin(GeoPointUtils.deg2rad(lat1)) * Math.sin(GeoPointUtils.deg2rad(lat2)) + Math.cos(GeoPointUtils.deg2rad(lat1)) * Math.cos(GeoPointUtils.deg2rad(lat2)) * Math.cos(GeoPointUtils.deg2rad(long1 - long2)));
        if (unit == GeoDistanceProcessor.DistanceUnit.KILOMETERS) {
            distance *= 6371.0;
        } else if (unit == GeoDistanceProcessor.DistanceUnit.MILES) {
            distance *= 3958.8;
        }
        distance = Precision.round((double)distance, (int)2);
        return distance;
    }

    private static double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }
}

