/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithDatabricksCredentials;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.PineconeConnection;
import com.dataiku.dip.connections.SAPHANAConnection;
import com.dataiku.dip.connections.SQLServerConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DirectoryAwareFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSEStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CodeBasedRecipeDatasetInfoHelper {
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private TransactionService transactionService;
    private static Logger logger = Logger.getLogger((String)"dip.codebased.info.helper");

    public CodeBasedRecipeDatasetInfoHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public LocationInfo getDatasetLocationInfo_NT(AuthCtx authCtx, Dataset dataset, boolean sensitiveInfo) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        LocationInfo ret = null;
        try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);){
            if (datasetHandler.getMeta() == BuiltinFSDatasets.FS_META) {
                rootPath = ((FilesystemDatasetHandler)datasetHandler).getInformationalRootPath();
                isSingleFile = ((FilesystemDatasetHandler)datasetHandler).isSingleFile();
                ret = LocationInfo.makeInfo(LocationInfoType.FS, "path", rootPath, "isSingleFile", isSingleFile);
            } else if (datasetHandler.getMeta() == BuiltinFSDatasets.UPLOADED_FILES_META) {
                rootPath = ((UploadedFilesDatasetHandler)datasetHandler).getInformationalRootPath();
                isSingleFile = ((UploadedFilesDatasetHandler)datasetHandler).isSingleFile();
                ret = LocationInfo.makeInfo(LocationInfoType.UPLOADED, "path", rootPath, "isSingleFile", isSingleFile);
            } else if (datasetHandler.getMeta() == BuiltinFSDatasets.HDFS_META) {
                ret = CodeBasedRecipeDatasetInfoHelper.locationInfoForHDFSDataset(dataset, datasetHandler);
            } else if (datasetHandler instanceof DirectoryAwareFSDatasetHandler) {
                rootPath = ((DirectoryAwareFSDatasetHandler)datasetHandler).getInformationalRootPath();
                ret = LocationInfo.makeInfo(LocationInfoType.FS, "path", rootPath);
            } else if (datasetHandler instanceof BlobLikeDatasetHandler) {
                rootPath = ((BlobLikeDatasetHandler)datasetHandler).getInformationalRootPath();
                ret = LocationInfo.makeInfo(LocationInfoType.FS, "path", rootPath);
            } else {
                ret = datasetHandler instanceof AbstractSQLDatasetHandler ? CodeBasedRecipeDatasetInfoHelper.locationInfoForSQLDataset(dataset, datasetHandler) : new LocationInfo();
            }
        }
        if (sensitiveInfo) {
            DSSConnection conn = null;
            try (Transaction t = this.transactionService.beginRead();){
                DatasetConnectionUtils dcu = new DatasetConnectionUtils();
                List<DatasetConnectionUtils.UsedConnection> usedConnections = dcu.getUsedConnections(authCtx, dataset.serialize(), false);
                if (usedConnections.size() == 1) {
                    conn = this.connectionsDAO.getConnection(authCtx, usedConnections.get((int)0).name);
                }
            }
            if (conn != null && conn.detailsReadableBy(authCtx)) {
                JsonObject connJSON;
                if (conn instanceof ConnectionWithEncryptedFields) {
                    ((ConnectionWithEncryptedFields)((Object)conn)).decryptFields(this.cryptoService);
                }
                if ((connJSON = JSON.toJsonObject((Object)conn)).has("params")) {
                    ret.info.put("connectionParams", connJSON.get("params").getAsJsonObject());
                }
            }
        }
        return ret;
    }

    private static LocationInfo locationInfoForHDFSDataset(Dataset dataset, DatasetHandler datasetHandler) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        HDFSDatasetHandler hhandler = (HDFSDatasetHandler)datasetHandler;
        String rootPath = hhandler.getFullyQualifiedRootPath();
        boolean isSingleFile = hhandler.isSingleFile();
        SQLUtils.SQLTable hiveTableRef = DatasetInspector.syncsMetastoreTable(dataset) ? HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset) : new SQLUtils.SQLTable(null, null, dataset.getName());
        LocationInfo locationInfo = LocationInfo.makeInfo(LocationInfoType.HDFS, "path", rootPath, "isSingleFile", isSingleFile, "hiveDatabase", hiveTableRef.getSchemaNullIfBlank(), "hiveTable", hiveTableRef.getTable());
        return locationInfo;
    }

    private static LocationInfo locationInfoForSQLDataset(Dataset dataset, DatasetHandler datasetHandler) throws DKUSecurityException {
        String connectionName = ((AbstractSQLDatasetHandler)datasetHandler).getConnectionName();
        if (datasetHandler instanceof AbstractSQLTableDatasetHandler) {
            AbstractSQLTableDatasetHandler stdh = (AbstractSQLTableDatasetHandler)datasetHandler;
            SQLUtils.SQLTable table = stdh.getResolvedTable();
            return LocationInfo.makeInfo(LocationInfoType.SQL, "databaseType", dataset.getType(), "table", table.getTable(), "schema", table.getSchemaNullIfBlank(), "catalog", table.getCatalog(), "connectionName", connectionName, "quotedResolvedTableName", stdh.getDialect().getQuotedTableFullName(table));
        }
        if (datasetHandler instanceof AbstractSQLQueryDatasetHandler) {
            String query = ((AbstractSQLQueryDatasetHandler)datasetHandler).getResolvedQuery();
            return LocationInfo.makeInfo(LocationInfoType.SQL, "databaseType", dataset.getType(), "query", query, "connectionName", connectionName);
        }
        return LocationInfo.makeInfo(LocationInfoType.SQL, "databaseType", dataset.getType(), "connectionName", connectionName);
    }

    public static LocationInfo getManagedFolderLocationInfo_NT(AuthCtx authCtx, ManagedFolder folder, boolean sensitiveInfo) throws IOException, DKUSecurityException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        LocationInfo ret = LocationInfo.makeInfo(LocationInfoType.MANAGEDFOLDER, "projectKey", folder.projectKey, "id", folder.id, "name", folder.name);
        ret.info.put("directoryBasedPartitioning", FilePartitioner.isSchemeRepresentableAsFolder(folder.getPartitioningSchema()));
        try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(authCtx);){
            ret.info.put("type", folder.type);
            Map<String, String> accessInfo = handler.getAccessInfo(sensitiveInfo);
            if (accessInfo.containsKey("path")) {
                ret.info.put("path", accessInfo.get("path"));
                accessInfo.remove("path");
            }
            ret.info.put("accessInfo", accessInfo);
        }
        return ret;
    }

    public LocationInfo getStreamingEndpointLocationInfo_NT(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, boolean sensitiveInfo) throws IOException, DKUSecurityException, SQLException {
        TransactionContext.assertNoAttachedTransaction();
        LocationInfo ret = LocationInfo.makeInfo(LocationInfoType.STREAMINGENDPOINT, "projectKey", streamingEndpoint.projectKey, "id", streamingEndpoint.id, "type", streamingEndpoint.type);
        if ("kafka".equals(streamingEndpoint.getType())) {
            KafkaStreamingEndpointParams params = StreamingEndpointsRegistry.getMeta(streamingEndpoint).getExpandedParams(streamingEndpoint.projectKey, streamingEndpoint, KafkaStreamingEndpointParams.class);
            ret.info.put("connection", params.connection);
            ret.info.put("topic", params.topic);
            ret.info.put("consumerParams", params.consumerParams);
            if (sensitiveInfo && StringUtils.isNotBlank((String)params.connection)) {
                ConnectionLocationInfo connectionInfo = this.getConnectionInfo_NT(authCtx, params.connection, null);
                ret.info.put("connectionParams", connectionInfo.params);
            }
        } else if ("httpsse".equals(streamingEndpoint.getType())) {
            HTTPSSEStreamingEndpointParams params = StreamingEndpointsRegistry.getMeta(streamingEndpoint).getExpandedParams(streamingEndpoint.projectKey, streamingEndpoint, HTTPSSEStreamingEndpointParams.class);
            ret.info.put("url", params.url);
        } else if ("sqs".equals(streamingEndpoint.getType())) {
            SQSStreamingEndpointParams params = StreamingEndpointsRegistry.getMeta(streamingEndpoint).getExpandedParams(streamingEndpoint.projectKey, streamingEndpoint, SQSStreamingEndpointParams.class);
            ret.info.put("connection", params.connection);
            ret.info.put("queue", params.queueName);
            if (sensitiveInfo && StringUtils.isNotBlank((String)params.connection)) {
                ConnectionLocationInfo connectionInfo = this.getConnectionInfo_NT(authCtx, params.connection, null);
                ret.info.put("connectionParams", connectionInfo.params);
                ret.info.put("connectionCredentials", connectionInfo.resolvedAWSCredential);
            }
        } else {
            logger.warn((Object)("Unhandled endpoint type " + streamingEndpoint.getType() + ", not adding details"));
        }
        return ret;
    }

    public static LocationInfo getModelEvaluationStoreLocationInfo_NT(ModelEvaluationStore mes, boolean sensitiveInfo) {
        TransactionContext.assertNoAttachedTransaction();
        LocationInfo ret = LocationInfo.makeInfo(LocationInfoType.MODELEVALUATIONSTORE, "projectKey", mes.projectKey, "id", mes.id);
        if (sensitiveInfo) {
            ret.info.put("path", MECPaths.modelEvaluationStoreBaseFolder(mes).getAbsolutePath());
        }
        return ret;
    }

    public ConnectionLocationInfo getConnectionInfo_NT(AuthCtx authCtx, String connectionName, @Nullable String projectKey) throws IOException, DKUSecurityException, SQLException {
        DSSConnection conn;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            conn = this.connectionsDAO.getConnection(authCtx, connectionName);
        }
        if (conn == null) {
            throw new UnauthorizedException("Connection does not exist or you do not have permission to view its details", "connection-info-denied");
        }
        return this.getConnectionInfo_NT(authCtx, conn, projectKey);
    }

    public ConnectionLocationInfo getConnectionInfo_NT(AuthCtx authCtx, DSSConnection conn, @Nullable String projectKey) throws IOException, DKUSecurityException, SQLException {
        TransactionContext.assertNoAttachedTransaction();
        boolean usable = conn.isFreelyUsableBy(authCtx);
        boolean detailsReadable = conn.detailsReadableBy(authCtx);
        if (!usable && !detailsReadable) {
            throw new UnauthorizedException("Connection does not exist or you do not have permission to view its details", "connection-info-denied");
        }
        ConnectionLocationInfo ret = new ConnectionLocationInfo();
        ret.type = conn.type;
        ret.proxySettingsAsString = conn.getProxySettings().getAsString();
        if (detailsReadable) {
            JsonObject connJSON;
            if (conn instanceof ConnectionWithEncryptedFields) {
                ((ConnectionWithEncryptedFields)((Object)conn)).decryptFields(this.cryptoService);
            }
            ret.params = (connJSON = JSON.toJsonObject((Object)conn)).get("params") == null ? null : connJSON.get("params").getAsJsonObject();
            ret.credentialsMode = conn.credentialsMode;
            if (conn instanceof ConnectionWithBasicCredential && ((ConnectionWithBasicCredential)((Object)conn)).actuallyHasBasicCredential()) {
                creds = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredentialConvertible.class);
                ret.resolvedBasicCredential = creds != null ? creds.toBasicCredential() : null;
            } else if (conn instanceof ConnectionWithGoogleAuthCredentials && ((ConnectionWithPerUserOAuth2Credentials)((Object)conn)).actuallyHasPerUserOAuth2Credential()) {
                ret.resolvedOAuth2Credential = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class).toOAuth2Credential();
            } else if (conn instanceof ConnectionWithAzureAuthCredentials && ((ConnectionWithPerUserOAuth2Credentials)((Object)conn)).actuallyHasPerUserOAuth2Credential()) {
                ret.resolvedOAuth2Credential = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class).toOAuth2Credential();
            } else if (conn instanceof SQLServerConnection && ((ConnectionWithPerUserOAuth2Credentials)((Object)conn)).actuallyHasPerUserOAuth2Credential()) {
                ret.resolvedOAuth2Credential = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SQLServerConnection.SerializableSQLServerCredentials.class).toOAuth2Credential();
            } else if (conn instanceof SnowflakeConnection && ((ConnectionWithPerUserOAuth2Credentials)((Object)conn)).actuallyHasPerUserOAuth2Credential()) {
                ret.resolvedOAuth2Credential = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SnowflakeConnection.SerializableSnowflakeCredentials.class).toOAuth2Credential();
            } else if (conn instanceof SAPHANAConnection && ((ConnectionWithPerUserOAuth2Credentials)((Object)conn)).actuallyHasPerUserOAuth2Credential()) {
                creds = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
                ret.resolvedOAuth2Credential = new ICredentialsService.OAuth2Credential(((ICredentialsService.BasicCredential)creds).password);
            } else if (conn instanceof ConnectionWithDatabricksCredentials && ((ConnectionWithDatabricksCredentials)((Object)conn)).getNonResolvedParams().getAuthType() == ConnectionWithDatabricksCredentials.AuthType.OAUTH2_APP) {
                ret.resolvedOAuth2Credential = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class).toOAuth2Credential();
            } else if (conn instanceof ConnectionWithPerUserOAuth2Credentials && ((ConnectionWithPerUserOAuth2Credentials)((Object)conn)).actuallyHasPerUserOAuth2Credential()) {
                ret.resolvedOAuth2Credential = ((ConnectionWithPerUserOAuth2Credentials)((Object)conn)).getResolvedOAuth2Credential(authCtx);
            } else if (conn instanceof ConnectionWithAzureAuthCredentials && ((ConnectionWithAzureAuthCredentials)((Object)conn)).getAzureAuth2NonResolvedParams().getAuthType() == ConnectionWithAzureAuthCredentials.AuthType.OAUTH2_APP) {
                ret.resolvedOAuth2Credential = ((ConnectionWithAzureAuthCredentials)((Object)conn)).getResolvedOAuth2Credential(authCtx);
            } else if (conn instanceof ConnectionWithAWSAuthCredentials && ((ConnectionWithAWSAuthCredentials)((Object)conn)).actuallyHasAWSAuthCredentials()) {
                ret.resolvedAWSCredential = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            } else if (conn instanceof PineconeConnection) {
                creds = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
                ret.resolvedAPIKey = ((ICredentialsService.BasicCredential)creds).password;
            }
            if (conn instanceof SnowflakeConnection) {
                SnowflakeConnection snowflakeConnection = (SnowflakeConnection)conn;
                ret.resolvedParams = snowflakeConnection.getResolvedParams(authCtx, projectKey);
                if (snowflakeConnection.params.authType == SnowflakeConnection.AuthType.OAUTH2_APP && snowflakeConnection.credentialsMode == DSSConnection.CredentialsMode.GLOBAL) {
                    ret.resolvedOAuth2Credential = snowflakeConnection.getResolvedOAuth2Credential(authCtx);
                }
            }
            if (conn instanceof DatabricksConnection) {
                ret.resolvedParams = ((DatabricksConnection)conn).getResolvedParams(authCtx, projectKey);
            }
            if (conn instanceof ConnectionWithGoogleAuthCredentials) {
                ConnectionWithGoogleAuthCredentials.IGoogleAuth2Params resolvedParams = ((ConnectionWithGoogleAuthCredentials)((Object)conn)).getGoogleAuth2ResolvedPrivateKeyParams();
                ret.resolvedParams = JSON.toJsonObject((Object)resolvedParams);
            }
        }
        return ret;
    }

    public static DatasetFilesInfo getDatasetFilesInfo(AuthCtx authCtx, Dataset dataset, List<String> partitions) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        DatasetFilesInfo ret = new DatasetFilesInfo();
        try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);){
            if (datasetHandler instanceof AbstractFSDatasetHandler) {
                ret.globalPaths = ((AbstractFSDatasetHandler)datasetHandler).enumerateFilesystem();
                FilePartitioner partitioner = new FilePartitioner(dataset.getPartitioningSchema());
                for (FilePartition partition : partitioner.getPartitionsFromFiles(ret.globalPaths)) {
                    String id = partition.id();
                    if (!partitions.contains(id) && partitions.size() != 0) continue;
                    ret.pathsByPartition.put(id, partition.getAllPaths());
                }
            }
            DatasetFilesInfo datasetFilesInfo = ret;
            return datasetFilesInfo;
        }
    }

    public static enum LocationInfoType {
        FS,
        HDFS,
        UPLOADED,
        SQL,
        MANAGEDFOLDER,
        SAVEDMODEL,
        STREAMINGENDPOINT,
        MODELEVALUATIONSTORE;

    }

    public static class LocationInfo {
        public LocationInfoType locationInfoType;
        public Map<String, Object> info = Maps.newHashMap();

        public static LocationInfo makeInfo(LocationInfoType type, Object ... args) {
            LocationInfo info = new LocationInfo();
            info.locationInfoType = type;
            info.info = Maps.newHashMap();
            for (int i = 0; i < args.length; i += 2) {
                if (args[i + 1] == null) continue;
                info.info.put(args[i].toString(), args[i + 1]);
            }
            return info;
        }

        public static LocationInfo makeInfoFromFSPath(LocationInfoType type, FSPathOrDirectory path, Object ... args) {
            LocationInfo info = new LocationInfo();
            info.locationInfoType = type;
            info.info = Maps.newHashMap();
            info.info.put("exists", path != null);
            if (path != null) {
                info.info.put("path", path.path());
                info.info.put("size", path.getSize());
                info.info.put("lastModified", path.getLastModified());
                info.info.put("isDirectory", path.isDirectory);
            }
            for (int i = 0; i < args.length; i += 2) {
                if (args[i + 1] == null) continue;
                info.info.put(args[i].toString(), args[i + 1]);
            }
            return info;
        }
    }

    public static class ConnectionLocationInfo {
        public String name;
        public String type;
        public JsonObject params;
        public ICredentialsService.BasicCredential resolvedBasicCredential;
        public ConnectionWithAWSAuthCredentials.SerializableAWSCredential resolvedAWSCredential;
        public JsonObject resolvedParams;
        public ICredentialsService.OAuth2Credential resolvedOAuth2Credential;
        public String resolvedAPIKey;
        public DSSConnection.CredentialsMode credentialsMode;
        @Nonnull
        public String proxySettingsAsString;
    }

    public static class DatasetFilesInfo {
        public Map<String, List<FSPath>> pathsByPartition = new HashMap<String, List<FSPath>>();
        public List<FSPath> globalPaths = new ArrayList<FSPath>();
    }
}

