/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeHelper;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class AutoFeatureGenerationRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    public static final int OUTPUT_COLUMNS_SIZE_WARN_LIMIT = 1000;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.autofeaturegeneration.status");

    public AutoFeatureGenerationRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        AutoFeatureGenerationRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
        }
        return status;
    }

    public void validateOutputSchema(AutoFeatureGenerationRecipeStatus status, String payload, JobActivity activity, AuthCtx authCtx) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            status.initOutputSchema(authCtx, activity, payload);
        }
    }

    @Override
    public AutoFeatureGenerationRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        AutoFeatureGenerationRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
        }
        if (status.isInvalid()) {
            if (!status.output.anyFatal()) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipe steps did not validate");
            }
            return status;
        }
        if (status.selectedEngine == null) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No available engine can run this recipe");
            return status;
        }
        try {
            this.validateOutputSchema(status, this.payload, init.activity, authCtx);
            int outputColumnsSizeWarnLimit = ApplicationConfigurator.getParams().getIntParam("dku.recipes.autoFeatureGeneration.outputColumnsSizeWarningLimit", Integer.valueOf(1000));
            if (status.outputSchema.getColumns().size() > outputColumnsSizeWarnLimit) {
                status.output.withWarning(RecipeCodes.WARN_RECIPE_GENERATE_FEATURES_MANY_COLUMNS, String.format("This recipe will generate an output dataset with over %d columns, which may trigger memory or database limit errors. To reduce the number of generated columns, you can remove some input datasets, select fewer columns for computation, or select fewer feature transformations.", outputColumnsSizeWarnLimit));
            }
            if (init.error != null) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, init.error);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipe steps did not validate");
        }
        return status;
    }

    boolean checkInputDatasets(AutoFeatureGenerationRecipeStatus status, Map<String, Dataset> datasetMap, AutoFeatureGenerationRecipePayloadParams params) {
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            AutoFeatureGenerationRecipePayloadParams.InputDesc inputDataset = (AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get(i);
            Dataset dataset = datasetMap.get(inputDataset.name);
            if (dataset == null) {
                status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "Cannot retrieve dataset " + inputDataset.name);
                continue;
            }
            Schema schema = dataset.getSchema();
            if (schema == null) {
                status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "Cannot retrieve schema from dataset " + inputDataset.name);
                continue;
            }
            if (inputDataset.timeIndexColumn == null || inputDataset.timeIndexColumn.isEmpty()) continue;
            SchemaColumn schemaColumn = schema.getColumn(inputDataset.timeIndexColumn);
            String timeIndexLabel = AutoFeatureGenerationRecipeHelper.getTimeIndexLabel(i);
            if (schemaColumn == null) {
                status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "The " + timeIndexLabel + " '" + inputDataset.timeIndexColumn + "' does not belong to the dataset '" + inputDataset.name + "'");
                continue;
            }
            if (schemaColumn.getType().isTemporal()) continue;
            status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "The " + timeIndexLabel + " '" + inputDataset.timeIndexColumn + "' is not of type datetime with tz, date only or datetime no tz, but '" + schemaColumn.getTypeString() + "'");
        }
        return !status.dataRelationships.anyFatal();
    }

    public boolean checkIOCharacteristics(AutoFeatureGenerationRecipeStatus status, Map<String, Dataset> datasetMap, JobActivity activity) throws IOException {
        AutoFeatureGenerationRecipePayloadParams params = status.params;
        Dataset outputDataset = this.visualRecipesService.getOutputDataset(activity);
        String outputDatasetName = null;
        boolean isSparkSelectable = AutoFeatureGenerationRecipeStatusComputer.isSparkSelectable(status);
        if (outputDataset != null) {
            outputDatasetName = outputDataset.getFullName();
            this.runIOChecks(status.output, outputDataset, outputDatasetName, true, isSparkSelectable);
        }
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            AutoFeatureGenerationRecipePayloadParams.InputDesc inputDataset = (AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get(i);
            Dataset dataset = datasetMap.get(inputDataset.name);
            this.runIOChecks(status.dataRelationships, dataset, outputDatasetName, false, isSparkSelectable);
        }
        return !status.dataRelationships.anyFatal() && !status.output.anyFatal();
    }

    private void runIOChecks(RecipeStatus.StepStatus stepStatus, Dataset dataset, String outputDatasetName, boolean isOutputDataset, boolean isSparkSelectable) {
        RecipeCodes errorCode = isOutputDataset ? RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_OUTPUT_PARAMS : RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS;
        if (dataset != null && dataset.getSchema() != null) {
            if (!isSparkSelectable && !DatasetInspector.isSQL(dataset)) {
                stepStatus.withFatal(errorCode, "The dataset '" + dataset.getName() + "' is not an SQL dataset");
            }
            if (dataset.getModel() != null && dataset.getModel().isPartitioned()) {
                stepStatus.withFatal(errorCode, "The dataset '" + dataset.getName() + "' is partitioned");
            }
            if (!isOutputDataset && outputDatasetName != null && Objects.equals(dataset.getFullName(), outputDatasetName)) {
                stepStatus.withFatal(errorCode, "The dataset '" + dataset.getName() + "' is the same as the output dataset");
            }
        }
    }

    public boolean checkJoinKeys(AutoFeatureGenerationRecipeStatus status, Map<String, Dataset> datasetMap, AutoFeatureGenerationRecipePayloadParams params) {
        for (AutoFeatureGenerationRecipePayloadParams.RelationshipDesc relationshipDesc : params.relationships) {
            AutoFeatureGenerationRecipePayloadParams.InputDesc input1 = (AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get(relationshipDesc.table1);
            AutoFeatureGenerationRecipePayloadParams.InputDesc input2 = (AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get(relationshipDesc.table2);
            Dataset dataset1 = datasetMap.get(input1.name);
            Dataset dataset2 = datasetMap.get(input2.name);
            for (JoinRecipePayloadParams.MatchingCondition condition : relationshipDesc.on) {
                Type type2;
                Type type1;
                SchemaColumn schemaColumn;
                if (dataset1 != null && dataset1.getSchema() != null && (schemaColumn = dataset1.getSchema().getColumn(condition.column1.name)) == null) {
                    status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "The relationship column '" + condition.column1.name + "' does not belong to the dataset '" + input1.name + "'");
                }
                if (dataset2 != null && dataset2.getSchema() != null && (schemaColumn = dataset2.getSchema().getColumn(condition.column2.name)) == null) {
                    status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "The relationship column '" + condition.column2.name + "' does not belong to the dataset '" + input2.name + "'");
                }
                if (dataset1 == null || dataset1.getSchema() == null || dataset2 == null || dataset2.getSchema() == null) continue;
                SchemaColumn sc1 = dataset1.getSchema().getColumn(condition.column1.name);
                SchemaColumn sc2 = dataset2.getSchema().getColumn(condition.column2.name);
                if (sc1 == null || sc2 == null || !JoinRecipePayloadParams.incompatibleTypesForJoinCondition(type1 = sc1.getType(), type2 = sc2.getType())) continue;
                status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "Cannot join columns '" + condition.column1.name + "' (" + String.valueOf(type1) + ") and '" + condition.column2.name + "' (" + String.valueOf(type2) + "). Fix the input dataset types.");
            }
        }
        return !status.dataRelationships.anyFatal();
    }

    public boolean checkRelationships(AutoFeatureGenerationRecipeStatus status, Map<String, Dataset> datasetMap) {
        AutoFeatureGenerationRecipePayloadParams params = status.params;
        boolean checkInputDatasets = this.checkInputDatasets(status, datasetMap, params);
        boolean checkJoinKeys = this.checkJoinKeys(status, datasetMap, params);
        return checkInputDatasets && checkJoinKeys;
    }

    private boolean isValidColumn(AutoFeatureGenerationRecipePayloadParams.Column column) {
        return column != null && !StringUtils.isBlank((String)column.name) && column.variableType != null;
    }

    public static boolean checkVariableTypeMatchesStorageType(AutoFeatureGenerationRecipePayloadParams.Column column, SchemaColumn schemaColumn) {
        Type storageType = schemaColumn.getType();
        switch (column.variableType) {
            case NUMERIC: {
                return Arrays.asList(Type.INT, Type.DOUBLE, Type.FLOAT, Type.BIGINT, Type.SMALLINT, Type.TINYINT).contains(storageType);
            }
            case CATEGORY: {
                return Arrays.asList(Type.INT, Type.DOUBLE, Type.FLOAT, Type.BIGINT, Type.STRING, Type.BOOLEAN, Type.DATE, Type.DATEONLY, Type.DATETIMENOTZ, Type.GEOPOINT, Type.GEOMETRY, Type.ARRAY, Type.MAP, Type.OBJECT).contains(storageType);
            }
            case TEXT: {
                return storageType == Type.STRING;
            }
            case DATE: {
                return Arrays.asList(Type.DATE, Type.DATEONLY, Type.DATETIMENOTZ).contains(storageType);
            }
        }
        return false;
    }

    public boolean checkSelectedColumns(AutoFeatureGenerationRecipeStatus status, Map<String, Dataset> datasetMap) {
        AutoFeatureGenerationRecipePayloadParams params = status.params;
        boolean anyColumnsSelected = false;
        for (AutoFeatureGenerationRecipePayloadParams.InputDesc inputDataset : params.virtualInputs) {
            Schema schema;
            Dataset dataset = datasetMap.get(inputDataset.name);
            if (dataset == null || (schema = dataset.getSchema()) == null) continue;
            for (AutoFeatureGenerationRecipePayloadParams.Column selectedColumn : inputDataset.getSelectedColumns()) {
                anyColumnsSelected = true;
                if (selectedColumn == null) {
                    status.columnsForComputation.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_SELECTED_COLUMNS_PARAMS, "There is an empty column in the selected columns");
                    continue;
                }
                if (!this.isValidColumn(selectedColumn)) {
                    status.columnsForComputation.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_SELECTED_COLUMNS_PARAMS, "The column '" + selectedColumn.name + "' is invalid '");
                    continue;
                }
                if (schema.getColumn(selectedColumn.name) == null) {
                    status.columnsForComputation.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_SELECTED_COLUMNS_PARAMS, "The column '" + selectedColumn.name + "' does not belong to the dataset '" + inputDataset.name + "'");
                    continue;
                }
                if (AutoFeatureGenerationRecipeStatusComputer.checkVariableTypeMatchesStorageType(selectedColumn, schema.getColumn(selectedColumn.name))) continue;
                status.columnsForComputation.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_SELECTED_COLUMNS_PARAMS, "The column '" + selectedColumn.name + "' has a type '" + selectedColumn.variableType.toString() + "' that does not match the storage type '" + schema.getColumn(selectedColumn.name).getTypeString() + "'");
            }
        }
        if (!anyColumnsSelected) {
            status.columnsForComputation.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_SELECTED_COLUMNS_PARAMS, "There are no columns selected for computation");
        }
        return !status.columnsForComputation.anyFatal();
    }

    @Override
    public AutoFeatureGenerationRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), authCtx);
    }

    private static boolean isSparkSelectable(AutoFeatureGenerationRecipeStatus status) {
        return status.engines.stream().anyMatch(engine -> Objects.equals(engine.type, "SPARK") && engine.isSelectable);
    }

    private AutoFeatureGenerationRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, AuthCtx authCtx) {
        AutoFeatureGenerationRecipeStatus status = new AutoFeatureGenerationRecipeStatus();
        try {
            this.performBasicStructureChecks(status, authCtx);
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            init.helper = new AutoFeatureGenerationRecipeHelper();
            status.params = AutoFeatureGenerationRecipeHelper.loadParams(this.payload, this.recipe);
            status.engineParams = status.params.engineParams;
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
            init.sources = new ArrayList<Dataset>();
            for (FlowDataset fd : init.activity.getSubgraph().getSourceDatasets()) {
                init.sources.add(fd.getMandatoryUnsafe(this.datasetsDAO));
            }
            status.engines = this.getEnginesStatus(authCtx, init.activity);
            RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, status.params.enginesPreferences);
            this.visualRecipesService.selectEngine(authCtx, init.activity, status.params.engineType, status, this.recipe.type, repc, false);
            if (status.selectedEngine == null) {
                status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, "Could not select an engine that fits the input datasets. Enable Spark or use SQL tables as input datasets.");
                return status;
            }
            this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Generation of aggregates in database, then streaming of results");
            init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedEngineBase());
            try {
                status.params.validate();
            }
            catch (Exception e) {
                logger.error((Object)"Invalid relationships params", (Throwable)e);
                status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_GENERATE_FEATURES_INVALID_RELATIONSHIP_PARAMS, ExceptionUtils.getMessageWithCauses((Throwable)e));
                return status;
            }
            init.helper.initInputDatasets(init.activity, status.params, init.dialect);
            boolean checkRelationships = this.checkRelationships(status, init.helper.datasetsMap);
            boolean checkSelectedColumns = this.checkSelectedColumns(status, init.helper.datasetsMap);
            boolean checkIOCharacteristics = this.checkIOCharacteristics(status, init.helper.datasetsMap, init.activity);
            if (!(checkRelationships && checkSelectedColumns && checkIOCharacteristics)) {
                return status;
            }
            try {
                AutoFeatureGenerationRecipeHelper.SqlQueryCollection sqlQueryCollection = init.helper.generateSqlQueries(authCtx, init.activity, init.dialect, status.params);
                status.sql = sqlQueryCollection.combineQueries();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to generate SQL query", (Throwable)e);
                init.error = e.getMessage();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.dataRelationships.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return status;
    }

    private List<RecipeEngineStatus> getEnginesStatus(AuthCtx authCtx, JobActivity activity) throws Exception {
        ArrayList<RecipeEngineStatus> ret = new ArrayList<RecipeEngineStatus>();
        VisualSQLRecipesBaseService.AppConfig appConfig = this.visualRecipesService.getAppConfig(authCtx, this.recipe.projectKey);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus sql = this.visualRecipesService.makeSQLEngineStatus(authCtx, activity);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus spark = this.visualRecipesService.makeSparkSQLEngineStatus(authCtx, this.recipe.projectKey);
        ret.add(sql);
        ret.add(spark);
        return ret;
    }

    private static class StatusInitializer {
        AutoFeatureGenerationRecipeHelper helper;
        List<Dataset> sources;
        SQLDialect dialect;
        public JobActivity activity;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class AutoFeatureGenerationRecipeStatus
    extends VisualSQLRecipeStatus {
        AutoFeatureGenerationRecipePayloadParams params;
        RecipeStatus.StepStatus dataRelationships = new RecipeStatus.StepStatus();
        RecipeStatus.StepStatus columnsForComputation = new RecipeStatus.StepStatus();
        RecipeStatus.StepStatus featureTransformations = new RecipeStatus.StepStatus();

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            ret.mergeFrom((InfoMessage.InfoMessages)this.dataRelationships);
            ret.mergeFrom((InfoMessage.InfoMessages)this.columnsForComputation);
            ret.mergeFrom((InfoMessage.InfoMessages)this.featureTransformations);
            return ret;
        }

        public void setOutputSchema(Schema schema) {
            this.outputSchema = schema;
        }

        public void initOutputSchema(AuthCtx authCtx, JobActivity activity, String payload) throws Exception {
            AutoFeatureGenerationRecipeSchemaComputer schemaComputer = new AutoFeatureGenerationRecipeSchemaComputer(authCtx, activity);
            schemaComputer.setPayload(payload);
            this.setOutputSchema(schemaComputer.getSchema());
        }
    }
}

