/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.dataflow.exec.split.AbstractSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.shaker.types.Boolean;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ColumnBasedSplitProcessorOutput
extends AbstractSplitProcessorOutput {
    private final List<FilteredOutput> outputs = new ArrayList<FilteredOutput>();
    private ProcessorOutput defaultOutput;
    private final Column col;
    private static Logger logger = Logger.getLogger((String)"dku.split.columnbased");

    public ColumnBasedSplitProcessorOutput(Column col, SplitRecipePayloadParams params) {
        this.col = col;
        this.params = params;
    }

    public void addOutput(String value, boolean caseSentitive, ProcessorOutput output) {
        if (value == null) {
            logger.warn((Object)"added a value split with null value");
            return;
        }
        this.outputs.add(new FilteredOutput(this.col, value, caseSentitive, output));
    }

    public void addBooleanOutput(String value, boolean caseSentitive, ProcessorOutput output) {
        if (value == null) {
            logger.warn((Object)"added a value split with null value");
            return;
        }
        this.outputs.add(new FilteredBooleanOutput(this.col, value, caseSentitive, output));
    }

    public void addFloatingPointOutput(String value, boolean caseSentitive, ProcessorOutput output) {
        if (value == null) {
            logger.warn((Object)"added a value split with null value");
            return;
        }
        this.outputs.add(new FilteredNumericalOutput(this.col, value, caseSentitive, output));
    }

    @Override
    public void setDefaultOutput(ProcessorOutput output) {
        this.defaultOutput = output;
    }

    public void emitRow(Row row) throws Exception {
        this.enrichRowWithComputedColumns(row);
        for (FilteredOutput fo : this.outputs) {
            if (!fo.matches(this.rowCopy)) continue;
            if (fo.output != null) {
                fo.output.emitRow(row);
            }
            return;
        }
        if (this.defaultOutput != null) {
            this.defaultOutput.emitRow(row);
        }
    }

    @Override
    public void lastRowEmitted() throws Exception {
    }

    public void cancel() throws Exception {
        for (FilteredOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.cancel();
        }
        if (this.defaultOutput != null) {
            this.defaultOutput.cancel();
        }
    }

    public void setMaxMemoryUsed(long size) {
        for (FilteredOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.setMaxMemoryUsed(size);
        }
        if (this.defaultOutput != null) {
            this.defaultOutput.setMaxMemoryUsed(size);
        }
    }

    private static class FilteredOutput {
        public String value;
        public ProcessorOutput output;
        public Column col;
        public boolean caseSensitive;

        public FilteredOutput(Column c2, String v, boolean cs2, ProcessorOutput o) {
            this.col = c2;
            this.value = v;
            this.caseSensitive = cs2;
            this.output = o;
        }

        public boolean matches(Row row) {
            String v = row.get(this.col);
            if (StringUtils.isBlank((String)this.value)) {
                return StringUtils.isBlank((String)v);
            }
            if (this.caseSensitive) {
                return this.value.equals(v);
            }
            return this.value.equalsIgnoreCase(v);
        }
    }

    private static class FilteredBooleanOutput
    extends FilteredOutput {
        private final Boolean booleanMeaning = new Boolean();
        private final java.lang.Boolean booleanValue;

        public FilteredBooleanOutput(Column c2, String v, boolean cs2, ProcessorOutput o) {
            super(c2, v, cs2, o);
            this.booleanValue = this.booleanMeaning.parseNoFail(v);
        }

        @Override
        public boolean matches(Row row) {
            String v = row.get(this.col);
            return this.booleanMeaning.parseNoFail(v) == this.booleanValue;
        }
    }

    private static class FilteredNumericalOutput
    extends FilteredOutput {
        private final Double numericalValue;

        public FilteredNumericalOutput(Column c2, String v, boolean cs2, ProcessorOutput o) {
            super(c2, v, cs2, o);
            this.numericalValue = DKUDoubles.tryParse((String)v);
        }

        @Override
        public boolean matches(Row row) {
            String v = row.get(this.col);
            return this.numericalValue.equals(DKUDoubles.tryParse((String)v));
        }
    }
}

