/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.PostgreSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLScriptRecipeRunner
implements FlowRunnable,
RecipeRunner,
AbortableRecipeRunner {
    @Autowired
    private RecipesDAO dao;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private DatasetWritingService datasetWritingService;
    @Autowired
    private ICredentialsService credentialsService;
    private JobActivity activity;
    private RecipeRunnableSubgraph subgraph;
    private FlowRecipe recipe;
    private String sqlScript;
    private String mainConnection;
    private boolean abortNotified;
    private Statement currentStatement;
    private boolean runTerminated;
    private DKUtils.ExecKiller runningProcessKiller;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.flow.sql");

    public SQLScriptRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
    }

    public String getSQL(SQLDialect dialect) throws IOException {
        return this.dao.getPayloadOrNull(this.recipe.getProjectKey(), this.recipe.getName());
    }

    @Override
    public synchronized void init() throws Exception {
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        logger.info((Object)"Initialize SQL runner");
        if (this.subgraph.getSources().size() == 0 && this.subgraph.getTargets().size() == 0) {
            throw ErrorContext.iae((String)"SQL recipe needs at least one input or one output.");
        }
        this.activity.runSummary.engineType = "SQL";
        SQLQueryRecipeUtils.SQLConnections sourceConnections = SQLQueryRecipeUtils.getSourceConnections(this.authCtxService.getAuthCtx(), this.subgraph, this.datasetsDAO);
        List<Dataset> targetDatasets = SQLQueryRecipeUtils.getTargetDatasets(this.subgraph);
        for (Dataset targetDataset : targetDatasets) {
            if (DatasetInspector.isSQLTable(targetDataset)) continue;
            throw ErrorContext.iae((String)String.format("Output dataset %s is not a SQL table", targetDataset.getName()));
        }
        SQLQueryRecipeUtils.SQLConnections targetConnections = SQLQueryRecipeUtils.getConnectionsFromSqlTableDatasets(targetDatasets);
        HashSet allConnections = Sets.newHashSet();
        allConnections.addAll(sourceConnections.connections);
        allConnections.addAll(targetConnections.connections);
        SQLScriptRecipeMeta.SQLScriptRecipeParams params = RecipeRegistry.getParamsAs(this.activity, SQLScriptRecipeMeta.SQLScriptRecipeParams.class);
        if (!params.allowMultipleConnections && allConnections.size() > 1) {
            throw ErrorContext.iaef((String)"SQL recipe can't work on multiple connections simultaneously (inputs/outputs use %s)", (Object)Joiner.on((String)", ").join((Iterable)allConnections), (Object[])new Object[0]);
        }
        if (params.allowMultipleConnections) {
            if (params.mainConnectionDataset == null) {
                throw ErrorContext.iae((String)"The dataset whose connection the query should be run in is not specified (mandatory when using multiple connections).");
            }
            String fullName = DatasetLocUtils.resolveSmart(this.recipe.getProjectKey(), params.mainConnectionDataset).getFullName();
            Dataset dataset = null;
            for (FlowDataset source : this.subgraph.getSourceDatasets()) {
                if (!source.getFullName().equals(fullName)) continue;
                dataset = source.getMandatory(this.datasetsDAO);
            }
            for (FlowDataset target : this.subgraph.getTargetsDatasets()) {
                if (!target.getFullName().equals(fullName)) continue;
                dataset = target.getOrNull(this.datasetsDAO);
            }
            if (dataset == null) {
                throw ErrorContext.iaef((String)"The dataset %s is not among the inputs or outputs of the recipe.", (Object)params.mainConnectionDataset, (Object[])new Object[0]);
            }
            if (!DatasetInspector.isSQL(dataset)) {
                throw ErrorContext.iaef((String)"The dataset %s is not a SQL dataset.", (Object)params.mainConnectionDataset, (Object[])new Object[0]);
            }
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
            this.mainConnection = config.connection;
        } else {
            this.mainConnection = sourceConnections.firstConnection;
            if (this.mainConnection == null || this.mainConnection.length() == 0) {
                this.mainConnection = targetConnections.firstConnection;
            }
        }
        AbstractSQLConnection conn = SQLConnectionProvider.getDSSConnection(this.authCtxService.getAuthCtx(), this.mainConnection);
        assert (conn != null);
        this.sqlScript = this.getSQL(conn.getDialect());
        if (this.sqlScript == null) {
            throw new Error("Could not find SQL script for " + this.recipe.getName());
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        FlowVariables.addPartitioningVariables(this.authCtxService.getAuthCtx(), variables, this.subgraph, this.datasetsDAO);
        FlowVariables.addWhereClauseVariables(variables, this.subgraph, this.datasetsDAO, conn.getDialect());
        variables.putAll(FlowVariables.getSQLTableVariables(this.authCtxService.getAuthCtx(), this.recipe.getModel()));
        logger.info((Object)("Substituting variables in SQL script : " + JSON.pretty(variables)));
        this.sqlScript = FlowVariables.substitute(variables, this.sqlScript);
        this.sqlScript = this.variablesService.getContext(this.recipe.getProjectKey()).expand(this.sqlScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() throws Exception {
        block42: {
            try {
                logger.info((Object)"SQL runner running");
                assert (this.sqlScript != null);
                SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.mainConnection);
                SQLScriptRecipeMeta.SQLScriptRecipeParams params = RecipeRegistry.getParamsAs(this.activity, SQLScriptRecipeMeta.SQLScriptRecipeParams.class);
                if ((connData.getType() == ConnectionUtils.SQLConnectionType.POSTGRESQL || connData.getType() == ConnectionUtils.SQLConnectionType.ALLOYDB || connData.getType() == ConnectionUtils.SQLConnectionType.DATABRICKSLAKEBASE) && params.usePsql) {
                    File sqlScriptFile = FlowJobUtils.getJobFile("sql-recipe", "script.sql");
                    DKUFileUtils.writeFileUTF8((File)sqlScriptFile, (String)this.sqlScript);
                    this.execPSQL(connData, sqlScriptFile.getAbsolutePath());
                } else {
                    Splitter sqlSplitter = new Splitter(connData.getDialect().getSemicolonExclusionPortionFinders());
                    Object var4_5 = null;
                    switch (params.statementsParsingMode) {
                        case SPLIT: {
                            String[] stringArray = sqlSplitter.split(this.sqlScript);
                            break;
                        }
                        case RAW: {
                            String[] stringArray = new String[]{this.sqlScript};
                        }
                    }
                    SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(this.mainConnection, this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
                    try {
                        void var4_8;
                        for (void token : var4_8) {
                            if (token.trim().length() <= 0) continue;
                            try (Statement stmt = conn.createStatement();){
                                this.executeCancellableStatement(conn, stmt, (String)token);
                            }
                        }
                        logger.info((Object)"Statements done");
                        if (connData.getDialect().supportsCommitAndRollback()) {
                            conn.commit();
                        }
                    }
                    finally {
                        logger.info((Object)"Closing connection");
                        conn.close();
                    }
                }
                if (!params.inferOutputDatasetsSchema) break block42;
                logger.info((Object)"Infering dataset schemas after SQL script recipe");
                for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
                    if (flowComputable.getType() != FlowComputable.FCType.DATASET) continue;
                    try {
                        Dataset dataset = ((FlowDataset)flowComputable).getMandatoryUnsafe(this.datasetsDAO);
                        SQLConnectionProvider.SQLConnectionData dsConnData = DatasetInspector.getSQLConnectionForSQLOrHiveDataset(this.authCtxService.getAuthCtx(), dataset);
                        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(dataset, dsConnData.getDialect(), null);
                        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
                        AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode = config.datetimenotzReadMode;
                        AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode = config.dateonlyReadMode;
                        if (dataset.isManaged()) {
                            if (dataset.getTypeSystemVersion() == SerializedDataset.TypeSystemVersion.V1) {
                                datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING;
                                dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
                            } else {
                                datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                                dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                            }
                        }
                        SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(dsConnData, this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
                        try {
                            Schema datasetSchema = dataset.getSchema();
                            SchemaReader.SchemaWithInfo tableSchema = SchemaReader.getTableSchemaWithInfo(this.authCtxService.getAuthCtx(), connData, conn, table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable(), datetimenotzReadMode, dateonlyReadMode, datasetSchema);
                            if (!JSON.pretty((Object)datasetSchema).equals(JSON.pretty((Object)tableSchema.schema))) {
                                logger.warn((Object)"SQL script modified the schema, overriding it");
                                logger.info((Object)"Overriding the schema of the dataset");
                                this.datasetWritingService.writeDatasetSchema(TransactionContext.retrieveWrite().getUser(), DatasetLocUtils.resolveFull(dataset.getFullName()), tableSchema.schema, false, null);
                                KernelSession.propagateSchemaToJekOrBackend(dataset.getFullName(), tableSchema.schema);
                                logger.info((Object)"Dataset schema propagated");
                                continue;
                            }
                            logger.info((Object)"SQL script did not modify the schema");
                        }
                        finally {
                            if (conn == null) continue;
                            conn.close();
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"SQL script schema propagation failed", (Throwable)e);
                        this.activity.warnContext.addWarning(WarningsContext.WarningType.SQL_SCRIPT_INFER_SCHEMA_FAILED, "SQL script schema propagation failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e), logger);
                    }
                }
            }
            catch (SQLException e) {
                throw ExceptionUtils.newSQLExceptionWithNestedMessages((SQLException)e);
            }
            finally {
                SQLScriptRecipeRunner sQLScriptRecipeRunner = this;
                synchronized (sQLScriptRecipeRunner) {
                    this.runTerminated = true;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execPSQL(SQLConnectionProvider.SQLConnectionData cd, String scriptPath) throws IOException, InterruptedException, DKUSecurityException {
        SimpleSQLDSSConnectionWithBasicCredential conn = (SimpleSQLDSSConnectionWithBasicCredential)cd.getConnection();
        PostgreSQLConnection.Params params = (PostgreSQLConnection.Params)conn.getParams();
        ICredentialsService.BasicCredential credentials = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey()), ICredentialsService.BasicCredential.class);
        Object[] args = new String[]{"psql", "-h", params.host, "-U", credentials.user, "-f", scriptPath, "-p", String.valueOf(params.port), params.db, "--set", "ON_ERROR_STOP=1"};
        Map env = DKUtils.getEnvironment();
        env.put("PGPASSWORD", credentials.password);
        logger.info((Object)("Executing with psql: " + StringUtils.join((Object[])args, (String)" ")));
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("sql-script", "psql-out");){
            DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withArgs((String[])args).withEnv(env).withCwd((File)outputTmpDir).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withCompletionHandler((DKUtils.ExecCompletionHandler)new DKUtils.SimpleExceptionExecCompletionHandler("psql execution failed"));
            SQLScriptRecipeRunner sQLScriptRecipeRunner = this;
            synchronized (sQLScriptRecipeRunner) {
                if (this.abortNotified) {
                    throw new ActivityAbortedException();
                }
                this.runningProcessKiller = execBuilder.makeNiceThenEvilKiller();
            }
            execBuilder.exec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCancellableStatement(SQLConnectionProvider.SQLConnectionWrapper conn, Statement statement, String sql) throws SQLException {
        SQLScriptRecipeRunner sQLScriptRecipeRunner;
        logger.info((Object)"Executing statement:");
        logger.info((Object)sql);
        SQLScriptRecipeRunner sQLScriptRecipeRunner2 = this;
        synchronized (sQLScriptRecipeRunner2) {
            if (this.abortNotified) {
                throw new ActivityAbortedException();
            }
            if (this.currentStatement != null) {
                throw new RuntimeException("This is a bug: concurrent statement are not possible !");
            }
            this.currentStatement = statement;
        }
        ComputeResourceUsage cru = SQLComputeResourceUsage.forSQLQuery(conn, sql).reportStartNoFail();
        try {
            if (statement.execute(sql)) {
                try {
                    do {
                        statement.getResultSet();
                    } while (statement.getMoreResults());
                }
                catch (SQLFeatureNotSupportedException e) {
                    logger.debug((Object)"Iterating through multiple result sets not supported by the JDBC driver, thus only checking the first result set -- subsequent result sets (if any) will be ignored");
                }
            }
            logger.info((Object)"Statement done");
        }
        finally {
            cru.reportCompleteNoFail();
            sQLScriptRecipeRunner = this;
            synchronized (sQLScriptRecipeRunner) {
                this.currentStatement = null;
            }
        }
        sQLScriptRecipeRunner = this;
        synchronized (sQLScriptRecipeRunner) {
            if (this.abortNotified) {
                throw new ActivityAbortedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        DKUtils.ExecKiller processToKill = null;
        Statement statementToCancel = null;
        SQLScriptRecipeRunner sQLScriptRecipeRunner = this;
        synchronized (sQLScriptRecipeRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            statementToCancel = this.currentStatement;
            processToKill = this.runningProcessKiller;
        }
        if (statementToCancel != null) {
            try {
                logger.info((Object)"Cancelling SQL statement...");
                statementToCancel.cancel();
                logger.info((Object)"SQL statement cancelled!");
            }
            catch (SQLException e) {
                logger.error((Object)"Unable to cancel SQL statement", (Throwable)e);
            }
        }
        if (processToKill != null) {
            processToKill.kill();
        }
        sQLScriptRecipeRunner = this;
        synchronized (sQLScriptRecipeRunner) {
            long start = System.currentTimeMillis();
            while (!this.runTerminated) {
                long end = System.currentTimeMillis();
                if (end - start > 15000L) {
                    logger.error((Object)"The recipe cannot be properly stopped. It'll be killed abruptly with the JEK.");
                    return;
                }
                logger.info((Object)"Waiting for the recipe to terminate...");
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            logger.info((Object)"Recipe terminated!");
        }
    }
}

