/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.ISISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.PeriodicObserver;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.WithAdditionalRunnables;
import com.dataiku.dip.dataflow.exec.sampling.FSToAnySamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.HiveSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.ImpalaSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SQLSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SingleThreadAnyToAnySamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SingleThreadAnyToKafkaSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SingleThreadAnyToSESamplingExecutor;
import com.dataiku.dip.dataflow.exec.sampling.SparkSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sql.SQLGenerator;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToSynapse;
import com.dataiku.dip.dataflow.exec.sync.AzureToTrino;
import com.dataiku.dip.dataflow.exec.sync.BigQueryToGCS;
import com.dataiku.dip.dataflow.exec.sync.ContainerizedSyncExecutor;
import com.dataiku.dip.dataflow.exec.sync.DatabricksToAzureBlob;
import com.dataiku.dip.dataflow.exec.sync.DatabricksToS3;
import com.dataiku.dip.dataflow.exec.sync.DatabricksVolumeToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.FSToVertica;
import com.dataiku.dip.dataflow.exec.sync.GCSToBigQuery;
import com.dataiku.dip.dataflow.exec.sync.GcsToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.GcsToTrino;
import com.dataiku.dip.dataflow.exec.sync.RedshiftToS3;
import com.dataiku.dip.dataflow.exec.sync.RepartitioningSingleThreadAnyToAny;
import com.dataiku.dip.dataflow.exec.sync.S3ToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.S3ToRedshift;
import com.dataiku.dip.dataflow.exec.sync.S3ToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.S3ToTrino;
import com.dataiku.dip.dataflow.exec.sync.SingleThreadAnyToVertica;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToGcs;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToS3;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToWASB;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.sync.TeradataHadoop;
import com.dataiku.dip.dataflow.exec.sync.TrinoToAzure;
import com.dataiku.dip.dataflow.exec.sync.TrinoToGcs;
import com.dataiku.dip.dataflow.exec.sync.TrinoToS3;
import com.dataiku.dip.dataflow.exec.sync.WASBToSnowflake;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunnableThreadsHolder;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.server.recipes.SamplingRecipeService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncRecipeRunner
implements FlowRunnable,
RecipeRunner,
WithAdditionalRunnables,
PeriodicObserver,
ContainerizedDSSEngineAble,
AbortableRecipeRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SamplingRecipeService service;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final SyncRecipeParams params;
    private ISISORecipeExecutor executor;
    private Output.WriteMode writeMode;
    private Dataset inputDS;
    private Dataset outputDS;
    private StreamingEndpoint outputSE;
    private boolean isRunningInContainer;
    private static final Logger logger = Logger.getLogger((String)"dku.flow.sync");

    public SyncRecipeRunner(JobActivity activity) {
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.activity = activity;
        this.recipe = subgraph.getRecipe();
        this.activity.initStatus();
        this.params = RecipeRegistry.getParamsAs(activity, SyncRecipeParams.class);
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void init() throws Exception {
        this.recipe.validateExactly1Source();
        this.recipe.validateExactly1Target();
        new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        FlowDataset inputFD = GraphUtils.getSingleSource(this.recipe);
        FlowComputable outputFC = GraphUtils.getSingleTargetAnyComputable(this.recipe);
        this.inputDS = inputFD.getMandatory(this.datasetsDAO);
        if (outputFC.getType() == FlowComputable.FCType.DATASET) {
            this.outputDS = ((FlowDataset)outputFC).getMandatory(this.datasetsDAO);
        } else if (outputFC.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
            this.outputSE = ((FlowStreamingEndpoint)outputFC).getStreamingEndpoint();
        }
        SerializedRecipe.RecipeOutput recipeOutput = this.recipe.getModel().getSingleOutput("main");
        this.writeMode = recipeOutput.getWriteMode();
        this.executor = this.getExecutor();
        logger.info((Object)("Using executor: " + this.executor.getClass().getName()));
        this.executor.init(this.activity, this.writeMode);
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    private ISISORecipeExecutor getExecutor() throws Exception {
        SyncRecipeStatusComputer computer = new SyncRecipeStatusComputer(this.recipe.getModel(), null);
        if (this.activity.getSubgraph().isAllTargetPartitions()) {
            FlowComputable outputFC = GraphUtils.getSingleTargetAnyComputable(this.recipe);
            if (!(outputFC instanceof FlowPartitionable)) {
                throw new IllegalStateException("Cannot redispatch to non-partitionable");
            }
            PartitioningScheme scheme = ((FlowPartitionable)((Object)outputFC)).getPartitioned(this.datasetsDAO).getPartitioningSchema();
            if (scheme == null || !scheme.isPartitioned()) {
                throw new IllegalStateException("Cannot redispatch to non-partitioned");
            }
            ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), null);
            if (containerConfig != null) {
                logger.info((Object)"Run in container");
                return new ContainerizedSyncExecutor(this.recipe, this.activity, containerConfig);
            }
            return new RepartitioningSingleThreadAnyToAny();
        }
        RecipeEngineStatus engine = computer.selectEngine(this.authCtxService.getAuthCtx(), this.activity, this.params.engineType, this.params);
        logger.info((Object)("Selected engine type: " + engine.type));
        JobContext.getCurrentActivitySummary().engineType = engine.type;
        if (!engine.isSelectable) {
            throw ErrorContext.iae((String)"Cannot run the recipe with this engine");
        }
        SQLGenerator sqlGenerator = dialect -> this.service.generateSQL(this.activity, dialect, this.params.engineParams);
        switch (engine.type) {
            case "TDCH": {
                return new TeradataHadoop(this.params.engineParams.tdchParams);
            }
            case "S3_TO_REDSHIFT": {
                return new S3ToRedshift();
            }
            case "REDSHIFT_TO_S3": {
                return new RedshiftToS3();
            }
            case "S3_TO_SNOWFLAKE": {
                return new S3ToSnowflake();
            }
            case "SNOWFLAKE_TO_S3": {
                return new SnowflakeToS3();
            }
            case "AZURE_TO_SQLSERVER": 
            case "AZURE_TO_FABRIC": {
                return new AzureBlobToSynapse(this.params.engineParams.synapseParams);
            }
            case "SNOWFLAKE_TO_WASB": {
                return new SnowflakeToWASB();
            }
            case "WASB_TO_SNOWFLAKE": {
                return new WASBToSnowflake();
            }
            case "GCS_TO_SNOWFLAKE": {
                return new GcsToSnowflake();
            }
            case "SNOWFLAKE_TO_GCS": {
                return new SnowflakeToGcs();
            }
            case "GCS_TO_BIGQUERY": {
                return new GCSToBigQuery();
            }
            case "BIGQUERY_TO_GCS": {
                return new BigQueryToGCS();
            }
            case "AZURE_TO_DATABRICKS": {
                return new AzureBlobToDatabricks();
            }
            case "DATABRICKS_TO_AZURE": {
                return new DatabricksToAzureBlob();
            }
            case "S3_TO_DATABRICKS": {
                return new S3ToDatabricks();
            }
            case "DATABRICKS_TO_S3": {
                return new DatabricksToS3();
            }
            case "DBVOLUME_TO_DATABRICKS": {
                return new DatabricksVolumeToDatabricks();
            }
            case "S3_TO_TRINO": {
                return new S3ToTrino();
            }
            case "TRINO_TO_S3": {
                return new TrinoToS3();
            }
            case "AZURE_TO_TRINO": {
                return new AzureToTrino();
            }
            case "TRINO_TO_AZURE": {
                return new TrinoToAzure();
            }
            case "GCS_TO_TRINO": {
                return new GcsToTrino();
            }
            case "TRINO_TO_GCS": {
                return new TrinoToGcs();
            }
            case "SQL": {
                return new SQLSamplingExecutor(sqlGenerator);
            }
            case "SPARK": {
                return new SparkSamplingExecutor(sqlGenerator, this.params.engineParams.sparkSQL);
            }
            case "IMPALA": {
                return new ImpalaSamplingExecutor(sqlGenerator, this.params.engineParams.impala);
            }
            case "HIVE": {
                return new HiveSamplingExecutor(sqlGenerator, this.params.engineParams.hive);
            }
            case "DSS": {
                return this.selectStreamExecutor();
            }
        }
        throw new NotImplementedException("Unknown engine type: " + engine.type);
    }

    private ISISORecipeExecutor selectStreamExecutor() throws Exception {
        if (this.outputDS == null && this.outputSE != null) {
            if ("kafka".equals(this.outputSE.getType())) {
                return new SingleThreadAnyToKafkaSamplingExecutor();
            }
            return new SingleThreadAnyToSESamplingExecutor();
        }
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), null);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            return new ContainerizedSyncExecutor(this.recipe, this.activity, containerConfig);
        }
        try (DatasetHandler inputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), this.inputDS);){
            SingleThreadAnyToAnySamplingExecutor singleThreadAnyToAnySamplingExecutor;
            block31: {
                DatasetHandler outputDatasetHandler;
                block29: {
                    SingleThreadAnyToVertica singleThreadAnyToVertica;
                    block30: {
                        boolean dontUseCopy;
                        DatasetHandler.DatasetMeta<?, ?> outputMeta;
                        block23: {
                            SingleThreadAnyToAnySamplingExecutor singleThreadAnyToAnySamplingExecutor2;
                            block28: {
                                block26: {
                                    FSToAnySamplingExecutor fSToAnySamplingExecutor;
                                    block27: {
                                        boolean inputIsRepeating;
                                        block24: {
                                            FSToVertica fSToVertica;
                                            block25: {
                                                outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), this.outputDS);
                                                try {
                                                    DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(this.inputDS);
                                                    outputMeta = DatasetHandlerFactory.getMeta(this.outputDS);
                                                    dontUseCopy = this.outputDS.getDkuPropertiesAsParams().getBoolParam("write_using_copy.disabled", false);
                                                    if (!inputMeta.isFS()) break block23;
                                                    inputIsRepeating = this.inputDS.getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig && this.inputDS.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).variablesExpansionLoopConfig.isEnabled();
                                                    logger.info((Object)("Input is repeating: " + inputIsRepeating));
                                                    if (outputMeta != BuiltinSQLDatasets.VERTICA_META || dontUseCopy) break block24;
                                                    fSToVertica = new FSToVertica(this.params);
                                                    if (outputDatasetHandler == null) break block25;
                                                }
                                                catch (Throwable throwable) {
                                                    if (outputDatasetHandler != null) {
                                                        try {
                                                            outputDatasetHandler.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                    }
                                                    throw throwable;
                                                }
                                                outputDatasetHandler.close();
                                            }
                                            return fSToVertica;
                                        }
                                        if (inputIsRepeating || !inputDatasetHandler.isParallelReadable() || !outputDatasetHandler.isParallelWritable()) break block26;
                                        fSToAnySamplingExecutor = new FSToAnySamplingExecutor(this.params.engineParams.maxThreads);
                                        if (outputDatasetHandler == null) break block27;
                                        outputDatasetHandler.close();
                                    }
                                    return fSToAnySamplingExecutor;
                                }
                                singleThreadAnyToAnySamplingExecutor2 = new SingleThreadAnyToAnySamplingExecutor();
                                if (outputDatasetHandler == null) break block28;
                                outputDatasetHandler.close();
                            }
                            return singleThreadAnyToAnySamplingExecutor2;
                        }
                        if (outputMeta != BuiltinSQLDatasets.VERTICA_META || dontUseCopy) break block29;
                        singleThreadAnyToVertica = new SingleThreadAnyToVertica(this.params);
                        if (outputDatasetHandler == null) break block30;
                        outputDatasetHandler.close();
                    }
                    return singleThreadAnyToVertica;
                }
                singleThreadAnyToAnySamplingExecutor = new SingleThreadAnyToAnySamplingExecutor();
                if (outputDatasetHandler == null) break block31;
                outputDatasetHandler.close();
            }
            return singleThreadAnyToAnySamplingExecutor;
        }
    }

    @Override
    public void run() throws Exception {
        this.activity.setStatusMessage("Syncing");
        this.executor.run();
        try {
            ActivityRunnableThreadsHolder.joinOthers();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    @Override
    public void onInterval() throws IOException {
        if (this.executor instanceof PeriodicObserver) {
            ((PeriodicObserver)((Object)this.executor)).onInterval();
        }
    }

    @Override
    public void onEnd(boolean isSuccess) throws IOException {
        if (this.executor instanceof PeriodicObserver) {
            ((PeriodicObserver)((Object)this.executor)).onEnd(isSuccess);
        }
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return this.executor.getRunnables();
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.executor instanceof AbortableRecipeRunner) {
            ((AbortableRecipeRunner)((Object)this.executor)).notifyBeforeAborting();
        }
    }
}

