/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.FlowZone;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializer;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.dataflow.graph.utils.ZoneGraphSerializer;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.XMLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.DOMNodeSelector;

public class ProjectGraphSerializer
extends GraphSerializer<ProjectFlowGraph> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.graph.ProjectGraphSerializer");
    private Map<String, GraphSerializer.SerializedGraph> zonesGraphsCache;
    private final Map<String, Zone> zonesCache = new HashMap<String, Zone>();
    private final Map<String, Set<SmartObjectRef>> sharedObjectsByZone = new HashMap<String, Set<SmartObjectRef>>();
    private final ExecutorService executor = Executors.newFixedThreadPool(DKUApp.getParams().getIntParam("dku.flow.nbThreadsComputeFlowZones", Integer.valueOf(4)));
    private final ExecutorCompletionService<ZoneGraphSerializer.ZoneSerializedGraph> completionService = new ExecutorCompletionService(this.executor);
    private static final double HEADER_HEIGHT_PT = 44.0;
    public static final int MIN_ZONE_SIZE = 300;
    private static final Pattern TRANSLATE_PATTERN = Pattern.compile("translate\\(\\s*([^\\s,)]+)[\\s,]\\s?([^\\s,)]+)");
    private final boolean drawZones;
    private final Set<String> zonesWithModifiedPosition = new HashSet<String>();
    private final String zoomedZoneId;
    private final Set<String> collapsedZones;
    private final String flowZoneAloneEmpty = String.format("<svg><g class=\"graph\"><image xlink:href=\"/static/dataiku/images/empty-zone.svg\" height=\"%1$dpx\" width=\"%1$dpx\" /></g></svg>", 300);
    private final String lang;
    @Autowired
    protected ZonesDAO zonesDAO;
    @Autowired
    protected TranslationService translationService;
    @Autowired
    protected UserSettingsService userSettingsService;
    @Autowired
    private TransactionService transactionService;

    public ProjectGraphSerializer(ProjectFlowGraph projectGraph, String projectKey, boolean drawZones, String zoneId, Set<String> collapsedZones, AuthCtx authCtx) throws IOException {
        super(projectGraph, projectKey, authCtx);
        this.drawZones = drawZones;
        this.zoomedZoneId = zoneId;
        this.collapsedZones = collapsedZones;
        this.lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
    }

    @Override
    public Callable<GraphSerializer.SerializedGraph> serialize() throws Exception {
        final ArrayList<Callable<ZoneGraphSerializer.ZoneSerializedGraph>> graphCallables = new ArrayList<Callable<ZoneGraphSerializer.ZoneSerializedGraph>>();
        final TreeMap contents = new TreeMap();
        final ArrayList standaloneZones = new ArrayList();
        if (((ProjectFlowGraph)this.graph).getFlowZones().isEmpty() || !this.drawZones) {
            return super.serialize();
        }
        ZoneGraphSerializer.ZoneGraphSerializerObjectDependencies zoneGraphSerializerObjectDependencies = new ZoneGraphSerializer.ZoneGraphSerializerObjectDependencies(this.getAllExposedObjects(), this.getAllDatasets(), this.getAllManagedFolders(), this.getAllSavedModels(), this.getAllModelEvaluationStores(), this.getAllStreamingEndpoints());
        for (FlowZone flowZone : ((ProjectFlowGraph)this.graph).getFlowZones()) {
            if (flowZone == null) continue;
            ZoneGraphSerializer gs = new ZoneGraphSerializer(this, flowZone, this.projectKey, this.authCtx, zoneGraphSerializerObjectDependencies);
            Zone zone = (Zone)this.zonesDAO.getOrNull(flowZone.getZone().getProjectKey(), flowZone.getZone().getId());
            if (zone == null) {
                logger.warnV("Zone:%s on project:%s should be there but we cannot find it", new Object[]{flowZone.getZone().getId(), flowZone.getZone().getProjectKey()});
                continue;
            }
            this.sharedObjectsByZone.put(zone.getId(), zone.getShared());
            this.zonesCache.put(zone.getId(), zone);
            graphCallables.add(gs.serialize());
        }
        return new Callable<GraphSerializer.SerializedGraph>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GraphSerializer.SerializedGraph call() throws Exception {
                boolean forceSameRank = DKUApp.getParams().getBoolParam("dku.flow.rendering.zones.forceSameRank", false);
                boolean connectZones = ProjectGraphSerializer.this.flowDisplaySettings.zonesGraphConnectZones;
                TransactionContext.assertNoAttachedTransaction();
                GraphSerializer.SerializedGraph serializedGraph = new GraphSerializer.SerializedGraph();
                serializedGraph.hasZones = StringUtils.isBlank((CharSequence)ProjectGraphSerializer.this.zoomedZoneId);
                ProjectGraphSerializer.this.zonesGraphsCache = new HashMap<String, GraphSerializer.SerializedGraph>();
                ArrayList<GraphSerializer.SerializedNode> zoneNodes = new ArrayList<GraphSerializer.SerializedNode>();
                String rankPlaceholder = "__DKU_RANK_PLACEHOLDER__";
                String splinesValue = ProjectGraphSerializer.this.flowDisplaySettings.zonesManualPositioning ? "false" : "true";
                ProjectGraphSerializer.this.headSB.append("digraph g {\n" + rankPlaceholder + "rankdir=\"LR\";splines=" + splinesValue + ";nodesep=3;ranksep=2;node[shape=box, fillcolor=transparent];\n");
                ProjectGraphSerializer.this.standaloneSB.append("subgraph cluster_standalone {rank=\"same\";edge[style=\"invisible\",dir=\"none\"];\n");
                ProjectGraphSerializer.this.mainSB.append("subgraph cluster_main {" + (forceSameRank ? "rank=\"same\";" : ""));
                for (Map.Entry<String, Zone> entry : ProjectGraphSerializer.this.zonesCache.entrySet()) {
                    GraphSerializer.SerializedNode serializedNode = new GraphSerializer.SerializedNode();
                    Zone zone = entry.getValue();
                    serializedNode.nodeType = GraphSerializer.NodeType.ZONE;
                    serializedNode.id = "zone_" + zone.getId();
                    serializedNode.name = zone.getId();
                    serializedNode.description = zone.getName();
                    serializedNode.projectKey = ProjectGraphSerializer.this.projectKey;
                    serializedNode.shortDesc = zone.shortDesc;
                    serializedNode.tags = zone.tags;
                    serializedNode.customData = ProjectGraphSerializer.this.getCustomData(zone);
                    serializedNode.realId = serializedNode.id;
                    serializedNode.discussionsFullIds = ProjectGraphSerializer.this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(ProjectGraphSerializer.this.projectKey, ITaggingService.TaggableType.FLOW_ZONE, serializedNode.id), false);
                    serializedNode.position = zone.getPosition();
                    serializedGraph.nodes.put(serializedNode.id, serializedNode);
                    zoneNodes.add(serializedNode);
                }
                try {
                    this.computeFlowZones(serializedGraph);
                }
                finally {
                    ProjectGraphSerializer.this.executor.shutdown();
                }
                for (Map.Entry<String, Zone> entry : contents.entrySet()) {
                    GraphSerializer.SerializedGraph graph = ProjectGraphSerializer.this.zonesGraphsCache.get(entry.getKey());
                    if (Objects.equals(graph.svg, ProjectGraphSerializer.this.getGlobalFlowZoneEmpty()) || Objects.equals(graph.svg, ProjectGraphSerializer.this.flowZoneAloneEmpty)) {
                        ProjectGraphSerializer.this.standaloneSB.append((String)((Object)entry.getValue()));
                        standaloneZones.add("zone_" + entry.getKey());
                        continue;
                    }
                    ProjectGraphSerializer.this.mainSB.append((String)((Object)entry.getValue()));
                }
                if (connectZones) {
                    for (GraphSerializer.SerializedNode serializedNode : zoneNodes) {
                        TreeSet<String> sortedSuccessors = new TreeSet<String>(serializedNode.successors);
                        for (String successor : sortedSuccessors) {
                            if (serializedGraph.nodes.get(serializedNode.id) == null) continue;
                            ProjectGraphSerializer.this.addConnection(serializedNode, serializedGraph.nodes.get(successor), null, false, new String[0]);
                        }
                    }
                }
                ProjectGraphSerializer.this.standaloneSB.append(StringUtils.join((Iterable)standaloneZones, (String)" -> "));
                ProjectGraphSerializer.this.standaloneSB.append("}");
                ProjectGraphSerializer.this.mainSB.append("}");
                ProjectGraphSerializer.this.headSB.append((CharSequence)ProjectGraphSerializer.this.standaloneSB);
                ProjectGraphSerializer.this.headSB.append((CharSequence)ProjectGraphSerializer.this.mainSB);
                ProjectGraphSerializer.this.headSB.append("}");
                String graphvizDef = ProjectGraphSerializer.this.headSB.toString();
                boolean bl = ProjectGraphSerializer.this.flowDisplaySettings.zonesGraphRenderingAlgorithm == SerializedProject.FlowDisplaySettings.ZonesGraphRenderingAlgorithm.DOT_NEWRANK_FREERANK;
                String graphvizFinalDef = graphvizDef.replace(rankPlaceholder, bl ? "newrank=true;" : "");
                try {
                    serializedGraph.svg = ProjectGraphSerializer.this.cleanSVGCache(graphvizFinalDef, "dot", true);
                }
                catch (ProcessDiedException e) {
                    if (!bl && ((String)StringUtils.defaultIfEmpty((CharSequence)e.getMessage(), (CharSequence)"")).contains("dot failed (exit code")) {
                        logger.warn((Object)("Graphviz failed, trying again with new rank (exception=" + e.getMessage() + ")"));
                        graphvizFinalDef = graphvizDef.replace(rankPlaceholder, "newrank=true;");
                        serializedGraph.svg = ProjectGraphSerializer.this.cleanSVGCache(graphvizFinalDef, "dot", true);
                    }
                    throw e;
                }
                ProjectGraphSerializer.this.enrichGraph(serializedGraph);
                if (ProjectGraphSerializer.this.flowDisplaySettings.zonesManualPositioning) {
                    serializedGraph.svg = ProjectGraphSerializer.this.setManualZonePositionsInSvg(serializedGraph.svg);
                }
                ProjectGraphSerializer.this.saveZones();
                return serializedGraph;
            }

            private void computeFlowZones(GraphSerializer.SerializedGraph serializedGraph) throws InterruptedException, ExecutionException, IOException, SAXException {
                ArrayList<Future<ZoneGraphSerializer.ZoneSerializedGraph>> futures = new ArrayList<Future<ZoneGraphSerializer.ZoneSerializedGraph>>(graphCallables.size());
                for (Callable entry : graphCallables) {
                    futures.add(ProjectGraphSerializer.this.completionService.submit(entry));
                }
                for (int i = 0; i < futures.size(); ++i) {
                    ZoneGraphSerializer.ZoneSerializedGraph serializedZone = ProjectGraphSerializer.this.completionService.take().get();
                    serializedGraph.nodes.putAll(serializedZone.nodes);
                    if (StringUtils.isBlank((CharSequence)ProjectGraphSerializer.this.zoomedZoneId) || serializedZone.zone.equals(ProjectGraphSerializer.this.zoomedZoneId)) {
                        serializedGraph.datasetsKeptForRecipe.addAll(serializedZone.datasetsKeptForRecipe);
                        ProjectGraphSerializer.mergeAndAdd(serializedGraph.includedObjectsByType, serializedZone.includedObjectsByType);
                    }
                    String entryZone = ProjectGraphSerializer.this.getZone(serializedZone.zone);
                    serializedZone.nodes.values().forEach(serializedNode -> serializedGraph.realNodesZones.computeIfAbsent(serializedNode.realId, k -> new HashSet()).add(entryZone));
                    serializedZone.sharedObjects = ProjectGraphSerializer.this.sharedObjectsByZone.get(entryZone);
                    if (entryZone.equals(ProjectGraphSerializer.this.zoomedZoneId)) {
                        boolean bl = serializedGraph.hasZoneSharedObjects = !serializedZone.sharedObjects.isEmpty();
                    }
                    if (StringUtils.isBlank((CharSequence)ProjectGraphSerializer.this.zoomedZoneId)) {
                        int includedZones = serializedGraph.includedObjectsByType.getOrDefault((Object)ITaggingService.TaggableType.FLOW_ZONE, 0);
                        serializedGraph.includedObjectsByType.put(ITaggingService.TaggableType.FLOW_ZONE, includedZones + 1);
                    }
                    for (String externalObject : serializedZone.externalObjects) {
                        Set zones = serializedGraph.zonesUsedByRealId.computeIfAbsent(externalObject, k -> new HashSet());
                        String ownerZone = ProjectGraphSerializer.this.getZone(((GraphSerializer.SerializedNode)serializedZone.realNodes.get((Object)externalObject)).ownerZone);
                        zones.add(entryZone);
                        zones.add(ownerZone);
                        GraphSerializer.SerializedNode ownerZoneNode = serializedGraph.nodes.get("zone_" + ownerZone);
                        if (ownerZoneNode != null && StringUtils.isBlank((CharSequence)ProjectGraphSerializer.this.zoomedZoneId)) {
                            ownerZoneNode.successors.add("zone_" + entryZone);
                        }
                        GraphSerializer.SerializedNode serializedNodeZone = serializedGraph.nodes.get("zone_" + entryZone);
                        serializedNodeZone.predecessors.add("zone_" + ownerZone);
                    }
                    Document svgDoc = XMLUtils.parse(serializedZone.svg);
                    Element svgNode = svgDoc.getDocumentElement();
                    double widthPt = 0.0;
                    double heightPt = 0.0;
                    String height = svgNode.getAttribute("height");
                    String width = svgNode.getAttribute("width");
                    if (StringUtils.isNotBlank((CharSequence)height)) {
                        heightPt = Double.parseDouble(height.substring(0, height.length() - 2));
                    }
                    if (StringUtils.isNotBlank((CharSequence)width)) {
                        widthPt = Double.parseDouble(width.substring(0, width.length() - 2));
                    }
                    if (serializedZone.includedObjectsByType.isEmpty() && serializedZone.sharedObjects.isEmpty()) {
                        widthPt = 428.0;
                        heightPt = 364.0;
                        serializedZone.svg = serializedGraph.hasZones ? ProjectGraphSerializer.this.getGlobalFlowZoneEmpty() : ProjectGraphSerializer.this.flowZoneAloneEmpty;
                    }
                    if (ProjectGraphSerializer.this.flowDisplaySettings.zonesManualPositioning && !ProjectGraphSerializer.this.zonesCache.get(entryZone).dimensionsEquals(heightPt += 64.0, widthPt)) {
                        ProjectGraphSerializer.this.zonesCache.get(entryZone).setDimensions(heightPt, widthPt);
                        ProjectGraphSerializer.this.zonesWithModifiedPosition.add(entryZone);
                    }
                    boolean isCollapsed = ProjectGraphSerializer.this.collapsedZones.contains(entryZone) && StringUtils.isEmpty((CharSequence)ProjectGraphSerializer.this.zoomedZoneId);
                    widthPt = isCollapsed ? Math.min(428.0, widthPt) : widthPt;
                    heightPt = isCollapsed ? 44.0 : heightPt;
                    ProjectGraphSerializer.this.zonesGraphsCache.put(entryZone, serializedZone);
                    contents.put(entryZone, String.format(Locale.US, "subgraph cluster_zone_%1$s {\nmargin=\"0.0 0.0\";class=\"zone_cluster\";id=\"cluster_zone_%1$s\";\nzone_%1$s [fixedsize=true, width=%2$f, height=%3$f, id=\"zone_%1$s\", class=\"zone\", color=\"transparent\"];\nlabel=\"%4$s\"; comment=\"%5$d\"}", GraphSerializerCommon.graphVizEscape(entryZone), widthPt / 72.0, heightPt / 72.0, GraphSerializerCommon.escapeForQuotedField(ProjectGraphSerializer.this.zonesCache.get(entryZone).getName()), serializedZone.svg.hashCode()));
                }
            }
        };
    }

    @Override
    protected void enrichGraph(GraphSerializer.SerializedGraph serializedGraph) {
        serializedGraph.hasProjectZones = ((ProjectFlowGraph)this.graph).hasZones;
    }

    private void saveZones() throws IOException, DKUSecurityException {
        if (this.zonesWithModifiedPosition.isEmpty()) {
            return;
        }
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            if (!this.permissionsService.hasProjectPrivilege(this.authCtx, this.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                logger.info((Object)"Cannot save zones: no write access for user.");
                return;
            }
            for (String zoneId : this.zonesWithModifiedPosition) {
                this.zonesDAO.save(this.projectKey, this.zonesCache.get(zoneId));
            }
            t.commitV("Saved zones: %s", new Object[]{this.zonesWithModifiedPosition.toString()});
        }
    }

    private JsonObject getCustomData(Zone zone) {
        JsonObject jsonObject = JSON.toJsonObject((Object)zone, (String[])new String[]{"color"});
        jsonObject.addProperty("isCollapsed", Boolean.valueOf(this.collapsedZones.contains(zone.getId()) && StringUtils.isEmpty((CharSequence)this.zoomedZoneId)));
        return jsonObject;
    }

    protected String getZone(String zone) {
        return zone != null ? zone : Zone.DEFAULT_ZONE.getId();
    }

    protected static void mergeAndAdd(Map<ITaggingService.TaggableType, Integer> graphMap, Map<ITaggingService.TaggableType, Integer> zoneMap) {
        for (Map.Entry<ITaggingService.TaggableType, Integer> entry : zoneMap.entrySet()) {
            ITaggingService.TaggableType key;
            Integer current = graphMap.get((Object)(key = entry.getKey()));
            graphMap.put(key, current == null ? entry.getValue() : entry.getValue() + current);
        }
    }

    private String setManualZonePositionsInSvg(String cleanedSvg) {
        try {
            Document doc = XMLUtils.parse(cleanedSvg);
            DOMNodeSelector selector = new DOMNodeSelector((Node)doc);
            for (Map.Entry<String, Zone> entry : this.zonesCache.entrySet()) {
                String zoneId = entry.getKey();
                Zone zone = entry.getValue();
                Node clusterZoneNode = selector.querySelector(String.format("g.cluster[id=cluster_zone_%s]", zoneId));
                Node zoneNode = selector.querySelector(String.format("g.node[id=zone_%s]", zoneId));
                Node parentNode = zoneNode.getParentNode();
                parentNode.removeChild(zoneNode);
                parentNode.removeChild(clusterZoneNode);
                parentNode.appendChild(clusterZoneNode);
                parentNode.appendChild(zoneNode);
                Double translateX = null;
                Double translateY = null;
                String transformAttribute = ((Element)zoneNode).getAttribute("transform");
                Matcher translateMatch = TRANSLATE_PATTERN.matcher(transformAttribute);
                if (translateMatch.find()) {
                    translateX = Double.parseDouble(translateMatch.group(1));
                    translateY = Double.parseDouble(translateMatch.group(2));
                }
                if (zone.hasValidCoordinates()) {
                    translateX = zone.getX();
                    translateY = zone.getY();
                } else if (translateX != null && translateY != null) {
                    zone.setCoordinates(translateX, translateY);
                    this.zonesWithModifiedPosition.add(zoneId);
                }
                if (translateX == null || translateY == null) continue;
                ((Element)clusterZoneNode).setAttribute("transform", String.format(Locale.US, "translate(%.1f,%.1f)", translateX, translateY));
                ((Element)zoneNode).setAttribute("transform", String.format(Locale.US, "translate(%.1f,%.1f)", translateX, translateY));
            }
            return XMLUtils.writeToString(doc);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set zones positions in cleaned Svg", (Throwable)e);
            return cleanedSvg;
        }
    }

    @Override
    protected void cleanupEnding(Document doc, DOMNodeSelector selector) throws IOException, SAXException {
        super.cleanupEnding(doc, selector);
        HashMap<String, String[]> pointsPerZone = new HashMap<String, String[]>();
        try {
            Set nodes = selector.querySelectorAll("g.node[id^=zone_]");
            for (Node node : nodes) {
                Element nodeElement = (Element)node;
                String graphZoneId = nodeElement.getAttribute("id");
                String realZoneId = graphZoneId.replace("zone_", "");
                GraphSerializer.SerializedGraph zoneGraph = this.zonesGraphsCache.get(realZoneId);
                Document zoneDoc = XMLUtils.parse(zoneGraph.svg);
                DOMNodeSelector nodeSelector = new DOMNodeSelector((Node)nodeElement);
                Element polygon = (Element)nodeSelector.querySelector("polygon");
                String[] points = polygon.getAttribute("points").split(" ");
                Element textElement = (Element)nodeSelector.querySelector("text");
                nodeElement.removeChild(textElement);
                pointsPerZone.put(realZoneId, points);
                String[] newPoints = Arrays.copyOf(points, points.length);
                Double minX = Double.parseDouble(newPoints[1].split(",")[0]);
                Double minY = Double.parseDouble(newPoints[1].split(",")[1]);
                newPoints = this.updateTopPoints(polygon, newPoints, 22.0);
                this.shiftPoints(polygon, newPoints, minX, minY);
                if (!StringUtils.isBlank((CharSequence)this.zoomedZoneId) || !this.collapsedZones.contains(realZoneId)) {
                    Element svgNode = (Element)doc.importNode(zoneDoc.getDocumentElement(), true);
                    svgNode.setAttribute("x", String.valueOf(32.0));
                    svgNode.setAttribute("y", String.valueOf(76.0));
                    nodeElement.appendChild(svgNode);
                    nodeElement.setAttribute("data-id", graphZoneId);
                    nodeElement.setAttribute("data-type", "ZONE");
                    nodeElement.setAttribute("transform", String.format(Locale.US, "translate(%.1f,%.1f)", minX, minY));
                }
                this.addClass(nodeElement, "zone");
            }
            Set clusterNodes = selector.querySelectorAll("g.cluster[id^=cluster_zone_]");
            for (Node clusterNode : clusterNodes) {
                Element clusterElement = (Element)clusterNode;
                String graphZoneId = clusterElement.getAttribute("id");
                String realZoneId = graphZoneId.replace("cluster_zone_", "");
                String[] zonePoints = (String[])pointsPerZone.get(realZoneId);
                Double minX = Double.parseDouble(zonePoints[1].split(",")[0]);
                Double minY = Double.parseDouble(zonePoints[0].split(",")[1]);
                Element clusterPolygon = (Element)new DOMNodeSelector((Node)clusterElement).querySelector("polygon");
                if (clusterPolygon != null) {
                    this.shiftPoints(clusterPolygon, zonePoints, minX, minY);
                    clusterPolygon.removeAttribute("stroke");
                    clusterPolygon.removeAttribute("fill");
                }
                clusterElement.setAttribute("data-type", "ZONE");
                clusterElement.setAttribute("data-id", graphZoneId);
                clusterElement.setAttribute("transform", String.format(Locale.US, "translate(%.1f,%.1f)", minX, minY));
                this.addClass(clusterElement, "zone_cluster");
            }
        }
        catch (NodeSelectorException e) {
            logger.warn((Object)"Cannot select node representing the zones", (Throwable)e);
        }
    }

    private void shiftPoints(Element polygon, String[] points, Double minX, Double minY) {
        Object[] newPoints = new String[points.length];
        for (int i = 0; i < points.length; ++i) {
            String[] xy = points[i].split(",");
            newPoints[i] = String.format(Locale.US, "%.1f,%.1f", Double.parseDouble(xy[0]) - minX, Double.parseDouble(xy[1]) - minY);
        }
        polygon.setAttribute("points", StringUtils.join((Object[])newPoints, (String)" "));
    }

    private String[] updateTopPoints(Element polygon, String[] points, double heightTransform) {
        String[] xy = points[0].split(",");
        points[0] = String.format(Locale.US, "%s,%.1f", xy[0], Double.parseDouble(xy[1]) + heightTransform);
        xy = points[1].split(",");
        points[1] = String.format(Locale.US, "%s,%.1f", xy[0], Double.parseDouble(xy[1]) + heightTransform);
        xy = points[4].split(",");
        points[4] = String.format(Locale.US, "%s,%.1f", xy[0], Double.parseDouble(xy[1]) + heightTransform);
        polygon.setAttribute("points", StringUtils.join((Object[])points, (String)" "));
        return points;
    }

    private void addClass(Element element, String classToAdd) {
        String[] classes;
        String classRepresentation = element.getAttribute("class");
        for (String aClass : classes = classRepresentation.split(" ")) {
            if (!aClass.equals(classToAdd)) continue;
            return;
        }
        element.setAttribute("class", classRepresentation + " " + classToAdd);
    }

    private String getGlobalFlowZoneEmpty() {
        return String.format("<image xlink:href=\"%2$s\" height=\"%1$dpx\" width=\"%1$dpx\" transform=\"translate(32, -20)\"/>", 300, this.translationService.translate(this.lang, "FLOW.EMPTY_ZONE.IMAGE.HREF", "/static/dataiku/images/flow-empty-zone-global.svg", new Object[0]));
    }
}

