/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.locking;

import com.dataiku.dip.dataflow.kernel.master.locking.PrioritizationStrategy;
import com.google.common.base.Function;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class BalancedPrioritizationStrategy<PermitRequest extends PermitRequestWithGroup<GroupKey>, GroupKey>
implements PrioritizationStrategy<PermitRequest> {
    private EvictingQueue<GroupKey> history;
    private Function<PermitRequest, GroupKey> extractGroup = new Function<PermitRequest, GroupKey>(){

        public GroupKey apply(PermitRequest request) {
            return request.getPermitGroupKey();
        }
    };

    public BalancedPrioritizationStrategy(int memory) {
        this.history = EvictingQueue.create((int)memory);
    }

    @Override
    public int selectHighestPriorityPermit(List<PermitRequest> acquiredPermits, List<PermitRequest> waitingPermits) {
        HashMultiset acquiredPerGroup = HashMultiset.create((Iterable)FluentIterable.from(acquiredPermits).transform(this.extractGroup));
        HashMultiset historyPerGroup = HashMultiset.create(this.history);
        ImmutableSortedSet sortedGroups = FluentIterable.from(waitingPermits).transform(this.extractGroup).toSortedSet((Comparator)this.getOrderByCount((Multiset<GroupKey>)acquiredPerGroup).compound(this.getOrderByCount((Multiset<GroupKey>)historyPerGroup)));
        for (Object groupKey : sortedGroups) {
            for (int i = 0; i < waitingPermits.size(); ++i) {
                PermitRequestWithGroup ref = (PermitRequestWithGroup)waitingPermits.get(i);
                Object thisGroup = ref.getPermitGroupKey();
                if (!Objects.equals(thisGroup, groupKey)) continue;
                this.history.add(groupKey);
                return i;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    private Ordering<GroupKey> getOrderByCount(final Multiset<GroupKey> counters) {
        return Ordering.natural().onResultOf(new Function<GroupKey, Integer>(){

            public Integer apply(GroupKey groupKey) {
                return counters.count(groupKey);
            }
        });
    }

    public static interface PermitRequestWithGroup<GroupType> {
        public GroupType getPermitGroupKey();
    }
}

