/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.plugins.model.CustomCodeRecipeDesc;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeJobDefBuilder;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeMeta;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.recipes.customcode.SparkCustomCodeRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SparkSQLDialect;

public class CustomCodeRecipePipelineHelper
extends RecipePipelineHelper {
    private LoadedCustomCodeRecipeDesc pluginDesc;
    private SparkCustomCodeRecipeParams params;
    private boolean isValidConfiguration;

    public CustomCodeRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void initializeForSpark() {
        this.isValidConfiguration = false;
        RecipeMeta meta = RecipeRegistry.getMeta(this.recipe);
        if (meta instanceof CustomCodeRecipeMeta) {
            this.pluginDesc = ((CustomCodeRecipeMeta)meta).getPluginDesc();
            CustomCodeRecipeDesc recipeDesc = this.pluginDesc.desc;
            if (recipeDesc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.SPARK_SCALA && recipeDesc.codeMode == CodeMode.FUNCTION) {
                this.params = this.recipe.getParamsAs(SparkCustomCodeRecipeParams.class);
                if (this.params != null) {
                    this.isValidConfiguration = true;
                    this.allowPipelineStart = this.params.pipelineAllowStart;
                    this.allowPipelineMerge = this.params.pipelineAllowMerge;
                }
            }
        }
    }

    @Override
    protected void initializeForSql() {
        this.isValidConfiguration = false;
    }

    @Override
    boolean canSetSqlPipelineability() {
        return false;
    }

    @Override
    String setSparkPipelineability(boolean allowStart, boolean allowMerge) {
        throw new IllegalStateException("Should not come here");
    }

    @Override
    String setSqlPipelineability(boolean allowStart, boolean allowMerge) {
        throw new IllegalStateException("Should not come here");
    }

    @Override
    public String setPipelineability(boolean allowStart, boolean allowMerge) {
        this.params.pipelineAllowStart = allowStart;
        this.params.pipelineAllowMerge = allowMerge;
        return this.payload;
    }

    @Override
    protected String getEngineType() {
        return "SPARK";
    }

    @Override
    protected void assertConfiguration() {
        assert (this.isValidConfiguration());
    }

    @Override
    protected boolean isValidConfiguration() {
        return this.isValidConfiguration;
    }

    @Override
    protected boolean useGlobalMetastore() {
        return this.params.useGlobalMetastore;
    }

    @Override
    protected void finalizeElt(SparkPipelineDef.SparkPipelineElt elt, JobActivity activity, SparkSQLDialect dialect, ResourcesGatherer gatherer) throws Exception {
        elt.type = "spark_scala";
        elt.scala = new SparkScalaRecipeJobDefBuilder(activity, this.pluginDesc).build();
    }

    @Override
    protected SparkOverrideConfig sparkConfig() {
        return this.params.sparkConfig;
    }

    @Override
    protected AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine() {
        return this.params.executionEngine;
    }
}

