/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.memimpl;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HighlightedMemRow
extends MemRow {
    Map<Integer, List<int[]>> highlightedIndices = new HashMap<Integer, List<int[]>>();

    public HighlightedMemRow(MemTable table) {
        super(table);
    }

    public HighlightedMemRow(MemTable table, int[] cellLengths, char[] buffer) {
        super(table, cellLengths, buffer);
    }

    public void put(Column key, String value, List<int[]> highlightedIndices) {
        super.put(key, value);
        this.highlightedIndices.put(((MemColumn)key).index, highlightedIndices);
    }

    @Override
    public void delete(Column key) {
        super.delete(key);
        this.highlightedIndices.remove(((MemColumn)key).index);
    }

    @Override
    public void delete() {
        super.delete();
        this.highlightedIndices.clear();
    }

    @Override
    public int rewrite(int[] oldIndexes) {
        int l = super.rewrite(oldIndexes);
        HashMap<Integer, List<int[]>> newHighlightedIndices = new HashMap<Integer, List<int[]>>();
        for (int i = 0; i < oldIndexes.length; ++i) {
            if (!this.highlightedIndices.containsKey(oldIndexes[i])) continue;
            newHighlightedIndices.put(i, this.highlightedIndices.get(oldIndexes[i]));
        }
        this.highlightedIndices = newHighlightedIndices;
        return l;
    }

    public List<int[]> getHighlighted(Column key) {
        return this.highlightedIndices.get(((MemColumn)key).index);
    }

    @Override
    public long getMemoryUsed() {
        return super.getMemoryUsed();
    }
}

