/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.cassandra.AbstractCassandraDatasetHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ManagedDatasetsHelper {
    public static final String PARTITIONING_DIMENSION_DOES_NOT_MATCH_ANY_COLUMN = "Partitioning dimension does not match any column of this dataset schema";
    public static final String DSS_CANNOT_CREATE_TABLE_FOR_DISCRETE_VALUES = "DSS will not make the BigQuery table partitioned on discrete values automatically. Go to the Advanced settings tab to configure BigQuery native partitioning.";
    public static final String DSS_CAN_ONLY_CREATE_BIG_QUERY_TABLE_PARTITIONED_BY_DAY = "DSS can only make the BigQuery table partitioned by day.";
    public static final String PARTITIONING_CONFIGURATION_MISMATCH_BETWEEN_DATASET_AND_BIG_QUERY_TABLE = "Partitioning configuration mismatch between the dataset and the BigQuery table. Go to the Advanced settings tab to configure BigQuery native partitioning.";
    private static Logger logger = Logger.getLogger((String)"dku.datasets.managed.helper");

    public static void setStandardCSVUNIX(Dataset dataset) {
        dataset.setFormatType("csv");
        CSVFormatConfig cf = new CSVFormatConfig();
        cf.style = CSVFormatConfig.CSVStyle.UNIX;
        cf.setSeparatorStr("\t");
        cf.setQuoteStr("\"");
        cf.setEscapeStr("\\");
        cf.parseHeaderRow = false;
        cf.charset = "utf8";
        cf.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.json;
        ManagedDatasetsHelper.setMaxRowChars(cf);
        dataset.setFormatParams(cf);
    }

    public static void setStandardCSVUNIXWithHeader(Dataset dataset) {
        dataset.setFormatType("csv");
        CSVFormatConfig cf = new CSVFormatConfig();
        cf.style = CSVFormatConfig.CSVStyle.UNIX;
        cf.setSeparatorStr("\t");
        cf.setQuoteStr("\"");
        cf.setEscapeStr("\\");
        cf.parseHeaderRow = true;
        cf.charset = "utf8";
        cf.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.json;
        ManagedDatasetsHelper.setMaxRowChars(cf);
        dataset.setFormatParams(cf);
    }

    public static void setStandardCSVExcel(Dataset dataset) {
        dataset.setFormatType("csv");
        CSVFormatConfig cf = new CSVFormatConfig();
        cf.style = CSVFormatConfig.CSVStyle.EXCEL;
        cf.setSeparatorStr("\t");
        cf.setQuoteStr("\"");
        cf.setEscapeStr("\\");
        cf.parseHeaderRow = false;
        cf.charset = "utf8";
        cf.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.json;
        ManagedDatasetsHelper.setMaxRowChars(cf);
        dataset.setFormatParams(cf);
    }

    public static void setStandardCSVNoEscape(Dataset dataset) {
        dataset.setFormatType("csv");
        CSVFormatConfig cf = new CSVFormatConfig();
        cf.style = CSVFormatConfig.CSVStyle.NO_ESCAPE_NO_QUOTE;
        cf.setSeparatorStr("\t");
        cf.parseHeaderRow = false;
        cf.charset = "utf8";
        cf.arrayItemSeparator = "\u0002";
        cf.mapKeySeparator = "\u0003";
        cf.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.json;
        dataset.setFormatParams(cf);
    }

    public static void setStandardCSVEscapeOnly(Dataset dataset) {
        dataset.setFormatType("csv");
        CSVFormatConfig cf = new CSVFormatConfig();
        cf.style = CSVFormatConfig.CSVStyle.ESCAPE_ONLY_NO_QUOTE;
        cf.setSeparatorStr("\t");
        cf.parseHeaderRow = false;
        cf.charset = "utf8";
        cf.arrayItemSeparator = "\u0002";
        cf.mapKeySeparator = "\u0003";
        cf.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.json;
        ManagedDatasetsHelper.setMaxRowChars(cf);
        dataset.setFormatParams(cf);
    }

    private static void setMaxRowChars(CSVFormatConfig cf) {
        cf.setMaxRowChars(DKUApp.getParams().getIntParam("dku.input.formats.csv.maxRowChars", Integer.valueOf(100000000)));
    }

    public static void setFormat(Dataset dataset, String formatOptionId) {
        ManagedDatasetsCreationService cs2 = (ManagedDatasetsCreationService)SpringUtils.getBean(ManagedDatasetsCreationService.class);
        ManagedDatasetsCreationService.FormatOptionId fi = formatOptionId == null ? ManagedDatasetsCreationService.FormatOptionId.CSV_UNIX_GZIP : ManagedDatasetsCreationService.FormatOptionId.valueOf(formatOptionId);
        ManagedDatasetsCreationService.setFormat(dataset, fi);
    }

    public static void doTheUglyPartitioningDance(Dataset datasetToFixup, Schema schemaToFixup, Schema schemaBefore) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Fixup partitioning, datasetToFixup=" + JSON.json((Object)datasetToFixup) + " schemaToFixup=" + JSON.json((Object)schemaToFixup)));
        }
        boolean partitioningColumnMustBeInSchema = DatasetInspector.arePartitioningColumnsMandatoryInSchema(datasetToFixup);
        boolean partitioningColumnForbiddenInSchema = DatasetInspector.arePartitioningColumnsForbiddenInSchema(datasetToFixup);
        if (partitioningColumnForbiddenInSchema) {
            for (String dim : datasetToFixup.getPartitioningSchema().getDimensionNames()) {
                schemaToFixup.removeColumn(dim);
            }
        }
        if (partitioningColumnMustBeInSchema && datasetToFixup.getPartitioningSchema().isPartitioned()) {
            for (String dn : datasetToFixup.getPartitioningSchema().getDimensionNames()) {
                if (schemaToFixup.getColumn(dn) != null) continue;
                SchemaColumn columnBefore = schemaBefore.getColumn(dn);
                if (columnBefore != null) {
                    schemaToFixup.addColumn(dn, columnBefore.getType());
                    continue;
                }
                schemaToFixup.addColumn(dn, Type.STRING);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("After partitioning fixup, got schema: " + JSON.json((Object)schemaToFixup)));
        }
    }

    public static InfoMessage.InfoMessages fixupSchema(AuthCtx authCtx, Dataset datasetToFixup, Schema schemaToFixup, Schema schemaBefore) throws IOException, DKUSecurityException {
        ManagedDatasetsHelper.doTheUglyPartitioningDance(datasetToFixup, schemaToFixup, schemaBefore);
        return datasetToFixup.fixupSchemaPerDatasetConstraint(authCtx, schemaToFixup);
    }

    public static InfoMessage.InfoMessages copySchema(AuthCtx authCtx, Schema copyFrom, Dataset copyTo) throws IOException, DKUSecurityException {
        if (copyFrom == null) {
            return new InfoMessage.InfoMessages();
        }
        boolean sqlLikeOutput = DatasetInspector.isSQLOrHive(copyTo) || copyTo.getType().equals("MongoDB") || copyTo.getType().equals("Cassandra") || copyTo.getType().equals("DynamoDB");
        Schema newSchema = new Schema();
        for (SchemaColumn sc : copyFrom.getColumns()) {
            boolean isPartitionColumnInOutput = false;
            for (String dim : copyTo.getPartitioningSchema().getDimensionNames()) {
                if (!StringUtils.equals((String)dim, (String)sc.getName())) continue;
                isPartitionColumnInOutput = true;
            }
            if (isPartitionColumnInOutput) {
                if (!sqlLikeOutput) continue;
                newSchema.addColumn(sc);
                continue;
            }
            newSchema.addColumn(sc);
        }
        if (sqlLikeOutput && copyTo.getPartitioningSchema().isPartitioned()) {
            for (String dn : copyTo.getPartitioningSchema().getDimensionNames()) {
                if (newSchema.getColumn(dn) != null) continue;
                newSchema.addColumn(dn, Type.STRING);
            }
        }
        InfoMessage.InfoMessages ret = copyTo.fixupSchemaPerDatasetConstraint(authCtx, newSchema);
        copyTo.setSchema(newSchema);
        return ret;
    }

    public static void copyPartitioning(DatasetsDAO dao, Partitionable copyFrom, Dataset target) {
        Schema copyFromSchema;
        assert (target.isManaged());
        Schema schema = copyFromSchema = copyFrom instanceof Dataset ? ((Dataset)copyFrom).getSchema() : null;
        if (DatasetInspector.isSQLOrHive(target)) {
            logger.info((Object)("Copying partitioning schema for " + target.getName()));
            ArrayList missing = Lists.newArrayList();
            for (String dimensionName : copyFrom.getPartitioningSchema().getDimensionNames()) {
                Integer idx = target.getSchema().getColumnIndex(dimensionName);
                if (idx != null) continue;
                missing.add(dimensionName);
            }
            if (!missing.isEmpty()) {
                logger.info((Object)("Partitioning columns " + Joiner.on((String)",").join((Iterable)missing) + " are not in the schema"));
                for (String dimensionName : missing) {
                    SchemaColumn copyFromColumn;
                    SchemaColumn schemaColumn = copyFromColumn = copyFromSchema != null ? copyFromSchema.getColumn(dimensionName) : null;
                    if (copyFromColumn == null) {
                        target.getSchema().addColumn(dimensionName, Type.STRING);
                        continue;
                    }
                    target.getSchema().addColumn(copyFromColumn);
                }
            }
            target.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).partitioningType = "custom";
            target.setPartitioningScheme(copyFrom.getPartitioningSchema());
        } else if (target.getType().equals("MongoDB") || target.getType().equals("Cassandra") || target.getType().equals("DynamoDB") || target.getType().equals("ElasticSearch")) {
            logger.info((Object)("Copying partitioning schema for " + target.getName()));
            if (!copyFrom.getPartitioningSchema().isSingleDimension() && !target.getType().equals("ElasticSearch")) {
                throw ErrorContext.iaef((String)"Cannot create a managed %s dataset with multiple partition dimensions", (Object)target.getType(), (Object[])new Object[0]);
            }
            String dimensionName = (String)copyFrom.getPartitioningSchema().getDimensionNames().get(0);
            boolean schemaHasPartitioningColumn = false;
            for (SchemaColumn col : target.getSchema().getColumns()) {
                if (!col.getName().equals(dimensionName)) continue;
                schemaHasPartitioningColumn = true;
                break;
            }
            logger.info((Object)("Partitioning column is " + dimensionName + " it is in schema:" + schemaHasPartitioningColumn));
            if (!schemaHasPartitioningColumn) {
                SchemaColumn copyFromColumn;
                SchemaColumn schemaColumn = copyFromColumn = copyFromSchema != null ? copyFromSchema.getColumn(dimensionName) : null;
                if (copyFromColumn == null) {
                    target.getSchema().addColumn(dimensionName, Type.STRING);
                } else {
                    target.getSchema().addColumn(copyFromColumn);
                }
            }
            if (target.getType().equals("MongoDB")) {
                target.getParamsAs(MongoDBDatasetHandler.Config.class).partitioned = true;
                target.getParamsAs(MongoDBDatasetHandler.Config.class).partitioningColumn = dimensionName;
            } else if (target.getType().equals("Cassandra")) {
                target.getParamsAs(AbstractCassandraDatasetHandler.Config.class).partitioned = true;
                target.getParamsAs(AbstractCassandraDatasetHandler.Config.class).partitioningColumn = dimensionName;
            } else if (target.getType().equals("DynamoDB")) {
                target.getParamsAs(DynamoDBDatasetHandler.Config.class).partitioned = true;
                target.getParamsAs(DynamoDBDatasetHandler.Config.class).partitioningColumn = dimensionName;
            } else if (target.getType().equals("ElasticSearch")) {
                target.getParamsAs(ElasticSearchDatasetHandler.Config.class).partitioned = true;
                target.getParamsAs(ElasticSearchDatasetHandler.Config.class).partitioningColumn = dimensionName;
            }
            target.setPartitioningScheme(copyFrom.getPartitioningSchema());
        } else {
            PartitioningScheme partitioningSchemeFrom = copyFrom.getPartitioningSchema();
            target.setPartitioningScheme(ManagedDatasetsHelper.copyToFSLikePartitioning(partitioningSchemeFrom));
        }
        logger.info((Object)("Final schema : " + JSON.json((Object)new Schema(target.getSchema()))));
    }

    public static PartitioningScheme copyToFSLikePartitioning(PartitioningScheme partitioningSchemeFrom) {
        PartitioningScheme partitioningSchemeTarget = new PartitioningScheme();
        partitioningSchemeTarget.setIgnoreNonMatchingFile(true);
        Object pattern = "";
        for (String dimName : partitioningSchemeFrom.getDimensionNames()) {
            Dimension dim = partitioningSchemeFrom.getDimension(dimName);
            partitioningSchemeTarget.addDimension(dim);
            if (dim instanceof TimeDimension) {
                Object timePattern = "";
                switch (((TimeDimension)dim).mappedPeriod) {
                    case HOUR: {
                        timePattern = "/%H" + (String)timePattern;
                    }
                    case DAY: {
                        timePattern = "/%D" + (String)timePattern;
                    }
                    case MONTH: {
                        timePattern = "/%M" + (String)timePattern;
                    }
                    case YEAR: {
                        timePattern = "/%Y" + (String)timePattern;
                    }
                }
                pattern = (String)pattern + (String)timePattern;
                continue;
            }
            pattern = (String)pattern + "/%{" + dimName + "}";
        }
        pattern = (String)pattern + "/.*";
        partitioningSchemeTarget.setFilePathPattern((String)pattern);
        return partitioningSchemeTarget;
    }

    public static InfoMessage.InfoMessages checkPartitioningConfiguration(DatasetHandler.DatasetParams params, @Nullable PartitioningScheme partitioningScheme, @Nullable Schema schema) {
        if (partitioningScheme == null) {
            return new InfoMessage.InfoMessages();
        }
        if (params instanceof BigQueryDatasetConfig) {
            boolean bigQueryPartitioningEnabled;
            BigQueryDatasetConfig bqConfig = (BigQueryDatasetConfig)params;
            boolean datasetIsPartitioned = partitioningScheme.isPartitioned();
            boolean bl = bigQueryPartitioningEnabled = bqConfig.useBigQueryPartitioning && StringUtils.isNotBlank((String)bqConfig.bigQueryPartitioningField);
            if (datasetIsPartitioned) {
                if (schema == null) {
                    return new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_MISSING_SCHEMA, "No schema has been specified in the dataset settings");
                }
                Set columnNames = schema.getColumns().stream().map(SchemaColumn::getName).collect(Collectors.toSet());
                List dimensionNames = partitioningScheme.getDimensionNames();
                Optional<String> nonExistingColumn = dimensionNames.stream().filter(dimensionName -> !columnNames.contains(dimensionName)).findFirst();
                if (nonExistingColumn.isPresent()) {
                    return new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Partitioning dimension does not match any column of this dataset schema: " + nonExistingColumn.get());
                }
                if (partitioningScheme.isSingleDimension()) {
                    Dimension singleDimension = partitioningScheme.getSingleDimension();
                    if (!bigQueryPartitioningEnabled && singleDimension instanceof ExactValueDimension) {
                        return new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, DSS_CANNOT_CREATE_TABLE_FOR_DISCRETE_VALUES);
                    }
                    if (singleDimension instanceof TimeDimension) {
                        TimeDimension singleTimeDimension = (TimeDimension)singleDimension;
                        if (!TimeDimension.Period.DAY.equals((Object)singleTimeDimension.mappedPeriod)) {
                            return new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, DSS_CAN_ONLY_CREATE_BIG_QUERY_TABLE_PARTITIONED_BY_DAY);
                        }
                    }
                }
            }
            if (ManagedDatasetsHelper.hasBigQueryPartitionMismatch(bqConfig, partitioningScheme)) {
                return new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, PARTITIONING_CONFIGURATION_MISMATCH_BETWEEN_DATASET_AND_BIG_QUERY_TABLE);
            }
        }
        return new InfoMessage.InfoMessages();
    }

    /*
     * Unable to fully structure code
     */
    public static void autoConfigureNativePartitioningIfRelevant(SerializedDataset preExisting, DatasetHandler.DatasetParams params, PartitioningScheme partitioningScheme, Schema schema) {
        block6: {
            if (!(params instanceof BigQueryDatasetConfig)) break block6;
            bqConfig = (BigQueryDatasetConfig)params;
            if (preExisting != null && (var6_5 = preExisting.getParams()) instanceof BigQueryDatasetConfig) {
                oldBQConfig = (BigQueryDatasetConfig)var6_5;
                if (oldBQConfig.useBigQueryPartitioning) {
                    return;
                }
            }
            bigQueryPartitioningEnabled = bqConfig.useBigQueryPartitioning != false && StringUtils.isNotBlank((String)bqConfig.bigQueryPartitioningField) != false;
            v0 = isPartitionedBySingleDimension = partitioningScheme.isPartitioned() != false && partitioningScheme.isSingleDimension() != false;
            if (bigQueryPartitioningEnabled || !isPartitionedBySingleDimension) {
                return;
            }
            singleDimension = partitioningScheme.getSingleDimension();
            if (!(singleDimension instanceof TimeDimension)) ** GOTO lbl-1000
            singleTimeDimension = (TimeDimension)singleDimension;
            if (TimeDimension.Period.DAY.equals((Object)singleTimeDimension.mappedPeriod)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            isSingleDayTimeDimension = v1;
            partitioningColumn = schema.columns.stream().filter((Predicate<SchemaColumn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$autoConfigureNativePartitioningIfRelevant$1(com.dataiku.dip.partitioning.Dimension com.dataiku.dip.coremodel.SchemaColumn ), (Lcom/dataiku/dip/coremodel/SchemaColumn;)Z)((Dimension)singleDimension)).findFirst();
            v2 = partitionInSchemaAndTemporal = partitioningColumn.isPresent() != false && partitioningColumn.get().getType().isTemporal() != false;
            if (isSingleDayTimeDimension && partitionInSchemaAndTemporal) {
                bqConfig.useBigQueryPartitioning = true;
                bqConfig.bigQueryPartitioningField = singleDimension.getName();
                bqConfig.bigQueryPartitioningType = BigQueryDatasetConfig.PartitioningType.DATE;
            }
        }
    }

    private static boolean hasBigQueryPartitionMismatch(@NotNull BigQueryDatasetConfig bqConfig, @NotNull PartitioningScheme partitioningScheme) {
        boolean bigQueryPartitioningEnabled;
        boolean datasetIsPartitioned = partitioningScheme.isPartitioned();
        boolean bl = bigQueryPartitioningEnabled = bqConfig.useBigQueryPartitioning && StringUtils.isNotBlank((String)bqConfig.bigQueryPartitioningField);
        if (datasetIsPartitioned) {
            if (!bigQueryPartitioningEnabled) {
                return true;
            }
            String firstDimensionName = (String)partitioningScheme.getDimensionNames().get(0);
            if (!firstDimensionName.equals(bqConfig.bigQueryPartitioningField)) {
                return true;
            }
            Dimension dimension = partitioningScheme.getDimension(firstDimensionName);
            if (dimension instanceof ExactValueDimension && !BigQueryDatasetConfig.PartitioningType.RANGE.equals((Object)bqConfig.bigQueryPartitioningType)) {
                return true;
            }
            return dimension instanceof TimeDimension && !BigQueryDatasetConfig.PartitioningType.DATE.equals((Object)bqConfig.bigQueryPartitioningType);
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$autoConfigureNativePartitioningIfRelevant$1(Dimension singleDimension, SchemaColumn col) {
        return col.getName().equals(singleDimension.getName());
    }
}

