/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColumnStorageTypeInferer;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SchemaDetection {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.schema");

    public static void addCustomFieldsToDetectedSchema(Schema currentSchema, Schema detectedSchema) {
        if (detectedSchema == null || currentSchema == null) {
            return;
        }
        HashMap<String, JsonObject> currentSchemaCustomFieldsMap = new HashMap<String, JsonObject>();
        for (SchemaColumn sc : currentSchema.getColumns()) {
            if (sc.customFields == null) continue;
            currentSchemaCustomFieldsMap.put(sc.getName(), sc.customFields);
        }
        for (SchemaColumn sc : detectedSchema.getColumns()) {
            sc.customFields = (JsonObject)currentSchemaCustomFieldsMap.get(sc.getName());
        }
    }

    public static void updateDetectionResultWithCommentCheck(SchemaDetectionResult ret, Schema currentSchema, Schema detectedSchema) {
        int i;
        if (detectedSchema == null || currentSchema == null || detectedSchema.getColumns().size() != currentSchema.getColumns().size()) {
            logger.warn((Object)"comment consistency check failed: detectedSchema and currentSchema are inconsistent");
            return;
        }
        for (i = 0; i < currentSchema.getColumns().size(); ++i) {
            String dssColumnName;
            String dbColumnName = StringUtils.defaultString((String)((SchemaColumn)currentSchema.getColumns().get(i)).getName());
            if (dbColumnName.equalsIgnoreCase(dssColumnName = StringUtils.defaultString((String)((SchemaColumn)detectedSchema.getColumns().get(i)).getName()))) continue;
            logger.warn((Object)"comment consistency check failed: detectedSchema and currentSchema are inconsistent");
            return;
        }
        for (i = 0; i < currentSchema.getColumns().size(); ++i) {
            String dssColumnComment;
            String dbColumnComment = StringUtils.defaultString((String)((SchemaColumn)detectedSchema.getColumns().get((int)i)).comment);
            if (dbColumnComment.equals(dssColumnComment = StringUtils.defaultString((String)((SchemaColumn)currentSchema.getColumns().get((int)i)).comment))) continue;
            String warningString = String.format("%s column: '%s' in %s, '%s' in %s", ((SchemaColumn)detectedSchema.getColumns().get(i)).getName(), dbColumnComment, "table metadata", dssColumnComment, "dss schema");
            ret.textReasons.add(warningString);
            ret.needsCommentSynchronization = true;
            ret.setWarningLevel(WarningLevel.WARN);
            logger.warn((Object)("Column descriptions do not match between DSS schema and table metadata: " + warningString));
            break;
        }
    }

    public static SchemaDetectionResult handleDetectionResult(SchemaHandlingType type, Schema currentDatasetSchema, Mode mode, ColumnFactory detected) {
        Schema detectedSchema = new Schema();
        for (Column col : detected.columns()) {
            detectedSchema.addColumn(col.getName(), Type.STRING);
        }
        return SchemaDetection.handleDetectionResult(type, currentDatasetSchema, mode, detectedSchema);
    }

    public static SchemaDetectionResult handleDetectionResult(SchemaHandlingType type, Schema currentDatasetSchema, Mode mode, Schema detected) {
        return SchemaDetection.handleDetectionResult(type, currentDatasetSchema, mode, detected, true);
    }

    public static SchemaDetectionResult handleDetectionResult(SchemaHandlingType type, Schema currentDatasetSchema, Mode mode, Schema detected, boolean keepDssColumnComments) {
        logger.infoV("Schema detection type=%s mode=%s currentColumns=%d detectedColumns=%d", new Object[]{type, mode, currentDatasetSchema == null ? -1 : currentDatasetSchema.getColumns().size(), detected == null ? -1 : detected.getColumns().size()});
        SchemaDetectionResult ret = new SchemaDetectionResult();
        ret.usedMode = mode;
        ret.type = type;
        if (detected == null || detected.getColumns().size() == 0) {
            ret.newSchema = new Schema(currentDatasetSchema);
            return ret;
        }
        Schema detectedSchema = new Schema();
        for (int i = 0; i < detected.getColumns().size(); ++i) {
            SchemaColumn newCol = new SchemaColumn((SchemaColumn)detected.getColumns().get(i));
            if (currentDatasetSchema != null && currentDatasetSchema.getColumns().size() > i) {
                if (keepDssColumnComments) {
                    newCol.comment = ((SchemaColumn)currentDatasetSchema.getColumns().get((int)i)).comment;
                }
                newCol.customFields = (JsonObject)JSON.deepCopy((Object)((SchemaColumn)currentDatasetSchema.getColumns().get((int)i)).customFields);
            }
            detectedSchema.addColumn(newCol);
        }
        ret.detectedSchema = new Schema(detectedSchema);
        if (currentDatasetSchema == null || currentDatasetSchema.getColumns().size() == 0) {
            ret.newSchema = new Schema(detected);
            return ret;
        }
        switch (mode) {
            case DETECTION_PREFER_DATA: {
                ret.newSchema = ret.detectedSchema;
                break;
            }
            case CONSISTENCY_CHECK: 
            case DETECTION_PREFER_USER_AND_WARN: 
            case DETECTION_ONLY_TYPES: {
                boolean incompatible = false;
                ret.newSchema = new Schema(currentDatasetSchema);
                HashMap<String, SchemaColumn> currentColumns = new HashMap<String, SchemaColumn>();
                HashMap<String, SchemaColumn> detectedColumns = new HashMap<String, SchemaColumn>();
                for (SchemaColumn col : currentDatasetSchema.getColumns()) {
                    currentColumns.put(col.getName(), col);
                }
                for (SchemaColumn col : detected.getColumns()) {
                    detectedColumns.put(col.getName(), col);
                }
                switch (type) {
                    case FIXED_TYPE_AND_SCHEMA: {
                        try {
                            SchemaReader.isSchemaCompatible(detected, currentDatasetSchema, "data", "schema", true);
                        }
                        catch (IllegalArgumentException e) {
                            ret.setWarningLevel(WarningLevel.FATAL);
                            ret.textReasons.add(e.getMessage());
                            incompatible = true;
                        }
                        break;
                    }
                    case NAME_BASED_VARIABLE_COLUMNS: {
                        for (Map.Entry curEntry : currentColumns.entrySet()) {
                            if (detectedColumns.get(curEntry.getKey()) != null) continue;
                            ret.setWarningLevel(WarningLevel.INFO);
                            ret.inSchemaButNotDetected.add((String)curEntry.getKey());
                        }
                        for (Map.Entry detectedEntry : detectedColumns.entrySet()) {
                            SchemaColumn schemaCol = (SchemaColumn)currentColumns.get(detectedEntry.getKey());
                            if (schemaCol != null) continue;
                            ret.setWarningLevel(WarningLevel.INFO);
                            ret.detectedButNotInSchema.add((String)detectedEntry.getKey());
                        }
                        break;
                    }
                    case TEXT_POSITION_BASED_FIXED_COLUMNS: 
                    case TEXT_POSITION_BASED_VARIABLE_COLUMNS: {
                        if (detected.getColumns().size() == currentDatasetSchema.getColumns().size()) break;
                        incompatible = true;
                        ret.setWarningLevel(WarningLevel.WARN);
                        ret.textReasons.add(String.format("Mismatch in number of columns: %d in schema, %d detected in data", currentDatasetSchema.getColumns().size(), detectedColumns.size()));
                    }
                }
                if (mode != Mode.DETECTION_ONLY_TYPES) break;
                if (!incompatible && currentDatasetSchema.getColumns().size() == detected.getColumns().size()) {
                    for (int i = 0; i < detected.getColumns().size(); ++i) {
                        ((SchemaColumn)ret.newSchema.getColumns().get(i)).setType(((SchemaColumn)detected.getColumns().get(i)).getType());
                    }
                    break;
                }
                ret.setWarningLevel(WarningLevel.WARN);
                ret.textReasons.add(String.format((incompatible ? "Compatibility warnings during inference" : "Column count changed") + ". Ignoring detected types.", new Object[0]));
            }
        }
        return ret;
    }

    public static Schema buildDetectedSchemaWithStorageTypesInference(MemTable sampleMT) {
        Schema detectedSchema = new Schema();
        block0: for (Column col : sampleMT.columns()) {
            ColumnStorageTypeInferer storageTypeInferer = new ColumnStorageTypeInferer();
            int nbNotEmpty = 0;
            for (MemRow row : sampleMT.rows) {
                String val = row.get(col);
                if (val == null) continue;
                ++nbNotEmpty;
                storageTypeInferer.invalidateStorageTypes(val);
            }
            if (nbNotEmpty == 0) {
                detectedSchema.addColumn(col.getName(), Type.STRING);
                continue;
            }
            Type[] fromBestToWorst = ColumnStorageTypeInferer.getFromBestToWorst();
            EnumSet<Type> stillStorable = storageTypeInferer.getStillStorable();
            for (Type t : fromBestToWorst) {
                if (!stillStorable.contains(t)) continue;
                detectedSchema.addColumn(col.getName(), t);
                continue block0;
            }
        }
        return detectedSchema;
    }

    public static class SchemaDetectionResult {
        public Mode usedMode;
        public SchemaHandlingType type;
        public Schema newSchema;
        public Schema detectedSchema;
        public WarningLevel warningLevel;
        public boolean needsCommentSynchronization;
        public List<String> detectedButNotInSchema = new ArrayList<String>();
        public List<String> inSchemaButNotDetected = new ArrayList<String>();
        public List<String> textReasons = new ArrayList<String>();
        public boolean makesSenseToInferStorageTypes = false;

        public void setWarningLevel(WarningLevel lvl) {
            if (this.warningLevel == null || lvl.compareTo(this.warningLevel) > 0) {
                this.warningLevel = lvl;
            }
        }
    }

    public static enum WarningLevel {
        INFO,
        WARN,
        FATAL;

    }

    public static enum SchemaHandlingType {
        FIXED_TYPE_AND_SCHEMA,
        TEXT_POSITION_BASED_FIXED_COLUMNS,
        TEXT_POSITION_BASED_VARIABLE_COLUMNS,
        NAME_BASED_VARIABLE_COLUMNS;

    }

    public static enum Mode {
        DETECTION_PREFER_DATA,
        DETECTION_PREFER_USER_AND_WARN,
        CONSISTENCY_CHECK,
        DETECTION_ONLY_TYPES;

    }
}

