/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class ElasticSearchDeleteOutputProcessor
implements ProcessorOutput {
    private final ElasticSearchIndex esIndex;
    private final Column idCol;
    private final Column indexCol;
    private final String bulkAddress;
    private final String targetIndex;
    private JSONObject delete;
    private final StringBuilder sb = new StringBuilder();
    private int count;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.elasticsearch.delete");

    public ElasticSearchDeleteOutputProcessor(ElasticSearchIndex esIndex, String targetIndex, ColumnFactory cf) {
        this.esIndex = esIndex;
        this.bulkAddress = esIndex.address + "_bulk";
        this.targetIndex = targetIndex;
        this.idCol = cf.column("_id");
        this.indexCol = cf.column("_index");
        this.delete = new JSONObject().put("_index", (Object)targetIndex).put("_id", (Object)"");
        if (esIndex.dialect.hasType) {
            this.delete = this.delete.put("_type", (Object)esIndex.type);
        }
    }

    public void emitRow(Row row) throws Exception {
        this.sb.append("{\"delete\":").append(this.delete.put("_id", (Object)row.get(this.idCol)).put("_index", (Object)row.get(this.indexCol)).toString()).append("}\n");
        if ((long)this.count++ % this.esIndex.frameSize == 0L) {
            this.push();
        }
    }

    public void lastRowEmitted() throws Exception {
        logger.info((Object)("Last row emitted. Count=" + this.count));
        if (this.sb.length() > 0) {
            this.push();
        }
        this.esIndex.refreshAndFlush(this.targetIndex, true);
    }

    public void cancel() throws Exception {
    }

    public void setMaxMemoryUsed(long size) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push() throws IOException {
        if (this.sb.length() == 0) {
            logger.info((Object)"Nothing to send to ElasticSearch");
            return;
        }
        logger.infoV("Deleting rows from ElasticSearch (total=%d) with address %s [%s/%s]", new Object[]{this.count, this.esIndex.address, this.targetIndex, this.esIndex.typeUrl});
        HttpPost put = new HttpPost(this.bulkAddress);
        put.setEntity((HttpEntity)new StringEntity(this.sb.toString(), ElasticSearchIndex.REQ_CONTENT_TYPE));
        HttpResponse resp = this.esIndex.execute((HttpUriRequest)put, false, "Send bulk failed", new int[0]);
        String tresp = null;
        try {
            tresp = ElasticSearchUtils.tryToGetString(resp.getEntity().getContent());
            JSONObject jresp = new JSONObject(tresp);
            if (jresp.has("errors") && jresp.getBoolean("errors")) {
                logger.warn((Object)("Errors encountered while deleting from ElasticSearch: " + tresp));
            } else {
                logger.info((Object)"Successfully deleted");
            }
            this.sb.setLength(0);
        }
        catch (JSONException e) {
            logger.warn((Object)("Failed to parse ElasticSearch response " + tresp), (Throwable)e);
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }
}

