/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FileFormatDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetTestHandler;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.utils.GsonEnumTypeAdapterFactory;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FSLikeDatasetTestHandler
extends FileFormatDatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    protected AbstractFSDatasetHandler handlerForData;
    protected DatasetHandler handlerForName;
    protected AuthCtx authCtx;

    public FSLikeDatasetTestHandler(AuthCtx authCtx, AbstractFSDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(dataset);
        this.authCtx = authCtx;
        this.handlerForData = handlerForData;
        this.handlerForName = (DatasetHandler)Preconditions.checkNotNull((Object)handlerForName);
    }

    public void setHandlerForName(DatasetHandler handlerForName) throws IOException {
        if (this.handlerForName != null) {
            try {
                this.handlerForName.close();
            }
            finally {
                this.handlerForName = null;
            }
        }
        this.handlerForName = handlerForName;
    }

    @Override
    public void close() throws IOException {
        if (this.handlerForData != null) {
            try {
                this.handlerForData.close();
            }
            finally {
                this.handlerForData = null;
            }
        }
        if (this.handlerForName != null) {
            try {
                this.handlerForName.close();
            }
            finally {
                this.handlerForName = null;
            }
        }
    }

    @Override
    protected StreamsInputSplit getSampleSplitForShapeFile() throws Exception {
        return ((FilesystemDatasetTestHandler)this).getMultiFileSampleSplit();
    }

    @Override
    protected String suggestName() throws Exception {
        return DatasetInspector.slufigyAndUnicize(this.dataset.getProjectKey(), this.handlerForName.suggestName(), this.dao, this.transactionService);
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        FSLikeDatasetTestResult result = this.testFormat(this.authCtx, true, false);
        ret.empty = result.empty;
        if (result.format != null) {
            ret.result = result.format.schemaDetection;
        }
        return ret;
    }

    @UIModel
    public static class FSLikeDatasetTestResult {
        public String suggestedName;
        public boolean connectionOK;
        public SerializedError connectionError;
        public Map<String, String> connectionMetadata = new HashMap<String, String>();
        public boolean empty;
        public String fileForDetectionPath;
        public long fileForDetectionSize;
        public DetectedFormat format;
    }

    public static class DetectedFormat {
        public String type;
        public FormatParams params;
        public Map<String, String> metadata = new HashMap<String, String>();
        public boolean ok = true;
        public String errorMessage;
        public double detectionScore;
        public int nbOK;
        public int nbNOK;
        public int percentage;
        public List<String> nokExamples = new ArrayList<String>();
        public SerializedMemTableSimple table;
        public SchemaDetection.SchemaDetectionResult schemaDetection;

        static {
            JSON.registerAdapter(DetectedFormat.class, (Object)new JSON.Adapter<DetectedFormat>(){

                public DetectedFormat deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    DetectedFormat ret = new DetectedFormat();
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ret.ok = (Boolean)jsonDeserializationContext.deserialize(jsonObj.get("ok"), Boolean.class);
                    ret.errorMessage = (String)jsonDeserializationContext.deserialize(jsonObj.get("errorMessage"), String.class);
                    ret.detectionScore = (Double)jsonDeserializationContext.deserialize(jsonObj.get("detectionScore"), Double.class);
                    ret.nbOK = (Integer)jsonDeserializationContext.deserialize(jsonObj.get("nbOK"), Integer.class);
                    ret.nbNOK = (Integer)jsonDeserializationContext.deserialize(jsonObj.get("nbNOK"), Integer.class);
                    ret.percentage = (Integer)jsonDeserializationContext.deserialize(jsonObj.get("percentage"), Integer.class);
                    ret.nokExamples = (List)jsonDeserializationContext.deserialize(jsonObj.get("nokExamples"), List.class);
                    ret.table = (SerializedMemTableSimple)jsonDeserializationContext.deserialize(jsonObj.get("table"), SerializedMemTableSimple.class);
                    ret.schemaDetection = (SchemaDetection.SchemaDetectionResult)jsonDeserializationContext.deserialize(jsonObj.get("schemaDetection"), SchemaDetection.SchemaDetectionResult.class);
                    ret.metadata = (Map)jsonDeserializationContext.deserialize(jsonObj.get("metadata"), Map.class);
                    if (jsonObj.has("type")) {
                        ret.type = jsonObj.get("type").getAsString();
                        ret.params = (FormatParams)jsonDeserializationContext.deserialize(jsonObj.get("params"), FormatFactory.getMeta(ret.type).paramsClass());
                    }
                    return ret;
                }

                public JsonElement serialize(DetectedFormat fmt, Type type, JsonSerializationContext ctx) {
                    return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonEnumTypeAdapterFactory()).create().toJsonTree((Object)fmt);
                }
            });
        }
    }
}

