/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DirectoryAwareFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.FilesystemDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class FilesystemDatasetHandler
extends DirectoryAwareFSDatasetHandler<FilesystemDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.file");

    public FilesystemDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        logger.info((Object)("Building Filesystem handler config: " + JSON.json((Object)this.resolvedConfig)));
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, DKUSecurityException, CodedException {
        FsConnection connection = (FsConnection)this.getConnection();
        connection.params.root = VariablesUtils.expand(this.dataset.getProjectKey(), connection.params.root);
        String providerPath = path == null ? VariablesUtils.expand(this.dataset.getProjectKey(), ((FilesystemDatasetConfig)this.resolvedConfig).path) : path;
        FSProvider provider = FSProviderFactory.getProvider("Filesystem", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, connection);
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    protected DSSConnection getConnection() throws IOException, DKUSecurityException {
        if (StringUtils.isBlank((String)((FilesystemDatasetConfig)this.resolvedConfig).connection)) {
            FsConnection connection = new FsConnection();
            connection.params.root = "/";
            return connection;
        }
        return ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((FilesystemDatasetConfig)this.resolvedConfig).connection, FsConnection.class);
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException, CodedException {
        this.getProvider();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.FS_META;
    }

    public File getRoot() throws IOException, DKUSecurityException, CodedException {
        if (this.isSingleFile()) {
            return new File(this.getTypedProvider().getRoot(), this.getSingleFile());
        }
        return new File(this.getTypedProvider().getRoot());
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        return this.getRoot().getAbsolutePath();
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new FilesystemDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }
}

