/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.com.microsoft.graph.models.DriveItem;
import com.dataiku.dss.shadelib.com.microsoft.graph.options.Option;
import com.dataiku.dss.shadelib.com.microsoft.graph.requests.DriveItemCollectionPage;
import com.dataiku.dss.shadelib.com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.dataiku.dss.shadelib.com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SharePointOnlineFSProvider
extends FSLikeFSProvider
implements PathToURIConverter {
    private final SharePointOnlineConnection connection;
    private final AuthCtx authCtx;
    private final ProxySettings proxySettings;
    private String site;
    private String drive;
    private final String root;
    private long listSize;
    private final int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
    private final SharePointClientInitializer clientInitializer;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.sharepointonline");
    private static DKULogger actionsLogger = DKULogger.getLogger((String)"dku.fs.sharepoint.actions");

    public void makeEmpty(String path) throws IOException, DKUSecurityException {
        String fullPath = PathUtils.concatLNT((String[])new String[]{this.root, path});
        logger.infoV("makeEmpty %s", new Object[]{fullPath});
        PathUtils.ensurePathStaysWithinRoot((String)fullPath);
        this.client().deleteFile(this.siteId(), this.driveId(), fullPath);
    }

    public void ensureDirectory(String path) throws IOException, DKUSecurityException {
    }

    public SharePointOnlineFSProvider(AuthCtx authCtx, DSSConnection connection, String root, ProxySettings proxySettings, boolean useCachedAccessToken, String providedSiteId, String siteName, String providedDriveId, String driveName) throws IOException {
        this.authCtx = authCtx;
        this.connection = (SharePointOnlineConnection)connection;
        this.proxySettings = proxySettings;
        this.root = root;
        this.clientInitializer = new SharePointClientInitializer(this.connection, this.authCtx, this.proxySettings, providedSiteId, siteName, providedDriveId, driveName);
    }

    public SharePointOnlineFSProvider(AuthCtx authCtx, DSSConnection connection, String root, ProxySettings proxySettings, String providedSiteId, String siteName, String providedDriveId, String driveName) throws IOException {
        this(authCtx, connection, root, proxySettings, true, providedSiteId, siteName, providedDriveId, driveName);
    }

    private SharePointOnlineConnection.SharePointOnlineClient client() throws IOException {
        return this.clientInitializer.getSettings().client();
    }

    private String siteId() throws IOException {
        return this.clientInitializer.getSettings().siteId();
    }

    private String driveId() throws IOException {
        return this.clientInitializer.getSettings().driveId();
    }

    private void checkConnectionWritability() {
        if (!this.connection.allowWrite) {
            throw new IllegalArgumentException("Cannot write on connection " + this.connection.name);
        }
    }

    public void close() throws IOException {
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException, CodedException {
        String normalizedRelativePath = PathUtils.slashes((String)PathUtils.canonical((String)path), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
        FSBrowsePath ret = FSBrowsePath.makeRoot((String)normalizedRelativePath, (boolean)false);
        DriveItemCollectionPage children = null;
        DriveItem driveItem = null;
        driveItem = this.client().getItem(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, normalizedRelativePath}));
        if (driveItem == null) {
            ret.exists = false;
            return ret;
        }
        logger.infoV("Browsing Sharepoint %s with strategy %s", new Object[]{path, strategy});
        if (driveItem.folder != null && (strategy == FSProvider.FSBrowseStrategy.DIRECTORY || strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY)) {
            ret.directory = true;
            children = this.client().getChildren(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, normalizedRelativePath}));
            List currentPage = children.getCurrentPage();
            logger.info((Object)"Begin browsing directory");
            while (children != null) {
                for (DriveItem childItem : currentPage) {
                    FSBrowsePath child = FSBrowsePath.makeChild((FSBrowsePath)ret, (String)childItem.name, (childItem.folder != null ? 1 : 0) != 0, (long)childItem.size, (long)(1000L * childItem.lastModifiedDateTime.toEpochSecond()));
                    if (childItem.folder != null) {
                        child.size = childItem.folder.childCount.intValue();
                    }
                    ret.children.add(child);
                    if (ret.children.size() <= this.enumerationLimit) continue;
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this SharePoint drive (> %d). Enumeration aborted.", this.enumerationLimit));
                }
                logger.infoV("Added current page to result list. Stats: %s items", new Object[]{ret.size});
                DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)children.getNextPage();
                if (nextPage != null) {
                    logger.info((Object)"Continue browsing next page");
                    children = (DriveItemCollectionPage)((DriveItemCollectionRequest)nextPage.buildRequest(new Option[0])).get();
                    currentPage = children.getCurrentPage();
                    continue;
                }
                break;
            }
        } else if (strategy == FSProvider.FSBrowseStrategy.FILE || strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY) {
            ret.directory = false;
            ret.size = driveItem.size;
            ret.lastModified = 1000L * driveItem.lastModifiedDateTime.toEpochSecond();
        }
        logger.infoV("Finished browsing %s. Stats: %s items", new Object[]{path, ret.size});
        return ret;
    }

    public SharePointOnlineEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) {
        String normalizedRelativePath = PathUtils.slashes((String)PathUtils.canonical((String)prefix), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
        try {
            this.listSize = 0L;
            List<FSPath> paths = this.enumerateFilesystem(normalizedRelativePath, enumerationSettings);
            if (paths == null) {
                return SharePointOnlineEnumerationResult.fromNonExistingPrefix();
            }
            return SharePointOnlineEnumerationResult.fromPaths(enumerationSettings.filter(paths));
        }
        catch (Exception e) {
            return SharePointOnlineEnumerationResult.fromError(e);
        }
    }

    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings settings) throws IOException, DKUSecurityException {
        DriveItemCollectionRequestBuilder nextPage;
        ArrayList ret = Lists.newArrayList();
        DriveItemCollectionPage childrenCollectionPage = null;
        logger.infoV("Enumerating file system with prefix %s", new Object[]{prefix});
        DriveItem item = this.client().getItem(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, prefix}));
        if (item != null && item.file != null) {
            logger.info((Object)"Item exists, adding it to result");
            ret.add(new FSPath(prefix, item.size.longValue(), item.lastModifiedDateTime.toEpochSecond() * 1000L));
            return ret;
        }
        try {
            logger.infoV("Getting children of %s", new Object[]{prefix});
            childrenCollectionPage = this.client().getChildren(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, prefix}));
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting children of " + prefix + " : "), (Throwable)e);
        }
        if (childrenCollectionPage == null) {
            logger.infoV("No children found for %s", new Object[]{prefix});
            return null;
        }
        List childrenCurrentPage = new ArrayList();
        do {
            try {
                logger.infoV("Getting current page for child of %s", new Object[]{prefix});
                childrenCurrentPage = childrenCollectionPage.getCurrentPage();
            }
            catch (Exception e) {
                logger.error((Object)("Error while getting current page for child of " + prefix + " : "), (Throwable)e);
                if (ret.isEmpty()) {
                    return null;
                }
                return ret;
            }
            for (DriveItem child : childrenCurrentPage) {
                if (child.folder != null) {
                    logger.info((Object)"Detected folder. Recursively enumerating path.");
                    List<FSPath> fsPaths = this.enumerateFilesystem(PathUtils.concatLNT((String[])new String[]{prefix, child.name}), settings);
                    if (fsPaths != null) {
                        ret.addAll(fsPaths);
                        this.listSize += (long)fsPaths.size();
                    }
                } else {
                    ret.add(new FSPath(PathUtils.concatLNT((String[])new String[]{prefix, child.name}), child.size.longValue(), child.lastModifiedDateTime.toEpochSecond() * 1000L));
                    ++this.listSize;
                    if (settings.firstNonEmpty && child.size > 0L) {
                        logger.info((Object)"Returning first non empty item.");
                        return ret;
                    }
                }
                if (settings.totalSizeLimit >= 0L && this.listSize >= settings.totalSizeLimit) {
                    logger.infoV("Reached totalSizeLimit (%s)", new Object[]{settings.totalSizeLimit});
                    return ret;
                }
                if (this.listSize > (long)this.enumerationLimit) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this SharePoint drive (> %d). Enumeration aborted.", this.enumerationLimit));
                }
                logger.infoV("Iterating on next child of current page. Stats: found %s items", new Object[]{this.listSize});
            }
            logger.infoV("All children from current page added. Stats: found %s items", new Object[]{this.listSize});
        } while ((childrenCollectionPage = (nextPage = (DriveItemCollectionRequestBuilder)childrenCollectionPage.getNextPage()) == null ? null : (DriveItemCollectionPage)((DriveItemCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
        logger.infoV("SharePoint enumeration done. Found %s items", new Object[]{this.listSize});
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public FSPathOrDirectory stat(String path) throws IOException, CodedException, DKUSecurityException {
        String normalizedRelativePath = PathUtils.slashes((String)PathUtils.canonical((String)path), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
        DriveItem driveItem = null;
        try {
            logger.infoV("Stats: Sharepoint getting item at %s", new Object[]{path});
            driveItem = this.client().getItem(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, normalizedRelativePath}));
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting item ", (Throwable)e);
        }
        if (driveItem == null) {
            logger.info((Object)"Item not found");
            return null;
        }
        return new FSPathOrDirectory(normalizedRelativePath, driveItem.size.longValue(), 1000L * driveItem.lastModifiedDateTime.toEpochSecond(), driveItem.folder != null);
    }

    public EnrichedInputStream read(String path) throws IOException, CodedException, DKUSecurityException {
        logger.infoV("Reading path %s", new Object[]{path});
        PathUtils.ensurePathStaysWithinRoot((String)path);
        String normalizedRelativePath = PathUtils.slashes((String)PathUtils.canonical((String)path), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
        DriveItem driveItem = null;
        try {
            driveItem = this.client().getItem(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, normalizedRelativePath}));
        }
        catch (Exception e) {
            logger.error((Object)("Error while reading the file " + path), (Throwable)e);
            throw e;
        }
        if (driveItem == null) {
            throw new IOException("Cannot read " + path + " because the file doesn't exist");
        }
        return new SharePointOnlineEnrichedInputStream(-1L, this.siteId(), this.driveId(), this.root, normalizedRelativePath, new FSPath(normalizedRelativePath), this.client());
    }

    public OutputStream write(String path) throws IOException, CodedException, DKUSecurityException {
        logger.infoV("Checking Sharepoint connection write permission on path %s", new Object[]{path});
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)path);
        OutputStream outputStream = this.client().getOutputStream(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, path}));
        logger.infoV("Obtained writing stream on path %s", new Object[]{path});
        return outputStream;
    }

    public void setLastModified(String path, long lastModified) throws IOException, CodedException, DKUSecurityException {
        logger.infoV("Set lastModified %s", new Object[]{path});
        throw new UnsupportedOperationException("Set last modified on SharePoint Online is not supported");
    }

    public void deleteRecursive(String path) throws IOException, CodedException, DKUSecurityException {
        logger.infoV("Deleting recursively %s", new Object[]{path});
        this.checkConnectionWritability();
        this.deleteDirectory(path);
    }

    @Override
    public String getConnectionRootWithinURIAuthority() {
        return null;
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public boolean deleteFile(String path) throws IOException, CodedException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        String fullPath = PathUtils.concatLNT((String[])new String[]{this.root, path});
        logger.infoV("Deleting file %s", new Object[]{fullPath});
        this.checkConnectionWritability();
        return this.client().deleteFile(this.siteId(), this.driveId(), fullPath);
    }

    @Override
    public boolean deleteDirectory(String path) throws IOException, CodedException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        String fullPath = PathUtils.concatLNT((String[])new String[]{this.root, path});
        logger.infoV("Deleting directory %s", new Object[]{fullPath});
        this.checkConnectionWritability();
        return this.client().deleteFile(this.siteId(), this.driveId(), fullPath);
    }

    public void moveDirectory(String from, String to) throws IOException, CodedException, DKUSecurityException {
        logger.infoV("Moving directory %s to %s", new Object[]{from, to});
        this.moveFile(from, to);
    }

    public void moveFile(String from, String to) throws IOException, CodedException, DKUSecurityException {
        logger.infoV("Moving file from %s to %s", new Object[]{from, to});
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        DriveItem itemFrom = this.client().getItem(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, from}));
        String itemFromId = itemFrom.id;
        String parent = PathUtils.getParent((String)to);
        DriveItem itemTo = this.client().getItem(this.siteId(), this.driveId(), PathUtils.concatLNT((String[])new String[]{this.root, parent}));
        String itemToId = itemTo.id;
        this.client().moveFile(this.siteId(), this.driveId(), itemFromId, itemToId, PathUtils.getLastPathSegment((String)to));
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, CodedException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        if (StringUtils.isEmpty((String)this.site)) {
            this.site = this.client().getSiteName(this.siteId());
        }
        if (StringUtils.isEmpty((String)this.drive)) {
            this.drive = this.client().getDriveName(this.siteId(), this.driveId());
        }
        ret.put("site", this.site);
        ret.put("siteId", this.siteId());
        ret.put("drive", this.drive);
        ret.put("driveId", this.driveId());
        ret.put("root", this.root);
        if (withSensitiveInfo && this.connection.detailsReadableBy(this.authCtx)) {
            ret.put("tenantId", this.connection.params.tenantId);
            ret.put("appId", this.connection.params.appId);
            ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (Map)ret);
        }
        return ret;
    }

    public String convertPathToURI(String path) {
        return null;
    }

    private static class SharePointClientInitializer {
        private SharepointConnectionSettings settings = null;
        private final SharePointOnlineConnection connection;
        private final AuthCtx authCtx;
        private final ProxySettings proxySettings;
        private final String providedSiteId;
        private final String siteName;
        private final String providedDriveId;
        private final String driveName;

        public SharePointClientInitializer(SharePointOnlineConnection connection, AuthCtx authCtx, ProxySettings proxySettings, String providedSiteId, String siteName, String providedDriveId, String driveName) {
            this.connection = connection;
            this.authCtx = authCtx;
            this.proxySettings = proxySettings;
            this.providedSiteId = providedSiteId;
            this.siteName = siteName;
            this.providedDriveId = providedDriveId;
            this.driveName = driveName;
        }

        public synchronized SharepointConnectionSettings getSettings() throws IOException {
            if (this.settings == null) {
                try {
                    String resolvedDriveId;
                    String resolvedSiteId;
                    SharePointOnlineConnection.SharePointOnlineClient newClient = this.connection.getSharePointOnlineClient(this.authCtx, this.proxySettings);
                    if (StringUtils.isNotBlank((String)this.siteName) && StringUtils.isBlank((String)this.providedSiteId)) {
                        resolvedSiteId = newClient.getSiteId(this.siteName);
                        if (resolvedSiteId == null) {
                            throw new IllegalArgumentException("Site '" + this.siteName + "' does not exist");
                        }
                    } else if (StringUtils.isNotBlank((String)this.providedSiteId)) {
                        resolvedSiteId = this.providedSiteId;
                    } else {
                        throw new IllegalArgumentException("Select a site or provide a site ID");
                    }
                    if (StringUtils.isNotBlank((String)this.driveName) && StringUtils.isBlank((String)this.providedDriveId)) {
                        resolvedDriveId = newClient.getDriveId(resolvedSiteId, this.driveName);
                        if (resolvedDriveId == null) {
                            throw new IllegalArgumentException("Drive '" + this.driveName + "' does not exist in site '" + (StringUtils.isNotBlank((String)this.siteName) ? this.siteName : resolvedSiteId) + "'");
                        }
                    } else if (StringUtils.isNotBlank((String)this.providedDriveId)) {
                        resolvedDriveId = this.providedDriveId;
                    } else {
                        throw new IllegalArgumentException("Select a drive or provide a drive ID");
                    }
                    this.settings = new SharepointConnectionSettings(newClient, resolvedSiteId, resolvedDriveId);
                    logger.debug((Object)"Done creating SharePoint client via initializer");
                }
                catch (IOException e) {
                    throw new IOException("Failed to initialize SharePoint client", e);
                }
            }
            return this.settings;
        }
    }

    private record SharepointConnectionSettings(SharePointOnlineConnection.SharePointOnlineClient client, String siteId, String driveId) {
    }

    static class SharePointOnlineEnumerationResult
    extends AbstractFSEnumerationResult {
        public SharePointOnlineEnumerationResult() {
        }

        public SharePointOnlineEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public SharePointOnlineEnumerationResult(Throwable error) {
            super(error);
        }

        private static SharePointOnlineEnumerationResult fromError(Throwable error) {
            return new SharePointOnlineEnumerationResult(error);
        }

        private static SharePointOnlineEnumerationResult fromPaths(List<FSPath> paths) {
            return new SharePointOnlineEnumerationResult(paths);
        }

        private static SharePointOnlineEnumerationResult fromNonExistingPrefix() {
            return new SharePointOnlineEnumerationResult();
        }
    }

    public static class SharePointOnlineEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final String file;
        private final String root;
        private final String pathWithinProvider;
        private final String siteId;
        private final String driveId;
        private final SharePointOnlineConnection.SharePointOnlineClient client;

        public SharePointOnlineEnrichedInputStream(long basicInputStreamSize, String siteId, String driveId, String root, String pathWithinProvider, FSPath filename, SharePointOnlineConnection.SharePointOnlineClient client) {
            super(basicInputStreamSize, pathWithinProvider, FilenameUtils.getName((String)filename.path()), filename.toString(), () -> SharePointOnlineEnrichedInputStream.getLatestLastModified(client, siteId, driveId, root, pathWithinProvider));
            this.file = filename.toString();
            this.siteId = siteId;
            this.driveId = driveId;
            this.pathWithinProvider = pathWithinProvider;
            this.client = client;
            this.root = root;
        }

        private static void checkClientInitialized(SharePointOnlineConnection.SharePointOnlineClient client) {
            if (client == null) {
                throw new IllegalStateException("SharePoint client not initialized");
            }
        }

        private static long getLatestLastModified(SharePointOnlineConnection.SharePointOnlineClient client, String siteId, String driveId, String root, String pathWithinProvider) {
            SharePointOnlineEnrichedInputStream.checkClientInitialized(client);
            DriveItem driveItem = client.getItem(siteId, driveId, PathUtils.concatLNT((String[])new String[]{root, pathWithinProvider}));
            return 1000L * driveItem.lastModifiedDateTime.toEpochSecond();
        }

        protected InputStream getBasicInputStream() throws IOException, InterruptedException, CodedException, DKUSecurityException {
            SharePointOnlineEnrichedInputStream.checkClientInitialized(this.client);
            logger.debug((Object)("Getting basic input stream for " + this.getFilename() + " pathWithinProvider:" + this.pathWithinProvider + " siteId:" + this.siteId + " driveId:" + this.driveId + " file:" + this.file + " root:" + this.root));
            return this.client.getFileInputStream(this.siteId, this.driveId, PathUtils.concatLNT((String[])new String[]{this.root, this.pathWithinProvider}));
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException, InterruptedException, CodedException, DKUSecurityException {
            SharePointOnlineEnrichedInputStream.checkClientInitialized(this.client);
            logger.info((Object)"Getting basic head input stream");
            return this.client.getFileInputStream(this.siteId, this.driveId, PathUtils.concatLNT((String[])new String[]{this.root, this.pathWithinProvider}));
        }
    }
}

