/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.hdfs;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.springframework.beans.factory.annotation.Autowired;

public class HDFSPermissionsSynchronizer {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private PasswordEncryptionService cryptoService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.hdfs.permissions");

    public HDFSPermissionsSynchronizer() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void setConnectionRootACL(AuthCtx authCtx, HDFSConnection conn) throws IOException, InterruptedException, DKUSecurityException {
        String connectionRootPathURISchemeAndAuthority;
        HDFSConnection.RootAndExtraConf rec = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), HDFSConnection.RootAndExtraConf.class);
        logger.info((Object)("Setting root ACL on connection: " + conn.name + " at path: " + rec.root));
        try {
            URI connectionRootURI = new URI(StringUtils.defaultIfEmpty((String)rec.root, (String)""));
            connectionRootPathURISchemeAndAuthority = connectionRootURI.getScheme() != null && connectionRootURI.getAuthority() != null ? connectionRootURI.getScheme() + "://" + connectionRootURI.getAuthority() : null;
        }
        catch (URISyntaxException e) {
            throw new IOException("Incorrect URI for connection root", e);
        }
        ArrayList fsExtraConf = Lists.newArrayList();
        try {
            HadoopSettings hadoopSettings = new ClusterSelector().selectGlobal().getHadoopSettings();
            fsExtraConf.addAll(hadoopSettings.extraConf.getAsSimpleKeyValueList());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get Hadoop settings:", e);
        }
        fsExtraConf.addAll(rec.getExtraConfAsSimpleKeyValue());
        FileSystem niFS = HadoopLoader.getFS(connectionRootPathURISchemeAndAuthority, fsExtraConf);
        Path rootPath = new Path(rec.root);
        if (!niFS.isDirectory(rootPath)) {
            niFS.mkdirs(rootPath);
        }
        HDFSPermissionsUtils utils = new HDFSPermissionsUtils();
        List<AclEntry> acls = utils.getConnectionLevelACL();
        logger.info((Object)("Setting ACLs on connection root: " + String.valueOf(rootPath) + ": " + String.valueOf(acls)));
        niFS.setAcl(rootPath, acls);
    }

    private void maybeSetPermissionsOnDataset(AuthCtx authCtx, InfoMessage.InfoMessages ret, String projectKey, SerializedDataset sd, HDFSConnection onlyOnConn) throws DKUSecurityException {
        if (sd.type.equals("HDFS")) {
            HDFSDatasetHandler.Config config = sd.getParamsAs(HDFSDatasetHandler.Config.class);
            if (onlyOnConn == null || onlyOnConn.name.equals(config.connection)) {
                logger.info((Object)("Need to sync perms for dataset: " + sd.name));
                Dataset dataset = Dataset.fromSerialized(projectKey + "." + sd.name, sd);
                try (HDFSDatasetHandler handler = new HDFSDatasetHandler(authCtx, dataset, false);){
                    HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(handler);
                    permHandler.setGatewayACLNoCreate(authCtx);
                    permHandler.setDataUsabilityAndDeletabilityACL(authCtx);
                }
                catch (Exception e) {
                    logger.error((Object)("Permissions sync failed for dataset: " + sd.projectKey + "." + sd.name), (Throwable)e);
                    ret.withFatal((InfoMessage.MessageCode)SyncCode.ERR_HDFSSYNC_ACL_SYNC_FAILED, "dataset: " + sd.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
        } else if (DatasetInspector.isHDFSInsideUploaded(authCtx, sd, this.connectionsDAO)) {
            logger.info((Object)"UploadedFiles dataset on HDFS, sync underlying HDFS dataset");
            try {
                Dataset dataset = Dataset.fromSerialized(projectKey + "." + sd.name, sd);
                try (UploadedFilesDatasetHandler udh = (UploadedFilesDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                    Dataset realDataset = udh.getRealDataset();
                    this.maybeSetPermissionsOnDataset(authCtx, ret, projectKey, realDataset.serialize(), onlyOnConn);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get real dataset of UploadedFiles dataset: " + sd.projectKey + "." + sd.name), (Throwable)e);
                ret.withFatal((InfoMessage.MessageCode)SyncCode.ERR_HDFSSYNC_ACL_SYNC_FAILED, "dataset: " + sd.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    private void maybeSetPermissionsOnFolder(AuthCtx authCtx, InfoMessage.InfoMessages ret, String projectKey, ManagedFolder folder, HDFSConnection onlyOnConn) throws IOException {
        if (folder.getType().equals("HDFS")) {
            HDFSDatasetHandler.Config config = folder.getParamsAs(HDFSDatasetHandler.Config.class);
            if (onlyOnConn == null || onlyOnConn.name.equals(config.connection)) {
                logger.info((Object)("Need to sync perms for folder : " + folder.name + " " + folder.id));
                try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(authCtx);){
                    try {
                        HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(handler);
                        permHandler.setGatewayACLNoCreate(authCtx);
                        permHandler.setDataUsabilityAndDeletabilityACL(authCtx);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Permissions sync failed for folder: " + folder.projectKey + "." + folder.id), (Throwable)e);
                        ret.withFatal((InfoMessage.MessageCode)SyncCode.ERR_HDFSSYNC_ACL_SYNC_FAILED, "folder: " + folder.id + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                }
            }
        }
    }

    public InfoMessage.InfoMessages setPermissionsOnProjectDatasets_NT(AuthCtx authCtx, String projectKey) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        logger.info((Object)("Setting all dataset ACLs in project " + projectKey));
        List datasets = null;
        List folders = null;
        try (Transaction t = this.transactionService.beginRead();){
            datasets = this.datasetsDAO.listUnsafe(projectKey);
            folders = this.managedFolderDAO.listUnsafe(projectKey);
        }
        for (SerializedDataset sd : datasets) {
            this.maybeSetPermissionsOnDataset(authCtx, ret, projectKey, sd, null);
        }
        for (ManagedFolder mf : folders) {
            this.maybeSetPermissionsOnFolder(authCtx, ret, projectKey, mf, null);
        }
        return ret;
    }

    public InfoMessage.InfoMessages setPermissionsOnDataset_NT(AuthCtx authCtx, String projectKey, SerializedDataset sd) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        logger.info((Object)("Setting ACLs in project " + projectKey + " on dataset " + sd.name));
        this.maybeSetPermissionsOnDataset(authCtx, ret, projectKey, sd, null);
        return ret;
    }

    public InfoMessage.InfoMessages setPermissionsOnConnectionDatasets_NT(AuthCtx authCtx, HDFSConnection conn) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        logger.info((Object)("Setting all dataset ACLs: " + conn.name + " at path: " + conn.getUnresolvedRootForDisplayOnly()));
        ArrayList<SerializedDataset> datasets = new ArrayList<SerializedDataset>();
        ArrayList<ManagedFolder> folders = new ArrayList<ManagedFolder>();
        try (Transaction t = this.transactionService.beginRead();){
            for (String projectKey : this.projectsService.listKeys()) {
                logger.info((Object)("Syncing for project: " + projectKey));
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                    datasets.add(sd);
                }
                for (ManagedFolder mf : this.managedFolderDAO.listUnsafe(projectKey)) {
                    folders.add(mf);
                }
            }
        }
        for (SerializedDataset sd : datasets) {
            this.maybeSetPermissionsOnDataset(authCtx, ret, sd.projectKey, sd, conn);
        }
        for (ManagedFolder mf : folders) {
            this.maybeSetPermissionsOnFolder(authCtx, ret, mf.projectKey, mf, conn);
        }
        return ret;
    }

    public static FuturePayload buildProjectSyncFuturePayload(String projectKey) {
        FuturePayload fp = new FuturePayload();
        fp.action = "sync_acls";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, ITaggingService.TaggableType.PROJECT.name()).withPart("acls"));
        fp.displayName = "Sync HDFS ACLs for " + projectKey;
        return fp;
    }

    public static FuturePayload buildConnectionSyncFuturePayload(HDFSConnection connection, boolean root) {
        FuturePayload fp = new FuturePayload();
        fp.action = "sync_acls";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(connection.name, "CONNECTION").withPart("acls"));
        fp.withExtra("root", (Object)root);
        fp.displayName = "Sync HDFS ACLs for connection " + connection.name;
        return fp;
    }

    public FutureResponse<InfoMessage.InfoMessages> startSetPermissionsOnProjectDatasets_NT(AuthCtx authCtx, String projectKey) throws Exception {
        return this.futureService.runFuture(new ProjectSyncThread(authCtx, projectKey), 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public FutureResponse<InfoMessage.InfoMessages> startSetPermissionsOnConnectionDatasets(AuthCtx authCtx, String connectionName) throws Exception {
        HDFSConnection conn = this.connectionsDAO.getMandatoryConnectionAs(authCtx, connectionName, HDFSConnection.class);
        logger.info((Object)("Resyncing ACLs on connection " + conn.name));
        return this.futureService.runFuture(new ConnectionSyncThread(authCtx, conn), 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public FutureResponse<Void> startSetPermissionsOnConnectionRoot(AuthCtx authCtx, String connectionName) throws Exception {
        HDFSConnection conn = this.connectionsDAO.getMandatoryConnectionAs(authCtx, connectionName, HDFSConnection.class);
        logger.info((Object)("Resyncing ACLs on connection " + conn.name));
        return this.futureService.runFuture(new ConnectionRootSyncThread(authCtx, conn), 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    public static enum SyncCode implements InfoMessage.MessageCode
    {
        ERR_HDFSSYNC_ACL_SYNC_FAILED("HDFS ACL sync failed", InfoMessage.FixabilityCategory.UNKNOWN);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private SyncCode(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    private class ProjectSyncThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final String projectKey;
        private final FuturePayload futurePayload;

        public ProjectSyncThread(AuthCtx owner, String projectKey) {
            super(owner);
            this.projectKey = projectKey;
            this.futurePayload = HDFSPermissionsSynchronizer.buildProjectSyncFuturePayload(projectKey);
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            return HDFSPermissionsSynchronizer.this.setPermissionsOnProjectDatasets_NT(this.owner, this.projectKey);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    private class ConnectionSyncThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final HDFSConnection connection;
        private final FuturePayload futurePayload;

        public ConnectionSyncThread(AuthCtx owner, HDFSConnection connection) {
            super(owner);
            this.connection = connection;
            this.futurePayload = HDFSPermissionsSynchronizer.buildConnectionSyncFuturePayload(connection, false);
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            return HDFSPermissionsSynchronizer.this.setPermissionsOnConnectionDatasets_NT(this.owner, this.connection);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    private class ConnectionRootSyncThread
    extends SimpleFutureThread<Void> {
        private final HDFSConnection connection;
        private final FuturePayload futurePayload;

        public ConnectionRootSyncThread(AuthCtx owner, HDFSConnection connection) {
            super(owner);
            this.connection = connection;
            this.futurePayload = HDFSPermissionsSynchronizer.buildConnectionSyncFuturePayload(connection, true);
        }

        @Override
        protected Void compute() throws Exception {
            HDFSPermissionsSynchronizer.this.setConnectionRootACL(this.owner, this.connection);
            return null;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }
}

