/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.mongodb.MongoDBConnectionWrapper;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBTypeConverter;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;

public class MongoDBOutput
implements Output {
    private final Dataset dataset;
    private final Partition targetPartition;
    private final WarningsContext warnContext;
    private final AuthCtx authCtx;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.mongodb");

    public MongoDBOutput(AuthCtx authCtx, Dataset dataset, Partition targetPartition, WarningsContext wc) {
        assert (dataset.getType().equals("MongoDB"));
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.warnContext = wc;
        this.authCtx = authCtx;
    }

    public OutputWriter getWriter(Output.WriteMode writeMode) throws IOException {
        try {
            return new MongoDBOutputWriter(writeMode);
        }
        catch (DKUSecurityException e) {
            throw new IOException("Failed to create writer", e);
        }
    }

    public class MongoDBOutputWriter
    extends OutputWriter {
        private final MongoDBConnectionWrapper mongoConn;
        private final MongoCollection<Document> collection;
        private ColumnFactory cf;
        private List<SchemaColumn> schemaColumns;
        private SchemaColumn partitioningColumn;
        private final HashSet<String> schemaColumnNames = new HashSet();
        private final long maxBatchSize = 0x200000L;
        private final List<Document> batch = new ArrayList<Document>(100);
        private long batchSize = 0L;
        private final Output.WriteMode writeMode;
        private final MongoDBTypeConverter typeConverter = new MongoDBTypeConverter();
        private final MongoDBDatasetHandler.Config datasetConfig;

        public MongoDBOutputWriter(Output.WriteMode writeMode) throws IOException, DKUSecurityException {
            String connectionName = MongoDBOutput.this.dataset.getParamsAs(MongoDBDatasetHandler.Config.class).connection;
            String collectionName = MongoDBOutput.this.dataset.getParamsAs(MongoDBDatasetHandler.Config.class).collection;
            logger.info((Object)("Connecting to database, connection=" + connectionName));
            this.mongoConn = MongoDBConnectionWrapper.get(MongoDBOutput.this.authCtx, connectionName);
            this.collection = this.mongoConn.db.getCollection(collectionName);
            this.datasetConfig = MongoDBOutput.this.dataset.getParamsAs(MongoDBDatasetHandler.Config.class);
            this.writeMode = writeMode;
        }

        public void init(ColumnFactory cf) throws Exception {
            this.cf = cf;
            this.schemaColumns = MongoDBOutput.this.dataset.getSchema().getColumns();
            String partitioningColumnName = MongoDBOutput.this.dataset.getParamsAs(MongoDBDatasetHandler.Config.class).partitioningColumn;
            for (SchemaColumn sc : this.schemaColumns) {
                String colName = sc.getName();
                this.schemaColumnNames.add(colName);
                if (!colName.equals(partitioningColumnName)) continue;
                this.partitioningColumn = sc;
            }
            if (this.writeMode == Output.WriteMode.OVERWRITE) {
                String collectionName = this.collection.getNamespace().getCollectionName();
                if (MongoDBOutput.this.dataset.isManaged()) {
                    if (partitioningColumnName == null) {
                        logger.info((Object)("Dropping collection: " + collectionName));
                        this.collection.drop();
                        this.mongoConn.db.createCollection(collectionName);
                    } else {
                        logger.info((Object)("Deleting partition contents for collection: " + collectionName + " with column " + partitioningColumnName));
                        this.collection.deleteOne((Bson)new BasicDBObject(partitioningColumnName, (Object)MongoDBOutput.this.targetPartition.id()));
                        this.collection.createIndex((Bson)new BasicDBObject(partitioningColumnName, (Object)1));
                    }
                } else {
                    Object deleteObj;
                    String queryParam;
                    BasicDBObject partitionObj = null;
                    DBObject queryObj = null;
                    if (partitioningColumnName != null) {
                        partitionObj = new BasicDBObject(partitioningColumnName, (Object)MongoDBOutput.this.targetPartition.id());
                    }
                    if ((queryParam = MongoDBOutput.this.dataset.getParamsAs(MongoDBDatasetHandler.Config.class).query) != null && !queryParam.isEmpty()) {
                        try {
                            queryObj = (DBObject)JSON.parse((String)queryParam, Object.class);
                        }
                        catch (JsonParseException e) {
                            logger.warn((Object)("invalid JSON query : " + queryParam + " : " + e.getMessage()));
                            throw e;
                        }
                    }
                    if (partitionObj != null && queryObj != null) {
                        BasicDBList l = new BasicDBList();
                        l.add((Object)partitionObj);
                        l.add((Object)queryObj);
                        deleteObj = new BasicDBObject("$and", (Object)l);
                    } else {
                        deleteObj = partitionObj != null ? partitionObj : (queryObj != null ? queryObj : new BasicDBObject());
                    }
                    logger.info((Object)("Deleting partition contents for collection: " + collectionName + " with query " + String.valueOf(deleteObj)));
                    this.collection.deleteOne((Bson)new BasicDBObject(deleteObj.toMap()));
                }
            }
        }

        public void emitRow(Row row) throws Exception {
            String colValue;
            String colName;
            Document obj = new Document();
            long objSize = 20L;
            for (SchemaColumn sc : this.schemaColumns) {
                colName = sc.getName();
                if (sc == this.partitioningColumn) {
                    obj.put(colName, (Object)MongoDBOutput.this.targetPartition.id());
                    objSize += (long)(colName.length() + MongoDBOutput.this.targetPartition.id().length());
                    continue;
                }
                colValue = row.get(this.cf.column(colName));
                if (colValue == null || colValue.isEmpty()) continue;
                obj.put(colName, this.typeConverter.toMongoValue(colValue, sc, this.datasetConfig.writeDataTypeMismatchBehavior, MongoDBOutput.this.warnContext));
                objSize += (long)(colName.length() + colValue.length());
            }
            if (!this.datasetConfig.strictOutputFormat) {
                for (Column col : this.cf.columns()) {
                    colName = col.getName();
                    if (this.schemaColumnNames.contains(colName) || (colValue = row.get(col)) == null) continue;
                    obj.put(colName, this.typeConverter.toMongoValue(colValue));
                    objSize += (long)(colName.length() + colValue.length());
                }
            }
            this.batch.add(obj);
            this.batchSize += objSize;
            if (this.batchSize >= 0x200000L) {
                this.collection.insertMany(this.batch);
                this.batch.clear();
                this.batchSize = 0L;
            }
        }

        public void lastRowEmitted() throws Exception {
            try {
                if (!this.batch.isEmpty()) {
                    this.collection.insertMany(this.batch);
                    this.batch.clear();
                    this.batchSize = 0L;
                }
            }
            finally {
                this.mongoConn.close();
            }
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }

        public void cancel() throws Exception {
            this.mongoConn.close();
        }
    }
}

