/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sharepointonline;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListDatasetHandler;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListTypeConverter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.GsonBuilder;
import com.dataiku.dss.shadelib.com.microsoft.graph.models.ColumnDefinition;
import com.dataiku.dss.shadelib.com.microsoft.graph.models.FieldValueSet;
import com.dataiku.dss.shadelib.com.microsoft.graph.models.ListItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharePointOnlineListOutput
implements Output {
    private final Dataset dataset;
    private final Partition targetPartition;
    private final WarningsContext warnContext;
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sharepointonlinelist");

    public SharePointOnlineListOutput(AuthCtx authCtx, Dataset dataset, Partition targetPartition, WarningsContext warningsContext) {
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.warnContext = warningsContext;
        this.authCtx = authCtx;
    }

    public OutputWriter getWriter(Output.WriteMode writeMode) throws IOException, DKUSecurityException, InterruptedException, CodedException {
        logger.info((Object)("getWriter with writeMode=" + writeMode.toString()));
        try {
            return new SharePointOnlineListOutputWriter(ConnectionsDAO.get(), writeMode);
        }
        catch (Exception e) {
            throw new IOException("Failed to create writer", e);
        }
    }

    private class SharePointOnlineListOutputWriter
    extends OutputWriter {
        private String listId;
        private final String siteId;
        private final StorageTypeVerifier.DataTypeMismatchBehavior readDataTypeMismatchBehavior;
        private final StorageTypeVerifier.DataTypeMismatchBehavior writeDataTypeMismatchBehavior;
        private ColumnFactory columnFactory;
        private List<SchemaColumn> schemaColumns;
        private Output.WriteMode writeMode;
        SharePointOnlineConnection.SharePointOnlineClient client;
        private SharePointOnlineListDatasetHandler.Config datasetConfig;
        private SharePointOnlineListTypeConverter typeConverter = new SharePointOnlineListTypeConverter();
        private List<ColumnDefinition> allSharePointColumns;
        private List<String> readOnlyColumns = new ArrayList<String>();
        private boolean useBatchWrite;
        private boolean truncateInsteadOfDelete;
        Map<String, String> columnDisplayNameToName = new HashMap<String, String>();
        private String sharePointList;

        public SharePointOnlineListOutputWriter(ConnectionsDAO connectionsDAO, Output.WriteMode writeMode) throws IOException, DKUSecurityException {
            this.writeMode = writeMode;
            SharePointOnlineListDatasetHandler.Config params = SharePointOnlineListOutput.this.dataset.getParamsAs(SharePointOnlineListDatasetHandler.Config.class);
            String connectionName = params.connection;
            String sharePointSite = params.sharePointSite;
            this.sharePointList = params.sharePointList;
            String sharepointSiteId = params.siteId;
            String sharePointListId = params.listId;
            boolean useBatchWrite = params.useBatchWrite;
            boolean truncateInsteadOfDelete = params.truncateInsteadOfDelete;
            logger.info((Object)("Connecting to database, connection=" + connectionName));
            SharePointOnlineConnection connection = connectionsDAO.getMandatoryConnectionAs(SharePointOnlineListOutput.this.authCtx, connectionName, SharePointOnlineConnection.class);
            ProxySettings proxySettings = connection.getProxySettings();
            this.client = connection.getSharePointOnlineClient(SharePointOnlineListOutput.this.authCtx, proxySettings);
            this.siteId = sharepointSiteId == null || sharepointSiteId.isBlank() ? this.client.getSiteId(sharePointSite) : sharepointSiteId;
            this.listId = sharePointListId == null || sharePointListId.isBlank() ? this.client.getListId(this.siteId, this.sharePointList) : sharePointListId;
            logger.info((Object)("Targeted list: " + this.siteId + " / " + this.listId));
            this.datasetConfig = params;
            this.readDataTypeMismatchBehavior = this.datasetConfig.readDataTypeMismatchBehavior;
            this.writeDataTypeMismatchBehavior = this.datasetConfig.writeDataTypeMismatchBehavior;
            this.useBatchWrite = useBatchWrite;
            this.truncateInsteadOfDelete = truncateInsteadOfDelete;
            if (useBatchWrite) {
                logger.info((Object)"Batch write mode activated");
            }
            if (truncateInsteadOfDelete) {
                logger.info((Object)"Overwrite mode is : truncate");
            } else {
                logger.info((Object)"Overwrite mode is : delete and recreate");
            }
        }

        private String getSharePointColumnId(String columnName) {
            String sharePointColumnId = null;
            for (ColumnDefinition sharePointColumn : this.allSharePointColumns) {
                if (!sharePointColumn.displayName.equals(columnName)) continue;
                sharePointColumnId = sharePointColumn.name;
                break;
            }
            return sharePointColumnId;
        }

        private boolean isColumnReadOnly(String columnName) {
            return this.readOnlyColumns.contains(columnName);
        }

        public void emitRow(Row row) throws Exception {
            ListItem requestBody = new ListItem();
            requestBody.fields = new FieldValueSet();
            Gson gson = new GsonBuilder().create();
            for (SchemaColumn schemaColumn : this.schemaColumns) {
                String colValue;
                String columnDisplayName = schemaColumn.getName();
                String columnName = this.columnDisplayNameToName.get(columnDisplayName);
                if (columnName == null) {
                    columnName = columnDisplayName;
                }
                if (this.isColumnReadOnly(columnName) || (colValue = row.get(this.columnFactory.column(columnDisplayName))) == null || colValue.isEmpty()) continue;
                if (colValue.length() > 255) {
                    logger.warn((Object)("Cell in column '" + columnName + "' truncated to 255 characters"));
                    colValue = colValue.substring(0, 255);
                }
                Object object = this.typeConverter.toSharePointValue(colValue, schemaColumn, this.writeDataTypeMismatchBehavior, SharePointOnlineListOutput.this.warnContext);
                requestBody.fields.additionalDataManager().put((Object)this.getSharePointColumnId(columnDisplayName), (Object)gson.toJsonTree(object, object.getClass()));
            }
            if (this.useBatchWrite) {
                this.client.batchPutRow(this.siteId, this.listId, requestBody);
            } else {
                this.client.putRow(this.siteId, this.listId, requestBody);
            }
        }

        public void lastRowEmitted() throws Exception {
            this.client.flushListRowsAndRetry();
        }

        public void cancel() throws Exception {
        }

        private List<SchemaColumn> computeMissingSharePointColumns(List<SchemaColumn> dssColumns, List<ColumnDefinition> sharePointColumns) {
            ArrayList<SchemaColumn> missingColumns = new ArrayList<SchemaColumn>();
            for (SchemaColumn dssColumn : dssColumns) {
                String dssColumnName = dssColumn.getName();
                String foundColumnName = "";
                boolean columnFound = false;
                for (ColumnDefinition sharePointColumn : sharePointColumns) {
                    String sharePointColumnName = sharePointColumn.displayName;
                    if (!sharePointColumnName.equals(dssColumnName)) continue;
                    columnFound = true;
                    foundColumnName = sharePointColumn.name;
                }
                if (columnFound) {
                    this.columnDisplayNameToName.put(dssColumnName, foundColumnName);
                    logger.info((Object)("Column " + dssColumnName + " found in the SharePoint list (" + foundColumnName + "). No need to create it"));
                    continue;
                }
                logger.info((Object)("Column " + dssColumnName + " not found in the SharePoint list. Has to create it"));
                missingColumns.add(dssColumn);
            }
            return missingColumns;
        }

        public void init(ColumnFactory columnFactory) throws Exception {
            this.listId = this.client.getListId(this.siteId, this.sharePointList);
            if (this.listId == null) {
                throw new Exception("The list ID could not be found. Check that the SharePoint list still exists. If it does, perform the site and list selection once again in the targeted dataset settings.");
            }
            if (this.writeMode == Output.WriteMode.OVERWRITE) {
                logger.info((Object)"write mode : overwrite");
                if (SharePointOnlineListOutput.this.dataset.isManaged()) {
                    logger.info((Object)"Dataset is managed");
                }
                if (this.truncateInsteadOfDelete) {
                    this.client.deleteAllRows(this.siteId, this.listId);
                } else {
                    this.listId = this.client.recreateList(this.siteId, this.listId);
                }
            } else {
                logger.info((Object)"write mode : append");
            }
            this.columnFactory = columnFactory;
            this.schemaColumns = SharePointOnlineListOutput.this.dataset.getSchema().getColumns();
            this.allSharePointColumns = this.client.getAllListColumns(this.siteId, this.listId);
            for (ColumnDefinition allSharePointColumn : this.allSharePointColumns) {
                if (!allSharePointColumn.readOnly.booleanValue() || allSharePointColumn.name.compareTo("LinkTitle") == 0) continue;
                this.readOnlyColumns.add(allSharePointColumn.name);
            }
            logger.info((Object)("Read only columns: " + this.readOnlyColumns.toString()));
            List<SchemaColumn> missingSharePointColumns = this.computeMissingSharePointColumns(this.schemaColumns, this.allSharePointColumns);
            if (missingSharePointColumns.size() > 0) {
                this.client.createMissingColumns(this.siteId, this.listId, missingSharePointColumns);
                this.allSharePointColumns = this.client.getAllListColumns(this.siteId, this.listId);
            }
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }
    }
}

