/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.JobRunCodes;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.DatasetRecordCount;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.datasets.sql.PGCopySQLTableOutput;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.datasets.sql.SQLExceptionsParser;
import com.dataiku.dip.datasets.sql.SQLTableOutput;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathBuilder;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathOutput;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.DatasetOrdering;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSQLTableDatasetHandler
extends AbstractSQLDatasetHandler {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    public AbstractSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getRecords() throws DataStoreIOException, DKUSecurityException, InterruptedException {
        if (StringUtils.isBlank((String)this.resolvedAbstractConfig.table)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table defined on SQL dataset " + this.dataset.getFullName());
        }
        try (SQLConnectionProvider.SQLConnectionWrapper conn = this.newConnection();){
            long l;
            block15: {
                Statement stmt = SQLUtils.getProperlyStreamableStatement(this.getConnectionData(), conn);
                try {
                    stmt.setFetchSize(1);
                    stmt.execute("SELECT COUNT(*) from " + this.getDialect().getQuotedTableFullName(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table));
                    ResultSet rs2 = stmt.getResultSet();
                    rs2.next();
                    l = rs2.getLong(1);
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new DataStoreIOException("Failed to count records", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatasetReadiness getSQLReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        DatasetReadiness cachedReadiness;
        boolean canUseCache;
        if (StringUtils.isBlank((String)this.rawAbstractConfig.table)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table defined on SQL dataset " + this.dataset.getFullName());
        }
        boolean bl = canUseCache = session != null && !this.dataset.getParams().isNotReadyIfEmpty();
        if (canUseCache && (cachedReadiness = session.alreadyComputedAndReusableSQLTableReadiness.get(this.dataset.getLoc())) != null) {
            logger.infoV("Readiness check of SQL table for dataset=%s partition=%s -> cache hit (%s)", new Object[]{this.dataset.getFullName(), p.id(), cachedReadiness.status});
            return cachedReadiness.copy();
        }
        try (SQLConnectionProvider.SQLConnectionWrapper conn = this.newConnection();){
            JsonObject jo = VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(this.authCtx, this.dataset.getProjectKey(), this.rawAbstractConfig.variablesExpansionLoopConfig, "Repeating dataset is empty, cannot get sample");
            AbstractSQLDatasetHandler.AbstractSQLConfig configWithJITResolvedTableLoc = null;
            try (Object ignored = DynamicLevelsStack.withLevel(jo);){
                configWithJITResolvedTableLoc = (AbstractSQLDatasetHandler.AbstractSQLConfig)VariablesUtils.expandObjectFieldsAllowUnresolved(this.dataset.getProjectKey(), this.rawAbstractConfig, new String[]{"catalog", "table", "schema"});
            }
            if (this.getDialect().tableExists(this.authCtx, this.getConnectionData(), conn, configWithJITResolvedTableLoc.catalog, configWithJITResolvedTableLoc.schema, configWithJITResolvedTableLoc.table)) {
                if (this.dataset.getParams().isNotReadyIfEmpty()) {
                    logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                    ignored = RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
                    return ignored;
                }
                DatasetReadiness ret = DatasetReadiness.ready(null);
                if (canUseCache) {
                    session.alreadyComputedAndReusableSQLTableReadiness.put(this.dataset.getLoc(), ret.copy());
                }
                DatasetReadiness datasetReadiness = ret;
                return datasetReadiness;
            }
            DatasetReadiness datasetReadiness = DatasetReadiness.notReady(new CodedSQLException(JobRunCodes.ERR_JOB_INPUT_DATASET_NOT_READY_NO_TABLE, "SQL table does not exist: " + this.resolvedAbstractConfig.table));
            return datasetReadiness;
        }
        catch (SQLException e) {
            try {
                CodedSQLException cse = SQLExceptionsParser.newCodedSQLException("Failed to check table existence", this.getConnectionData(), e, true);
                return DatasetReadiness.error(cse);
            }
            catch (DKUSecurityException e1) {
                return DatasetReadiness.error(e1);
            }
        }
        catch (Exception e) {
            return DatasetReadiness.error(e);
        }
    }

    @Override
    protected RowsInputSplit getHasDataSplit() throws Exception {
        return new HasDataSplit();
    }

    @Override
    public void clearAllData() throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
        this.checkClearIsNotDangerous();
        if (ConnectionUtils.shouldPreferTruncateTable(this.authCtx, this.resolvedAbstractConfig.connection)) {
            this.truncateTable();
        } else {
            this.dropTable();
        }
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
        this.checkClearIsNotDangerous();
        this.dropTable();
    }

    protected void checkClearIsNotDangerous() throws CodedSQLException {
        AbstractSQLDatasetHandler.AbstractSQLConfig params = this.dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        String connectionName = StringUtils.defaultIfBlank((String)params.connection, (String)"no_connection");
        if (!this.dataset.isManaged()) {
            boolean allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.external." + connectionName + ".allowClear", false);
            try {
                DSSConnection conn = ConnectionsDAO.get().getConnection(this.authCtx, connectionName);
                if (conn instanceof AbstractSQLConnection) {
                    Params p = ConnectionUtils.getParamsFromProperties((AbstractSQLConnection)conn);
                    allowed = p.getBoolParam("dku.connection.externalDatasets.allowClear", allowed);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (allowed) {
                logger.warnV("Clearing dataset %s on external SQL connection %s, table %s", new Object[]{this.getDataset().getName(), connectionName, params.table});
            } else {
                throw new CodedSQLException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Clearing external (i.e., non-managed) datasets in connection " + connectionName + " is forbidden. Do you want to use a managed dataset instead?");
            }
        }
    }

    public boolean isFullyTranslatable(InputFilter filter) {
        if (filter == null || !FilterDescUtils.willFilter(filter.getFilter())) {
            return true;
        }
        try {
            FilterDescUtils.getSQLExpression(filter.getFilter(), this.getDialect(), this.dataset, true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void createManaged() throws Exception {
        if (this.dataset.getSchema() == null) {
            throw ErrorContext.iaef((String)"Dataset %s has no schema, can't create table", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        try (SQLConnectionProvider.SQLConnectionWrapper conn = this.newConnection();){
            SQLDialect dialect = this.getDialect();
            try {
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                dialect.createTableIfNeeded(this.authCtx, this.getConnectionData(), conn, this.dataset, true, messages);
                if (!messages.isEmpty()) {
                    logger.warn((Object)("Warnings were raised during table creation: " + messages.report("\n")));
                }
            }
            catch (Exception e) {
                if (dialect.supportsCommitAndRollback()) {
                    conn.rollback();
                }
                throw e;
            }
        }
        catch (SQLException e) {
            throw new DataStoreIOException("Failed to create table", (Throwable)e);
        }
    }

    protected void dropTable() throws DataStoreIOException, DKUSecurityException {
        if (this.tableExists()) {
            try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(this.getConnectionData(), this.authCtx, this.dataset.getProjectKey());){
                this.getDialect().dropTable(this.authCtx, this.getConnectionData(), conn, new SQLUtils.SQLTable(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table, true));
            }
            catch (Exception e) {
                throw new DataStoreIOException("Failed to drop table", (Throwable)e);
            }
        }
    }

    protected void truncateTable() throws DataStoreIOException, DKUSecurityException, InterruptedException {
        if (this.tableExists()) {
            try (SQLConnectionProvider.SQLConnectionWrapper conn = this.newConnection();){
                SQLDialect dialect = this.getDialect();
                try {
                    SQLUtils.safeExec(conn, "TRUNCATE TABLE " + dialect.getQuotedTableFullName(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table), true);
                    if (dialect.supportsCommitAndRollback()) {
                        conn.commit();
                    }
                }
                catch (SQLException e) {
                    if (dialect.supportsCommitAndRollback()) {
                        conn.rollback();
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                throw new DataStoreIOException("Failed to truncate table", (Throwable)e);
            }
        }
    }

    protected boolean tableExists() throws DataStoreIOException, DKUSecurityException {
        boolean bl;
        block8: {
            SQLConnectionProvider.SQLConnectionWrapper conn = this.newConnection();
            try {
                bl = this.getDialect().tableExists(this.authCtx, this.getConnectionData(), conn, this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DataStoreIOException("Failed to check table existence", (Throwable)e);
                }
            }
            conn.close();
        }
        return bl;
    }

    public SQLUtils.SQLTable getResolvedTable() {
        return new SQLUtils.SQLTable(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table, true);
    }

    public SQLUtils.SQLTable getUnresolvedTable() {
        return new SQLUtils.SQLTable(this.rawAbstractConfig.catalog, this.rawAbstractConfig.schema, this.rawAbstractConfig.table, true);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        boolean isYellowBrick;
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
        assert (targetSplit == 0);
        SQLViaCloudAutoFastPathOutput fp = new SQLViaCloudAutoFastPathBuilder().buildIfCanUseAutoFastPath(this, targetPartition, warningsContext);
        if (fp != null) {
            return fp;
        }
        boolean dontUseCopy = "true".equals(AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrNull(this.dataset.getModel().dkuProperties, "write_using_copy.disabled"));
        boolean bl = isYellowBrick = "Yellowbrick".equalsIgnoreCase(this.getDialect().getId()) && this.getMeta() == BuiltinSQLDatasets.JDBC_META;
        if (!dontUseCopy && (this.getMeta() == BuiltinSQLDatasets.GREENPLUM_META || this.getMeta() == BuiltinSQLDatasets.POSTGRESQL_META || this.getMeta() == BuiltinSQLDatasets.DATABRICKS_LAKEBASE_META || this.getMeta() == BuiltinSQLDatasets.ALLOYDB_META || isYellowBrick)) {
            return new PGCopySQLTableOutput(this, this.dataset, targetPartition, warningsContext);
        }
        return new SQLTableOutput(this, this.dataset, targetPartition, warningsContext);
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() {
        return false;
    }

    public void prepareSqlTableForWrite(AuthCtx authCtx, Partition targetPartition, Output.WriteMode writeMode, InfoMessage.InfoMessages messages) throws Exception {
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(this.getConnectionData(), authCtx, this.getDataset().getProjectKey());){
            this.getDialect().prepareTableForWriting(authCtx, this.getConnectionData(), conn, writeMode, this.getDataset(), targetPartition, false, messages);
        }
    }

    @Override
    public DatasetRecordCount getRecordsFast() throws Exception {
        SQLDialect dialect = this.getDialect();
        if (dialect.supportRetrieveTableRowCount()) {
            DatasetRecordCount datasetRecordCount;
            block9: {
                SQLConnectionProvider.SQLConnectionData connectionData = this.getConnectionData();
                SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connectionData, this.authCtx, this.dataset.getProjectKey());
                try {
                    SQLUtils.SQLTable sqlTable = new SQLUtils.SQLTable(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table);
                    datasetRecordCount = dialect.retrieveTableRowCount(connectionData, conn, sqlTable);
                    if (conn == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new DataStoreIOException("Failed to retrieve table row count", (Throwable)e);
                    }
                }
                conn.close();
            }
            return datasetRecordCount;
        }
        return null;
    }

    @Override
    public boolean handlesSamplingMethodDuringPush(ExtractionLimit limit) throws DKUSecurityException {
        return this.getRandomSampleClauseLocation(limit) != SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    private SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(ExtractionLimit limit) throws DKUSecurityException {
        if (limit == null) {
            return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        return this.getDialect().getRandomSampleClauseLocation(limit.samplingMethod, limit.maxRecords, limit.samplingRatio, limit.samplingSeed);
    }

    public void tryAddCommentToTable(String description, InfoMessage.InfoMessages messages) throws SQLException, DKUSecurityException, InterruptedException {
        try (SQLConnectionProvider.SQLConnectionWrapper conn = this.newConnection();){
            SQLDialect dialect = this.getDialect();
            dialect.tryAddCommentToTable(conn, this.resolvedAbstractConfig, dialect.truncateDescription(description, this.resolvedAbstractConfig.table, true, messages), messages);
        }
    }

    public void tryWriteColumnComments(AuthCtx authCtx, String projectKey, List<SchemaColumn> columns, InfoMessage.InfoMessages messages) {
        try (SQLConnectionProvider.SQLConnectionWrapper conn = this.newConnection();){
            this.getDialect().tryWriteColumnComments(authCtx, conn, this.resolvedAbstractConfig, columns, projectKey, messages);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to synchronize column comments", (Throwable)e);
            messages.withWarning((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_SYNC_COLUMN_DESC, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    class HasDataSplit
    extends RowsInputSplit {
        HasDataSplit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long l;
            if (StringUtils.isBlank((String)AbstractSQLTableDatasetHandler.this.resolvedAbstractConfig.table)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified for dataset " + AbstractSQLTableDatasetHandler.this.dataset.getFullName());
            }
            SQLDialect dialect = AbstractSQLTableDatasetHandler.this.getDialect();
            String query = "SELECT * FROM " + dialect.getQuotedTableFullName(AbstractSQLTableDatasetHandler.this.resolvedAbstractConfig.catalog, AbstractSQLTableDatasetHandler.this.resolvedAbstractConfig.schema, AbstractSQLTableDatasetHandler.this.resolvedAbstractConfig.table);
            String q = limit != null && limit.maxRecords > 0L ? dialect.getLimitedQuery(query, limit.maxRecords) : query;
            SQLConnectionProvider.SQLConnectionWrapper conn = AbstractSQLTableDatasetHandler.this.newConnection();
            try {
                l = AbstractSQLTableDatasetHandler.this.executePush(conn, q, out, cf, rf, limit, listener, warningsContext, false);
            }
            catch (Throwable throwable) {
                try {
                    logger.info((Object)"Exited push");
                    SQLUtils.unsafeRollbackAndClose(conn);
                    throw throwable;
                }
                catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new DataStoreIOException("Failed to read data from table", (Throwable)e);
                }
            }
            logger.info((Object)"Exited push");
            SQLUtils.unsafeRollbackAndClose(conn);
            return l;
        }

        public String getDesc() {
            return "Table-HasData";
        }
    }

    public class TableClauseSplit
    extends RowsInputSplit {
        protected InputFilter filter;
        protected final AbstractSQLDatasetHandler.AbstractSQLConfig configWithJITResolvedTableLoc;
        protected boolean performBigQuerySampling = false;

        protected TableClauseSplit(InputFilter filter) {
            this.filter = filter;
            this.configWithJITResolvedTableLoc = (AbstractSQLDatasetHandler.AbstractSQLConfig)VariablesUtils.expandObjectFieldsAllowUnresolved(AbstractSQLTableDatasetHandler.this.dataset.getProjectKey(), AbstractSQLTableDatasetHandler.this.rawAbstractConfig, new String[]{"catalog", "table", "schema"});
        }

        @Nullable
        public ExpressionBuilder generateFilterClause() {
            if (this.filter == null || !FilterDescUtils.willFilter(this.filter.getFilter())) {
                return null;
            }
            try {
                ExpressionBuilder eb = FilterDescUtils.getSQLExpressionBuilder(this.filter.getFilter(), AbstractSQLTableDatasetHandler.this.getDialect(), AbstractSQLTableDatasetHandler.this.dataset, false);
                eb.toSQL(AbstractSQLTableDatasetHandler.this.getDialect());
                return eb;
            }
            catch (Exception e) {
                logger.info((Object)("Filter expression \"" + FilterDescUtils.getFilterRepr(this.filter.getFilter()) + "\" could not be translated into SQL, perform request without filter (" + e.getMessage() + ")"));
                return null;
            }
        }

        public List<ExpressionBuilder> generateClauses(QueryAst.SampleClause sample) throws SQLException {
            ArrayList<ExpressionBuilder> resultClauses = new ArrayList<ExpressionBuilder>();
            ExpressionBuilder filterClause = this.generateFilterClause();
            if (filterClause != null) {
                resultClauses.add(filterClause);
            }
            try {
                if (sample != null) {
                    resultClauses.add(new ExpressionBuilder.ExpressionBuilderFactory().expr(AbstractSQLTableDatasetHandler.this.getDialect().getRandomSampleClause(sample)));
                }
            }
            catch (DKUSecurityException e) {
                throw new SQLException("Unable to get SQL dialect, unable to generate additional sampling clause", e);
            }
            return resultClauses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long l;
            if (StringUtils.isBlank((String)this.configWithJITResolvedTableLoc.table)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified for dataset " + AbstractSQLTableDatasetHandler.this.dataset.getFullName());
            }
            SQLDialect.RandomSampleClauseLocation randomSampleClauseLocation = AbstractSQLTableDatasetHandler.this.getRandomSampleClauseLocation(limit);
            QueryAst.SampleClause sample = null;
            if (randomSampleClauseLocation != SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED) {
                logger.debug((Object)"Random sampling will be done in database");
                sample = QueryAst.SampleClause.sampleClause(limit);
            }
            SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
            queryBuilder.from(this.configWithJITResolvedTableLoc.catalog, this.configWithJITResolvedTableLoc.schema, this.configWithJITResolvedTableLoc.table, null, randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.FROM ? sample : null);
            queryBuilder.where(this.generateClauses(randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.WHERE ? sample : null).toArray(new ExpressionBuilder[0]));
            if (randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT) {
                queryBuilder.order(new ExpressionBuilder.ExpressionBuilderFactory().expr(AbstractSQLTableDatasetHandler.this.getDialect().getRandomSampleClause(sample)));
            }
            if (limit != null && limit.maxRecords > 0L && (randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED || randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT)) {
                queryBuilder.limit(limit.maxRecords);
            }
            SelectQueryBuilder topLevelQueryBuilder = queryBuilder;
            if (limit != null && limit.ordering.enabled) {
                if (randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT) {
                    topLevelQueryBuilder = new SelectQueryBuilder();
                    topLevelQueryBuilder.from(queryBuilder, "__dku_inner");
                }
                for (DatasetOrdering.DatasetOrderingRule order : limit.ordering.rules) {
                    topLevelQueryBuilder.order(order.columnName, QueryAst.OrderType.valueOf(order.asc ? "ASC" : "DESC"));
                }
            }
            SQLConnectionProvider.SQLConnectionWrapper conn = AbstractSQLTableDatasetHandler.this.newConnection();
            try {
                l = AbstractSQLTableDatasetHandler.this.executePush(conn, topLevelQueryBuilder.toSQL(AbstractSQLTableDatasetHandler.this.getDialect()), out, cf, rf, limit, listener, warningsContext, true);
            }
            catch (Throwable throwable) {
                try {
                    logger.info((Object)"Exited push");
                    SQLUtils.unsafeRollbackAndClose(conn);
                    throw throwable;
                }
                catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw SQLExceptionsParser.newDatastoreIOException("Failed to read data from table", AbstractSQLTableDatasetHandler.this.getConnectionData(), e, true);
                }
            }
            logger.info((Object)"Exited push");
            SQLUtils.unsafeRollbackAndClose(conn);
            return l;
        }

        public String getDesc() {
            String filterDesc = "none";
            ExpressionBuilder filterClause = this.generateFilterClause();
            if (filterClause != null) {
                try {
                    filterDesc = filterClause.toSQL(AbstractSQLTableDatasetHandler.this.getDialect());
                }
                catch (Exception e) {
                    filterDesc = "unknown";
                }
            }
            return "Table-Clause: " + filterDesc;
        }
    }
}

