/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.PluginEntryPoint;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GreenplumConnection;
import com.dataiku.dip.connections.OracleConnection;
import com.dataiku.dip.connections.TeradataConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.FabricWarehouseDatasetConfig;
import com.dataiku.dip.datasets.sql.GenericSQLDatasetMeta;
import com.dataiku.dip.datasets.sql.GreenplumDatasetConfig;
import com.dataiku.dip.datasets.sql.PartitionedHiveQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedHiveTableDatasetHandler;
import com.dataiku.dip.datasets.sql.RedshiftDatasetConfig;
import com.dataiku.dip.datasets.sql.SynapseDatasetConfig;
import com.dataiku.dip.datasets.sql.TeradataDatasetConfig;
import com.dataiku.dip.datasets.sql.UnpartitionedHiveQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.UnpartitionedHiveTableDatasetHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQuerySQLDatasetMeta;
import com.dataiku.dip.datasets.sql.mysql.MySQLDatasetConfig;
import com.dataiku.dip.datasets.sql.treasuredata.TreasureDataSQLDatasetMeta;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesUtils;
import org.apache.commons.lang.StringUtils;

public class BuiltinSQLDatasets
extends PluginEntryPoint {
    public static final DatasetHandler.DatasetMeta<?, ?> POSTGRESQL_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "PostgreSQL";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return PostgreSQLDialect.PostgreSQLDatasetConfig.class;
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> ALLOYDB_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "AlloyDB";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return PostgreSQLDialect.PostgreSQLDatasetConfig.class;
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> MYSQL_META = new GenericSQLDatasetMeta(){

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return MySQLDatasetConfig.class;
        }

        @Override
        public String getType() {
            return "MySQL";
        }

        @Override
        public boolean hasCaseInsensitiveColumns() {
            return true;
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> VERTICA_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Vertica";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> SNOWFLAKE_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Snowflake";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> DATABRICKS_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Databricks";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> DATABRICKS_LAKEBASE_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "DatabricksLakebase";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> REDSHIFT_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Redshift";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return RedshiftDatasetConfig.class;
        }

        @Override
        public boolean hasCaseInsensitiveColumns() {
            return true;
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> GREENPLUM_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Greenplum";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return GreenplumDatasetConfig.class;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            super.fillManagedDatasetParams(dataset, targetConnection, specificSettings, useExistingParams);
            if (targetConnection instanceof GreenplumConnection) {
                GreenplumDatasetConfig config = dataset.getParamsAs(GreenplumDatasetConfig.class);
                config.distributionStrategy = ((GreenplumConnection)targetConnection).getParams().defaultDistributionStrategy;
            }
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> TERADATA_META = new GenericSQLDatasetMeta(){

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return TeradataDatasetConfig.class;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            super.fillManagedDatasetParams(dataset, targetConnection, specificSettings, useExistingParams);
            if (targetConnection instanceof TeradataConnection) {
                TeradataDatasetConfig config = dataset.getParamsAs(TeradataDatasetConfig.class);
                config.primaryIndexBehavior = ((TeradataConnection)targetConnection).getParams().defaultPrimaryIndexBehavior;
            }
        }

        @Override
        public String getType() {
            return "Teradata";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> ORACLE_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Oracle";
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            super.fillManagedDatasetParams(dataset, targetConnection, specificSettings, useExistingParams);
            if (ApplicationConfigurator.isDevLambdaServer()) {
                return;
            }
            AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            if (config.mode != null && "table".equals(config.mode)) {
                String tableName = VariablesUtils.expand(dataset.getProjectKey(), config.table);
                int maxSize = ((OracleConnection)targetConnection).getParams().maxIdentifierSize;
                if (tableName.length() > maxSize) {
                    throw ErrorContext.iae((String)("Oracle does not support table names with more than " + maxSize + " characters : [" + tableName.substring(0, maxSize) + "]" + tableName.substring(maxSize)));
                }
            }
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> SQLSERVER_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "SQLServer";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return SynapseDatasetConfig.class;
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> FABRIC_WAREHOUSE_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "FabricWarehouse";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return FabricWarehouseDatasetConfig.class;
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> SYNAPSE_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Synapse";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return SynapseDatasetConfig.class;
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> NETEZZA_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Netezza";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> SAPHANA_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "SAPHANA";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> BIGQUERY_META = new BigQuerySQLDatasetMeta();
    public static final DatasetHandler.DatasetMeta<?, ?> JDBC_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "JDBC";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> HIVE_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "hiveserver2";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return AbstractSQLDatasetHandler.AbstractSQLConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
            String mode = StringUtils.defaultIfBlank((String)config.mode, (String)"table");
            boolean partitioned = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned();
            switch (mode) {
                case "table": {
                    if (partitioned) {
                        return new PartitionedHiveTableDatasetHandler(authCtx, dataset, this);
                    }
                    return new UnpartitionedHiveTableDatasetHandler(authCtx, dataset, this);
                }
                case "query": {
                    if (partitioned) {
                        return new PartitionedHiveQueryDatasetHandler(authCtx, dataset, this);
                    }
                    return new UnpartitionedHiveQueryDatasetHandler(authCtx, dataset, this);
                }
            }
            throw ErrorContext.iaef((String)"Invalid Hive dataset mode : '%s' expected 'query' or 'table'", (Object)mode, (Object[])new Object[0]);
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            throw new IllegalArgumentException("Hive datasets are read-only");
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> ATHENA_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Athena";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> KDBPLUS_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "KDBPlus";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> TRINO_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Trino";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> DENODO_META = new GenericSQLDatasetMeta(){

        @Override
        public String getType() {
            return "Denodo";
        }
    };
    public static final DatasetHandler.DatasetMeta<?, ?> TREASUREDATA_META = new TreasureDataSQLDatasetMeta();

    @Override
    public void load() {
        DatasetHandlerFactory.registerDatasetType(MYSQL_META);
        DatasetHandlerFactory.registerDatasetType(POSTGRESQL_META);
        DatasetHandlerFactory.registerDatasetType(ALLOYDB_META);
        DatasetHandlerFactory.registerDatasetType(VERTICA_META);
        DatasetHandlerFactory.registerDatasetType(SNOWFLAKE_META);
        DatasetHandlerFactory.registerDatasetType(DATABRICKS_META);
        DatasetHandlerFactory.registerDatasetType(DATABRICKS_LAKEBASE_META);
        DatasetHandlerFactory.registerDatasetType(REDSHIFT_META);
        DatasetHandlerFactory.registerDatasetType(GREENPLUM_META);
        DatasetHandlerFactory.registerDatasetType(TERADATA_META);
        DatasetHandlerFactory.registerDatasetType(ORACLE_META);
        DatasetHandlerFactory.registerDatasetType(SQLSERVER_META);
        DatasetHandlerFactory.registerDatasetType(FABRIC_WAREHOUSE_META);
        DatasetHandlerFactory.registerDatasetType(SYNAPSE_META);
        DatasetHandlerFactory.registerDatasetType(NETEZZA_META);
        DatasetHandlerFactory.registerDatasetType(SAPHANA_META);
        DatasetHandlerFactory.registerDatasetType(BIGQUERY_META);
        DatasetHandlerFactory.registerDatasetType(JDBC_META);
        DatasetHandlerFactory.registerDatasetType(HIVE_META);
        DatasetHandlerFactory.registerDatasetType(ATHENA_META);
        DatasetHandlerFactory.registerDatasetType(TRINO_META);
        DatasetHandlerFactory.registerDatasetType(DENODO_META);
        DatasetHandlerFactory.registerDatasetType(KDBPLUS_META);
        DatasetHandlerFactory.registerDatasetType(TREASUREDATA_META);
    }
}

