/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PartitionedSQLTableDatasetHandler
extends AbstractSQLTableDatasetHandler {
    protected List<Partition> explicitPartitionsList;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.sql");

    public PartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
        if (this.resolvedAbstractConfig.explicitPartitionsList != null) {
            this.explicitPartitionsList = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), this.resolvedAbstractConfig.explicitPartitionsList);
        }
    }

    @Override
    public void checkConfiguration() throws IOException {
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        this.checkConfiguration();
        if (this.explicitPartitionsList != null) {
            return this.explicitPartitionsList;
        }
        if (StringUtils.isBlank((String)this.resolvedAbstractConfig.table)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified for dataset " + this.dataset.getFullName());
        }
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.selectDistinct();
        SQLDialect dialect = this.getDialect();
        if (!(dialect instanceof TeradataSQLDialect) && !(dialect instanceof OracleSQLDialect)) {
            builder.limit(MAX_PARTITIONS + 1L);
        }
        builder.from(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table, null);
        for (String dimensionName : this.dataset.getPartitioningSchema().getDimensionNames()) {
            ExpressionBuilder partitioningExpression = ExpressionUtils.getPartitionColumnExpression(dimensionName, this.dataset, dialect);
            builder.select(partitioningExpression, dimensionName);
            if (!(this.resolvedAbstractConfig instanceof BigQueryDatasetConfig) || !((BigQueryDatasetConfig)this.resolvedAbstractConfig).requiresPartitionFilter) continue;
            ExpressionBuilder.ExpressionBuilderFactory expressionBuilderFactory = new ExpressionBuilder.ExpressionBuilderFactory();
            builder.where(expressionBuilderFactory.col(dimensionName).isnotnull());
        }
        String listPartitionsQuery = builder.toSQL(dialect);
        if (dialect instanceof OracleSQLDialect) {
            listPartitionsQuery = dialect.getLimitedQuery(listPartitionsQuery, MAX_PARTITIONS + 1L);
        }
        return this.listPartitionsWithQuery(listPartitionsQuery);
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getPartitionRecords(Partition p) throws DataStoreIOException, DKUSecurityException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        List<Partition> list = this.listPartitions();
        return list.contains(p);
    }

    @Override
    public void clearAllData() throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
        this.checkClearIsNotDangerous();
        if (this.tableExists()) {
            this.dropTable();
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
        this.checkClearIsNotDangerous();
        if (partitions.size() == 0) {
            return;
        }
        if (StringUtils.isBlank((String)this.resolvedAbstractConfig.table)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table defined on SQL dataset " + this.dataset.getFullName());
        }
        StringBuilder sb = new StringBuilder();
        SQLDialect dialect = this.getDialect();
        sb.append("DELETE FROM ").append(dialect.getQuotedTableFullName(this.resolvedAbstractConfig.catalog, this.resolvedAbstractConfig.schema, this.resolvedAbstractConfig.table)).append(" WHERE ");
        ExpressionBuilder clause = ExpressionUtils.getPartitionFilterClause(this.dataset.getPartitioningSchema(), this.dataset, partitions, dialect);
        sb.append(clause.toSQL(dialect));
        String query = sb.toString();
        logger.info((Object)("Deleting partitions using SQL query : " + query));
        try (SQLConnectionProvider.SQLConnectionWrapper c2 = this.newConnection();){
            SQLUtils.safeExec(c2, query, true);
            if (dialect.supportsCommitAndRollback()) {
                c2.commit();
            }
        }
        catch (SQLException e) {
            throw new DataStoreIOException("Failed to clear partitions", (Throwable)e);
        }
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
        this.checkClearIsNotDangerous();
        if (this.tableExists()) {
            this.dropTable();
        }
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return new TablePartitionSplit(partition, null);
    }

    public InputSplit getPartitionSplit(Partition partition, InputFilter filter) {
        return new TablePartitionSplit(partition, filter);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (filter != null);
        FilterResultWithSplits ret = new FilterResultWithSplits();
        if (filter.hasPartitionsFiltering()) {
            for (Partition partition : filter.getPartitionsClause()) {
                ret.withMatchingPartition(partition).withSplit(this.getPartitionSplit(partition, filter));
            }
        } else {
            ret.withSplit(this.getPartitionSplit(null, filter));
        }
        ret.setNeedsRefilter(!this.isFullyTranslatable(filter));
        return ret;
    }

    protected void throwIfVELoopConfigEnabled() {
        if (this.rawAbstractConfig.variablesExpansionLoopConfig.isEnabled()) {
            throw new IllegalArgumentException("A partitioned SQL table dataset cannot have 'repeated dataset' mode enabled");
        }
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        this.throwIfVELoopConfigEnabled();
        return new AbstractSQLTableDatasetHandler.TableClauseSplit(null);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return new AbstractSQLTableDatasetHandler.TableClauseSplit(null);
    }

    class TablePartitionSplit
    extends AbstractSQLTableDatasetHandler.TableClauseSplit {
        Partition partition;

        TablePartitionSplit(Partition partition, InputFilter filter) {
            super(filter);
            this.partition = partition;
        }

        @Override
        public List<ExpressionBuilder> generateClauses(QueryAst.SampleClause sample) throws SQLException {
            ArrayList<ExpressionBuilder> result = new ArrayList<ExpressionBuilder>();
            try {
                SQLDialect dialect = PartitionedSQLTableDatasetHandler.this.getDialect();
                result.add(ExpressionUtils.getPartitionFilterClause(PartitionedSQLTableDatasetHandler.this.dataset.getPartitioningSchema(), PartitionedSQLTableDatasetHandler.this.dataset, this.partition, dialect));
                result.addAll(super.generateClauses(sample));
            }
            catch (DKUSecurityException e) {
                throw new SQLException("Unable to get SQL dialect, can't generate partition clauses", e);
            }
            return result;
        }

        @Override
        public String getDesc() {
            return this.partition == null ? "Table-All-Partitions" : "Table-Partition-" + this.partition.id();
        }
    }
}

