/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.bigquery;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.GenericSQLDatasetMeta;
import com.dataiku.dip.datasets.sql.PartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLExceptionsParser;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathBuilder;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathOutput;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.datasets.sql.bigquery.BigQuerySQLTableOutput;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class BigQuerySQLDatasetMeta
extends GenericSQLDatasetMeta {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return BigQueryDatasetConfig.class;
    }

    @Override
    public String getType() {
        return "BigQuery";
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
        String mode = config.mode == null ? "table" : config.mode;
        boolean partitioned = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned();
        switch (mode) {
            case "table": {
                if (partitioned) {
                    return new BigQueryPartitionedSQLTableDatasetHandler(authCtx, dataset, this);
                }
                return new BigQueryUnpartitionedSQLTableDatasetHandler(authCtx, dataset, this);
            }
            case "query": {
                if (partitioned) {
                    return new PartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
                }
                return new UnpartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
            }
        }
        throw ErrorContext.iaef((String)"Invalid SQL dataset mode : '%s' expected 'query' or 'table'", (Object)mode, (Object[])new Object[0]);
    }

    protected static String getPreviewTablePseudoSQL(ExtractionLimit limit, String catalog, String schema, String table, boolean forbidPreviewFallbackToSelect) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)schema), (Object)"BigQuery dataset Id cannot be empty or null.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)table), (Object)"BigQuery table Id cannot be empty or null.");
        return Joiner.on((String)"\n").join((Object)"PREVIEW TABLE", (Object)StringUtils.defaultIfBlank((CharSequence)catalog, (CharSequence)""), new Object[]{schema, table, limit != null ? limit.maxRecords : -1L, forbidPreviewFallbackToSelect});
    }

    private static boolean canUseDirectTablePreview(ExtractionLimit limit, SQLConnectionProvider.SQLConnectionData connectionData) {
        boolean useDriver = ((SQLConnectionProvider.BigQuerySQLConnectionData)connectionData).useDriver;
        return !useDriver && !BigQuerySQLDatasetMeta.hasOrdering(limit) && !BigQuerySQLDatasetMeta.hasLargeMaxRecords(limit);
    }

    private static boolean hasLargeMaxRecords(ExtractionLimit limit) {
        return limit != null && limit.maxRecords >= Integer.MAX_VALUE;
    }

    private static boolean hasOrdering(ExtractionLimit limit) {
        return limit != null && limit.ordering != null && limit.ordering.enabled && !limit.ordering.rules.isEmpty();
    }

    private static boolean shouldForbidPreviewFallbackToSelect(AbstractSQLDatasetHandler.AbstractSQLConfig abstractSQLConfig) {
        if (abstractSQLConfig instanceof BigQueryDatasetConfig) {
            return ((BigQueryDatasetConfig)abstractSQLConfig).forbidPreviewFallbackToSelect;
        }
        return false;
    }

    private static class BigQueryPartitionedSQLTableDatasetHandler
    extends PartitionedSQLTableDatasetHandler {
        public BigQueryPartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
            super(authCtx, dataset, meta);
        }

        @Override
        public RowsInputSplit getSingleSplit() throws Exception {
            this.throwIfVELoopConfigEnabled();
            return new BigQueryTableClauseSplit(null);
        }

        @Override
        public RowsInputSplit getSampleSplit() throws Exception {
            return new BigQueryTableClauseSplit(null);
        }

        @Override
        public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
            ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
            assert (targetSplit == 0);
            SQLViaCloudAutoFastPathOutput fp = new SQLViaCloudAutoFastPathBuilder().buildIfCanUseAutoFastPath(this, targetPartition, warningsContext);
            if (fp != null) {
                logger.info((Object)"Using automatic fast-write SQL output");
                return fp;
            }
            logger.info((Object)"Using SQL output based on the BigQuery Storage Write API");
            return new BigQuerySQLTableOutput(this, targetPartition, warningsContext);
        }

        class BigQueryTableClauseSplit
        extends AbstractSQLTableDatasetHandler.TableClauseSplit {
            protected BigQueryTableClauseSplit(InputFilter filter) {
                super(filter);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
                if (BigQuerySQLDatasetMeta.canUseDirectTablePreview(limit, BigQueryPartitionedSQLTableDatasetHandler.this.getConnectionData()) && !BigQueryPartitionedSQLTableDatasetHandler.this.handlesSamplingMethodDuringPush(limit)) {
                    long l;
                    SQLConnectionProvider.SQLConnectionWrapper conn = BigQueryPartitionedSQLTableDatasetHandler.this.newConnection();
                    try {
                        boolean forbidPreviewFallbackToSelect = BigQuerySQLDatasetMeta.shouldForbidPreviewFallbackToSelect(BigQueryPartitionedSQLTableDatasetHandler.this.rawAbstractConfig);
                        String previewTablePseudoSQL = BigQuerySQLDatasetMeta.getPreviewTablePseudoSQL(limit, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.catalog, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.schema, ((BigQueryPartitionedSQLTableDatasetHandler)BigQueryPartitionedSQLTableDatasetHandler.this).resolvedAbstractConfig.table, forbidPreviewFallbackToSelect);
                        l = BigQueryPartitionedSQLTableDatasetHandler.this.executePush(conn, previewTablePseudoSQL, out, cf, rf, limit, listener, warningsContext, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            logger.info((Object)"Exited push");
                            SQLUtils.unsafeRollbackAndClose(conn);
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw SQLExceptionsParser.newDatastoreIOException("Failed to read data from table", BigQueryPartitionedSQLTableDatasetHandler.this.getConnectionData(), e, true);
                        }
                    }
                    logger.info((Object)"Exited push");
                    SQLUtils.unsafeRollbackAndClose(conn);
                    return l;
                }
                return super.push(out, cf, rf, limit, listener, warningsContext);
            }
        }
    }

    private static class BigQueryUnpartitionedSQLTableDatasetHandler
    extends UnpartitionedSQLTableDatasetHandler {
        public BigQueryUnpartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
            super(authCtx, dataset, meta);
        }

        @Override
        public RowsInputSplit getSingleSplit() throws Exception {
            if (!this.rawAbstractConfig.variablesExpansionLoopConfig.isEnabled()) {
                return new BigQueryTableClauseSplit(null);
            }
            ArrayList<BigQueryTableClauseSplit> loopIterations = new ArrayList<BigQueryTableClauseSplit>();
            for (JsonObject jo : new VariablesExpansionLoopItemsIterable(this.authCtx, this.dataset.getProjectKey(), this.rawAbstractConfig.variablesExpansionLoopConfig)) {
                AutoCloseable ignored = DynamicLevelsStack.withLevel(jo);
                try {
                    loopIterations.add(new BigQueryTableClauseSplit(null));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            return new RowSequenceInputSplit(loopIterations);
        }

        @Override
        public RowsInputSplit getSampleSplit() throws Exception {
            try (AutoCloseable ignored = DynamicLevelsStack.withLevel(this.createVELoopSampleIterationFailIfNone());){
                BigQueryTableClauseSplit bigQueryTableClauseSplit = new BigQueryTableClauseSplit(null);
                return bigQueryTableClauseSplit;
            }
        }

        @Override
        public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
            ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
            assert (targetSplit == 0);
            SQLViaCloudAutoFastPathOutput fp = new SQLViaCloudAutoFastPathBuilder().buildIfCanUseAutoFastPath(this, targetPartition, warningsContext);
            if (fp != null) {
                logger.info((Object)"Using automatic fast-write SQL output");
                return fp;
            }
            logger.info((Object)"Using SQL output based on the BigQuery Storage Write API");
            return new BigQuerySQLTableOutput(this, targetPartition, warningsContext);
        }

        class BigQueryTableClauseSplit
        extends AbstractSQLTableDatasetHandler.TableClauseSplit {
            protected BigQueryTableClauseSplit(InputFilter filter) {
                super(filter);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
                if (BigQuerySQLDatasetMeta.canUseDirectTablePreview(limit, BigQueryUnpartitionedSQLTableDatasetHandler.this.getConnectionData()) && !BigQueryUnpartitionedSQLTableDatasetHandler.this.handlesSamplingMethodDuringPush(limit)) {
                    long l;
                    SQLConnectionProvider.SQLConnectionWrapper conn = BigQueryUnpartitionedSQLTableDatasetHandler.this.newConnection();
                    try {
                        boolean forbidPreviewFallbackToSelect = BigQuerySQLDatasetMeta.shouldForbidPreviewFallbackToSelect(BigQueryUnpartitionedSQLTableDatasetHandler.this.rawAbstractConfig);
                        String previewTablePseudoSQL = BigQuerySQLDatasetMeta.getPreviewTablePseudoSQL(limit, this.configWithJITResolvedTableLoc.catalog, this.configWithJITResolvedTableLoc.schema, this.configWithJITResolvedTableLoc.table, forbidPreviewFallbackToSelect);
                        l = BigQueryUnpartitionedSQLTableDatasetHandler.this.executePush(conn, previewTablePseudoSQL, out, cf, rf, limit, listener, warningsContext, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            logger.info((Object)"Exited push");
                            SQLUtils.unsafeRollbackAndClose(conn);
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw SQLExceptionsParser.newDatastoreIOException("Failed to read data from table", BigQueryUnpartitionedSQLTableDatasetHandler.this.getConnectionData(), e, true);
                        }
                    }
                    logger.info((Object)"Exited push");
                    SQLUtils.unsafeRollbackAndClose(conn);
                    return l;
                }
                return super.push(out, cf, rf, limit, listener, warningsContext);
            }
        }
    }
}

