/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.security.AuthCtx;
import org.apache.log4j.Logger;

public class UnpartitionedStreamWriter
extends StreamWriter {
    private StreamWriter.OpenOutputPartition openPartition = null;
    private static Logger logger = Logger.getLogger((String)"dip.stream.unpartitioned.writer");

    public UnpartitionedStreamWriter(AuthCtx authCtx, DatasetHandler outputDH, String sourceId, int splitId) throws Exception {
        super(authCtx, outputDH, sourceId, splitId);
    }

    private StreamWriter.OpenOutputPartition getOrOpenPartition() throws Exception {
        StreamWriter.OpenOutputPartition oop = this.openPartition;
        if (oop != null) {
            return oop;
        }
        oop = new StreamWriter.OpenOutputPartition();
        oop.setupNewOpenOutputPartition("NP");
        this.openPartition = oop;
        return oop;
    }

    @Override
    public void append(Row row) throws Exception {
        StreamWriter.OpenOutputPartition oop = this.getOrOpenPartition();
        oop.writer.emitRow(row);
    }

    @Override
    protected void closeOpenPartitions() throws Exception {
        if (this.openPartition != null) {
            this.openPartition.lastRowEmitted();
            this.openPartition = null;
        }
    }

    @Override
    protected void cancelOpenPartitions() throws Exception {
        if (this.openPartition != null) {
            this.openPartition.cancel();
            this.openPartition = null;
        }
    }
}

