/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datastory;

import com.dataiku.common.rpc.ProxyUserAPIClient;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.com.google.common.io.ByteStreams;
import com.dataiku.dss.shadelib.org.apache.http.HttpRequest;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PowerslideClient
extends ProxyUserAPIClient {
    private static final String BASE_URL = "api/datastory";
    private static final String BASE_URL_V2 = "v2/api/dashboards";

    public PowerslideClient(AuthCtx authCtx, String baseURI, String apiKey) {
        super(authCtx, baseURI, apiKey, true);
    }

    protected void setAuth(HttpRequest method) {
        method.setHeader("Authorization", "Bearer " + this.apiKey);
    }

    protected int getConnectTimeout() {
        return ApplicationConfigurator.getParams().getIntParam("dku.powerslide.connectTimeout", Integer.valueOf(20000));
    }

    protected int getSocketTimeout() {
        return ApplicationConfigurator.getParams().getIntParam("dku.powerslide.socketTimeout", Integer.valueOf(0));
    }

    public String createStory(Workspace workspace, Workspace.Story data) throws IOException {
        DatastoryDTO datastoryDTO = new DatastoryDTO();
        Function<String, Workspace.WorkspaceObject> findObjectInWorkspace = id -> WorkspacesService.findDatasetWithId(workspace, id);
        if (data.references != null) {
            datastoryDTO.datasets = data.references.stream().map(findObjectInWorkspace).filter(Objects::nonNull).map(wo -> new DatasetRef(wo.reference.projectKey, wo.reference.id, wo.id)).collect(Collectors.toList());
        }
        datastoryDTO.title = data.title;
        datastoryDTO.description = data.description;
        datastoryDTO.workspaceKey = workspace.workspaceKey;
        return ((DatastoryCreationResponse)this.postObject((String)BASE_URL, DatastoryCreationResponse.class, (Object)datastoryDTO)).datastoryId;
    }

    public String duplicateStory(Workspace workspace, String dataStoryId, @Nullable String newTitle) throws IOException {
        DatastoryDTO datastoryDTO = new DatastoryDTO();
        datastoryDTO.title = newTitle;
        datastoryDTO.workspaceKey = workspace.workspaceKey;
        DatastoryDuplicationResponse response = (DatastoryDuplicationResponse)this.postObject(this.buildDatastoryPathV2(dataStoryId, "duplicate"), DatastoryDuplicationResponse.class, datastoryDTO);
        return response.dashboardId;
    }

    public void updateStory(Workspace workspace, Workspace.Story data) throws IOException {
        DatastoryDTO datastoryDTO = new DatastoryDTO();
        datastoryDTO.title = data.title;
        datastoryDTO.description = data.description;
        DatastoryUpdateResponse response = (DatastoryUpdateResponse)this.postObject(this.buildDatastoryPath(data.id), DatastoryUpdateResponse.class, datastoryDTO);
        data.title = response.datastoryTitle;
        data.description = response.datastoryDescription;
    }

    public void deleteStory(String dataStoryId) throws IOException {
        this.delete(this.buildDatastoryPath(dataStoryId), Void.class, new Object[0]);
    }

    public byte[] getThumbnail(String dataStoryId) throws IOException {
        try (InputStream thumbnail = this.getToInputStream(this.buildDatastoryPath(dataStoryId, "thumbnail"));){
            byte[] byArray = ByteStreams.toByteArray((InputStream)thumbnail);
            return byArray;
        }
    }

    public void getStoryStatus() throws IOException {
        this.get(BASE_URL, DatastoryStatus.class);
    }

    public <T> T handleJSONResp(HttpResponse resp, Class<T> ofClazz) throws IOException {
        return (T)super.handleJSONResp(resp, ofClazz, this::handlePowerslideError);
    }

    public IOException handlePowerslideError(HttpResponse resp) throws IOException {
        PowerslideAPIError powerslideAPIError = (PowerslideAPIError)JSON.parse((InputStream)resp.getEntity().getContent(), PowerslideAPIError.class);
        String reason = powerslideAPIError.title;
        if (StringUtils.isBlank((CharSequence)reason) && powerslideAPIError.code instanceof Map) {
            Map values = (Map)powerslideAPIError.code;
            reason = values.getOrDefault("key", "").toString();
        }
        APIError apiError = new APIError(powerslideAPIError.status, reason, resp.getStatusLine().getStatusCode());
        return new APIError.APIErrorException(apiError);
    }

    private String buildDatastoryPath(String datastoryId) {
        return "api/datastory/" + datastoryId;
    }

    private String buildDatastoryPath(String datastoryId, String path) {
        return "api/datastory/" + datastoryId + "/" + path;
    }

    private String buildDatastoryPathV2(String datastoryId) {
        return "v2/api/dashboards/" + datastoryId;
    }

    private String buildDatastoryPathV2(String datastoryId, String path) {
        return "v2/api/dashboards/" + datastoryId + "/" + path;
    }

    private static class DatastoryDTO {
        public String title;
        public String description;
        public String workspaceKey;
        public List<DatasetRef> datasets = new ArrayList<DatasetRef>();

        private DatastoryDTO() {
        }
    }

    private static class DatastoryCreationResponse {
        public String datastoryId;

        private DatastoryCreationResponse() {
        }
    }

    private static class DatastoryDuplicationResponse {
        public String dashboardId;
        public String status;

        private DatastoryDuplicationResponse() {
        }
    }

    private static class DatastoryUpdateResponse {
        public String datastoryId;
        public String datastoryTitle;
        public String datastoryDescription;

        private DatastoryUpdateResponse() {
        }
    }

    private static class DatastoryStatus {
        public String status;

        private DatastoryStatus() {
        }
    }

    private static class PowerslideAPIError {
        public String status;
        public Object code;
        public String title;
        public String message;

        private PowerslideAPIError() {
        }
    }

    private static class DatasetRef {
        public final String projectKey;
        public final String datasetName;
        public final String id;

        public DatasetRef(String projectKey, String datasetName, String id) {
            this.projectKey = projectKey;
            this.datasetName = datasetName;
            this.id = id;
        }
    }
}

