/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SlowCodeReporter;
import com.dataiku.dip.utils.StackUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DSSDBConnectionDebugMonitor {
    private static final long LOG_CONNECTION_TRACKER_DURATION = 10000L;
    private final Cache<String, String> throttler = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final ThreadLocal<List<Tracker>> threadLocalConnection = ThreadLocal.withInitial(ArrayList::new);
    private final SlowCodeReporter slowCodeReporter = new SlowCodeReporter();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.db.internal");

    public synchronized Tracker register(String debugId) {
        List<Tracker> trackersInCurrentThreads = this.threadLocalConnection.get();
        Tracker newTracker = new Tracker(debugId);
        trackersInCurrentThreads.add(newTracker);
        if (trackersInCurrentThreads.size() > 1) {
            String humanStack = StackUtils.getHumanStack(this.getShortStack(10));
            String humanIds = trackersInCurrentThreads.stream().map(t -> t.debugId).collect(Collectors.joining(" -> "));
            try {
                this.throttler.get((Object)humanStack, () -> {
                    logger.warn((Object)("Nested acquisition to internal DBs (" + humanIds + ") at:\n" + humanStack));
                    return humanStack;
                });
            }
            catch (ExecutionException e) {
                logger.error((Object)"Impossible error", (Throwable)e);
            }
        }
        return newTracker;
    }

    private List<StackTraceElement> getShortStack(int limit) {
        return StackUtils.getShortStackForDeduplication((StackTraceElement[])Thread.currentThread().getStackTrace(), (String)"com.dataiku.dip.db.DSSDBConnection", (String)"close", (int)limit);
    }

    class Tracker
    implements AutoCloseable {
        final String debugId;
        final List<Tracker> trackersInCreatorThread;
        final long trackerStartTimeMS;

        Tracker(String debugId) {
            this.trackersInCreatorThread = DSSDBConnectionDebugMonitor.this.threadLocalConnection.get();
            this.trackerStartTimeMS = System.currentTimeMillis();
            this.debugId = debugId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            DSSDBConnectionDebugMonitor dSSDBConnectionDebugMonitor = DSSDBConnectionDebugMonitor.this;
            synchronized (dSSDBConnectionDebugMonitor) {
                long trackerDurationMS;
                if (this.trackersInCreatorThread.remove(this) && (trackerDurationMS = System.currentTimeMillis() - this.trackerStartTimeMS) >= 10000L) {
                    List<StackTraceElement> shortStack = DSSDBConnectionDebugMonitor.this.getShortStack(25);
                    String humanStack = StackUtils.getHumanStack(shortStack);
                    logger.warnV("Internal DB connection was checked out from pool for %dms at:\n%s", new Object[]{trackerDurationMS, humanStack});
                    SlowDBCodeContext context = new SlowDBCodeContext(trackerDurationMS, shortStack);
                    DSSDBConnectionDebugMonitor.this.slowCodeReporter.report((SlowCodeReporter.SlowCodeContext)context);
                }
            }
        }
    }

    public static class SlowDBCodeContext
    extends SlowCodeReporter.SlowCodeContext {
        private final long durationMs;
        private final List<StackTraceElement> stackTrace;

        public SlowDBCodeContext(long durationMs, List<StackTraceElement> stackTrace) {
            super("slow_code_path_database_init");
            this.durationMs = durationMs;
            this.stackTrace = stackTrace;
        }

        public List<StackTraceElement> getStackTrace() {
            return this.stackTrace;
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("durationMs", (Number)this.durationMs);
            json.addProperty("stackTrace", StackUtils.getStringStack(this.stackTrace));
            return json;
        }
    }
}

