/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.directory;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.audit.model.AuditTrailTargetSettings;
import com.dataiku.dip.security.audit.model.EventServerTargetSettings;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodesDirectoryAuditConfigurationService {
    @Autowired
    private NodesDirectoryService nodesDirectoryService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private GeneralSettingsService gsService;
    @Autowired
    private PubSubService pubSubService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.nodesdirectory");

    private void updateAuditConfigurationFromNodesDirectory() throws Exception {
        NodesDirectory nd = this.nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
        if (nd.enabled && StringUtils.isNotBlank((String)nd.eventServerNodeId)) {
            logger.info((Object)"Nodes directory manages event server, making sure that event server target is present");
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            Optional ref = nd.getById(nd.eventServerNodeId);
            String eventServerUrl = ref.isPresent() ? ((NodesDirectory.NodeRef)ref.get()).externalUrl : null;
            EventServerTargetSettings found = this.retrieveAutoConfiguredSetting(gs);
            if (found == null) {
                logger.info((Object)("Event Server target not present yet, adding " + eventServerUrl));
                try (RWTransaction rwt = this.transactionService.beginWriteAsDSS();){
                    EventServerTargetSettings ests = new EventServerTargetSettings();
                    ests.autoconfigureFromNodesDirectory = true;
                    ests.url = eventServerUrl;
                    gs = this.gsService.read();
                    gs.auditTrailSettings.targets.add(ests);
                    this.gsService.save(rwt.getUser(), gs);
                    rwt.commit("Added managed Event Server audit target");
                }
            }
            if (!Objects.equals(eventServerUrl, found.url)) {
                logger.info((Object)("Event Server target present, updating url to " + eventServerUrl));
                try (RWTransaction rwt = this.transactionService.beginWriteAsDSS();){
                    gs = this.gsService.read();
                    found = this.retrieveAutoConfiguredSetting(gs);
                    if (found != null) {
                        found.url = eventServerUrl;
                    }
                    logger.info((Object)"Saving general settings");
                    this.gsService.save(rwt.getUser(), gs);
                    rwt.commit("Update Event Server audit target");
                }
            }
            gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.auditTrailService.reconfigure(gs.auditTrailSettings);
        }
    }

    private EventServerTargetSettings retrieveAutoConfiguredSetting(GeneralSettingsDAO.GeneralSettings gs) {
        Optional<AuditTrailTargetSettings> found = gs.auditTrailSettings.targets.stream().filter(target -> target instanceof EventServerTargetSettings && ((EventServerTargetSettings)target).autoconfigureFromNodesDirectory).findAny();
        return found.isPresent() ? (EventServerTargetSettings)found.get() : null;
    }

    @PostConstruct
    public void startup() throws Exception {
        this.pubSubService.subscribe("nodes-directory-updated", (DSSEventListener)new DSSEventListener<DSSEvent>(){

            public void on(DSSEvent evt) throws Exception {
                NodesDirectoryAuditConfigurationService.this.updateAuditConfigurationFromNodesDirectory();
            }
        });
        this.updateAuditConfigurationFromNodesDirectory();
    }
}

