/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.IDocumentScreenshotsDrawer;
import com.dataiku.dip.docextraction.Screenshotter;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class DocumentIterator
implements Iterator<BufferedImage> {
    IDocumentScreenshotsDrawer document;
    Screenshotter.ScreenshotterSettings settings;
    int pageCount;
    boolean hasNextPaginationResults;
    int currentIndex;
    int endIndex;

    public DocumentIterator(IDocumentScreenshotsDrawer document, Screenshotter.ScreenshotterSettings settings) {
        this.document = document;
        this.settings = settings;
        this.pageCount = document.getPageCount();
        if (settings.paginationOffset >= this.pageCount) {
            throw new IllegalArgumentException("Cannot start extraction at offset: " + settings.paginationOffset + ", the document is only " + this.pageCount + " pages long");
        }
        if (settings.paginationOffset + settings.paginationSize < this.pageCount) {
            this.hasNextPaginationResults = true;
        }
        this.endIndex = Math.min(this.pageCount, settings.paginationOffset + settings.paginationSize) - 1;
        this.currentIndex = settings.paginationOffset;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex <= this.endIndex;
    }

    @Override
    public BufferedImage next() {
        try {
            BufferedImage bufferedImage = this.document.drawImage(this.currentIndex);
            ++this.currentIndex;
            return bufferedImage;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

